/*
 * Decompiled with CFR 0.152.
 */
package app.astrosoft.xps.beans;

import app.astrosoft.beans.PlanetaryInfo;
import app.astrosoft.consts.Planet;
import app.astrosoft.consts.Rasi;
import app.astrosoft.consts.Varga;
import app.astrosoft.util.AstroUtil;
import app.astrosoft.util.CollectionUtil;
import app.astrosoft.util.Mod;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class PlanetChart {
    private static final Logger log = Logger.getLogger(PlanetChart.class.getName());
    private String varga;
    private Map<Planet, Integer> planetLocations;
    private Map<Planet, Rasi> planetHouses;
    private Map<Rasi, Set<Planet>> planetsInHouse;
    private Mod mod12 = new Mod(12);

    public PlanetChart(Varga varga, PlanetaryInfo planetaryInfo) {
        this(varga, planetaryInfo.getPlanetLocation(varga), planetaryInfo.getPlanetRasi(varga));
    }

    public PlanetChart(Varga varga, Map<Planet, Integer> map, Map<Planet, Rasi> map2) {
        this.varga = varga.name();
        this.planetLocations = map;
        this.planetHouses = map2;
        this.planetsInHouse = AstroUtil.calcPlanetInHouses(map2);
    }

    public PlanetChart(Varga varga, Map<Planet, Rasi> map) {
        this(varga, AstroUtil.calcPlanetLocation(map), map);
    }

    public Map<Planet, Integer> getPlanetLocations() {
        return this.planetLocations;
    }

    public int getPlanetLocation(Planet planet) {
        return this.planetLocations.get((Object)planet);
    }

    public Rasi getPlanetHouse(Planet planet) {
        return this.planetHouses.get((Object)planet);
    }

    public String getVarga() {
        return this.varga;
    }

    public boolean isPlanetAt(Planet planet, int n) {
        return this.getPlanetLocation(planet) == n;
    }

    public boolean isPlanetsAt(Set<Planet> set, int n) {
        for (Planet planet : set) {
            if (this.isPlanetAt(planet, n)) continue;
            return false;
        }
        return true;
    }

    public boolean isPlanetAt(Planet planet, Rasi rasi) {
        return this.getPlanetHouse(planet).equals((Object)rasi);
    }

    public boolean isPlanetsAt(Set<Planet> set, Rasi rasi) {
        for (Planet planet : set) {
            if (this.isPlanetAt(planet, rasi)) continue;
            return false;
        }
        return true;
    }

    public boolean isPlanetWith(Planet planet, Planet planet2) {
        return this.getPlanetHouse(planet).equals((Object)this.getPlanetHouse(planet2));
    }

    public boolean isPlanetWithAll(Planet planet, Set<Planet> set) {
        for (Planet planet2 : set) {
            if (this.isPlanetWith(planet, planet2)) continue;
            return false;
        }
        return true;
    }

    public boolean isPlanetWithAny(Planet planet, Set<Planet> set) {
        for (Planet planet2 : set) {
            if (!this.isPlanetWith(planet, planet2)) continue;
            return true;
        }
        return false;
    }

    public boolean isPlanetInOwnHouse(Planet planet) {
        return planet.isOwnerOf(this.getPlanetHouse(planet));
    }

    public boolean isPlanetExalted(Planet planet) {
        return planet.isExaltedRasi(this.getPlanetHouse(planet));
    }

    public boolean isPlanetDebilitated(Planet planet) {
        return planet.isDebilitatedRasi(this.getPlanetHouse(planet));
    }

    public boolean isPlanetInMoolaTrikona(Planet planet) {
        return planet.isMoolaTrikona(this.getPlanetHouse(planet));
    }

    public boolean isPlanetInOwnOrExaltedHouse(Planet planet) {
        return this.isPlanetInOwnHouse(planet) || this.isPlanetExalted(planet);
    }

    public boolean isPlanetInKendra(Planet planet) {
        return PlanetChart.isKendraLocation(this.getPlanetLocation(planet));
    }

    public boolean isPlanetInTrine(Planet planet) {
        return PlanetChart.isTrineLocation(this.getPlanetLocation(planet));
    }

    public boolean isPlanetInKendraTo(Planet planet, Planet planet2) {
        int n = this.mod12.sub(this.getPlanetLocation(planet), this.getPlanetLocation(planet2)) + 1;
        return PlanetChart.isKendraLocation(n);
    }

    public boolean isPlanetInTrineTo(Planet planet, Planet planet2) {
        int n = this.mod12.sub(this.getPlanetLocation(planet), this.getPlanetLocation(planet2)) + 1;
        return PlanetChart.isTrineLocation(n);
    }

    public boolean isPlanetInKendraOrTrine(Planet planet) {
        return this.isPlanetInKendra(planet) || this.isPlanetInTrine(planet);
    }

    public boolean isPlanetInKendraOrTrineTo(Planet planet, Planet planet2) {
        return this.isPlanetInKendraTo(planet, planet2) || this.isPlanetInTrineTo(planet, planet2);
    }

    public boolean isPlanetAspectedBy(Planet planet, Planet planet2) {
        int n = this.mod12.sub(this.getPlanetLocation(planet), this.getPlanetLocation(planet2)) + 1;
        return planet2.isAspectingLocation(n);
    }

    public boolean isHouseAspectedBy(Rasi rasi, Planet planet) {
        int n = this.mod12.sub(rasi.ordinal(), this.getPlanetHouse(planet).ordinal()) + 1;
        return planet.isAspectingLocation(n);
    }

    public Set<Planet> planetsAt(Planet planet, int n) {
        Rasi rasi = this.getPlanetHouse(planet);
        Rasi rasi2 = rasi.absolute(n - 1);
        log.fine("From house " + (Object)((Object)rasi));
        log.fine("To house " + (Object)((Object)rasi2));
        return this.planetsInHouse.get((Object)rasi2);
    }

    public Planet lordOf(int n) {
        Rasi rasi = this.getPlanetHouse(Planet.Ascendant);
        return rasi.absolute(n - 1).owner();
    }

    public Planet lordOf(String string) {
        return this.lordOf(Integer.parseInt(string));
    }

    public Rasi houseOf(int n) {
        Rasi rasi = this.getPlanetHouse(Planet.Ascendant);
        return rasi.absolute(n - 1);
    }

    public Rasi houseOf(String string) {
        return this.houseOf(Integer.parseInt(string));
    }

    public boolean isPlanetStronglyDisposed(Planet planet) {
        return this.isPlanetExalted(planet) || this.isPlanetInOwnHouse(planet) || this.isPlanetInKendraOrTrine(planet) && !this.isPlanetDebilitated(planet);
    }

    public static boolean isKendraLocation(int n) {
        return n == 1 || n == 4 || n == 7 || n == 10;
    }

    public static boolean isTrineLocation(int n) {
        return n == 1 || n == 5 || n == 9;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.varga);
        stringBuilder.append(" => ");
        stringBuilder.append(this.planetLocations);
        stringBuilder.append(" => ");
        stringBuilder.append(this.planetHouses);
        return stringBuilder.toString();
    }

    public static void main(String[] stringArray) {
        Map.Entry<Planet, Rasi> entry = CollectionUtil.newEntry(Planet.Sun, Rasi.Mesha);
        Map.Entry<Planet, Rasi> entry2 = CollectionUtil.newEntry(Planet.Moon, Rasi.Vrichika);
        Map.Entry<Planet, Rasi> entry3 = CollectionUtil.newEntry(Planet.Ascendant, Rasi.Kataka);
        EnumMap<Planet, Rasi> enumMap = CollectionUtil.newEnumMap(Planet.class, CollectionUtil.newEntry(Planet.Sun, Rasi.Mesha), CollectionUtil.newEntry(Planet.Ascendant, Rasi.Kanya));
        PlanetChart planetChart = new PlanetChart(Varga.Rasi, enumMap);
        System.out.println(planetChart);
    }
}

