/*
 * Decompiled with CFR 0.152.
 */
package app.astrosoft.xps.beans;

import app.astrosoft.beans.PlanetCharacter;
import app.astrosoft.consts.Planet;
import app.astrosoft.consts.Sex;
import app.astrosoft.core.Horoscope;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class YogaFacts {
    private static final Logger log = Logger.getLogger(YogaFacts.class.getName());
    private static final double POWERFUL_PLANET_THRESHOLD = 75.0;
    private static final NumberFormat format = new DecimalFormat("000");
    private PlanetCharacter character;
    private Set<Planet> powerfulPlanets;
    private Map<Planet, Double> planetStrength;
    private boolean isBirthAtDay;
    private Sex personSex;

    public YogaFacts() {
    }

    public YogaFacts(Horoscope horoscope) {
        PlanetCharacter planetCharacter = new PlanetCharacter(horoscope.getPlanetaryInfo().getPlanetCharacter());
        this.setCharacter(planetCharacter);
        this.setPlanetStrength(horoscope.getShadBala().getStrengthPer());
        this.setPowerfulPlanets(this.planetStrength);
        this.setBirthAtDay(horoscope.isBirthAtDay());
        this.setPersonSex(horoscope.getPersonSex());
    }

    public void setPlanetStrength(Map<Planet, Double> map) {
        this.planetStrength = map;
    }

    public void setCharacter(PlanetCharacter planetCharacter) {
        this.character = planetCharacter;
    }

    public PlanetCharacter character() {
        return this.character;
    }

    public void setPowerfulPlanets(Map<Planet, Double> map) {
        this.powerfulPlanets = EnumSet.noneOf(Planet.class);
        for (Map.Entry<Planet, Double> entry : map.entrySet()) {
            if (!(entry.getValue() >= 75.0)) continue;
            this.powerfulPlanets.add(entry.getKey());
        }
        log.fine(this.powerfulPlanets.toString());
    }

    public void setPowerfulPlanets(Set<Planet> set) {
        this.powerfulPlanets = set;
    }

    public Set<Planet> powerfulPlanets() {
        return this.powerfulPlanets;
    }

    public boolean isPlanetPowerful(Planet planet) {
        return this.powerfulPlanets.contains((Object)planet);
    }

    public boolean isAnyPlanetPowerful(Set<Planet> set) {
        for (Planet planet : set) {
            if (!this.isPlanetPowerful(planet)) continue;
            return true;
        }
        return false;
    }

    public void setBirthAtDay(boolean bl) {
        this.isBirthAtDay = bl;
    }

    public boolean isBirthAtDay() {
        System.out.println("isBirthAtDay--> " + this.isBirthAtDay);
        return this.isBirthAtDay;
    }

    public void setPersonSex(Sex sex) {
        this.personSex = sex;
    }

    public boolean isMale() {
        if (this.personSex != null) {
            return this.personSex.isMale();
        }
        return false;
    }

    public boolean isFemale() {
        if (this.personSex != null) {
            return this.personSex.isFemale();
        }
        return false;
    }

    public String getPlanetStrength(Planet planet) {
        if (this.planetStrength == null) {
            return "100%";
        }
        return format.format(this.planetStrength.get((Object)planet)) + "%";
    }
}

