/*
 * Decompiled with CFR 0.152.
 */
package app.astrosoft.xps.yoga;

import app.astrosoft.consts.Varga;
import app.astrosoft.core.Horoscope;
import app.astrosoft.exception.AstrosoftException;
import app.astrosoft.test.SampleHoroscopes;
import app.astrosoft.util.Timer;
import app.astrosoft.xps.XpsUtil;
import app.astrosoft.xps.beans.PlanetChart;
import app.astrosoft.xps.beans.YogaFacts;
import app.astrosoft.xps.yoga.YogaResults;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.drools.RuleBase;
import org.drools.RuleBaseFactory;
import org.drools.StatefulSession;
import org.drools.compiler.DroolsParserException;
import org.drools.compiler.PackageBuilder;
import org.drools.event.AgendaEventListener;
import org.drools.event.DebugAgendaEventListener;
import org.drools.event.DebugWorkingMemoryEventListener;
import org.drools.event.WorkingMemoryEventListener;
import org.drools.rule.Package;

public class YogaFinder {
    private static final Logger log = Logger.getLogger(YogaFinder.class.getName());
    private static String RULE_FILE = "YogaCombinations.dslr";
    private static String DSL_FILE = "YogaCombinations.dsl";
    private static String PACKAGE_FILE = "YogaCombinations.pkg";
    private RuleBase ruleBase;
    private static YogaFinder instance = null;

    private YogaFinder() {
        try {
            Timer timer = new Timer();
            Package package_ = YogaFinder.deserializePackage();
            this.ruleBase = RuleBaseFactory.newRuleBase();
            this.ruleBase.addPackage(package_);
            timer.print("Time taken for creating rule base ");
        }
        catch (Exception exception) {
            log.log(Level.SEVERE, "Exception in initializing rules ", exception);
            throw new AstrosoftException("Exception in initializing rules ", exception);
        }
    }

    public static YogaFinder getInstance() {
        if (instance == null) {
            instance = new YogaFinder();
        }
        return instance;
    }

    public YogaResults findYogas(Horoscope horoscope) {
        Timer timer = new Timer();
        StatefulSession statefulSession = this.ruleBase.newStatefulSession();
        if (log.isLoggable(Level.FINE)) {
            YogaFinder.registerListener(statefulSession);
        }
        YogaFinder.loadFacts(horoscope, statefulSession);
        statefulSession.fireAllRules();
        YogaResults yogaResults = (YogaResults)statefulSession.getGlobal("yogas");
        statefulSession.dispose();
        timer.print("FindYoga Execution time for " + horoscope.getPersonName());
        return yogaResults;
    }

    private static void loadFacts(Horoscope horoscope, StatefulSession statefulSession) {
        YogaResults yogaResults = new YogaResults();
        statefulSession.setGlobal("yogas", (Object)yogaResults);
        YogaFacts yogaFacts = new YogaFacts(horoscope);
        statefulSession.setGlobal("$facts", (Object)yogaFacts);
        PlanetChart planetChart = new PlanetChart(Varga.Rasi, horoscope.getPlanetaryInfo());
        statefulSession.insert((Object)planetChart);
    }

    private static void registerListener(StatefulSession statefulSession) {
        statefulSession.addEventListener((AgendaEventListener)new DebugAgendaEventListener());
        statefulSession.addEventListener((WorkingMemoryEventListener)new DebugWorkingMemoryEventListener());
    }

    private static Package buildPackage() throws DroolsParserException, IOException {
        InputStreamReader inputStreamReader = new InputStreamReader(XpsUtil.getRuleAsStream(RULE_FILE));
        InputStreamReader inputStreamReader2 = new InputStreamReader(XpsUtil.getRuleAsStream(DSL_FILE));
        PackageBuilder packageBuilder = new PackageBuilder();
        packageBuilder.addPackageFromDrl((Reader)inputStreamReader, (Reader)inputStreamReader2);
        if (packageBuilder.hasErrors()) {
            log.severe("Compilation Errors in rule : " + packageBuilder.getErrors().toString());
            throw new AstrosoftException("Compilation Errors in " + RULE_FILE);
        }
        return packageBuilder.getPackage();
    }

    public void serializePackage() {
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(PACKAGE_FILE));
            objectOutputStream.writeObject(YogaFinder.buildPackage());
        }
        catch (Exception exception) {
            log.log(Level.SEVERE, "Exception in Serializing Package");
        }
    }

    private static Package deserializePackage() {
        Package package_ = null;
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(XpsUtil.getRuleAsStream(PACKAGE_FILE));
            package_ = (Package)objectInputStream.readObject();
        }
        catch (Exception exception) {
            log.log(Level.SEVERE, "Exception in Serializing Package");
            throw new AstrosoftException("Exception in Serializing Package", exception);
        }
        return package_;
    }

    public static void main(String[] stringArray) {
        Horoscope horoscope = SampleHoroscopes.getMyHoroscope();
        Timer timer = new Timer();
        horoscope = SampleHoroscopes.getMyHoroscope();
        timer.print("Default Horoscope construction time ");
        timer.reset();
        horoscope = SampleHoroscopes.getMyHoroscope();
        horoscope.calculateAll();
        timer.print("Full Horoscope construction time ");
    }
}

