/*
 * Decompiled with CFR 0.152.
 */
package app.astrosoft.xps.yoga;

import app.astrosoft.consts.YogaCombination;
import java.util.ArrayList;
import java.util.List;

public class YogaResults {
    private List<Result> yogas = new ArrayList<Result>();

    public void addYoga(YogaCombination yogaCombination, String string) {
        this.yogas.add(new Result(yogaCombination, string));
    }

    public void addYoga(YogaCombination yogaCombination) {
        this.addYoga(yogaCombination, "100%");
    }

    public List<Result> getYogas() {
        return this.yogas;
    }

    public void clearAll() {
        this.yogas.clear();
    }

    public boolean hasYogaCombination(YogaCombination yogaCombination) {
        for (Result result : this.yogas) {
            if (!result.yoga.equals((Object)yogaCombination)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.yogas.toString();
    }

    public static class Result {
        private YogaCombination yoga;
        private String efficacy;

        public Result(YogaCombination yogaCombination, String string) {
            this.yoga = yogaCombination;
            this.efficacy = string;
        }

        public YogaCombination getYoga() {
            return this.yoga;
        }

        public String getEfficacy() {
            return this.efficacy;
        }

        public int hashCode() {
            int n = 17;
            n += 31 * this.yoga.hashCode();
            return n += 31 * this.efficacy.hashCode();
        }

        public boolean equals(Object object) {
            if (object instanceof Result) {
                Result result = (Result)object;
                return result.yoga.equals((Object)this.yoga) && result.efficacy.equals(this.efficacy);
            }
            return false;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(this.yoga.toString());
            stringBuilder.append(" ( ");
            stringBuilder.append(this.efficacy);
            stringBuilder.append(" )");
            return stringBuilder.toString();
        }
    }
}

