/*
 * Decompiled with CFR 0.152.
 */
package app.astrosoft.xps.yoga.test;

import app.astrosoft.consts.Planet;
import app.astrosoft.consts.Rasi;
import app.astrosoft.consts.YogaCombination;
import app.astrosoft.util.CollectionUtil;
import app.astrosoft.xps.beans.PlanetChart;
import app.astrosoft.xps.yoga.test.YogaAnalysisTestCase;
import app.astrosoft.xps.yoga.test.YogaAnalysisTestHelper;
import org.junit.Test;

public class AdhiYogaTestCase
extends YogaAnalysisTestCase {
    @Test
    public void testAdhiYoga1() throws Exception {
        PlanetChart planetChart = YogaAnalysisTestHelper.constructChart(CollectionUtil.newEntry(Planet.Ascendant, Rasi.Mesha), CollectionUtil.newEntry(Planet.Moon, Rasi.Mesha), CollectionUtil.newEntry(Planet.Jupiter, Rasi.Kanya), CollectionUtil.newEntry(Planet.Mercury, Rasi.Kanya));
        YogaAnalysisTestHelper.setUp("Adhi Yoga");
        YogaAnalysisTestHelper.loadFacts(planetChart);
        YogaAnalysisTestHelper.getSession().fireAllRules();
        YogaAnalysisTestHelper.testYogaPresent(YogaCombination.AdhiYoga, "75%");
    }

    @Test
    public void testAdhiYoga2() throws Exception {
        PlanetChart planetChart = YogaAnalysisTestHelper.constructChart(CollectionUtil.newEntry(Planet.Ascendant, Rasi.Mesha), CollectionUtil.newEntry(Planet.Moon, Rasi.Mesha), CollectionUtil.newEntry(Planet.Venus, Rasi.Vrichika));
        YogaAnalysisTestHelper.setUp("Adhi Yoga");
        YogaAnalysisTestHelper.loadFacts(planetChart);
        YogaAnalysisTestHelper.getSession().fireAllRules();
        YogaAnalysisTestHelper.testYogaNotPresent(YogaCombination.AdhiYoga);
    }

    @Test
    public void testAdhiYoga3() throws Exception {
        PlanetChart planetChart = YogaAnalysisTestHelper.constructChart(CollectionUtil.newEntry(Planet.Ascendant, Rasi.Mesha), CollectionUtil.newEntry(Planet.Moon, Rasi.Mesha), CollectionUtil.newEntry(Planet.Jupiter, Rasi.Kanya), CollectionUtil.newEntry(Planet.Mercury, Rasi.Thula), CollectionUtil.newEntry(Planet.Venus, Rasi.Vrichika));
        YogaAnalysisTestHelper.setUp("Adhi Yoga");
        YogaAnalysisTestHelper.loadFacts(planetChart);
        YogaAnalysisTestHelper.getSession().fireAllRules();
        YogaAnalysisTestHelper.testYogaPresent(YogaCombination.AdhiYoga, "100%");
    }
}

