/*
 * Decompiled with CFR 0.152.
 */
package app.astrosoft.xps.yoga.test;

import app.astrosoft.consts.Planet;
import app.astrosoft.consts.Rasi;
import app.astrosoft.consts.YogaCombination;
import app.astrosoft.util.CollectionUtil;
import app.astrosoft.xps.beans.PlanetChart;
import app.astrosoft.xps.yoga.test.YogaAnalysisTestCase;
import app.astrosoft.xps.yoga.test.YogaAnalysisTestHelper;
import org.junit.Test;

public class AmalaYogaTestCase
extends YogaAnalysisTestCase {
    @Test
    public void testAmalaYoga1() throws Exception {
        YogaAnalysisTestHelper.setUp("Amala Yoga");
        YogaAnalysisTestHelper.loadFacts(YogaAnalysisTestHelper.SAMPLE_HOROSCOPE.RAJA);
        YogaAnalysisTestHelper.getSession().fireAllRules();
        YogaAnalysisTestHelper.testYogaPresent(YogaCombination.AmalaYoga);
    }

    @Test
    public void testAmalaYoga2() throws Exception {
        PlanetChart planetChart = YogaAnalysisTestHelper.constructChart(CollectionUtil.newEntry(Planet.Ascendant, Rasi.Mesha), CollectionUtil.newEntry(Planet.Moon, Rasi.Mesha));
        log.fine("Chart " + planetChart);
        YogaAnalysisTestHelper.setUp("Amala Yoga");
        YogaAnalysisTestHelper.loadFacts(planetChart);
        YogaAnalysisTestHelper.getSession().fireAllRules();
        YogaAnalysisTestHelper.testYogaNotPresent(YogaCombination.AmalaYoga);
    }

    @Test
    public void testAmalaYoga3() throws Exception {
        PlanetChart planetChart = YogaAnalysisTestHelper.constructChart(CollectionUtil.newEntry(Planet.Ascendant, Rasi.Mesha), CollectionUtil.newEntry(Planet.Moon, Rasi.Makara));
        log.fine("Chart " + planetChart);
        YogaAnalysisTestHelper.setUp("Amala Yoga");
        YogaAnalysisTestHelper.loadFacts(planetChart);
        YogaAnalysisTestHelper.getSession().fireAllRules();
        YogaAnalysisTestHelper.testYogaPresent(YogaCombination.AmalaYoga, "100%");
    }
}

