/*
 * Decompiled with CFR 0.152.
 */
package app.astrosoft.xps.yoga.test;

import app.astrosoft.consts.Planet;
import app.astrosoft.consts.Rasi;
import app.astrosoft.consts.YogaCombination;
import app.astrosoft.util.CollectionUtil;
import app.astrosoft.xps.beans.PlanetChart;
import app.astrosoft.xps.yoga.test.YogaAnalysisTestCase;
import app.astrosoft.xps.yoga.test.YogaAnalysisTestHelper;
import org.junit.Test;

public class AnaphaYogaTestCase
extends YogaAnalysisTestCase {
    @Test
    public void testAnaphaYoga1() throws Exception {
        YogaAnalysisTestHelper.setUp("Anapha Yoga");
        YogaAnalysisTestHelper.loadFacts(YogaAnalysisTestHelper.SAMPLE_HOROSCOPE.RAJA);
        YogaAnalysisTestHelper.getSession().fireAllRules();
        YogaAnalysisTestHelper.testYogaPresent(YogaCombination.AnaphaYoga, "50%");
    }

    @Test
    public void testAnaphaYoga2() throws Exception {
        PlanetChart planetChart = YogaAnalysisTestHelper.constructChart(CollectionUtil.newEntry(Planet.Ascendant, Rasi.Meena), CollectionUtil.newEntry(Planet.Rahu, Rasi.Meena), CollectionUtil.newEntry(Planet.Moon, Rasi.Mesha));
        YogaAnalysisTestHelper.setUp("Anapha Yoga");
        YogaAnalysisTestHelper.loadFacts(planetChart);
        YogaAnalysisTestHelper.getSession().fireAllRules();
        YogaAnalysisTestHelper.testYogaNotPresent(YogaCombination.AnaphaYoga);
    }

    @Test
    public void testAnaphaYoga3() throws Exception {
        PlanetChart planetChart = YogaAnalysisTestHelper.constructChart(CollectionUtil.newEntry(Planet.Ascendant, Rasi.Mesha), CollectionUtil.newEntry(Planet.Moon, Rasi.Mesha), CollectionUtil.newEntry(Planet.Mercury, Rasi.Meena));
        YogaAnalysisTestHelper.setUp("Anapha Yoga");
        YogaAnalysisTestHelper.loadFacts(planetChart);
        YogaAnalysisTestHelper.getSession().fireAllRules();
        YogaAnalysisTestHelper.testYogaPresent(YogaCombination.AnaphaYoga, "100%");
    }
}

