/*
 * Decompiled with CFR 0.152.
 */
package app.astrosoft.xps.yoga.test;

import app.astrosoft.consts.Planet;
import app.astrosoft.consts.Rasi;
import app.astrosoft.consts.YogaCombination;
import app.astrosoft.util.CollectionUtil;
import app.astrosoft.xps.beans.PlanetChart;
import app.astrosoft.xps.yoga.test.YogaAnalysisTestCase;
import app.astrosoft.xps.yoga.test.YogaAnalysisTestHelper;
import org.junit.Test;

public class ChapaYogaTestCase
extends YogaAnalysisTestCase {
    @Test
    public void testChapaYoga1() throws Exception {
        PlanetChart planetChart = YogaAnalysisTestHelper.constructChart(CollectionUtil.newEntry(Planet.Ascendant, Rasi.Vrishabha), CollectionUtil.newEntry(Planet.Venus, Rasi.Meena), CollectionUtil.newEntry(Planet.Sun, Rasi.Kumbha), CollectionUtil.newEntry(Planet.Saturn, Rasi.Simha));
        YogaAnalysisTestHelper.setUp("Chapa Yoga");
        YogaAnalysisTestHelper.loadFacts(planetChart);
        YogaAnalysisTestHelper.getSession().fireAllRules();
        YogaAnalysisTestHelper.testYogaPresent(YogaCombination.ChapaYoga, "100%");
    }

    @Test
    public void testChapaYoga2() throws Exception {
        PlanetChart planetChart = YogaAnalysisTestHelper.constructChart(CollectionUtil.newEntry(Planet.Ascendant, Rasi.Vrishabha), CollectionUtil.newEntry(Planet.Venus, Rasi.Mesha), CollectionUtil.newEntry(Planet.Sun, Rasi.Kumbha), CollectionUtil.newEntry(Planet.Saturn, Rasi.Simha));
        YogaAnalysisTestHelper.setUp("Chapa Yoga");
        YogaAnalysisTestHelper.loadFacts(planetChart);
        YogaAnalysisTestHelper.getSession().fireAllRules();
        YogaAnalysisTestHelper.testYogaNotPresent(YogaCombination.ChapaYoga);
    }
}

