/*
 * Decompiled with CFR 0.152.
 */
package app.astrosoft.xps.yoga.test;

import app.astrosoft.consts.Planet;
import app.astrosoft.consts.Rasi;
import app.astrosoft.consts.YogaCombination;
import app.astrosoft.util.CollectionUtil;
import app.astrosoft.xps.beans.PlanetChart;
import app.astrosoft.xps.yoga.test.YogaAnalysisTestCase;
import app.astrosoft.xps.yoga.test.YogaAnalysisTestHelper;
import org.junit.Test;

public class ChatussagaraYogaTestCase
extends YogaAnalysisTestCase {
    @Test
    public void testChatussagaraYoga1() throws Exception {
        PlanetChart planetChart = YogaAnalysisTestHelper.constructChart(CollectionUtil.newEntry(Planet.Ascendant, Rasi.Mesha), CollectionUtil.newEntry(Planet.Moon, Rasi.Mesha), CollectionUtil.newEntry(Planet.Jupiter, Rasi.Kataka), CollectionUtil.newEntry(Planet.Mercury, Rasi.Thula), CollectionUtil.newEntry(Planet.Saturn, Rasi.Makara), CollectionUtil.newEntry(Planet.Venus, Rasi.Thula));
        YogaAnalysisTestHelper.setUp("Chatussagara Yoga");
        YogaAnalysisTestHelper.loadFacts(planetChart);
        YogaAnalysisTestHelper.getSession().fireAllRules();
        YogaAnalysisTestHelper.testYogaPresent(YogaCombination.ChatussagaraYoga, "100%");
    }

    @Test
    public void testChatussagaraYoga2() throws Exception {
        YogaAnalysisTestHelper.setUp("Chatussagara Yoga");
        YogaAnalysisTestHelper.loadFacts(YogaAnalysisTestHelper.SAMPLE_HOROSCOPE.RAJA);
        YogaAnalysisTestHelper.getSession().fireAllRules();
        YogaAnalysisTestHelper.testYogaNotPresent(YogaCombination.ChatussagaraYoga);
    }

    @Test
    public void testChatussagaraYoga4() throws Exception {
        PlanetChart planetChart = YogaAnalysisTestHelper.constructChart(CollectionUtil.newEntry(Planet.Ascendant, Rasi.Mesha), CollectionUtil.newEntry(Planet.Moon, Rasi.Mesha), CollectionUtil.newEntry(Planet.Jupiter, Rasi.Kataka), CollectionUtil.newEntry(Planet.Mercury, Rasi.Thula), CollectionUtil.newEntry(Planet.Rahu, Rasi.Makara));
        YogaAnalysisTestHelper.setUp("Chatussagara Yoga");
        YogaAnalysisTestHelper.loadFacts(planetChart);
        YogaAnalysisTestHelper.getSession().fireAllRules();
        YogaAnalysisTestHelper.testYogaNotPresent(YogaCombination.ChatussagaraYoga);
    }
}

