/*
 * Decompiled with CFR 0.152.
 */
package app.astrosoft.xps.yoga.test;

import app.astrosoft.consts.Planet;
import app.astrosoft.consts.Rasi;
import app.astrosoft.consts.YogaCombination;
import app.astrosoft.util.CollectionUtil;
import app.astrosoft.xps.beans.PlanetChart;
import app.astrosoft.xps.yoga.test.YogaAnalysisTestCase;
import app.astrosoft.xps.yoga.test.YogaAnalysisTestHelper;
import org.junit.Test;

public class GoYogaTestCase
extends YogaAnalysisTestCase {
    @Test
    public void testGoYoga1() throws Exception {
        PlanetChart planetChart = YogaAnalysisTestHelper.constructChart(CollectionUtil.newEntry(Planet.Ascendant, Rasi.Thula), CollectionUtil.newEntry(Planet.Venus, Rasi.Meena), CollectionUtil.newEntry(Planet.Jupiter, Rasi.Dhanus), CollectionUtil.newEntry(Planet.Mars, Rasi.Dhanus));
        YogaAnalysisTestHelper.setUp("Go Yoga");
        YogaAnalysisTestHelper.loadFacts(planetChart);
        YogaAnalysisTestHelper.getSession().fireAllRules();
        YogaAnalysisTestHelper.testYogaPresent(YogaCombination.GoYoga, "100%");
    }

    @Test
    public void testGoYoga3() throws Exception {
        PlanetChart planetChart = YogaAnalysisTestHelper.constructChart(CollectionUtil.newEntry(Planet.Ascendant, Rasi.Kanya), CollectionUtil.newEntry(Planet.Mercury, Rasi.Kanya), CollectionUtil.newEntry(Planet.Jupiter, Rasi.Dhanus), CollectionUtil.newEntry(Planet.Venus, Rasi.Dhanus));
        YogaAnalysisTestHelper.setUp("Go Yoga");
        YogaAnalysisTestHelper.loadFacts(planetChart);
        YogaAnalysisTestHelper.getSession().fireAllRules();
        YogaAnalysisTestHelper.testYogaPresent(YogaCombination.GoYoga, "100%");
    }

    @Test
    public void testGoYoga2() throws Exception {
        PlanetChart planetChart = YogaAnalysisTestHelper.constructChart(CollectionUtil.newEntry(Planet.Ascendant, Rasi.Kumbha), CollectionUtil.newEntry(Planet.Mercury, Rasi.Kanya), CollectionUtil.newEntry(Planet.Jupiter, Rasi.Dhanus));
        YogaAnalysisTestHelper.setUp("Go Yoga");
        YogaAnalysisTestHelper.loadFacts(planetChart);
        YogaAnalysisTestHelper.getSession().fireAllRules();
        YogaAnalysisTestHelper.testYogaNotPresent(YogaCombination.GoYoga);
    }

    @Test
    public void testGoYoga4() throws Exception {
        PlanetChart planetChart = YogaAnalysisTestHelper.constructChart(CollectionUtil.newEntry(Planet.Ascendant, Rasi.Kanya), CollectionUtil.newEntry(Planet.Mercury, Rasi.Kanya), CollectionUtil.newEntry(Planet.Jupiter, Rasi.Makara), CollectionUtil.newEntry(Planet.Venus, Rasi.Dhanus));
        YogaAnalysisTestHelper.setUp("Go Yoga");
        YogaAnalysisTestHelper.loadFacts(planetChart);
        YogaAnalysisTestHelper.getSession().fireAllRules();
        YogaAnalysisTestHelper.testYogaNotPresent(YogaCombination.GoYoga);
    }
}

