/*
 * Decompiled with CFR 0.152.
 */
package app.astrosoft.xps.yoga.test;

import app.astrosoft.consts.Planet;
import app.astrosoft.consts.Rasi;
import app.astrosoft.consts.YogaCombination;
import app.astrosoft.util.CollectionUtil;
import app.astrosoft.xps.beans.PlanetChart;
import app.astrosoft.xps.yoga.test.YogaAnalysisTestCase;
import app.astrosoft.xps.yoga.test.YogaAnalysisTestHelper;
import org.junit.Test;

public class IndraYogaTestCase
extends YogaAnalysisTestCase {
    @Test
    public void testIndraYoga1() throws Exception {
        PlanetChart planetChart = YogaAnalysisTestHelper.constructChart(CollectionUtil.newEntry(Planet.Ascendant, Rasi.Dhanus), CollectionUtil.newEntry(Planet.Mars, Rasi.Thula), CollectionUtil.newEntry(Planet.Venus, Rasi.Mesha), CollectionUtil.newEntry(Planet.Moon, Rasi.Mesha));
        YogaAnalysisTestHelper.setUp("Indra Yoga");
        YogaAnalysisTestHelper.loadFacts(planetChart);
        YogaAnalysisTestHelper.getSession().fireAllRules();
        YogaAnalysisTestHelper.testYogaPresent(YogaCombination.IndraYoga, "100%");
    }

    @Test
    public void testIndraYoga3() throws Exception {
        PlanetChart planetChart = YogaAnalysisTestHelper.constructChart(CollectionUtil.newEntry(Planet.Ascendant, Rasi.Kanya), CollectionUtil.newEntry(Planet.Moon, Rasi.Makara), CollectionUtil.newEntry(Planet.Saturn, Rasi.Kataka));
        YogaAnalysisTestHelper.setUp("Indra Yoga");
        YogaAnalysisTestHelper.loadFacts(planetChart);
        YogaAnalysisTestHelper.getSession().fireAllRules();
        YogaAnalysisTestHelper.testYogaPresent(YogaCombination.IndraYoga, "100%");
    }

    @Test
    public void testIndraYoga2() throws Exception {
        PlanetChart planetChart = YogaAnalysisTestHelper.constructChart(CollectionUtil.newEntry(Planet.Ascendant, Rasi.Dhanus), CollectionUtil.newEntry(Planet.Mars, Rasi.Thula), CollectionUtil.newEntry(Planet.Venus, Rasi.Mesha), CollectionUtil.newEntry(Planet.Moon, Rasi.Vrishabha));
        YogaAnalysisTestHelper.setUp("Indra Yoga");
        YogaAnalysisTestHelper.loadFacts(planetChart);
        YogaAnalysisTestHelper.getSession().fireAllRules();
        YogaAnalysisTestHelper.testYogaNotPresent(YogaCombination.IndraYoga);
    }

    @Test
    public void testIndraYoga4() throws Exception {
        PlanetChart planetChart = YogaAnalysisTestHelper.constructChart(CollectionUtil.newEntry(Planet.Ascendant, Rasi.Dhanus), CollectionUtil.newEntry(Planet.Mars, Rasi.Vrichika), CollectionUtil.newEntry(Planet.Venus, Rasi.Mesha), CollectionUtil.newEntry(Planet.Moon, Rasi.Mesha));
        YogaAnalysisTestHelper.setUp("Indra Yoga");
        YogaAnalysisTestHelper.loadFacts(planetChart);
        YogaAnalysisTestHelper.getSession().fireAllRules();
        YogaAnalysisTestHelper.testYogaNotPresent(YogaCombination.IndraYoga);
    }
}

