/*
 * Decompiled with CFR 0.152.
 */
package app.astrosoft.xps.yoga.test;

import app.astrosoft.consts.Planet;
import app.astrosoft.consts.Rasi;
import app.astrosoft.consts.Sex;
import app.astrosoft.consts.YogaCombination;
import app.astrosoft.util.CollectionUtil;
import app.astrosoft.xps.beans.PlanetChart;
import app.astrosoft.xps.beans.YogaFacts;
import app.astrosoft.xps.yoga.test.YogaAnalysisTestCase;
import app.astrosoft.xps.yoga.test.YogaAnalysisTestHelper;
import org.junit.Test;

public class MahabhagyaYogaTestCase
extends YogaAnalysisTestCase {
    @Test
    public void testMahabhagyaYoga1() throws Exception {
        YogaAnalysisTestHelper.setUp("Mahabhagya Yoga");
        PlanetChart planetChart = YogaAnalysisTestHelper.constructChart(CollectionUtil.newEntry(Planet.Ascendant, Rasi.Mesha), CollectionUtil.newEntry(Planet.Sun, Rasi.Mesha), CollectionUtil.newEntry(Planet.Moon, Rasi.Thula));
        YogaFacts yogaFacts = new YogaFacts();
        yogaFacts.setBirthAtDay(true);
        yogaFacts.setPersonSex(Sex.Male);
        YogaAnalysisTestHelper.loadFacts(planetChart, yogaFacts);
        YogaAnalysisTestHelper.getSession().fireAllRules();
        YogaAnalysisTestHelper.testYogaPresent(YogaCombination.MahabhagyaYoga);
    }

    @Test
    public void testMahabhagyaYoga2() throws Exception {
        YogaAnalysisTestHelper.setUp("Mahabhagya Yoga");
        PlanetChart planetChart = YogaAnalysisTestHelper.constructChart(CollectionUtil.newEntry(Planet.Ascendant, Rasi.Mesha), CollectionUtil.newEntry(Planet.Sun, Rasi.Vrishabha), CollectionUtil.newEntry(Planet.Moon, Rasi.Thula));
        YogaFacts yogaFacts = new YogaFacts();
        yogaFacts.setBirthAtDay(true);
        yogaFacts.setPersonSex(Sex.Male);
        YogaAnalysisTestHelper.loadFacts(planetChart, yogaFacts);
        YogaAnalysisTestHelper.getSession().fireAllRules();
        YogaAnalysisTestHelper.testYogaNotPresent(YogaCombination.MahabhagyaYoga);
    }

    @Test
    public void testMahabhagyaYoga4() throws Exception {
        YogaAnalysisTestHelper.setUp("Mahabhagya Yoga");
        PlanetChart planetChart = YogaAnalysisTestHelper.constructChart(CollectionUtil.newEntry(Planet.Ascendant, Rasi.Mesha), CollectionUtil.newEntry(Planet.Sun, Rasi.Mesha), CollectionUtil.newEntry(Planet.Moon, Rasi.Thula));
        YogaFacts yogaFacts = new YogaFacts();
        yogaFacts.setBirthAtDay(true);
        yogaFacts.setPersonSex(Sex.Female);
        YogaAnalysisTestHelper.loadFacts(planetChart, yogaFacts);
        YogaAnalysisTestHelper.getSession().fireAllRules();
        YogaAnalysisTestHelper.testYogaNotPresent(YogaCombination.MahabhagyaYoga);
    }

    @Test
    public void testMahabhagyaYoga6() throws Exception {
        YogaAnalysisTestHelper.setUp("Mahabhagya Yoga");
        PlanetChart planetChart = YogaAnalysisTestHelper.constructChart(CollectionUtil.newEntry(Planet.Ascendant, Rasi.Mesha), CollectionUtil.newEntry(Planet.Sun, Rasi.Mesha), CollectionUtil.newEntry(Planet.Moon, Rasi.Thula));
        YogaFacts yogaFacts = new YogaFacts();
        yogaFacts.setBirthAtDay(false);
        yogaFacts.setPersonSex(Sex.Male);
        YogaAnalysisTestHelper.loadFacts(planetChart, yogaFacts);
        YogaAnalysisTestHelper.getSession().fireAllRules();
        YogaAnalysisTestHelper.testYogaNotPresent(YogaCombination.MahabhagyaYoga);
    }

    @Test
    public void testMahabhagyaYoga3() throws Exception {
        YogaAnalysisTestHelper.setUp("Mahabhagya Yoga");
        PlanetChart planetChart = YogaAnalysisTestHelper.constructChart(CollectionUtil.newEntry(Planet.Ascendant, Rasi.Vrishabha), CollectionUtil.newEntry(Planet.Sun, Rasi.Kataka), CollectionUtil.newEntry(Planet.Moon, Rasi.Kanya));
        YogaFacts yogaFacts = new YogaFacts();
        yogaFacts.setBirthAtDay(false);
        yogaFacts.setPersonSex(Sex.Female);
        YogaAnalysisTestHelper.loadFacts(planetChart, yogaFacts);
        YogaAnalysisTestHelper.getSession().fireAllRules();
        YogaAnalysisTestHelper.testYogaPresent(YogaCombination.MahabhagyaYoga);
    }

    @Test
    public void testMahabhagyaYoga8() throws Exception {
        YogaAnalysisTestHelper.setUp("Mahabhagya Yoga");
        PlanetChart planetChart = YogaAnalysisTestHelper.constructChart(CollectionUtil.newEntry(Planet.Ascendant, Rasi.Mesha), CollectionUtil.newEntry(Planet.Sun, Rasi.Vrichika), CollectionUtil.newEntry(Planet.Moon, Rasi.Makara));
        YogaFacts yogaFacts = new YogaFacts();
        yogaFacts.setBirthAtDay(false);
        yogaFacts.setPersonSex(Sex.Female);
        YogaAnalysisTestHelper.loadFacts(planetChart, yogaFacts);
        YogaAnalysisTestHelper.getSession().fireAllRules();
        YogaAnalysisTestHelper.testYogaNotPresent(YogaCombination.MahabhagyaYoga);
    }

    @Test
    public void testMahabhagyaYoga10() throws Exception {
        YogaAnalysisTestHelper.setUp("Mahabhagya Yoga");
        PlanetChart planetChart = YogaAnalysisTestHelper.constructChart(CollectionUtil.newEntry(Planet.Ascendant, Rasi.Meena), CollectionUtil.newEntry(Planet.Sun, Rasi.Vrichika), CollectionUtil.newEntry(Planet.Moon, Rasi.Makara));
        YogaFacts yogaFacts = new YogaFacts();
        yogaFacts.setBirthAtDay(false);
        yogaFacts.setPersonSex(Sex.Male);
        YogaAnalysisTestHelper.loadFacts(planetChart, yogaFacts);
        YogaAnalysisTestHelper.getSession().fireAllRules();
        YogaAnalysisTestHelper.testYogaNotPresent(YogaCombination.MahabhagyaYoga);
    }

    @Test
    public void testMahabhagyaYoga12() throws Exception {
        YogaAnalysisTestHelper.setUp("Mahabhagya Yoga");
        PlanetChart planetChart = YogaAnalysisTestHelper.constructChart(CollectionUtil.newEntry(Planet.Ascendant, Rasi.Meena), CollectionUtil.newEntry(Planet.Sun, Rasi.Vrichika), CollectionUtil.newEntry(Planet.Moon, Rasi.Makara));
        YogaFacts yogaFacts = new YogaFacts();
        yogaFacts.setBirthAtDay(true);
        yogaFacts.setPersonSex(Sex.Female);
        YogaAnalysisTestHelper.loadFacts(planetChart, yogaFacts);
        YogaAnalysisTestHelper.getSession().fireAllRules();
        YogaAnalysisTestHelper.testYogaNotPresent(YogaCombination.MahabhagyaYoga);
    }
}

