/*
 * Decompiled with CFR 0.152.
 */
package app.astrosoft.xps.yoga.test;

import app.astrosoft.consts.Planet;
import app.astrosoft.consts.Rasi;
import app.astrosoft.consts.YogaCombination;
import app.astrosoft.util.CollectionUtil;
import app.astrosoft.xps.beans.PlanetChart;
import app.astrosoft.xps.yoga.test.YogaAnalysisTestCase;
import app.astrosoft.xps.yoga.test.YogaAnalysisTestHelper;
import org.junit.Test;

public class PanchamahapurushaYogaTestCase
extends YogaAnalysisTestCase {
    @Test
    public void testHamsaYoga1() throws Exception {
        PlanetChart planetChart = YogaAnalysisTestHelper.constructChart(CollectionUtil.newEntry(Planet.Ascendant, Rasi.Mesha), CollectionUtil.newEntry(Planet.Jupiter, Rasi.Kataka));
        YogaAnalysisTestHelper.setUp("Hamsa Yoga");
        YogaAnalysisTestHelper.loadFacts(planetChart);
        YogaAnalysisTestHelper.getSession().fireAllRules();
        YogaAnalysisTestHelper.testYogaPresent(YogaCombination.HamsaYoga, "100%");
    }

    @Test
    public void testHamsaYoga3() throws Exception {
        PlanetChart planetChart = YogaAnalysisTestHelper.constructChart(CollectionUtil.newEntry(Planet.Ascendant, Rasi.Dhanus), CollectionUtil.newEntry(Planet.Jupiter, Rasi.Meena));
        YogaAnalysisTestHelper.setUp("Hamsa Yoga");
        YogaAnalysisTestHelper.loadFacts(planetChart);
        YogaAnalysisTestHelper.getSession().fireAllRules();
        YogaAnalysisTestHelper.testYogaPresent(YogaCombination.HamsaYoga, "100%");
    }

    @Test
    public void testHamsaYoga2() throws Exception {
        PlanetChart planetChart = YogaAnalysisTestHelper.constructChart(CollectionUtil.newEntry(Planet.Ascendant, Rasi.Mesha), CollectionUtil.newEntry(Planet.Jupiter, Rasi.Meena));
        YogaAnalysisTestHelper.setUp("Hamsa Yoga");
        YogaAnalysisTestHelper.loadFacts(planetChart);
        YogaAnalysisTestHelper.getSession().fireAllRules();
        YogaAnalysisTestHelper.testYogaNotPresent(YogaCombination.HamsaYoga);
    }

    @Test
    public void testHamsaYoga4() throws Exception {
        PlanetChart planetChart = YogaAnalysisTestHelper.constructChart(CollectionUtil.newEntry(Planet.Ascendant, Rasi.Meena), CollectionUtil.newEntry(Planet.Jupiter, Rasi.Kataka));
        YogaAnalysisTestHelper.setUp("Hamsa Yoga");
        YogaAnalysisTestHelper.loadFacts(planetChart);
        YogaAnalysisTestHelper.getSession().fireAllRules();
        YogaAnalysisTestHelper.testYogaNotPresent(YogaCombination.HamsaYoga);
    }

    @Test
    public void testMalavyaYoga1() throws Exception {
        PlanetChart planetChart = YogaAnalysisTestHelper.constructChart(CollectionUtil.newEntry(Planet.Ascendant, Rasi.Mesha), CollectionUtil.newEntry(Planet.Venus, Rasi.Thula));
        YogaAnalysisTestHelper.setUp("Malavya Yoga");
        YogaAnalysisTestHelper.loadFacts(planetChart);
        YogaAnalysisTestHelper.getSession().fireAllRules();
        YogaAnalysisTestHelper.testYogaPresent(YogaCombination.MalavyaYoga, "100%");
    }

    @Test
    public void testMalavyaYoga3() throws Exception {
        PlanetChart planetChart = YogaAnalysisTestHelper.constructChart(CollectionUtil.newEntry(Planet.Ascendant, Rasi.Dhanus), CollectionUtil.newEntry(Planet.Venus, Rasi.Meena));
        YogaAnalysisTestHelper.setUp("Malavya Yoga");
        YogaAnalysisTestHelper.loadFacts(planetChart);
        YogaAnalysisTestHelper.getSession().fireAllRules();
        YogaAnalysisTestHelper.testYogaPresent(YogaCombination.MalavyaYoga, "100%");
    }

    @Test
    public void testMalavyaYoga2() throws Exception {
        PlanetChart planetChart = YogaAnalysisTestHelper.constructChart(CollectionUtil.newEntry(Planet.Ascendant, Rasi.Mesha), CollectionUtil.newEntry(Planet.Venus, Rasi.Meena));
        YogaAnalysisTestHelper.setUp("Malavya Yoga");
        YogaAnalysisTestHelper.loadFacts(planetChart);
        YogaAnalysisTestHelper.getSession().fireAllRules();
        YogaAnalysisTestHelper.testYogaNotPresent(YogaCombination.MalavyaYoga);
    }

    @Test
    public void testMalavyaYoga4() throws Exception {
        PlanetChart planetChart = YogaAnalysisTestHelper.constructChart(CollectionUtil.newEntry(Planet.Ascendant, Rasi.Mesha), CollectionUtil.newEntry(Planet.Venus, Rasi.Kataka));
        YogaAnalysisTestHelper.setUp("Malavya Yoga");
        YogaAnalysisTestHelper.loadFacts(planetChart);
        YogaAnalysisTestHelper.getSession().fireAllRules();
        YogaAnalysisTestHelper.testYogaNotPresent(YogaCombination.MalavyaYoga);
    }

    @Test
    public void testSasaYoga1() throws Exception {
        PlanetChart planetChart = YogaAnalysisTestHelper.constructChart(CollectionUtil.newEntry(Planet.Ascendant, Rasi.Mesha), CollectionUtil.newEntry(Planet.Saturn, Rasi.Thula));
        YogaAnalysisTestHelper.setUp("Sasa Yoga");
        YogaAnalysisTestHelper.loadFacts(planetChart);
        YogaAnalysisTestHelper.getSession().fireAllRules();
        YogaAnalysisTestHelper.testYogaPresent(YogaCombination.SasaYoga, "100%");
    }

    @Test
    public void testSasaYoga3() throws Exception {
        PlanetChart planetChart = YogaAnalysisTestHelper.constructChart(CollectionUtil.newEntry(Planet.Ascendant, Rasi.Mesha), CollectionUtil.newEntry(Planet.Saturn, Rasi.Makara));
        YogaAnalysisTestHelper.setUp("Sasa Yoga");
        YogaAnalysisTestHelper.loadFacts(planetChart);
        YogaAnalysisTestHelper.getSession().fireAllRules();
        YogaAnalysisTestHelper.testYogaPresent(YogaCombination.SasaYoga, "100%");
    }

    @Test
    public void testSasaYoga2() throws Exception {
        PlanetChart planetChart = YogaAnalysisTestHelper.constructChart(CollectionUtil.newEntry(Planet.Ascendant, Rasi.Vrishabha), CollectionUtil.newEntry(Planet.Saturn, Rasi.Makara));
        YogaAnalysisTestHelper.setUp("Sasa Yoga");
        YogaAnalysisTestHelper.loadFacts(planetChart);
        YogaAnalysisTestHelper.getSession().fireAllRules();
        YogaAnalysisTestHelper.testYogaNotPresent(YogaCombination.SasaYoga);
    }

    @Test
    public void testSasaYoga4() throws Exception {
        PlanetChart planetChart = YogaAnalysisTestHelper.constructChart(CollectionUtil.newEntry(Planet.Ascendant, Rasi.Vrishabha), CollectionUtil.newEntry(Planet.Saturn, Rasi.Thula));
        YogaAnalysisTestHelper.setUp("Sasa Yoga");
        YogaAnalysisTestHelper.loadFacts(planetChart);
        YogaAnalysisTestHelper.getSession().fireAllRules();
        YogaAnalysisTestHelper.testYogaNotPresent(YogaCombination.SasaYoga);
    }

    @Test
    public void testRuchakaYoga1() throws Exception {
        PlanetChart planetChart = YogaAnalysisTestHelper.constructChart(CollectionUtil.newEntry(Planet.Ascendant, Rasi.Mesha), CollectionUtil.newEntry(Planet.Mars, Rasi.Mesha));
        YogaAnalysisTestHelper.setUp("Ruchaka Yoga");
        YogaAnalysisTestHelper.loadFacts(planetChart);
        YogaAnalysisTestHelper.getSession().fireAllRules();
        YogaAnalysisTestHelper.testYogaPresent(YogaCombination.RuchakaYoga);
    }

    @Test
    public void testRuchakaYoga3() throws Exception {
        PlanetChart planetChart = YogaAnalysisTestHelper.constructChart(CollectionUtil.newEntry(Planet.Ascendant, Rasi.Mesha), CollectionUtil.newEntry(Planet.Mars, Rasi.Makara));
        YogaAnalysisTestHelper.setUp("Ruchaka Yoga");
        YogaAnalysisTestHelper.loadFacts(planetChart);
        YogaAnalysisTestHelper.getSession().fireAllRules();
        YogaAnalysisTestHelper.testYogaPresent(YogaCombination.RuchakaYoga);
    }

    @Test
    public void testRuchakaYoga2() throws Exception {
        PlanetChart planetChart = YogaAnalysisTestHelper.constructChart(CollectionUtil.newEntry(Planet.Ascendant, Rasi.Meena), CollectionUtil.newEntry(Planet.Mars, Rasi.Makara));
        YogaAnalysisTestHelper.setUp("Ruchaka Yoga");
        YogaAnalysisTestHelper.loadFacts(planetChart);
        YogaAnalysisTestHelper.getSession().fireAllRules();
        YogaAnalysisTestHelper.testYogaNotPresent(YogaCombination.RuchakaYoga);
    }

    @Test
    public void testRuchakaYoga4() throws Exception {
        PlanetChart planetChart = YogaAnalysisTestHelper.constructChart(CollectionUtil.newEntry(Planet.Ascendant, Rasi.Meena), CollectionUtil.newEntry(Planet.Mars, Rasi.Mithuna));
        YogaAnalysisTestHelper.setUp("Ruchaka Yoga");
        YogaAnalysisTestHelper.loadFacts(planetChart);
        YogaAnalysisTestHelper.getSession().fireAllRules();
        YogaAnalysisTestHelper.testYogaNotPresent(YogaCombination.RuchakaYoga);
    }

    @Test
    public void testBhadraYoga1() throws Exception {
        PlanetChart planetChart = YogaAnalysisTestHelper.constructChart(CollectionUtil.newEntry(Planet.Ascendant, Rasi.Mithuna), CollectionUtil.newEntry(Planet.Mercury, Rasi.Kanya));
        YogaAnalysisTestHelper.setUp("Bhadra Yoga");
        YogaAnalysisTestHelper.loadFacts(planetChart);
        YogaAnalysisTestHelper.getSession().fireAllRules();
        YogaAnalysisTestHelper.testYogaPresent(YogaCombination.BhadraYoga);
    }

    @Test
    public void testBhadraYoga3() throws Exception {
        PlanetChart planetChart = YogaAnalysisTestHelper.constructChart(CollectionUtil.newEntry(Planet.Ascendant, Rasi.Mithuna), CollectionUtil.newEntry(Planet.Mercury, Rasi.Mithuna));
        YogaAnalysisTestHelper.setUp("Bhadra Yoga");
        YogaAnalysisTestHelper.loadFacts(planetChart);
        YogaAnalysisTestHelper.getSession().fireAllRules();
        YogaAnalysisTestHelper.testYogaPresent(YogaCombination.BhadraYoga);
    }

    @Test
    public void testBhadraYoga2() throws Exception {
        PlanetChart planetChart = YogaAnalysisTestHelper.constructChart(CollectionUtil.newEntry(Planet.Ascendant, Rasi.Vrichika), CollectionUtil.newEntry(Planet.Mercury, Rasi.Mithuna));
        YogaAnalysisTestHelper.setUp("Bhadra Yoga");
        YogaAnalysisTestHelper.loadFacts(planetChart);
        YogaAnalysisTestHelper.getSession().fireAllRules();
        YogaAnalysisTestHelper.testYogaNotPresent(YogaCombination.BhadraYoga);
    }

    @Test
    public void testBhadraYoga4() throws Exception {
        PlanetChart planetChart = YogaAnalysisTestHelper.constructChart(CollectionUtil.newEntry(Planet.Ascendant, Rasi.Kumbha), CollectionUtil.newEntry(Planet.Mercury, Rasi.Kanya));
        YogaAnalysisTestHelper.setUp("Bhadra Yoga");
        YogaAnalysisTestHelper.loadFacts(planetChart);
        YogaAnalysisTestHelper.getSession().fireAllRules();
        YogaAnalysisTestHelper.testYogaNotPresent(YogaCombination.BhadraYoga);
    }
}

