/*
 * Decompiled with CFR 0.152.
 */
package app.astrosoft.xps.yoga.test;

import app.astrosoft.beans.PlanetCharacter;
import app.astrosoft.consts.Planet;
import app.astrosoft.consts.Rasi;
import app.astrosoft.consts.Varga;
import app.astrosoft.core.Horoscope;
import app.astrosoft.test.SampleHoroscopes;
import app.astrosoft.xps.beans.PlanetChart;
import java.util.EnumMap;
import java.util.EnumSet;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class PlanetChartTestCase {
    private static PlanetChart chart1;
    private static PlanetChart chart2;
    private static PlanetCharacter character1;

    @BeforeClass
    public static void setUpTest() {
        PlanetChartTestCase.setUpChart1();
        PlanetChartTestCase.setUpChart2();
    }

    private static void setUpChart2() {
        EnumMap<Planet, Integer> enumMap = new EnumMap<Planet, Integer>(Planet.class);
        enumMap.put(Planet.Sun, 1);
        enumMap.put(Planet.Moon, 4);
        enumMap.put(Planet.Mars, 4);
        enumMap.put(Planet.Mercury, 6);
        enumMap.put(Planet.Jupiter, 2);
        enumMap.put(Planet.Venus, 2);
        enumMap.put(Planet.Saturn, 2);
        enumMap.put(Planet.Rahu, 2);
        enumMap.put(Planet.Ketu, 2);
        enumMap.put(Planet.Ascendant, 1);
        EnumMap<Planet, Rasi> enumMap2 = new EnumMap<Planet, Rasi>(Planet.class);
        enumMap2.put(Planet.Sun, Rasi.Mesha);
        enumMap2.put(Planet.Moon, Rasi.Kataka);
        enumMap2.put(Planet.Mars, Rasi.Kataka);
        enumMap2.put(Planet.Mercury, Rasi.Kanya);
        enumMap2.put(Planet.Jupiter, Rasi.Vrishabha);
        enumMap2.put(Planet.Venus, Rasi.Vrishabha);
        enumMap2.put(Planet.Saturn, Rasi.Vrishabha);
        enumMap2.put(Planet.Rahu, Rasi.Vrishabha);
        enumMap2.put(Planet.Ketu, Rasi.Vrishabha);
        enumMap2.put(Planet.Ascendant, Rasi.Mesha);
        chart2 = new PlanetChart(Varga.Rasi, enumMap, enumMap2);
    }

    private static void setUpChart1() {
        Horoscope horoscope = SampleHoroscopes.getMyHoroscope();
        chart1 = new PlanetChart(Varga.Rasi, horoscope.getPlanetaryInfo());
        character1 = new PlanetCharacter(horoscope.getPlanetaryInfo().getPlanetCharacter());
    }

    @Test
    public void testIsPlanetsAtLocation() {
        Assert.assertTrue((String)"testIsPlanetsAtLocation() sucess", (boolean)chart1.isPlanetsAt(EnumSet.of(Planet.Sun, Planet.Mercury), 3));
    }

    @Test
    public void testIsPlanetsAtHouse1() {
        Assert.assertTrue((String)"testIsPlanetsAtHouse() sucess", (boolean)chart1.isPlanetsAt(EnumSet.of(Planet.Sun, Planet.Mercury), Rasi.Vrichika));
    }

    @Test
    public void testIsPlanetsAtHouse2() {
        Assert.assertFalse((String)"testIsPlanetsAtLocation() sucess", (boolean)chart1.isPlanetsAt(EnumSet.of(Planet.Sun, Planet.Mercury, Planet.Moon), Rasi.Mesha));
    }

    @Test
    public void testIsPlanetWithAll() {
        Assert.assertTrue((boolean)chart1.isPlanetWithAll(Planet.Ascendant, EnumSet.of(Planet.Saturn, Planet.Jupiter)));
    }

    @Test
    public void testIsPlanetWithAny() {
        Assert.assertTrue((boolean)chart1.isPlanetWithAny(Planet.Ascendant, EnumSet.of(Planet.Sun, Planet.Jupiter)));
    }

    @Test
    public void testIsPlanetExalted1() throws Exception {
        Assert.assertTrue((boolean)chart2.isPlanetExalted(Planet.Sun));
    }

    @Test
    public void testIsPlanetExalted2() throws Exception {
        Assert.assertFalse((boolean)chart2.isPlanetExalted(Planet.Jupiter));
    }

    @Test
    public void testIsPlanetDebilitated1() throws Exception {
        Assert.assertTrue((boolean)chart2.isPlanetDebilitated(Planet.Mars));
    }

    @Test
    public void testIsPlanetDebilitated2() throws Exception {
        Assert.assertFalse((boolean)chart2.isPlanetDebilitated(Planet.Sun));
    }

    @Test
    public void testIsPlanetInOwnHouse1() throws Exception {
        Assert.assertTrue((boolean)chart2.isPlanetInOwnHouse(Planet.Moon));
    }

    @Test
    public void testIsPlanetInOwnHouse2() throws Exception {
        Assert.assertFalse((boolean)chart2.isPlanetInOwnHouse(Planet.Jupiter));
    }

    @Test
    public void testIsPlanetInMoolaTrikona1() throws Exception {
        Assert.assertTrue((boolean)chart1.isPlanetInMoolaTrikona(Planet.Venus));
    }

    @Test
    public void testIsPlanetInKendra1() throws Exception {
        Assert.assertTrue((boolean)chart1.isPlanetInKendra(Planet.Mars));
    }

    @Test
    public void testIsPlanetInKendra2() throws Exception {
        Assert.assertFalse((boolean)chart1.isPlanetInKendra(Planet.Sun));
    }

    @Test
    public void testIsPlanetInTrine1() throws Exception {
        Assert.assertTrue((boolean)chart1.isPlanetInTrine(Planet.Moon));
    }

    @Test
    public void testIsPlanetInTrine2() throws Exception {
        Assert.assertFalse((boolean)chart1.isPlanetInTrine(Planet.Mars));
    }

    @Test
    public void testIsPlanetInKendraTo1() throws Exception {
        Assert.assertTrue((boolean)chart1.isPlanetInKendraTo(Planet.Moon, Planet.Venus));
    }

    @Test
    public void testIsPlanetInKendraTo2() throws Exception {
        Assert.assertFalse((boolean)chart1.isPlanetInKendraTo(Planet.Mars, Planet.Venus));
    }

    @Test
    public void testIsPlanetInTrineTo1() throws Exception {
        Assert.assertTrue((boolean)chart1.isPlanetInTrineTo(Planet.Jupiter, Planet.Moon));
    }

    @Test
    public void testIsPlanetAspectedBy1() throws Exception {
        Assert.assertTrue((boolean)chart1.isPlanetAspectedBy(Planet.Mercury, Planet.Saturn));
    }

    @Test
    public void testIsPlanetAspectedBy2() throws Exception {
        Assert.assertFalse((boolean)chart1.isPlanetAspectedBy(Planet.Saturn, Planet.Mercury));
    }

    @Test
    public void testIsPlanetAspectedBy3() throws Exception {
        Assert.assertFalse((boolean)chart1.isPlanetAspectedBy(Planet.Mars, Planet.Jupiter));
    }

    @Test
    public void testIsPlanetAspectedBy4() throws Exception {
        Assert.assertTrue((boolean)chart1.isPlanetAspectedBy(Planet.Rahu, Planet.Ketu));
    }

    @Test
    public void testIsPlanetAspectedBy5() throws Exception {
        Assert.assertTrue((boolean)chart1.isPlanetAspectedBy(Planet.Ketu, Planet.Rahu));
    }

    @Test
    public void testIsPlanetAspectedBy6() throws Exception {
        Assert.assertFalse((boolean)chart1.isPlanetAspectedBy(Planet.Jupiter, Planet.Saturn));
    }

    @Test
    public void testIsPlanetAspectedBy7() throws Exception {
        Assert.assertTrue((boolean)chart1.isPlanetAspectedBy(Planet.Rahu, Planet.Moon));
    }

    @Test
    public void testIsHouseAspectedBy1() throws Exception {
        Assert.assertTrue((boolean)chart1.isHouseAspectedBy(Rasi.Mithuna, Planet.Saturn));
    }

    @Test
    public void testIsHouseAspectedBy2() throws Exception {
        Assert.assertTrue((boolean)chart1.isHouseAspectedBy(Rasi.Vrishabha, Planet.Sun));
    }

    @Test
    public void testIsHouseAspectedBy3() throws Exception {
        Assert.assertFalse((boolean)chart1.isHouseAspectedBy(Rasi.Vrishabha, Planet.Moon));
    }

    @Test
    public void testIsHouseAspectedBy4() throws Exception {
        Assert.assertTrue((boolean)chart1.isHouseAspectedBy(Rasi.Kataka, Planet.Mars));
    }

    @Test
    public void testIsHouseAspectedBy5() throws Exception {
        Assert.assertFalse((boolean)chart1.isHouseAspectedBy(Rasi.Vrichika, Planet.Mercury));
    }

    @Test
    public void testIsHouseAspectedBy6() throws Exception {
        Assert.assertTrue((boolean)chart1.isHouseAspectedBy(Rasi.Mesha, Planet.Venus));
    }

    @Test
    public void testIsHouseAspectedBy7() throws Exception {
        Assert.assertTrue((boolean)chart1.isHouseAspectedBy(Rasi.Makara, Planet.Jupiter));
    }

    @Test
    public void testIsHouseAspectedBy8() throws Exception {
        Assert.assertTrue((boolean)chart1.isHouseAspectedBy(Rasi.Kataka, Planet.Ketu));
    }

    @Test
    public void testIsHouseAspectedBy9() throws Exception {
        Assert.assertTrue((boolean)chart1.isHouseAspectedBy(Rasi.Makara, Planet.Rahu));
    }

    @Test
    public void testPlanetsAt1() {
        Assert.assertTrue((boolean)chart1.planetsAt(Planet.Moon, 1).containsAll(EnumSet.of(Planet.Moon, Planet.Ketu)));
    }

    @Test
    public void testPlanetsAt2() {
        Assert.assertTrue((boolean)chart1.planetsAt(Planet.Saturn, 5).containsAll(EnumSet.of(Planet.Moon, Planet.Ketu)));
    }

    @Test
    public void testPlanetsAt3() {
        Assert.assertTrue((boolean)chart1.planetsAt(Planet.Mars, 12).containsAll(EnumSet.of(Planet.Sun, Planet.Mercury)));
    }

    @Test
    public void testPlanetsAt4() {
        Assert.assertTrue((boolean)chart1.planetsAt(Planet.Sun, 7).isEmpty());
    }

    @Test
    public void testIsAllBenefic() {
        Assert.assertTrue((boolean)character1.isAllBenefics(EnumSet.of(Planet.Moon, Planet.Jupiter, Planet.Venus, Planet.Mercury)));
    }

    @Test
    public void testIsAllBenefic2() {
        Assert.assertFalse((boolean)character1.isAllBenefics(EnumSet.of(Planet.Moon, Planet.Saturn, Planet.Venus, Planet.Mercury)));
    }

    @Test
    public void testIsAnyBenefic1() {
        Assert.assertTrue((boolean)character1.isAnyBenefics(EnumSet.of(Planet.Moon, Planet.Sun, Planet.Rahu, Planet.Ketu)));
    }

    @Test
    public void testIsAnyBenefic2() {
        Assert.assertFalse((boolean)character1.isAnyBenefics(EnumSet.of(Planet.Mars, Planet.Sun, Planet.Rahu, Planet.Ketu)));
    }

    @Test
    public void testIsAllMalefic1() {
        Assert.assertTrue((boolean)character1.isAllMalefics(EnumSet.of(Planet.Mars, Planet.Sun, Planet.Rahu, Planet.Ketu)));
    }

    @Test
    public void testIsAllMalefic2() {
        Assert.assertFalse((boolean)character1.isAllMalefics(EnumSet.of(Planet.Jupiter, Planet.Sun, Planet.Rahu, Planet.Ketu)));
    }

    @Test
    public void testIsAnyMalefic1() {
        Assert.assertTrue((boolean)character1.isAnyMalefics(EnumSet.of(Planet.Mars, Planet.Jupiter, Planet.Rahu, Planet.Ketu)));
    }

    @Test
    public void testIsAnyMalefic2() {
        Assert.assertFalse((boolean)character1.isAnyMalefics(EnumSet.of(Planet.Moon, Planet.Jupiter, Planet.Venus, Planet.Mercury)));
    }

    @Test
    public void testLordOf1() {
        Assert.assertEquals((Object)((Object)chart1.lordOf(1)), (Object)((Object)Planet.Mercury));
    }

    @Test
    public void testLordOf2() {
        Assert.assertEquals((Object)((Object)chart1.lordOf(2)), (Object)((Object)Planet.Venus));
    }

    @Test
    public void testLordOf3() {
        Assert.assertEquals((Object)((Object)chart1.lordOf(3)), (Object)((Object)Planet.Mars));
    }

    @Test
    public void testLordOf4() {
        Assert.assertEquals((Object)((Object)chart1.lordOf(12)), (Object)((Object)Planet.Sun));
    }
}

