/*
 * Decompiled with CFR 0.152.
 */
package app.astrosoft.xps.yoga.test;

import app.astrosoft.consts.Planet;
import app.astrosoft.consts.Rasi;
import app.astrosoft.consts.YogaCombination;
import app.astrosoft.util.CollectionUtil;
import app.astrosoft.xps.beans.PlanetChart;
import app.astrosoft.xps.yoga.test.YogaAnalysisTestCase;
import app.astrosoft.xps.yoga.test.YogaAnalysisTestHelper;
import org.junit.Test;

public class SankhaYogaTestCase
extends YogaAnalysisTestCase {
    @Test
    public void testSankhaYoga1() throws Exception {
        PlanetChart planetChart = YogaAnalysisTestHelper.constructChart(CollectionUtil.newEntry(Planet.Ascendant, Rasi.Mesha), CollectionUtil.newEntry(Planet.Mars, Rasi.Mesha), CollectionUtil.newEntry(Planet.Sun, Rasi.Thula), CollectionUtil.newEntry(Planet.Mercury, Rasi.Thula));
        YogaAnalysisTestHelper.setUp("Sankha Yoga");
        YogaAnalysisTestHelper.loadFacts(planetChart);
        YogaAnalysisTestHelper.getSession().fireAllRules();
        YogaAnalysisTestHelper.testYogaPresent(YogaCombination.SankhaYoga, "100%");
    }

    @Test
    public void testSankhaYoga3() throws Exception {
        PlanetChart planetChart = YogaAnalysisTestHelper.constructChart(CollectionUtil.newEntry(Planet.Ascendant, Rasi.Mesha), CollectionUtil.newEntry(Planet.Mars, Rasi.Thula), CollectionUtil.newEntry(Planet.Sun, Rasi.Thula), CollectionUtil.newEntry(Planet.Mercury, Rasi.Mesha));
        YogaAnalysisTestHelper.setUp("Sankha Yoga");
        YogaAnalysisTestHelper.loadFacts(planetChart);
        YogaAnalysisTestHelper.getSession().fireAllRules();
        YogaAnalysisTestHelper.testYogaPresent(YogaCombination.SankhaYoga, "100%");
    }

    @Test
    public void testSankhaYoga2() throws Exception {
        PlanetChart planetChart = YogaAnalysisTestHelper.constructChart(CollectionUtil.newEntry(Planet.Ascendant, Rasi.Mesha), CollectionUtil.newEntry(Planet.Mars, Rasi.Vrishabha), CollectionUtil.newEntry(Planet.Sun, Rasi.Thula), CollectionUtil.newEntry(Planet.Mercury, Rasi.Mesha));
        YogaAnalysisTestHelper.setUp("Sankha Yoga");
        YogaAnalysisTestHelper.loadFacts(planetChart);
        YogaAnalysisTestHelper.getSession().fireAllRules();
        YogaAnalysisTestHelper.testYogaNotPresent(YogaCombination.SankhaYoga);
    }

    @Test
    public void testSankhaYoga4() throws Exception {
        PlanetChart planetChart = YogaAnalysisTestHelper.constructChart(CollectionUtil.newEntry(Planet.Ascendant, Rasi.Mesha), CollectionUtil.newEntry(Planet.Mars, Rasi.Kataka), CollectionUtil.newEntry(Planet.Sun, Rasi.Thula), CollectionUtil.newEntry(Planet.Mercury, Rasi.Vrichika));
        YogaAnalysisTestHelper.setUp("Sankha Yoga");
        YogaAnalysisTestHelper.loadFacts(planetChart);
        YogaAnalysisTestHelper.getSession().fireAllRules();
        YogaAnalysisTestHelper.testYogaNotPresent(YogaCombination.SankhaYoga);
    }
}

