/*
 * Decompiled with CFR 0.152.
 */
package app.astrosoft.xps.yoga.test;

import app.astrosoft.consts.Planet;
import app.astrosoft.consts.Rasi;
import app.astrosoft.consts.YogaCombination;
import app.astrosoft.util.CollectionUtil;
import app.astrosoft.xps.beans.PlanetChart;
import app.astrosoft.xps.yoga.test.YogaAnalysisTestCase;
import app.astrosoft.xps.yoga.test.YogaAnalysisTestHelper;
import org.junit.Test;

public class SreenathaYogaTestCase
extends YogaAnalysisTestCase {
    @Test
    public void testSreenathaYoga1() throws Exception {
        PlanetChart planetChart = YogaAnalysisTestHelper.constructChart(CollectionUtil.newEntry(Planet.Ascendant, Rasi.Dhanus), CollectionUtil.newEntry(Planet.Mercury, Rasi.Kanya), CollectionUtil.newEntry(Planet.Sun, Rasi.Kanya));
        YogaAnalysisTestHelper.setUp("Sreenatha Yoga");
        YogaAnalysisTestHelper.loadFacts(planetChart);
        YogaAnalysisTestHelper.getSession().fireAllRules();
        YogaAnalysisTestHelper.testYogaPresent(YogaCombination.SreenathaYoga, "100%");
    }

    @Test
    public void testSreenathaYoga2() throws Exception {
        PlanetChart planetChart = YogaAnalysisTestHelper.constructChart(CollectionUtil.newEntry(Planet.Ascendant, Rasi.Dhanus), CollectionUtil.newEntry(Planet.Mercury, Rasi.Kanya), CollectionUtil.newEntry(Planet.Sun, Rasi.Simha));
        YogaAnalysisTestHelper.setUp("Sreenatha Yoga");
        YogaAnalysisTestHelper.loadFacts(planetChart);
        YogaAnalysisTestHelper.getSession().fireAllRules();
        YogaAnalysisTestHelper.testYogaNotPresent(YogaCombination.SreenathaYoga);
    }
}

