/*
 * Decompiled with CFR 0.152.
 */
package app.astrosoft.xps.yoga.test;

import app.astrosoft.consts.Planet;
import app.astrosoft.consts.Rasi;
import app.astrosoft.consts.YogaCombination;
import app.astrosoft.util.CollectionUtil;
import app.astrosoft.xps.beans.PlanetChart;
import app.astrosoft.xps.yoga.test.YogaAnalysisTestCase;
import app.astrosoft.xps.yoga.test.YogaAnalysisTestHelper;
import org.junit.Test;

public class ThrilochanaYogaTestCase
extends YogaAnalysisTestCase {
    @Test
    public void testThrilochanaYoga1() throws Exception {
        PlanetChart planetChart = YogaAnalysisTestHelper.constructChart(CollectionUtil.newEntry(Planet.Ascendant, Rasi.Mesha), CollectionUtil.newEntry(Planet.Sun, Rasi.Kanya), CollectionUtil.newEntry(Planet.Moon, Rasi.Makara), CollectionUtil.newEntry(Planet.Mars, Rasi.Vrishabha));
        YogaAnalysisTestHelper.setUp("Thrilochana Yoga");
        YogaAnalysisTestHelper.loadFacts(planetChart);
        YogaAnalysisTestHelper.getSession().fireAllRules();
        YogaAnalysisTestHelper.testYogaPresent(YogaCombination.ThrilochanaYoga, "100%");
    }

    @Test
    public void testThrilochanaYoga3() throws Exception {
        PlanetChart planetChart = YogaAnalysisTestHelper.constructChart(CollectionUtil.newEntry(Planet.Ascendant, Rasi.Mesha), CollectionUtil.newEntry(Planet.Moon, Rasi.Mesha), CollectionUtil.newEntry(Planet.Sun, Rasi.Simha), CollectionUtil.newEntry(Planet.Mars, Rasi.Dhanus));
        YogaAnalysisTestHelper.setUp("Thrilochana Yoga");
        YogaAnalysisTestHelper.loadFacts(planetChart);
        YogaAnalysisTestHelper.getSession().fireAllRules();
        YogaAnalysisTestHelper.testYogaPresent(YogaCombination.ThrilochanaYoga, "100%");
    }

    @Test
    public void testThrilochanaYoga5() throws Exception {
        PlanetChart planetChart = YogaAnalysisTestHelper.constructChart(CollectionUtil.newEntry(Planet.Ascendant, Rasi.Mesha), CollectionUtil.newEntry(Planet.Moon, Rasi.Mithuna), CollectionUtil.newEntry(Planet.Sun, Rasi.Thula), CollectionUtil.newEntry(Planet.Mars, Rasi.Thula));
        YogaAnalysisTestHelper.setUp("Thrilochana Yoga");
        YogaAnalysisTestHelper.loadFacts(planetChart);
        YogaAnalysisTestHelper.getSession().fireAllRules();
        YogaAnalysisTestHelper.testYogaPresent(YogaCombination.ThrilochanaYoga, "100%");
    }

    @Test
    public void testThrilochanaYoga2() throws Exception {
        PlanetChart planetChart = YogaAnalysisTestHelper.constructChart(CollectionUtil.newEntry(Planet.Ascendant, Rasi.Mesha), CollectionUtil.newEntry(Planet.Moon, Rasi.Mithuna), CollectionUtil.newEntry(Planet.Sun, Rasi.Thula), CollectionUtil.newEntry(Planet.Mars, Rasi.Vrichika));
        YogaAnalysisTestHelper.setUp("Thrilochana Yoga");
        YogaAnalysisTestHelper.loadFacts(planetChart);
        YogaAnalysisTestHelper.getSession().fireAllRules();
        YogaAnalysisTestHelper.testYogaNotPresent(YogaCombination.ThrilochanaYoga);
    }
}

