/*
 * Decompiled with CFR 0.152.
 */
package app.astrosoft.xps.yoga.test;

import app.astrosoft.consts.Planet;
import app.astrosoft.consts.Rasi;
import app.astrosoft.consts.YogaCombination;
import app.astrosoft.util.CollectionUtil;
import app.astrosoft.xps.beans.PlanetChart;
import app.astrosoft.xps.yoga.test.YogaAnalysisTestCase;
import app.astrosoft.xps.yoga.test.YogaAnalysisTestHelper;
import org.junit.Test;

public class VasiYogaTestCase
extends YogaAnalysisTestCase {
    @Test
    public void testSubhaVasiYoga1() throws Exception {
        PlanetChart planetChart = YogaAnalysisTestHelper.constructChart(CollectionUtil.newEntry(Planet.Ascendant, Rasi.Mesha), CollectionUtil.newEntry(Planet.Sun, Rasi.Kanya), CollectionUtil.newEntry(Planet.Jupiter, Rasi.Simha));
        YogaAnalysisTestHelper.setUp("SubhaVasi Yoga");
        YogaAnalysisTestHelper.loadFacts(planetChart);
        YogaAnalysisTestHelper.getSession().fireAllRules();
        YogaAnalysisTestHelper.testYogaPresent(YogaCombination.SubhaVasiYoga, "100%");
    }

    @Test
    public void testPapaVasiYoga1() throws Exception {
        PlanetChart planetChart = YogaAnalysisTestHelper.constructChart(CollectionUtil.newEntry(Planet.Ascendant, Rasi.Mesha), CollectionUtil.newEntry(Planet.Sun, Rasi.Kanya), CollectionUtil.newEntry(Planet.Saturn, Rasi.Simha));
        YogaAnalysisTestHelper.setUp("PapaVasi Yoga");
        YogaAnalysisTestHelper.loadFacts(planetChart);
        YogaAnalysisTestHelper.getSession().fireAllRules();
        YogaAnalysisTestHelper.testYogaPresent(YogaCombination.PapaVasiYoga, "100%");
    }

    @Test
    public void testSubhaVasiYoga2() throws Exception {
        PlanetChart planetChart = YogaAnalysisTestHelper.constructChart(CollectionUtil.newEntry(Planet.Ascendant, Rasi.Mesha), CollectionUtil.newEntry(Planet.Sun, Rasi.Kanya), CollectionUtil.newEntry(Planet.Rahu, Rasi.Thula));
        YogaAnalysisTestHelper.setUp("SubhaVasi Yoga");
        YogaAnalysisTestHelper.loadFacts(planetChart);
        YogaAnalysisTestHelper.getSession().fireAllRules();
        YogaAnalysisTestHelper.testYogaNotPresent(YogaCombination.SubhaVasiYoga);
    }

    @Test
    public void testPapaVasiYoga2() throws Exception {
        PlanetChart planetChart = YogaAnalysisTestHelper.constructChart(CollectionUtil.newEntry(Planet.Ascendant, Rasi.Simha), CollectionUtil.newEntry(Planet.Sun, Rasi.Kanya));
        YogaAnalysisTestHelper.setUp("PapaVasi Yoga");
        YogaAnalysisTestHelper.loadFacts(planetChart);
        YogaAnalysisTestHelper.getSession().fireAllRules();
        YogaAnalysisTestHelper.testYogaNotPresent(YogaCombination.PapaVasiYoga);
    }
}

