/*
 * Decompiled with CFR 0.152.
 */
package app.astrosoft.xps.yoga.test;

import app.astrosoft.consts.Planet;
import app.astrosoft.consts.Rasi;
import app.astrosoft.consts.YogaCombination;
import app.astrosoft.util.CollectionUtil;
import app.astrosoft.xps.beans.PlanetChart;
import app.astrosoft.xps.yoga.test.YogaAnalysisTestCase;
import app.astrosoft.xps.yoga.test.YogaAnalysisTestHelper;
import org.junit.Test;

public class VasumathiYogaTestCase
extends YogaAnalysisTestCase {
    @Test
    public void testVasumathiYoga1() throws Exception {
        PlanetChart planetChart = YogaAnalysisTestHelper.constructChart(CollectionUtil.newEntry(Planet.Ascendant, Rasi.Mesha), CollectionUtil.newEntry(Planet.Moon, Rasi.Mithuna), CollectionUtil.newEntry(Planet.Venus, Rasi.Simha), CollectionUtil.newEntry(Planet.Jupiter, Rasi.Meena));
        YogaAnalysisTestHelper.setUp("Vasumathi Yoga");
        YogaAnalysisTestHelper.loadFacts(planetChart);
        YogaAnalysisTestHelper.getSession().fireAllRules();
        YogaAnalysisTestHelper.testYogaPresent(YogaCombination.VasumathiYoga, "75%");
    }

    @Test
    public void testVasumathiYoga2() throws Exception {
        PlanetChart planetChart = YogaAnalysisTestHelper.constructChart(CollectionUtil.newEntry(Planet.Ascendant, Rasi.Mesha), CollectionUtil.newEntry(Planet.Moon, Rasi.Mithuna), CollectionUtil.newEntry(Planet.Venus, Rasi.Thula));
        YogaAnalysisTestHelper.setUp("Vasumathi Yoga");
        YogaAnalysisTestHelper.loadFacts(planetChart);
        YogaAnalysisTestHelper.getSession().fireAllRules();
        YogaAnalysisTestHelper.testYogaNotPresent(YogaCombination.VasumathiYoga);
    }

    @Test
    public void testVasumathiYoga3() throws Exception {
        PlanetChart planetChart = YogaAnalysisTestHelper.constructChart(CollectionUtil.newEntry(Planet.Ascendant, Rasi.Mithuna), CollectionUtil.newEntry(Planet.Moon, Rasi.Vrichika), CollectionUtil.newEntry(Planet.Venus, Rasi.Simha), CollectionUtil.newEntry(Planet.Jupiter, Rasi.Meena));
        YogaAnalysisTestHelper.setUp("Vasumathi Yoga");
        YogaAnalysisTestHelper.loadFacts(planetChart, YogaAnalysisTestHelper.getCharacter2());
        YogaAnalysisTestHelper.getSession().fireAllRules();
        YogaAnalysisTestHelper.testYogaPresent(YogaCombination.VasumathiYoga, "100%");
    }
}

