/*
 * Decompiled with CFR 0.152.
 */
package app.astrosoft.xps.yoga.test;

import app.astrosoft.consts.Planet;
import app.astrosoft.consts.Rasi;
import app.astrosoft.consts.YogaCombination;
import app.astrosoft.util.CollectionUtil;
import app.astrosoft.xps.beans.PlanetChart;
import app.astrosoft.xps.yoga.test.YogaAnalysisTestCase;
import app.astrosoft.xps.yoga.test.YogaAnalysisTestHelper;
import org.junit.Test;

public class VesiYogaTestCase
extends YogaAnalysisTestCase {
    @Test
    public void testSubhaVesiYoga1() throws Exception {
        PlanetChart planetChart = YogaAnalysisTestHelper.constructChart(CollectionUtil.newEntry(Planet.Ascendant, Rasi.Mesha), CollectionUtil.newEntry(Planet.Sun, Rasi.Kanya), CollectionUtil.newEntry(Planet.Jupiter, Rasi.Thula));
        YogaAnalysisTestHelper.setUp("SubhaVesi Yoga");
        YogaAnalysisTestHelper.loadFacts(planetChart);
        YogaAnalysisTestHelper.getSession().fireAllRules();
        YogaAnalysisTestHelper.testYogaPresent(YogaCombination.SubhaVesiYoga, "100%");
    }

    @Test
    public void testPapaVesiYoga1() throws Exception {
        PlanetChart planetChart = YogaAnalysisTestHelper.constructChart(CollectionUtil.newEntry(Planet.Ascendant, Rasi.Mesha), CollectionUtil.newEntry(Planet.Sun, Rasi.Kanya), CollectionUtil.newEntry(Planet.Saturn, Rasi.Thula));
        YogaAnalysisTestHelper.setUp("PapaVesi Yoga");
        YogaAnalysisTestHelper.loadFacts(planetChart);
        YogaAnalysisTestHelper.getSession().fireAllRules();
        YogaAnalysisTestHelper.testYogaPresent(YogaCombination.PapaVesiYoga, "100%");
    }

    @Test
    public void testSubhaVesiYoga2() throws Exception {
        PlanetChart planetChart = YogaAnalysisTestHelper.constructChart(CollectionUtil.newEntry(Planet.Ascendant, Rasi.Mesha), CollectionUtil.newEntry(Planet.Sun, Rasi.Kanya), CollectionUtil.newEntry(Planet.Rahu, Rasi.Thula));
        YogaAnalysisTestHelper.setUp("SubhaVesi Yoga");
        YogaAnalysisTestHelper.loadFacts(planetChart);
        YogaAnalysisTestHelper.getSession().fireAllRules();
        YogaAnalysisTestHelper.testYogaNotPresent(YogaCombination.SubhaVesiYoga);
    }

    @Test
    public void testPapaVesiYoga2() throws Exception {
        PlanetChart planetChart = YogaAnalysisTestHelper.constructChart(CollectionUtil.newEntry(Planet.Ascendant, Rasi.Thula), CollectionUtil.newEntry(Planet.Sun, Rasi.Kanya));
        YogaAnalysisTestHelper.setUp("PapaVesi Yoga");
        YogaAnalysisTestHelper.loadFacts(planetChart);
        YogaAnalysisTestHelper.getSession().fireAllRules();
        YogaAnalysisTestHelper.testYogaNotPresent(YogaCombination.PapaVesiYoga);
    }
}

