/*
 * Decompiled with CFR 0.152.
 */
package app.astrosoft.xps.yoga.test;

import app.astrosoft.consts.Planet;
import app.astrosoft.consts.Rasi;
import app.astrosoft.consts.YogaCombination;
import app.astrosoft.util.CollectionUtil;
import app.astrosoft.xps.beans.PlanetChart;
import app.astrosoft.xps.yoga.test.YogaAnalysisTestCase;
import app.astrosoft.xps.yoga.test.YogaAnalysisTestHelper;
import org.junit.Test;

public class VidyutYogaTestCase
extends YogaAnalysisTestCase {
    @Test
    public void testVidyutYoga1() throws Exception {
        PlanetChart planetChart = YogaAnalysisTestHelper.constructChart(CollectionUtil.newEntry(Planet.Ascendant, Rasi.Simha), CollectionUtil.newEntry(Planet.Mercury, Rasi.Kanya), CollectionUtil.newEntry(Planet.Venus, Rasi.Kanya), CollectionUtil.newEntry(Planet.Sun, Rasi.Kanya));
        YogaAnalysisTestHelper.setUp("Vidyut Yoga");
        YogaAnalysisTestHelper.loadFacts(planetChart);
        YogaAnalysisTestHelper.getSession().fireAllRules();
        YogaAnalysisTestHelper.testYogaPresent(YogaCombination.VidyutYoga, "100%");
    }

    @Test
    public void testVidyutYoga3() throws Exception {
        PlanetChart planetChart = YogaAnalysisTestHelper.constructChart(CollectionUtil.newEntry(Planet.Ascendant, Rasi.Kataka), CollectionUtil.newEntry(Planet.Venus, Rasi.Meena), CollectionUtil.newEntry(Planet.Moon, Rasi.Kanya));
        YogaAnalysisTestHelper.setUp("Vidyut Yoga");
        YogaAnalysisTestHelper.loadFacts(planetChart);
        YogaAnalysisTestHelper.getSession().fireAllRules();
        YogaAnalysisTestHelper.testYogaPresent(YogaCombination.VidyutYoga, "100%");
    }

    @Test
    public void testVidyutYoga2() throws Exception {
        PlanetChart planetChart = YogaAnalysisTestHelper.constructChart(CollectionUtil.newEntry(Planet.Ascendant, Rasi.Simha), CollectionUtil.newEntry(Planet.Mercury, Rasi.Mithuna), CollectionUtil.newEntry(Planet.Venus, Rasi.Kanya), CollectionUtil.newEntry(Planet.Sun, Rasi.Kanya));
        YogaAnalysisTestHelper.setUp("Vidyut Yoga");
        YogaAnalysisTestHelper.loadFacts(planetChart);
        YogaAnalysisTestHelper.getSession().fireAllRules();
        YogaAnalysisTestHelper.testYogaNotPresent(YogaCombination.VidyutYoga);
    }

    @Test
    public void testVidyutYoga4() throws Exception {
        PlanetChart planetChart = YogaAnalysisTestHelper.constructChart(CollectionUtil.newEntry(Planet.Ascendant, Rasi.Simha), CollectionUtil.newEntry(Planet.Mercury, Rasi.Kanya), CollectionUtil.newEntry(Planet.Venus, Rasi.Kanya), CollectionUtil.newEntry(Planet.Sun, Rasi.Thula));
        YogaAnalysisTestHelper.setUp("Vidyut Yoga");
        YogaAnalysisTestHelper.loadFacts(planetChart);
        YogaAnalysisTestHelper.getSession().fireAllRules();
        YogaAnalysisTestHelper.testYogaNotPresent(YogaCombination.VidyutYoga);
    }
}

