/*
 * Decompiled with CFR 0.152.
 */
package app.astrosoft.xps.yoga.test;

import app.astrosoft.beans.PlanetCharacter;
import app.astrosoft.consts.Planet;
import app.astrosoft.consts.Rasi;
import app.astrosoft.consts.Varga;
import app.astrosoft.consts.YogaCombination;
import app.astrosoft.core.Horoscope;
import app.astrosoft.test.SampleHoroscopes;
import app.astrosoft.util.CollectionUtil;
import app.astrosoft.xps.XpsUtil;
import app.astrosoft.xps.beans.PlanetChart;
import app.astrosoft.xps.beans.YogaFacts;
import app.astrosoft.xps.yoga.YogaResults;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import org.drools.RuleBase;
import org.drools.RuleBaseFactory;
import org.drools.StatefulSession;
import org.drools.WorkingMemoryEventManager;
import org.drools.audit.WorkingMemoryFileLogger;
import org.drools.compiler.DroolsParserException;
import org.drools.compiler.PackageBuilder;
import org.drools.event.AgendaEventListener;
import org.drools.event.DebugAgendaEventListener;
import org.drools.event.DebugWorkingMemoryEventListener;
import org.drools.event.WorkingMemoryEventListener;
import org.drools.rule.Package;
import org.drools.rule.Rule;
import org.junit.Assert;

public class YogaAnalysisTestHelper {
    private static PlanetCharacter character1;
    private static PlanetCharacter character2;
    private static String RULE_FILE;
    private static String DSL_FILE;
    public static final String YOGAS = "yogas";
    private static RuleBase ruleBase;
    private static StatefulSession session;
    private static Package pkg;
    private static WorkingMemoryFileLogger logger;
    private static Map<SAMPLE_HOROSCOPE, Horoscope> samples;

    public static Package buildPackage() throws DroolsParserException, IOException {
        InputStreamReader inputStreamReader = new InputStreamReader(XpsUtil.getRuleAsStream(RULE_FILE));
        InputStreamReader inputStreamReader2 = new InputStreamReader(XpsUtil.getRuleAsStream(DSL_FILE));
        PackageBuilder packageBuilder = new PackageBuilder();
        packageBuilder.addPackageFromDrl((Reader)inputStreamReader, (Reader)inputStreamReader2);
        if (packageBuilder.hasErrors()) {
            System.out.println(packageBuilder.getErrors().toString());
            throw new RuntimeException("Compilation Errors in " + RULE_FILE);
        }
        return packageBuilder.getPackage();
    }

    public static void setUpBeforeClass() throws Exception {
        System.out.println("setUpBeforeClass()");
        pkg = YogaAnalysisTestHelper.buildPackage();
        ruleBase = RuleBaseFactory.newRuleBase();
        ruleBase.addPackage(pkg);
        YogaAnalysisTestHelper.setUpHoroscope();
        YogaAnalysisTestHelper.setUpCharacter();
    }

    private static void setUpCharacter() {
        EnumMap<Planet, Boolean> enumMap = new EnumMap<Planet, Boolean>(Planet.class);
        EnumMap<Planet, Boolean> enumMap2 = new EnumMap<Planet, Boolean>(Planet.class);
        for (Planet planet : Planet.subaPlanets()) {
            enumMap.put(planet, true);
            enumMap2.put(planet, true);
        }
        for (Planet planet : Planet.papaPlanets()) {
            enumMap.put(planet, false);
            enumMap2.put(planet, false);
        }
        enumMap.put(Planet.Moon, true);
        enumMap2.put(Planet.Moon, false);
        character1 = new PlanetCharacter(enumMap);
        character2 = new PlanetCharacter(enumMap2);
    }

    private static void setUpHoroscope() {
        samples = new EnumMap<SAMPLE_HOROSCOPE, Horoscope>(SAMPLE_HOROSCOPE.class);
        Horoscope horoscope = SampleHoroscopes.getMyHoroscope();
        samples.put(SAMPLE_HOROSCOPE.RAJA, horoscope);
        samples.put(SAMPLE_HOROSCOPE.SUBA, SampleHoroscopes.getSubaHoroscope());
    }

    public static void setUp(String string) throws Exception {
        YogaAnalysisTestHelper.filterRule(string);
        YogaAnalysisTestHelper.printRules();
        session = ruleBase.newStatefulSession();
        YogaAnalysisTestHelper.registerListener(session);
        logger = new WorkingMemoryFileLogger((WorkingMemoryEventManager)session);
        logger.setFileName("C:/Astrosoft/yogaanalysis");
        YogaResults yogaResults = new YogaResults();
        session.setGlobal(YOGAS, (Object)yogaResults);
    }

    private static void registerListener(StatefulSession statefulSession) {
        statefulSession.addEventListener((AgendaEventListener)new DebugAgendaEventListener());
        statefulSession.addEventListener((WorkingMemoryEventListener)new DebugWorkingMemoryEventListener());
    }

    public static void filterRule(String string) throws Exception {
        Rule[] ruleArray;
        pkg = YogaAnalysisTestHelper.buildPackage();
        for (Rule rule : ruleArray = pkg.getRules()) {
            if (rule.getName().equals(string)) continue;
            pkg.removeRule(pkg.getRule(rule.getName()));
        }
        ruleBase = RuleBaseFactory.newRuleBase();
        ruleBase.addPackage(pkg);
    }

    public static void testYogaPresent(YogaCombination yogaCombination, String string) {
        YogaResults yogaResults = (YogaResults)session.getGlobal(YOGAS);
        Assert.assertTrue((boolean)yogaResults.getYogas().contains(new YogaResults.Result(yogaCombination, string)));
    }

    public static void testYogaPresent(YogaCombination yogaCombination) {
        YogaAnalysisTestHelper.testYogaPresent(yogaCombination, "100%");
    }

    public static void testYogaNotPresent(YogaCombination yogaCombination) {
        YogaResults yogaResults = (YogaResults)session.getGlobal(YOGAS);
        Assert.assertFalse((boolean)yogaResults.hasYogaCombination(yogaCombination));
    }

    public static PlanetChart constructChart(Varga varga, Map.Entry<Planet, Rasi> ... entryArray) {
        EnumMap<Planet, Rasi> enumMap = CollectionUtil.newEnumMap(Planet.class, entryArray);
        return new PlanetChart(varga, enumMap);
    }

    public static PlanetChart constructChart(Map.Entry<Planet, Rasi> ... entryArray) {
        return YogaAnalysisTestHelper.constructChart(Varga.Rasi, entryArray);
    }

    public static void loadFacts(SAMPLE_HOROSCOPE sAMPLE_HOROSCOPE) {
        Horoscope horoscope = samples.get((Object)sAMPLE_HOROSCOPE);
        YogaFacts yogaFacts = new YogaFacts(horoscope);
        session.setGlobal("$facts", (Object)yogaFacts);
        PlanetChart planetChart = new PlanetChart(Varga.Rasi, horoscope.getPlanetaryInfo());
        session.insert((Object)planetChart);
    }

    public static void loadFacts(PlanetChart planetChart, PlanetCharacter planetCharacter, Set<Planet> set) {
        YogaFacts yogaFacts = new YogaFacts();
        yogaFacts.setCharacter(planetCharacter);
        yogaFacts.setPowerfulPlanets(set);
        session.setGlobal("$facts", (Object)yogaFacts);
        session.insert((Object)planetChart);
    }

    public static void loadFacts(PlanetChart planetChart) {
        YogaAnalysisTestHelper.loadFacts(planetChart, character1, null);
    }

    public static void loadFacts(PlanetChart planetChart, PlanetCharacter planetCharacter) {
        YogaAnalysisTestHelper.loadFacts(planetChart, planetCharacter, null);
    }

    public static void loadFacts(PlanetChart planetChart, Set<Planet> set) {
        YogaAnalysisTestHelper.loadFacts(planetChart, character1, set);
    }

    public static void loadFacts(PlanetChart planetChart, YogaFacts yogaFacts) {
        session.setGlobal("$facts", (Object)yogaFacts);
        session.insert((Object)planetChart);
    }

    public static void tearDown() throws Exception {
        logger.writeToDisk();
        System.out.println(YogaAnalysisTestHelper.getSession().getGlobal(YOGAS));
        session.dispose();
    }

    public static void printRules() {
        System.out.println("Rules: ");
        for (Rule rule : ruleBase.getPackage(pkg.getName()).getRules()) {
            System.out.println(rule.getName());
        }
    }

    public static StatefulSession getSession() {
        return session;
    }

    public static WorkingMemoryFileLogger getLogger() {
        return logger;
    }

    public static PlanetCharacter getCharacter1() {
        return character1;
    }

    public static PlanetCharacter getCharacter2() {
        return character2;
    }

    static {
        RULE_FILE = "YogaCombinations.dslr";
        DSL_FILE = "YogaCombinations.dsl";
    }

    public static enum SAMPLE_HOROSCOPE {
        RAJA,
        SUBA;

    }
}

