/*
 * Decompiled with CFR 0.152.
 */
package app.astrosoft.xps.yoga.test;

import app.astrosoft.consts.Planet;
import app.astrosoft.core.Horoscope;
import app.astrosoft.test.SampleHoroscopes;
import app.astrosoft.xps.beans.YogaFacts;
import java.util.EnumSet;
import org.junit.Assert;
import org.junit.Test;

public class YogaFactsTestCase {
    private static Horoscope raja = SampleHoroscopes.getMyHoroscope();
    private static Horoscope suba = SampleHoroscopes.getSubaHoroscope();

    @Test
    public void testPowerfulPlanet1() {
        YogaFacts yogaFacts = new YogaFacts();
        yogaFacts.setPowerfulPlanets(raja.getShadBala().getStrengthPer());
        Assert.assertTrue((boolean)yogaFacts.powerfulPlanets().containsAll(EnumSet.range(Planet.Sun, Planet.Saturn)));
    }

    @Test
    public void testPowerfulPlanet3() {
        YogaFacts yogaFacts = new YogaFacts();
        yogaFacts.setPowerfulPlanets(suba.getShadBala().getStrengthPer());
        Assert.assertFalse((boolean)yogaFacts.powerfulPlanets().contains((Object)Planet.Mercury));
    }

    @Test
    public void testPowerfulPlanet5() {
        YogaFacts yogaFacts = new YogaFacts();
        yogaFacts.setPowerfulPlanets(suba.getShadBala().getStrengthPer());
        Assert.assertTrue((boolean)yogaFacts.isPlanetPowerful(Planet.Sun));
    }

    @Test
    public void testPowerfulPlanet2() {
        YogaFacts yogaFacts = new YogaFacts();
        yogaFacts.setPowerfulPlanets(suba.getShadBala().getStrengthPer());
        Assert.assertFalse((boolean)yogaFacts.isPlanetPowerful(Planet.Mercury));
    }

    @Test
    public void testPowerfulPlanet7() {
        YogaFacts yogaFacts = new YogaFacts();
        yogaFacts.setPowerfulPlanets(EnumSet.of(Planet.Sun, Planet.Moon, Planet.Mars));
        Assert.assertTrue((boolean)yogaFacts.isAnyPlanetPowerful(EnumSet.of(Planet.Sun, Planet.Saturn)));
    }

    @Test
    public void testPowerfulPlanet4() {
        YogaFacts yogaFacts = new YogaFacts();
        yogaFacts.setPowerfulPlanets(EnumSet.of(Planet.Sun, Planet.Moon, Planet.Mars));
        Assert.assertFalse((boolean)yogaFacts.isAnyPlanetPowerful(EnumSet.of(Planet.Mercury, Planet.Saturn)));
    }
}

