/*
 * Decompiled with CFR 0.152.
 */
package app.astrosoft.xps.yoga.test;

import app.astrosoft.beans.PlanetCharacter;
import app.astrosoft.consts.Varga;
import app.astrosoft.core.Horoscope;
import app.astrosoft.test.SampleHoroscopes;
import app.astrosoft.util.Timer;
import app.astrosoft.xps.XpsUtil;
import app.astrosoft.xps.beans.PlanetChart;
import app.astrosoft.xps.beans.YogaFacts;
import app.astrosoft.xps.yoga.YogaResults;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import org.drools.RuleBase;
import org.drools.RuleBaseFactory;
import org.drools.StatefulSession;
import org.drools.WorkingMemoryEventManager;
import org.drools.audit.WorkingMemoryFileLogger;
import org.drools.compiler.DroolsParserException;
import org.drools.compiler.PackageBuilder;
import org.drools.event.AgendaEventListener;
import org.drools.event.DebugAgendaEventListener;
import org.drools.event.DebugWorkingMemoryEventListener;
import org.drools.event.WorkingMemoryEventListener;
import org.drools.rule.Package;

public class YogasTest {
    private static String RULE_FILE = "YogaCombinations.dslr";
    private static String DSL_FILE = "YogaCombinations.dsl";

    public static final void main(String[] stringArray) throws Exception {
        Package package_ = YogasTest.buildPackage();
        RuleBase ruleBase = RuleBaseFactory.newRuleBase();
        ruleBase.addPackage(package_);
        System.out.println("Raja -->" + YogasTest.findYogas(ruleBase, SampleHoroscopes.getMyHoroscope()));
        System.out.println("Elango -->" + YogasTest.findYogas(ruleBase, SampleHoroscopes.getElangoHoroscope()));
        System.out.println("Mani -->" + YogasTest.findYogas(ruleBase, SampleHoroscopes.getManiHoroscope()));
        System.out.println("Muthu -->" + YogasTest.findYogas(ruleBase, SampleHoroscopes.getMuthuHoroscope()));
        System.out.println("Suba -->" + YogasTest.findYogas(ruleBase, SampleHoroscopes.getSubaHoroscope()));
    }

    public static YogaResults findYogas(RuleBase ruleBase, Horoscope horoscope) {
        Timer timer = new Timer();
        StatefulSession statefulSession = ruleBase.newStatefulSession();
        YogasTest.registerListener(statefulSession);
        WorkingMemoryFileLogger workingMemoryFileLogger = new WorkingMemoryFileLogger((WorkingMemoryEventManager)statefulSession);
        workingMemoryFileLogger.setFileName("C:/Astrosoft/helloworld");
        YogasTest.loadFacts(horoscope, statefulSession);
        statefulSession.fireAllRules();
        workingMemoryFileLogger.writeToDisk();
        YogaResults yogaResults = (YogaResults)statefulSession.getGlobal("yogas");
        statefulSession.dispose();
        timer.print("FindYoga Execution time for " + horoscope.getPersonName());
        return yogaResults;
    }

    private static void loadFacts(Horoscope horoscope, StatefulSession statefulSession) {
        YogaResults yogaResults = new YogaResults();
        statefulSession.setGlobal("yogas", (Object)yogaResults);
        PlanetCharacter planetCharacter = new PlanetCharacter(horoscope.getPlanetaryInfo().getPlanetCharacter());
        YogaFacts yogaFacts = new YogaFacts();
        yogaFacts.setCharacter(planetCharacter);
        yogaFacts.setPowerfulPlanets(horoscope.getShadBala().getStrengthPer());
        statefulSession.setGlobal("$facts", (Object)yogaFacts);
        PlanetChart planetChart = new PlanetChart(Varga.Rasi, horoscope.getPlanetaryInfo());
        statefulSession.insert((Object)planetChart);
    }

    private static void registerListener(StatefulSession statefulSession) {
        statefulSession.addEventListener((AgendaEventListener)new DebugAgendaEventListener());
        statefulSession.addEventListener((WorkingMemoryEventListener)new DebugWorkingMemoryEventListener());
    }

    private static Package buildPackage() throws DroolsParserException, IOException {
        InputStreamReader inputStreamReader = new InputStreamReader(XpsUtil.getRuleAsStream(RULE_FILE));
        InputStreamReader inputStreamReader2 = new InputStreamReader(XpsUtil.getRuleAsStream(DSL_FILE));
        PackageBuilder packageBuilder = new PackageBuilder();
        packageBuilder.addPackageFromDrl((Reader)inputStreamReader, (Reader)inputStreamReader2);
        if (packageBuilder.hasErrors()) {
            System.out.println(packageBuilder.getErrors().toString());
            throw new RuntimeException("Compilation Errors in " + RULE_FILE);
        }
        return packageBuilder.getPackage();
    }
}

