/*
 * Decompiled with CFR 0.152.
 */
package swisseph;

import swisseph.SwissEph;
import swisseph.SwissephException;
import swisseph.TransitCalculator;

class Extensions {
    SwissEph sw;
    protected double[] maxBaryDist = new double[]{0.009570999, 1.028809521, 0.466604085, 0.728698831, 0.728698831, 4.955912195, 8.968685733, 19.893326756, 30.326750627, 41.499626899, 0.002569555, 0.002774851, 1.0, 0.002782378, 0.0, 0.05, 31.901319663, 3.012409508, 3.721614106, 3.326307148, 2.570197288};

    Extensions(SwissEph swissEph) {
        this.sw = swissEph;
    }

    double getTransit(TransitCalculator transitCalculator, double d, boolean bl, double d2) throws IllegalArgumentException, SwissephException {
        boolean bl2;
        double d3 = transitCalculator.getMaxSpeed();
        double d4 = transitCalculator.getMinSpeed();
        double d5 = d;
        boolean bl3 = false;
        double d6 = transitCalculator.getOffset();
        boolean bl4 = d3 < 0.0;
        boolean bl5 = bl2 = d4 < 0.0;
        if (!bl4 && !bl2) {
            d4 = d3;
        }
        if (bl4 && bl2) {
            d3 = d4;
        }
        double d7 = transitCalculator.getDegreePrecision(d) / 2.0;
        double d8 = transitCalculator.getTimePrecision(d7);
        double d9 = transitCalculator.calc(d);
        if (d6 - d9 == 0.0) {
            return d;
        }
        if (d3 == 0.0 && d4 == 0.0) {
            throw new SwissephException(d, 384, "No transit possible due to lack of variation of speed or position.");
        }
        do {
            double d10;
            double d11;
            double d12;
            if (transitCalculator.rollover) {
                while (d9 >= transitCalculator.rolloverVal) {
                    d9 -= transitCalculator.rolloverVal;
                }
                while (d9 < 0.0) {
                    d9 += transitCalculator.rolloverVal;
                }
            }
            boolean bl6 = d9 >= d6;
            d5 = d;
            double d13 = d9;
            if (transitCalculator.rollover && !bl6) {
                d9 += transitCalculator.rolloverVal;
            }
            if (transitCalculator.rollover) {
                d12 = Math.min(d9 - d6, 360.0 - d9 + d6) / Math.abs(d3);
                d11 = Math.min(d9 - d6, 360.0 - d9 + d6) / Math.abs(d4);
                d = bl ? (d -= Math.min(d12, d11)) : (d += Math.min(d12, d11));
            } else {
                d12 = (d6 - d9) / d3;
                d11 = (d6 - d9) / d4;
                if (bl) {
                    if (d12 >= 0.0 && d11 >= 0.0) {
                        throw new SwissephException(d, 384, -1, "No transit in ephemeris time range.");
                    }
                    d = d12 >= 0.0 ? (d += d11) : (d += d12);
                } else {
                    if (d12 <= 0.0 && d11 <= 0.0) {
                        throw new SwissephException(d, 384, -1, "No transit in ephemeris time range.");
                    }
                    d = d12 <= 0.0 ? (d += d11) : (d += d12);
                }
            }
            if (Math.abs(d - d5) < d8) {
                d = d5 + (bl ? -d8 : d8);
            }
            if (d == d5) {
                return d;
            }
            d9 = transitCalculator.calc(d);
            if (transitCalculator.rollover && d9 >= transitCalculator.rolloverVal) {
                d9 %= transitCalculator.rolloverVal;
            }
            while (transitCalculator.rollover && d9 < 0.0) {
                d9 += transitCalculator.rolloverVal;
            }
            if (d6 - d9 == 0.0) {
                return d;
            }
            boolean bl7 = true;
            if (transitCalculator.rollover) {
                double d14;
                d10 = d9 - d13;
                if (d10 < 0.0) {
                    d10 += transitCalculator.rolloverVal;
                }
                if ((d14 = d13 - d9) < 0.0) {
                    d14 += transitCalculator.rolloverVal;
                }
                bl7 = Math.abs(d10 / d3) < Math.abs(d14 / d4);
            } else {
                bl7 = d13 <= d9;
            }
            boolean bl8 = bl3 = bl6 && d9 <= d6 && !bl7 || !bl6 && d9 >= d6 && bl7 || transitCalculator.rollover && (d6 < d13 && d9 > 340.0 && d13 < 20.0 && !bl7 || d6 > d13 && d9 < 20.0 && d13 > 340.0 && bl7 || d6 > d9 && d9 > 340.0 && d13 < 20.0 && !bl7 || d6 < d9 && d9 < 20.0 && d13 > 340.0 && bl7);
            if (!bl3) continue;
            if (transitCalculator.rollover) {
                if (transitCalculator.rollover && Math.abs(d9 - d13) > 300.0) {
                    if (d9 > d13) {
                        d13 += transitCalculator.rolloverVal;
                    } else {
                        d9 += transitCalculator.rolloverVal;
                    }
                    if (d6 < 10.0) {
                        d6 += transitCalculator.rolloverVal;
                    }
                }
                if (d9 - d13 < 0.0 && d6 - d13 > 0.0) {
                    d9 += transitCalculator.rolloverVal;
                } else if (d9 - d13 > 0.0 && d6 - d13 < 0.0) {
                    d6 += transitCalculator.rolloverVal;
                }
            }
            d10 = d5 + (d - d5) * (d6 - d13) / (d9 - d13);
            if (bl) {
                return Math.max(d10, d);
            }
            return Math.min(d10, d);
        } while (!(bl && d < d2) && (bl || !(d > d2)));
        throw new SwissephException(d, 6144, -1, "User time limit of " + d2 + " has been reached.");
    }
}

