/*
 * Decompiled with CFR 0.152.
 */
package swisseph;

import java.io.IOException;
import java.nio.BufferUnderflowException;
import swisseph.FilePtr;
import swisseph.PlanData;
import swisseph.SwissData;
import swisseph.SwissLib;
import swisseph.SwissephException;

class FileData {
    final byte SEI_FILE_NMAXPLAN = (byte)50;
    String fnam;
    int fversion;
    String astnam;
    int sweph_denum;
    FilePtr fptr;
    double tfstart;
    double tfend;
    int iflg;
    short npl;
    int[] ipl = new int[50];
    static long[] crc32_table = null;
    static final int CRC32_POLY = 79764919;

    FileData() {
    }

    void clearData() {
        this.fnam = "";
        this.fversion = 0;
        this.astnam = "";
        this.sweph_denum = 0;
        try {
            if (this.fptr != null) {
                this.fptr.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.fptr = null;
        this.tfstart = 0.0;
        this.tfend = 0.0;
        this.iflg = 0;
        this.npl = 0;
        for (int i = 0; i < 50; ++i) {
            this.ipl[i] = 0;
        }
    }

    int read_const(int n, StringBuffer stringBuffer, SwissData swissData) {
        String string = "";
        String string2 = "";
        String string3 = "";
        int n2 = 19;
        String string4 = "Ephemeris file " + this.fnam + " is damaged. ";
        int n3 = 2;
        try {
            Object object;
            int n4;
            int n5;
            char c;
            byte by = 0;
            do {
                c = (char)by;
                by = this.fptr.readByte();
                string = string + (char)by;
            } while (c != '\r' && (char)by != '\n' && string.length() < 256);
            string = string.trim();
            int n6 = 0;
            int n7 = -1;
            while (!Character.isDigit(string.charAt(n6))) {
                ++n6;
            }
            try {
                n7 = Integer.parseInt(string.substring(n6));
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println(string4 + " (1)");
                this.fptr.close();
                throw new SwissephException(this.tfstart, 65, -1, stringBuffer);
            }
            this.fversion = n7;
            by = 0;
            string = "";
            do {
                c = (char)by;
                by = this.fptr.readByte();
                string = string + (char)by;
            } while (c != '\r' && (char)by != '\n' && string.length() < 256);
            string2 = this.fnam.substring(this.fnam.lastIndexOf(swissData.DIR_GLUE) + 1).toLowerCase();
            if (!(string = string.trim().toLowerCase()).equals(string2) && !string.equals(string2 = this.fnam.substring(this.fnam.lastIndexOf("/") + 1).toLowerCase())) {
                string2 = this.fnam.substring(this.fnam.lastIndexOf(swissData.DIR_GLUE) + 1).toLowerCase();
                System.out.println("Ephemeris file name '" + string2 + "' is wrong; rename to '" + string + "'");
                this.fptr.close();
                throw new SwissephException(this.tfstart, 65, -1, stringBuffer);
            }
            by = 0;
            string = "";
            do {
                c = (char)by;
                by = this.fptr.readByte();
                string = string + (char)by;
            } while (c != '\r' && (char)by != '\n' && string.length() < 256);
            if (n == 3) {
                by = 0;
                string = "";
                do {
                    c = (char)by;
                    by = this.fptr.readByte();
                    string = string + (char)by;
                } while (c != '\r' && (char)by != '\n' && string.length() < 512);
                String string5 = string;
                while (Character.isWhitespace(string5.charAt(0))) {
                    string5 = string5.substring(1);
                }
                while (Character.isDigit(string5.charAt(0))) {
                    string5 = string5.substring(1);
                }
                string5 = string5.substring(1);
                n5 = string.length() - string5.length();
                string3 = string5.substring(0, n2 + n5);
                swissData.astelem = string;
                swissData.ast_H = SwissLib.atof(string.substring(35 + n5));
                swissData.ast_G = SwissLib.atof(string.substring(42 + n5));
                if (swissData.ast_G == 0.0) {
                    swissData.ast_G = 0.15;
                }
                string2 = string.substring(51 + n5, 58 + n5);
                swissData.ast_diam = SwissLib.atof(string2);
                if (swissData.ast_diam == 0.0) {
                    swissData.ast_diam = 1329.0 / Math.sqrt(0.15) * Math.pow(10.0, -0.2 * swissData.ast_H);
                }
            }
            int n8 = this.fptr.readInt();
            long l = 0L;
            if (n8 == 6382179) {
                n4 = 0;
            } else {
                n4 = 2;
                l = ((n8 & 0xFF) << 24) + ((n8 & 0xFF00) << 8) + ((n8 & 0xFF0000) >> 8) + ((n8 & 0xFF000000) >> 24);
                if (l != 6382179L) {
                    throw new SwissephException(this.tfstart, 65, -1, "File is damaged: byte ordering info not correct.");
                }
            }
            int n9 = 0 == (n8 & 0xFF) ? 0 : 1;
            this.iflg = n4 | n9;
            l = this.read4(this.fptr, -1L, false, n4, n9);
            if (l < 0L) {
                l &= 0xFFFFFFFFFFFFFFFFL;
            }
            long l2 = this.fptr.getFilePointer();
            long l3 = this.fptr.length();
            if (l != l3) {
                System.out.println(string4 + " (2)");
                this.fptr.close();
                throw new SwissephException(this.tfstart, 65, -1, stringBuffer);
            }
            this.fptr.seek(l2);
            swissData.jpldenum = this.sweph_denum = this.read4(this.fptr, l2, false, n4, n9);
            this.tfstart = this.read8(this.fptr, -1L, n4, n9);
            this.tfend = this.read8(this.fptr, -1L, n4, n9);
            int n10 = this.read2(this.fptr, -1L, n4, n9);
            if (n10 > 256) {
                n3 = 4;
                n10 = (short)(n10 % 256);
            }
            if (n10 < 1 || n10 > 20) {
                System.out.println(string4 + " (3)");
                this.fptr.close();
                throw new SwissephException(this.tfstart, 65, -1, stringBuffer);
            }
            this.npl = n10;
            if (n3 == 2) {
                for (n5 = 0; n5 < n10; ++n5) {
                    this.ipl[n5] = this.read2(this.fptr, -1L, n4, n9);
                }
            } else if (n3 == 4) {
                for (n5 = 0; n5 < n10; ++n5) {
                    this.ipl[n5] = this.read4(this.fptr, -1L, false, n4, n9);
                }
            } else {
                System.out.println(string4 + " (3b)");
            }
            if (n == 3) {
                int n11;
                for (n11 = 4; string3.charAt(n11) != ' ' && n11 < 10; ++n11) {
                }
                object = string3.substring(0, Math.min(string3.length(), n11)).trim();
                try {
                    n5 = Integer.parseInt((String)object);
                }
                catch (NumberFormatException numberFormatException) {
                    n5 = 0;
                }
                if (n5 == this.ipl[0] - 10000) {
                    this.astnam = string3.substring(Math.min(string3.length(), n11 + 1), Math.min(string3.length(), n11 + 1 + n2));
                    string = "";
                    for (n5 = 0; n5 < 30; ++n5) {
                        string = string + (char)this.fptr.readByte();
                    }
                } else {
                    this.astnam = "";
                    for (n5 = 0; n5 < 30; ++n5) {
                        this.astnam = this.astnam + (char)this.fptr.readByte();
                    }
                }
                this.astnam = this.astnam.trim();
            }
            l2 = this.fptr.getFilePointer();
            long l4 = this.read4(this.fptr, -1L, false, n4, n9);
            this.fptr.seek(0L);
            if (l2 - 1L > 512L) {
                System.out.println(string4 + " (4)");
                this.fptr.close();
                throw new SwissephException(this.tfstart, 65, -1, stringBuffer);
            }
            by = 0;
            string = "";
            object = new byte[512];
            n5 = 0;
            while ((long)n5 < l2) {
                c = (char)by;
                by = this.fptr.readByte();
                object[n5] = by;
                string = string + (char)by;
                ++n5;
            }
            if ((int)this.swi_crc32((byte[])object, (int)l2) != (int)l4) {
                System.err.println(string4 + " (5)");
                this.fptr.close();
                throw new SwissephException(this.tfstart, 65, -1, stringBuffer);
            }
            this.fptr.seek(l2 + 4L);
            swissData.gcdat.clight = this.read8(this.fptr, -1L, n4, n9);
            swissData.gcdat.aunit = this.read8(this.fptr, -1L, n4, n9);
            swissData.gcdat.helgravconst = this.read8(this.fptr, -1L, n4, n9);
            swissData.gcdat.ratme = this.read8(this.fptr, -1L, n4, n9);
            swissData.gcdat.sunradius = this.read8(this.fptr, -1L, n4, n9);
            for (int i = 0; i < this.npl; ++i) {
                int n12 = this.ipl[i];
                PlanData planData = n12 >= 10000 ? swissData.pldat[11] : swissData.pldat[n12];
                planData.ibdy = n12;
                planData.lndx0 = (long)this.read4(this.fptr, -1L, false, n4, n9) & 0xFFFFFFFFL;
                planData.iflg = this.fptr.readUnsignedByte();
                planData.ncoe = this.fptr.readUnsignedByte();
                l = this.read4(this.fptr, -1L, false, n4, n9);
                planData.rmax = (double)l / 1000.0;
                planData.tfstart = this.read8(this.fptr, -1L, n4, n9);
                planData.tfend = this.read8(this.fptr, -1L, n4, n9);
                planData.dseg = this.read8(this.fptr, -1L, n4, n9);
                planData.nndx = (int)((planData.tfend - planData.tfstart + 0.1) / planData.dseg);
                planData.telem = this.read8(this.fptr, -1L, n4, n9);
                planData.prot = this.read8(this.fptr, -1L, n4, n9);
                planData.dprot = this.read8(this.fptr, -1L, n4, n9);
                planData.qrot = this.read8(this.fptr, -1L, n4, n9);
                planData.dqrot = this.read8(this.fptr, -1L, n4, n9);
                planData.peri = this.read8(this.fptr, -1L, n4, n9);
                planData.dperi = this.read8(this.fptr, -1L, n4, n9);
                if ((planData.iflg & 4) == 0) continue;
                if (planData.refep != null) {
                    planData.refep = null;
                    if (planData.segp != null) {
                        planData.segp = null;
                    }
                }
                planData.refep = new double[2 * planData.ncoe];
                for (n5 = 0; n5 < 2 * planData.ncoe; ++n5) {
                    planData.refep[n5] = this.read8(this.fptr, -1L, n4, n9);
                }
            }
        }
        catch (IOException iOException) {
            try {
                this.fptr.close();
            }
            catch (IOException iOException2) {
                // empty catch block
            }
            System.out.println(string4 + " (6a)");
            System.out.println(iOException.getMessage());
            throw new SwissephException(this.tfstart, 65, -1, stringBuffer);
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            try {
                this.fptr.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            System.out.println(string4 + " (6b)");
            System.out.println(bufferUnderflowException.getMessage());
            throw new SwissephException(this.tfstart, 65, -1, stringBuffer);
        }
        catch (Exception exception) {
            try {
                this.fptr.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            System.out.println(string4 + " (6c)");
            System.out.println(exception.getMessage());
            throw new SwissephException(this.tfstart, 65, -1, stringBuffer);
        }
        return 0;
    }

    long swi_crc32(byte[] byArray, int n) {
        if (crc32_table == null) {
            this.init_crc32();
        }
        long l = 0xFFFFFFFFL;
        int n2 = 0;
        while (n > 0) {
            l = l << 8 & 0xFFFFFFFFL ^ crc32_table[(int)(l >> 24 ^ (long)byArray[n2] & 0xFFL)];
            ++n2;
            --n;
        }
        return l ^ 0xFFFFFFFFFFFFFFFFL;
    }

    void init_crc32() {
        crc32_table = new long[256];
        for (long i = 0L; i < 256L; ++i) {
            long l = i << 24;
            for (long j = 8L; j > 0L; --j) {
                l = (l & 0x80000000L) != 0L ? l << 1 ^ 0x4C11DB7L : l << 1;
            }
            FileData.crc32_table[(int)i] = l &= 0xFFFFFFFFL;
        }
    }

    private short read2(FilePtr filePtr, long l, int n, int n2) throws Exception {
        if (l >= 0L) {
            filePtr.seek(l);
        }
        short s = filePtr.readShort();
        if (n != 0) {
            s = (short)((s << 8) + (s >>> 8));
        }
        return s;
    }

    private int read3(FilePtr filePtr, long l, int n, int n2) throws Exception {
        if (l >= 0L) {
            filePtr.seek(l);
        }
        int n3 = filePtr.readUnsignedByte();
        int n4 = filePtr.readShort();
        if (n4 < 0) {
            n4 &= 0xFFFF;
        }
        n3 = (n3 << 16) + n4;
        if (n != 0) {
            n3 = ((n3 & 0xFF) << 24) + ((n3 & 0xFF00) << 8) + ((n3 & 0xFF0000) >> 8) + ((n3 & 0xFF000000) >> 24);
            boolean bl = n2 == 0 && n != 0 || n2 == 1 && n == 0;
            return bl ? n3 >> 8 : n3;
        }
        return n3;
    }

    private int read4(FilePtr filePtr, long l, boolean bl, int n, int n2) throws Exception {
        if (l >= 0L) {
            filePtr.seek(l);
        }
        int n3 = filePtr.readInt();
        if (n != 0) {
            n3 = bl ? ((n3 & 0xFF) << 24) + ((n3 & 0xFF00) << 8) + ((n3 & 0xFF0000) >> 8) + ((n3 & 0xFF000000) >> 24) : ((n3 & 0xFF) << 24) + ((n3 & 0xFF00) << 8) + ((n3 & 0xFF0000) >> 8) + ((n3 & 0xFF000000) >>> 24);
        } else if (bl && n3 < 0) {
            n3 &= Integer.MAX_VALUE;
        }
        return n3;
    }

    private double read8(FilePtr filePtr, long l, int n, int n2) throws Exception {
        if (l >= 0L) {
            filePtr.seek(l);
        }
        long l2 = Double.doubleToLongBits(filePtr.readDouble());
        if (n != 0) {
            l2 = ((l2 & 0xFFL) << 56) + ((l2 & 0xFF00L) << 40) + ((l2 & 0xFF0000L) << 24) + ((l2 & 0xFF000000L) << 8) + ((l2 & 0xFF00000000L) >> 8) + ((l2 & 0xFF0000000000L) >> 24) + ((l2 & 0xFF000000000000L) >> 40) + ((l2 & 0xFF00000000000000L) >> 56);
        }
        return Double.longBitsToDouble(l2);
    }

    int get_new_segment(SwissData swissData, double d, int n, int n2, StringBuffer stringBuffer) {
        int[] nArray = new int[6];
        short[] sArray = new short[4];
        PlanData planData = swissData.pldat[n];
        FileData fileData = swissData.fidat[n2];
        int n3 = fileData.iflg & 2;
        int n4 = fileData.iflg & 1;
        long[] lArray = new long[41];
        int n5 = (int)((d - planData.tfstart) / planData.dseg);
        planData.tseg0 = planData.tfstart + (double)n5 * planData.dseg;
        planData.tseg1 = planData.tseg0 + planData.dseg;
        int n6 = (int)planData.lndx0 + n5 * 3;
        try {
            int n7;
            n6 = this.read3(this.fptr, n6, n3, n4);
            this.fptr.seek(n6);
            if (planData.segp == null) {
                planData.segp = new double[planData.ncoe * 3];
            }
            for (n7 = 0; n7 < planData.segp.length; ++n7) {
                planData.segp[n7] = 0.0;
            }
            for (int i = 0; i < 3; ++i) {
                int n8;
                int n9;
                int n10 = i * planData.ncoe;
                sArray[0] = (short)this.fptr.readUnsignedByte();
                sArray[1] = (short)this.fptr.readUnsignedByte();
                if ((sArray[0] & 0x80) != 0) {
                    n9 = 6;
                    sArray[2] = (short)this.fptr.readUnsignedByte();
                    sArray[3] = (short)this.fptr.readUnsignedByte();
                    nArray[0] = sArray[1] / 16;
                    nArray[1] = sArray[1] % 16;
                    nArray[2] = sArray[2] / 16;
                    nArray[3] = sArray[2] % 16;
                    nArray[4] = sArray[3] / 16;
                    nArray[5] = sArray[3] % 16;
                    n8 = nArray[0] + nArray[1] + nArray[2] + nArray[3] + nArray[4] + nArray[5];
                } else {
                    n9 = 4;
                    nArray[0] = sArray[0] / 16;
                    nArray[1] = sArray[0] % 16;
                    nArray[2] = sArray[1] / 16;
                    nArray[3] = sArray[1] % 16;
                    n8 = nArray[0] + nArray[1] + nArray[2] + nArray[3];
                }
                if (n8 > planData.ncoe) {
                    if (stringBuffer != null) {
                        stringBuffer.append("error in ephemeris file " + fileData.fnam + ": " + n8 + " coefficients instead of " + planData.ncoe + ". ");
                    }
                    throw new SwissephException(this.tfstart, 65, -1, stringBuffer);
                }
                for (n7 = 0; n7 < n9; ++n7) {
                    int n11;
                    int n12;
                    int n13;
                    int n14;
                    int n15;
                    int n16;
                    if (nArray[n7] == 0) continue;
                    if (n7 < 4) {
                        n16 = 4 - n7;
                        n15 = nArray[n7];
                        block13: for (n14 = 0; n14 < n15; ++n14) {
                            switch (n16) {
                                case 1: {
                                    lArray[n14] = this.fptr.readUnsignedByte();
                                    continue block13;
                                }
                                case 2: {
                                    lArray[n14] = this.read2(this.fptr, -1L, n3, n4);
                                    if (lArray[n14] >= 0L) continue block13;
                                    int n17 = n14;
                                    lArray[n17] = lArray[n17] & 0xFFFFL;
                                    continue block13;
                                }
                                case 3: {
                                    lArray[n14] = this.read3(this.fptr, -1L, n3, n4);
                                    if (lArray[n14] >= 0L) continue block13;
                                    int n18 = n14;
                                    lArray[n18] = lArray[n18] & 0xFFFFFFL;
                                    continue block13;
                                }
                                case 4: {
                                    lArray[n14] = this.read4(this.fptr, -1L, false, n3, n4);
                                    if (lArray[n14] >= 0L) continue block13;
                                    int n19 = n14;
                                    lArray[n19] = lArray[n19] & 0xFFFFFFFFFFFFFFFFL;
                                }
                            }
                        }
                        n13 = 0;
                        while (n13 < n15) {
                            planData.segp[n10] = (lArray[n13] & 1L) != 0L ? -((double)((lArray[n13] + 1L) / 2L & Integer.MAX_VALUE) / 1.0E9 * planData.rmax / 2.0) : (double)(lArray[n13] / 2L & Integer.MAX_VALUE) / 1.0E9 * planData.rmax / 2.0;
                            ++n13;
                            ++n10;
                        }
                        continue;
                    }
                    if (n7 == 4) {
                        n16 = 1;
                        n15 = (nArray[n7] + 1) / 2;
                        for (n14 = 0; n14 < n15; ++n14) {
                            lArray[n14] = this.fptr.readUnsignedByte();
                        }
                        n16 = 0;
                        for (n13 = 0; n13 < n15 && n16 < nArray[n7]; ++n13) {
                            n12 = 0;
                            n11 = 16;
                            while (n12 < 2 && n16 < nArray[n7]) {
                                planData.segp[n10] = (lArray[n13] & (long)n11) != 0L ? -((double)((lArray[n13] + (long)n11) / (long)n11 / 2L) * planData.rmax / 2.0 / 1.0E9) : (double)(lArray[n13] / (long)n11 / 2L) * planData.rmax / 2.0 / 1.0E9;
                                ++n12;
                                ++n16;
                                ++n10;
                                int n20 = n13;
                                lArray[n20] = lArray[n20] % (long)n11;
                                n11 /= 16;
                            }
                        }
                        continue;
                    }
                    if (n7 != 5) continue;
                    n16 = 1;
                    n15 = (nArray[n7] + 3) / 4;
                    for (n14 = 0; n14 < n15; ++n14) {
                        lArray[n14] = this.fptr.readUnsignedByte();
                    }
                    n16 = 0;
                    for (n13 = 0; n13 < n15 && n16 < nArray[n7]; ++n13) {
                        n12 = 0;
                        n11 = 64;
                        while (n12 < 4 && n16 < nArray[n7]) {
                            planData.segp[n10] = (lArray[n13] & (long)n11) != 0L ? -((double)((lArray[n13] + (long)n11) / (long)n11 / 2L) * planData.rmax / 2.0 / 1.0E9) : (double)(lArray[n13] / (long)n11 / 2L) * planData.rmax / 2.0 / 1.0E9;
                            ++n12;
                            ++n16;
                            ++n10;
                            int n21 = n13;
                            lArray[n21] = lArray[n21] % (long)n11;
                            n11 /= 4;
                        }
                    }
                }
            }
            return 0;
        }
        catch (IOException iOException) {
            stringBuffer.append("file error in swisseph.FileData: " + iOException.getMessage());
            throw new SwissephException(this.tfstart, 65, -1, stringBuffer);
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            stringBuffer.append("file error in swisseph.FileData: " + bufferUnderflowException.getMessage());
            throw new SwissephException(this.tfstart, 65, -1, stringBuffer);
        }
        catch (Exception exception) {
            stringBuffer.append("file error in swisseph.FileData: " + exception.getMessage());
            throw new SwissephException(this.tfstart, 65, -1, stringBuffer);
        }
    }
}

