/*
 * Decompiled with CFR 0.152.
 */
package swisseph;

import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.nio.BufferOverflowException;
import java.nio.CharBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;

public class FilePtr {
    public static final String useragent = "swisseph-java-1.71.00(02)";
    private static final int STRING_BUFFER_SIZE = 200;
    private static final int MAX_FAILURES = 100;
    RandomAccessFile fp;
    FileChannel fc;
    private MappedByteBuffer mbb = null;
    private CharBuffer cb = null;
    Socket sk;
    InputStream is;
    BufferedOutputStream os;
    String fnamp;
    private long fpos = 0L;
    private String host;
    private int port;
    private int BUFSIZE;
    private long startIdx = -1L;
    private long endIdx = -1L;
    private byte[] data;
    private byte[] inbuf;
    private long savedLength = -1L;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public FilePtr(RandomAccessFile randomAccessFile, Socket socket, InputStream inputStream, BufferedOutputStream bufferedOutputStream, String string, long l, int n) throws IOException {
        this.fp = randomAccessFile;
        this.sk = socket;
        this.is = inputStream;
        this.os = bufferedOutputStream;
        this.fnamp = string;
        this.savedLength = l;
        this.BUFSIZE = n;
        this.data = new byte[this.BUFSIZE];
        this.inbuf = new byte[this.BUFSIZE];
        if (randomAccessFile == null) {
            this.fc = null;
            try {
                URL uRL = new URL(string);
                this.host = uRL.getHost();
                this.port = uRL.getPort();
                if (this.port >= 0) return;
                this.port = 80;
                return;
            }
            catch (MalformedURLException malformedURLException) {
                throw new IOException("Malformed URL '" + string + "'");
            }
        } else {
            this.fc = randomAccessFile.getChannel();
            this.mbb = this.fc.map(FileChannel.MapMode.READ_ONLY, 0L, this.length());
            this.cb = CharBuffer.allocate(200);
        }
    }

    public byte readByte() throws IOException, EOFException {
        if (this.fc != null) {
            return this.mbb.get();
        }
        if (this.startIdx < 0L || this.fpos < this.startIdx || this.fpos > this.endIdx) {
            this.readToBuffer();
        }
        ++this.fpos;
        return this.data[(int)(this.fpos - 1L - this.startIdx)];
    }

    public int readUnsignedByte() throws IOException, EOFException {
        return this.readByte() & 0xFF;
    }

    public short readShort() throws IOException, EOFException {
        if (this.fc != null) {
            return this.mbb.getShort();
        }
        return (short)((this.readByte() << 8) + this.readUnsignedByte());
    }

    public int readInt() throws IOException, EOFException {
        if (this.fc != null) {
            return this.mbb.getInt();
        }
        return (this.readByte() << 24) + (this.readUnsignedByte() << 16) + (this.readUnsignedByte() << 8) + this.readUnsignedByte();
    }

    public double readDouble() throws IOException, EOFException {
        if (this.fc != null) {
            return this.mbb.getDouble();
        }
        long l = ((long)this.readUnsignedByte() << 56) + ((long)this.readUnsignedByte() << 48) + ((long)this.readUnsignedByte() << 40) + ((long)this.readUnsignedByte() << 32) + ((long)this.readUnsignedByte() << 24) + ((long)this.readUnsignedByte() << 16) + ((long)this.readUnsignedByte() << 8) + (long)this.readUnsignedByte();
        return Double.longBitsToDouble(l);
    }

    public String readLine() throws IOException, EOFException {
        StringBuffer stringBuffer;
        block8: {
            if (this.fc != null) {
                this.cb.clear();
                while (true) {
                    try {
                        char c;
                        while ((c = (char)this.readUnsignedByte()) != '\n') {
                            this.cb.put(c);
                        }
                        this.cb.put(c);
                    }
                    catch (BufferOverflowException bufferOverflowException) {
                        System.err.println("Re-allocating CharBuffer to size of " + 2 * this.cb.capacity() + " characters.");
                        this.cb.flip();
                        String string = this.cb.toString();
                        this.cb = CharBuffer.allocate(this.cb.capacity() * 2);
                        this.cb.clear();
                        this.cb.put(string);
                        continue;
                    }
                    break;
                }
                this.cb.flip();
                return this.cb.toString();
            }
            stringBuffer = new StringBuffer(200);
            try {
                char c;
                while ((c = (char)this.readUnsignedByte()) != '\n') {
                    stringBuffer.append(c);
                }
                stringBuffer.append(c);
            }
            catch (EOFException eOFException) {
                if (stringBuffer.length() != 0) break block8;
                throw eOFException;
            }
        }
        return stringBuffer.toString();
    }

    public void close() throws IOException {
        try {
            this.fnamp = "";
            if (this.fp != null) {
                this.fp.close();
            }
            this.fp = null;
            if (this.sk != null) {
                this.sk.close();
            }
            this.sk = null;
            this.is = null;
            this.os = null;
        }
        catch (IOException iOException) {
            if (this.sk != null) {
                this.sk.close();
            }
            this.sk = null;
            this.is = null;
            this.os = null;
            throw iOException;
        }
    }

    public long getFilePointer() {
        if (this.fc != null) {
            return this.mbb.position();
        }
        return this.fpos;
    }

    public long length() throws IOException {
        if (this.fc != null) {
            return this.fc.size();
        }
        if (this.fp != null && this.savedLength < 0L) {
            this.savedLength = this.fp.length();
        }
        if (this.fp != null || this.savedLength >= 0L) {
            return this.savedLength;
        }
        long l = 0L;
        String string = "HEAD " + this.fnamp + " HTTP/1.1\r\n" + "User-Agent: " + useragent + "\r\n" + "Host: " + this.host + ":" + this.port + "\r\n\r\n";
        String string2 = "";
        int n = 0;
        int n2 = 0;
        while (true) {
            try {
                this.URLwrite(this.os, string);
                string2 = this.URLread(this.is);
            }
            catch (IOException iOException) {
                if (++n >= 100) {
                    throw new IOException("(java.net.SocketException) " + iOException.getMessage());
                }
                this.reconnect();
                continue;
            }
            n2 = this.checkHeader(string2);
            if (n2 >= 0) break;
            if (++n >= 100) {
                throw new IOException("Failed to read a valid / complete header.");
            }
            this.reconnect();
        }
        int n3 = string2.indexOf("Content-Length:");
        if (n2 != 200 || string2.indexOf("Content-Length:") < 0) {
            throw new IOException("Can't determine length of (HTTP-)file '" + this.fnamp + "'. HTTP error code: " + n2);
        }
        string2 = string2.substring(n3 + "Content-Length:".length());
        string2 = string2.substring(0, string2.indexOf("\n")).trim();
        l = Long.parseLong(string2);
        return l;
    }

    public void seek(long l) {
        if (this.fc != null) {
            this.mbb.position((int)l);
        }
        this.fpos = l;
    }

    private String URLread(InputStream inputStream) throws IOException {
        StringBuffer stringBuffer = new StringBuffer(this.BUFSIZE);
        int n = inputStream.read();
        if (n == -1) {
            throw new IOException("No bytes available.");
        }
        stringBuffer.append((char)n);
        while (inputStream.available() > 0) {
            stringBuffer.append((char)inputStream.read());
        }
        return stringBuffer.toString();
    }

    private void URLwrite(BufferedOutputStream bufferedOutputStream, String string) throws IOException {
        for (int i = 0; i < string.length(); ++i) {
            bufferedOutputStream.write((byte)string.charAt(i));
        }
        bufferedOutputStream.flush();
    }

    private String htmlStrip(String string) {
        int n = string.indexOf("\r\n\r\n");
        if (n >= 0) {
            return string.substring(n + 4);
        }
        return "";
    }

    private int checkHeader(String string) {
        try {
            int n = string.indexOf(" ");
            int n2 = string.indexOf(" ", n + 1);
            if (n < 0 || n2 < 0 || n < 8 || n + 4 != n2) {
                return -1;
            }
            return Integer.parseInt(string.substring(n + 1, n2));
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    private void readToBuffer() throws IOException, EOFException {
        int n;
        int n2;
        String string;
        block8: {
            if (this.fpos >= this.length()) {
                throw new EOFException("Filepointer position " + this.fpos + " exceeds file " + "length by " + (this.fpos - this.length() + 1L) + " byte(s).");
            }
            String string2 = "GET " + this.fnamp + " HTTP/1.1\r\n" + "User-Agent: " + useragent + "\r\n" + "Host: " + this.host + ":" + this.port + "\r\n" + "Range: bytes=" + this.fpos + "-" + Math.min(this.length() - 1L, this.fpos + (long)this.BUFSIZE - 1L) + "\r\n\r\n";
            string = "";
            n2 = 0;
            int n3 = 0;
            while (true) {
                try {
                    this.URLwrite(this.os, string2);
                    string = this.URLread(this.is);
                }
                catch (IOException iOException) {
                    if (++n3 >= 100) {
                        throw new IOException("(java.net.SocketException) " + iOException.getMessage());
                    }
                    this.reconnect();
                    continue;
                }
                n = this.checkHeader(string);
                if (n < 0) {
                    if (++n3 < 100) continue;
                    throw new IOException("Failed to read successfully from address\n'" + this.fnamp + "'. The http reply from the server was " + string.length() + " bytes long and it's content is:\n\n" + string);
                }
                string = this.htmlStrip(string);
                n2 = string.length();
                if (n != 200 && n != 206 || n2 > this.BUFSIZE || n2 < this.BUFSIZE && this.savedLength >= 0L && this.fpos + (long)n2 != this.savedLength) {
                    if (++n3 < 100) continue;
                    throw new IOException("HTTP read failed with HTTP response " + n + ". Read " + n2 + " bytes, requested " + this.BUFSIZE + " bytes.");
                }
                if (n2 != 0) break block8;
                if (++n3 >= 100) break;
            }
            throw new EOFException("Filepointer position " + this.fpos + " exceeds file " + "length by " + (this.fpos - this.length() + 1L) + " byte(s).");
        }
        this.startIdx = this.fpos;
        this.endIdx = this.fpos + (long)n2 - 1L;
        for (n = 0; n < n2; ++n) {
            this.data[n] = (byte)string.charAt(n);
        }
    }

    private void reconnect() throws IOException {
        System.err.println("reconnecting...");
        this.sk.close();
        this.sk = new Socket(this.host, this.port);
        this.sk.setSoTimeout(5000);
        this.is = this.sk.getInputStream();
        this.os = new BufferedOutputStream(this.sk.getOutputStream());
    }
}

