/*
 * Decompiled with CFR 0.152.
 */
package swisseph;

import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import swisseph.FilePtr;
import swisseph.IDate;
import swisseph.SwissEph;
import swisseph.SwissLib;
import swisseph.SwissephException;

public class SweDate {
    private static SwissEph sw = new SwissEph();
    public static final int SUNDAY = 0;
    public static final int MONDAY = 1;
    public static final int TUESDAY = 2;
    public static final int WEDNESDAY = 3;
    public static final int THURSDAY = 4;
    public static final int FRIDAY = 5;
    public static final int SATURDAY = 6;
    public static final boolean SE_JUL_CAL = false;
    public static final boolean SE_GREG_CAL = true;
    public static final boolean SE_KEEP_DATE = true;
    public static final boolean SE_KEEP_JD = false;
    public static final double SE_TIDAL_DE403 = -25.8;
    public static final double SE_TIDAL_DE404 = -25.8;
    public static final double SE_TIDAL_DE405 = -25.7376;
    public static final double SE_TIDAL_DE406 = -25.7376;
    public static final double SE_TIDAL_DE200 = -23.8946;
    public static final double SE_TIDAL_26 = -26.0;
    public static final double SE_TIDAL_DEFAULT = -25.7376;
    public static final double JD0 = 2440587.5;
    private double tid_acc = -25.7376;
    private static boolean init_dt_done = false;
    private double jd;
    private double jdCO = 2299160.5;
    private boolean calType;
    private int year;
    private int month;
    private int day;
    private double hour;
    private double deltaT;
    private boolean deltatIsValid = false;
    private static final int TABSTART = 1620;
    private static final int TABEND = 2014;
    private static final int TABSIZ = 395;
    private static final int TABSIZ_SPACE = 445;
    private static short[] dt = new short[]{12400, 11900, 11500, 11000, 10600, 10200, 9800, 9500, 9100, 8800, 8500, 8200, 7900, 7700, 7400, 7200, 7000, 6700, 6500, 6300, 6200, 6000, 5800, 5700, 5500, 5400, 5300, 5100, 5000, 4900, 4800, 4700, 4600, 4500, 4400, 4300, 4200, 4100, 4000, 3800, 3700, 3600, 3500, 3400, 3300, 3200, 3100, 3000, 2800, 2700, 2600, 2500, 2400, 2300, 2200, 2100, 2000, 1900, 1800, 1700, 1600, 1500, 1400, 1400, 1300, 1200, 1200, 1100, 1100, 1000, 1000, 1000, 900, 900, 900, 900, 900, 900, 900, 900, 900, 900, 900, 900, 900, 900, 900, 900, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1100, 1100, 1100, 1100, 1100, 1100, 1100, 1100, 1100, 1100, 1100, 1100, 1100, 1100, 1100, 1100, 1100, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 1200, 1300, 1300, 1300, 1300, 1300, 1300, 1300, 1400, 1400, 1400, 1400, 1400, 1400, 1400, 1500, 1500, 1500, 1500, 1500, 1500, 1500, 1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600, 1600, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1600, 1600, 1600, 1600, 1500, 1500, 1400, 1400, 1370, 1340, 1310, 1290, 1270, 1260, 1250, 1250, 1250, 1250, 1250, 1250, 1250, 1250, 1250, 1250, 1250, 1240, 1230, 1220, 1200, 1170, 1140, 1110, 1060, 1020, 960, 910, 860, 800, 750, 700, 660, 630, 600, 580, 570, 560, 560, 560, 570, 580, 590, 610, 620, 630, 650, 660, 680, 690, 710, 720, 730, 740, 750, 760, 770, 770, 780, 780, 788, 782, 754, 697, 640, 602, 541, 410, 292, 182, 161, 10, -102, -128, -269, -324, -364, -454, -471, -511, -540, -542, -520, -546, -546, -579, -563, -564, -580, -566, -587, -601, -619, -664, -644, -647, -609, -576, -466, -374, -272, -154, -2, 124, 264, 386, 537, 614, 775, 913, 1046, 1153, 1336, 1465, 1601, 1720, 1824, 1906, 2025, 2095, 2116, 2225, 2241, 2303, 2349, 2362, 2386, 2449, 2434, 2408, 2402, 2400, 2387, 2395, 2386, 2393, 2373, 2392, 2396, 2402, 2433, 2483, 2530, 2570, 2624, 2677, 2728, 2778, 2825, 2871, 2915, 2957, 2997, 3036, 3072, 3107, 3135, 3168, 3218, 3268, 3315, 3359, 3400, 3447, 3503, 3573, 3654, 3743, 3829, 3920, 4018, 4117, 4223, 4337, 4449, 4548, 4646, 4752, 4853, 4959, 5054, 5138, 5217, 5296, 5379, 5434, 5487, 5532, 5582, 5630, 5686, 5757, 5831, 5912, 5998, 6078, 6163, 6230, 6297, 6347, 6383, 6409, 6430, 6447, 6457, 6469, 6481, 6500, 6520, 6550, 6600, 6650, 6700, 6750, 6800, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final int TAB2_START = -500;
    private static final int TAB2_END = 1600;
    private static short[] dt2 = new short[]{16800, 16000, 15300, 14600, 14000, 13400, 12800, 12200, 11600, 11100, 10600, 10100, 9600, 9100, 8600, 8200, 7700, 7200, 6700, 6200, 5700, 5200, 4700, 4300, 3800, 3400, 3000, 2600, 2200, 1900, 1600, 1350, 1100, 900, 750, 600, 470, 380, 300, 230, 180, 140, 110};

    public SweDate() {
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT+0"));
        this.setFields(calendar.get(1), calendar.get(2) + 1, calendar.get(5), (double)calendar.get(11) + (double)calendar.get(12) / 60.0 + (double)calendar.get(13) / 3600.0 + (double)calendar.get(14) / 3600000.0, true);
    }

    public SweDate(double d) {
        this.initDateFromJD(d, this.jdCO <= d);
    }

    public SweDate(double d, boolean bl) {
        this.initDateFromJD(d, bl);
    }

    public SweDate(int n, int n2, int n3, double d) {
        this.setFields(n, n2, n3, d);
    }

    public SweDate(int n, int n2, int n3, double d, boolean bl) {
        this.setFields(n, n2, n3, d, bl);
    }

    public double getJulDay() {
        return this.jd;
    }

    public static double getJulDay(int n, int n2, int n3, double d) {
        double d2 = SweDate.swe_julday(n, n2, n3, d, true);
        return d2;
    }

    public static double getJulDay(int n, int n2, int n3, double d, boolean bl) {
        double d2 = SweDate.swe_julday(n, n2, n3, d, bl);
        return d2;
    }

    public int getDayOfWeekNr() {
        return (int)(this.jd - 5.5) % 7;
    }

    public static synchronized int getDayOfWeekNr(double d) {
        return (int)(d - 5.5) % 7;
    }

    public static int getDayOfWeekNr(int n, int n2, int n3) {
        int n4 = (int)(SweDate.swe_julday(n, n2, n3, 0.0, true) - 5.5) % 7;
        return n4;
    }

    public static int getDayOfWeekNr(int n, int n2, int n3, boolean bl) {
        int n4 = (int)(SweDate.swe_julday(n, n2, n3, 0.0, bl) - 5.5) % 7;
        return n4;
    }

    public boolean getCalendarType() {
        return this.calType;
    }

    public int getYear() {
        return this.year;
    }

    public int getMonth() {
        return this.month;
    }

    public int getDay() {
        return this.day;
    }

    public double getHour() {
        return this.hour;
    }

    public double getDeltaT() {
        if (this.deltatIsValid) {
            return this.deltaT;
        }
        this.deltaT = this.calc_deltaT(this.getJulDay());
        this.deltatIsValid = true;
        return this.deltaT;
    }

    public static double getDeltaT(double d) {
        double d2 = SweDate.calc_deltaT(d, -25.7376);
        return d2;
    }

    public Date getDate(long l) {
        long l2 = (long)((this.getJulDay() - 2440587.5) * 24.0 * 3600.0 * 1000.0) + l;
        return new Date(l2);
    }

    public static Date getDate(double d) {
        long l = (long)((d - 2440587.5) * 24.0 * 3600.0 * 1000.0);
        return new Date(l);
    }

    public void setJulDay(double d) {
        this.jd = d;
        this.deltatIsValid = false;
        IDate iDate = this.swe_revjul(d, this.calType);
        this.year = iDate.year;
        this.month = iDate.month;
        this.day = iDate.day;
        this.hour = iDate.hour;
    }

    public void setCalendarType(boolean bl, boolean bl2) {
        if (this.calType != bl) {
            this.calType = bl;
            this.deltatIsValid = false;
            if (bl2) {
                this.jd = SweDate.swe_julday(this.year, this.month, this.day, this.hour, this.calType);
            } else {
                IDate iDate = this.swe_revjul(this.jd, bl);
                this.year = iDate.year;
                this.month = iDate.month;
                this.day = iDate.day;
                this.hour = iDate.hour;
            }
        }
    }

    public void updateCalendarType() {
        this.calType = this.jdCO <= this.jd;
    }

    public boolean setDate(int n, int n2, int n3, double d) {
        this.year = n;
        this.month = n2;
        this.day = n3;
        this.hour = d;
        this.deltatIsValid = false;
        this.jd = SweDate.swe_julday(this.year, this.month, this.day, this.hour, this.calType);
        return true;
    }

    public boolean setDate(int n, int n2, int n3, double d, boolean bl) {
        this.year = n;
        double d2 = this.month;
        double d3 = this.day;
        this.month = n2;
        this.day = n3;
        this.hour = d;
        this.deltatIsValid = false;
        this.jd = SweDate.swe_julday(this.year, this.month, this.day, this.hour, this.calType);
        if (bl) {
            IDate iDate = this.swe_revjul(this.jd, this.calType);
            this.year = iDate.year;
            this.month = iDate.month;
            this.day = iDate.day;
            this.hour = iDate.hour;
            return this.year == n && (double)this.month == d2 && (double)this.day == d3;
        }
        return true;
    }

    public boolean setYear(int n) {
        this.year = n;
        this.deltatIsValid = false;
        this.jd = SweDate.swe_julday(this.year, this.month, this.day, this.hour, this.calType);
        return true;
    }

    public boolean setYear(int n, boolean bl) {
        this.year = n;
        this.deltatIsValid = false;
        this.jd = SweDate.swe_julday(this.year, this.month, this.day, this.hour, this.calType);
        if (bl) {
            double d = this.month;
            double d2 = this.day;
            IDate iDate = this.swe_revjul(this.jd, this.calType);
            this.year = iDate.year;
            this.month = iDate.month;
            this.day = iDate.day;
            this.hour = iDate.hour;
            return this.year == n && (double)this.month == d && (double)this.day == d2;
        }
        return true;
    }

    public boolean setMonth(int n) {
        this.month = n;
        this.deltatIsValid = false;
        this.jd = SweDate.swe_julday(this.year, this.month, this.day, this.hour, this.calType);
        return true;
    }

    public boolean setMonth(int n, boolean bl) {
        this.month = n;
        this.deltatIsValid = false;
        this.jd = SweDate.swe_julday(this.year, this.month, this.day, this.hour, this.calType);
        if (bl) {
            double d = this.year;
            double d2 = this.day;
            IDate iDate = this.swe_revjul(this.jd, this.calType);
            this.year = iDate.year;
            this.month = iDate.month;
            this.day = iDate.day;
            this.hour = iDate.hour;
            return (double)this.year == d && this.month == n && (double)this.day == d2;
        }
        return true;
    }

    public boolean setDay(int n) {
        this.day = n;
        this.deltatIsValid = false;
        this.jd = SweDate.swe_julday(this.year, this.month, this.day, this.hour, this.calType);
        return true;
    }

    public boolean setDay(int n, boolean bl) {
        this.day = n;
        this.deltatIsValid = false;
        this.jd = SweDate.swe_julday(this.year, this.month, this.day, this.hour, this.calType);
        if (bl) {
            double d = this.year;
            double d2 = this.month;
            IDate iDate = this.swe_revjul(this.jd, this.calType);
            this.year = iDate.year;
            this.month = iDate.month;
            this.day = iDate.day;
            this.hour = iDate.hour;
            return (double)this.year == d && (double)this.month == d2 && this.day == n;
        }
        return true;
    }

    public boolean setHour(double d) {
        this.hour = d;
        this.jd = SweDate.swe_julday(this.year, this.month, this.day, this.hour, this.calType);
        return true;
    }

    public boolean checkDate() {
        boolean bl = this.checkDate(this.year, this.month, this.day, this.hour);
        return bl;
    }

    public boolean checkDate(int n, int n2, int n3) {
        boolean bl = this.checkDate(n, n2, n3, 0.0);
        return bl;
    }

    public boolean checkDate(int n, int n2, int n3, double d) {
        double d2 = SweDate.swe_julday(n, n2, n3, d, true);
        IDate iDate = this.swe_revjul(d2, true);
        return iDate.year == n && iDate.month == n2 && iDate.day == n3;
    }

    public void makeValidDate() {
        double d = SweDate.swe_julday(this.year, this.month, this.day, this.hour, true);
        IDate iDate = this.swe_revjul(d, true);
        this.year = iDate.year;
        this.month = iDate.month;
        this.day = iDate.day;
        this.hour = iDate.hour;
    }

    public double getGregorianChange() {
        return this.jdCO;
    }

    public void setGregorianChange(int n, int n2, int n3) {
        this.year = n;
        this.month = n2;
        this.day = n3;
        this.deltatIsValid = false;
        this.calType = true;
        if (this.year < n || this.year == n && this.month < n2 || this.year == n && this.month == n2 && this.day < n3) {
            this.calType = false;
        }
        this.jdCO = SweDate.swe_julday(n, n2, n3, 0.0, true);
        this.jd = SweDate.swe_julday(this.year, this.month, this.day, this.hour, this.calType);
    }

    public void setGregorianChange(double d) {
        this.jdCO = d;
        this.calType = this.jd >= this.jdCO;
        IDate iDate = this.swe_revjul(this.jd, this.calType);
        this.year = iDate.year;
        this.month = iDate.month;
        this.day = iDate.day;
        this.hour = iDate.hour;
    }

    public double getTidalAcc() {
        return this.tid_acc;
    }

    public void setTidalAcc(double d) {
        this.tid_acc = d;
    }

    public String toString() {
        double d = this.getHour();
        String string = (int)d + ":";
        d = 60.0 * (d - (double)((int)d));
        string = string + (int)d + ":";
        d = 60.0 * (d - (double)((int)d));
        string = string + d;
        return "(YYYY/MM/DD) " + this.getYear() + "/" + (this.getMonth() < 10 ? "0" : "") + this.getMonth() + "/" + (this.getDay() < 10 ? "0" : "") + this.getDay() + ", " + string + "h " + (this.getCalendarType() ? "(greg)" : "(jul)") + "\n" + "Jul. Day: " + this.getJulDay() + "; " + "DeltaT: " + this.getDeltaT();
    }

    private static synchronized double swe_julday(int n, int n2, int n3, double d, boolean bl) {
        double d2 = n;
        if (n2 < 3) {
            d2 -= 1.0;
        }
        double d3 = d2 + 4712.0;
        double d4 = (double)n2 + 1.0;
        if (d4 < 4.0) {
            d4 += 12.0;
        }
        double d5 = Math.floor(d3 * 365.25) + Math.floor(30.6 * d4 + 1.0E-6) + (double)n3 + d / 24.0 - 63.5;
        if (bl) {
            double d6 = Math.floor(Math.abs(d2) / 100.0) - Math.floor(Math.abs(d2) / 400.0);
            if (d2 < 0.0) {
                d6 = -d6;
            }
            d5 = d5 - d6 + 2.0;
            if (d2 < 0.0 && d2 / 100.0 == Math.floor(d2 / 100.0) && d2 / 400.0 != Math.floor(d2 / 400.0)) {
                d5 -= 1.0;
            }
        }
        return d5;
    }

    private synchronized IDate swe_revjul(double d, boolean bl) {
        IDate iDate = new IDate();
        double d2 = d + 32082.5;
        if (bl) {
            double d3 = d2 + Math.floor(d2 / 36525.0) - Math.floor(d2 / 146100.0) - 38.0;
            if (d >= 1830691.5) {
                d3 += 1.0;
            }
            d2 = d2 + Math.floor(d3 / 36525.0) - Math.floor(d3 / 146100.0) - 38.0;
        }
        double d4 = Math.floor(d2 + 123.0);
        double d5 = Math.floor((d4 - 122.2) / 365.25);
        double d6 = Math.floor((d4 - Math.floor(365.25 * d5)) / 30.6001);
        iDate.month = (int)(d6 - 1.0);
        if (iDate.month > 12) {
            iDate.month -= 12;
        }
        iDate.day = (int)(d4 - Math.floor(365.25 * d5) - Math.floor(30.6001 * d6));
        iDate.year = (int)(d5 + Math.floor((d6 - 2.0) / 12.0) - 4800.0);
        iDate.hour = (d - Math.floor(d + 0.5) + 0.5) * 24.0;
        return iDate;
    }

    private synchronized double calc_deltaT(double d) {
        double d2 = SweDate.calc_deltaT(d, this.tid_acc);
        return d2;
    }

    private static synchronized double calc_deltaT(double d, double d2) {
        int n;
        double d3;
        double d4;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        int[] nArray = new int[6];
        int n2 = SweDate.init_dt();
        int n3 = 1620 + n2 - 1;
        d7 = 2000.0 + (d - 2451545.0) / 365.25;
        if (d7 < -500.0) {
            d6 = (d7 - 1735.0) * 0.01;
            d5 = -20.0 + 35.0 * d6 * d6;
            d5 = SweDate.adjust_for_tidacc(d2, d5, d7);
            if (d7 >= -600.0) {
                double d8 = SweDate.adjust_for_tidacc(d2, dt2[0], -500.0);
                d6 = -22.35;
                double d9 = -20.0 + 35.0 * d6 * d6;
                d9 = SweDate.adjust_for_tidacc(d2, d9, d7);
                d4 = d9 - d8;
                d6 = (d7 - -600.0) * 0.01;
                d5 -= d4 * d6;
            }
        }
        if (d7 >= -500.0 && d7 < 1600.0) {
            d3 = Math.floor(d7);
            n = (int)((d3 - -500.0) / 50.0);
            d4 = (d7 - (double)(-500 + 50 * n)) / 50.0;
            d5 = (double)dt2[n] + (double)(dt2[n + 1] - dt2[n]) * d4;
            d5 = SweDate.adjust_for_tidacc(d2, d5, d7);
        }
        if (d7 >= 1600.0 && d7 < 1620.0) {
            d6 = 20.0;
            n = 42;
            d4 = (d7 - 1600.0) / d6;
            d5 = (double)dt2[n] + d4 * ((double)dt[0] / 100.0 - (double)dt2[n]);
            d5 = SweDate.adjust_for_tidacc(d2, d5, d7);
        }
        if (d7 >= 1620.0 && d7 <= (double)n3) {
            int n4;
            d3 = Math.floor(d7);
            n = (int)(d3 - 1620.0);
            d5 = dt[n];
            int n5 = n + 1;
            if (n5 >= n2) {
                return SweDate.deltatIsDone(d5, d7, d6, d2, n2, n3);
            }
            d3 = d7 - d3;
            d5 += d3 * (double)(dt[n5] - dt[n]);
            if (n - 1 < 0 || n + 2 >= n2) {
                return SweDate.deltatIsDone(d5, d7, d6, d2, n2, n3);
            }
            n5 = n - 2;
            for (n4 = 0; n4 < 5; ++n4) {
                nArray[n4] = n5 < 0 || n5 + 1 >= n2 ? 0 : dt[n5 + 1] - dt[n5];
                ++n5;
            }
            for (n4 = 0; n4 < 4; ++n4) {
                nArray[n4] = nArray[n4 + 1] - nArray[n4];
            }
            d6 = 0.25 * d3 * (d3 - 1.0);
            d5 += d6 * (double)(nArray[1] + nArray[2]);
            if (n + 2 >= n2) {
                return SweDate.deltatIsDone(d5, d7, d6, d2, n2, n3);
            }
            for (n4 = 0; n4 < 3; ++n4) {
                nArray[n4] = nArray[n4 + 1] - nArray[n4];
            }
            d6 = 2.0 * d6 / 3.0;
            d5 += (d3 - 0.5) * d6 * (double)nArray[1];
            if (n - 2 < 0 || n + 3 > n2) {
                return SweDate.deltatIsDone(d5, d7, d6, d2, n2, n3);
            }
            for (n4 = 0; n4 < 2; ++n4) {
                nArray[n4] = nArray[n4 + 1] - nArray[n4];
            }
            d6 = 0.125 * d6 * (d3 + 1.0) * (d3 - 2.0);
            d5 += d6 * (double)(nArray[0] + nArray[1]);
        }
        return SweDate.deltatIsDone(d5, d7, d6, d2, n2, n3);
    }

    private static synchronized double deltatIsDone(double d, double d2, double d3, double d4, int n, int n2) {
        if (d2 >= 1620.0 && d2 <= (double)n2) {
            d *= 0.01;
            d = SweDate.adjust_for_tidacc(d4, d, d2);
        }
        if (d2 > (double)n2) {
            d3 = 0.01 * (d2 - 1820.0);
            d = -20.0 + 31.0 * d3 * d3;
            if (d2 <= (double)(n2 + 100)) {
                double d5 = 0.01 * (double)(n2 - 1820);
                double d6 = -20.0 + 31.0 * d5 * d5;
                double d7 = (double)dt[n - 1] * 0.01;
                double d8 = d6 - d7;
                d += d8 * (d2 - (double)(n2 + 100)) * 0.01;
            }
        }
        return d / 86400.0;
    }

    private static int init_dt() {
        FilePtr filePtr = null;
        if (!init_dt_done) {
            init_dt_done = true;
            try {
                filePtr = sw.swi_fopen(-1, "sedeltat.txt", SweDate.sw.swed.ephepath, null);
                if (filePtr == null) {
                    return 395;
                }
            }
            catch (SwissephException swissephException) {
                return 395;
            }
            try {
                String string;
                while ((string = filePtr.readLine()) != null) {
                    int n;
                    int n2;
                    string.trim();
                    if (string.length() == 0 || string.charAt(0) == '#' || (n2 = (n = SwissLib.atoi(string)) - 1620) >= 445) continue;
                    if (string.length() > 4) {
                        string = string.substring(4).trim();
                    }
                    SweDate.dt[n2] = (short)((double)(SwissLib.atoi(string) * 100) + 0.5);
                }
            }
            catch (IOException iOException) {
            }
            catch (BufferUnderflowException bufferUnderflowException) {
                // empty catch block
            }
            try {
                filePtr.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        int n = 382;
        for (int i = n - 1; i < 445 && dt[i] != 0; ++i) {
            ++n;
        }
        return --n;
    }

    private static double adjust_for_tidacc(double d, double d2, double d3) {
        if (d3 < 1955.0) {
            double d4 = d3 - 1955.0;
            d2 += -9.1E-5 * (d + 26.0) * d4 * d4;
        }
        return d2;
    }

    private void initDateFromJD(double d, boolean bl) {
        this.jd = d;
        this.calType = bl;
        IDate iDate = this.swe_revjul(d, bl);
        this.year = iDate.year;
        this.month = iDate.month;
        this.day = iDate.day;
        this.hour = iDate.hour;
    }

    private void setFields(int n, int n2, int n3, double d) {
        IDate iDate = this.swe_revjul(this.jdCO, true);
        boolean bl = true;
        if (iDate.year > n || iDate.year == n && iDate.month > n2 || iDate.year == n && iDate.month == n2 && iDate.day > n3) {
            bl = false;
        }
        this.setFields(n, n2, n3, d, bl);
    }

    private void setFields(int n, int n2, int n3, double d, boolean bl) {
        this.year = n;
        this.month = n2;
        this.day = n3;
        this.hour = d;
        this.calType = bl;
        this.jd = SweDate.swe_julday(n, n2, n3, d, bl);
    }
}

