/*
 * Decompiled with CFR 0.152.
 */
package swisseph;

import swisseph.DblObj;
import swisseph.Epsilon;
import swisseph.PlanData;
import swisseph.SweDate;
import swisseph.Swemmoon;
import swisseph.SwephData;
import swisseph.SwissData;
import swisseph.SwissEph;
import swisseph.SwissLib;

class Swecl {
    SwissEph sw = null;
    SwissLib sl = null;
    Swemmoon sm = null;
    SwissData swed = null;
    private static final double DSUN = 0.009304945276685664;
    private static final double DMOON = 2.3237630219355155E-5;
    private static final double DEARTH = 8.527046503885043E-5;
    private static final double RSUN = 0.004652472638342832;
    private static final double RMOON = 1.1618815109677577E-5;
    private static final double REARTH = 4.263523251942522E-5;
    private static final int SEI_OCC_FAST = 16384;
    private static final double lnlog = Math.log(10.0);
    private static final double EULER = 2.718281828459;
    private static final int NMAG_ELEM = 21;
    private static final double[][] mag_elem = new double[][]{{-26.86, 0.0, 0.0, 0.0}, {-12.55, 0.0, 0.0, 0.0}, {-0.42, 3.8, -2.73, 2.0}, {-4.4, 0.09, 2.39, -0.65}, {-1.52, 1.6, 0.0, 0.0}, {-9.4, 0.5, 0.0, 0.0}, {-8.88, -2.6, 1.25, 0.044}, {-7.19, 0.0, 0.0, 0.0}, {-6.87, 0.0, 0.0, 0.0}, {-1.0, 0.0, 0.0, 0.0}, {99.0, 0.0, 0.0, 0.0}, {99.0, 0.0, 0.0, 0.0}, {99.0, 0.0, 0.0, 0.0}, {99.0, 0.0, 0.0, 0.0}, {99.0, 0.0, 0.0, 0.0}, {6.5, 0.15, 0.0, 0.0}, {7.0, 0.15, 0.0, 0.0}, {3.34, 0.12, 0.0, 0.0}, {4.13, 0.11, 0.0, 0.0}, {5.33, 0.32, 0.0, 0.0}, {3.2, 0.32, 0.0, 0.0}};
    private static final double[][] el_node = new double[][]{{48.330893, 1.186189, 1.7587E-4, 2.11E-7}, {76.67992, 0.901119, 4.0665E-4, -8.0E-8}, {0.0, 0.0, 0.0, 0.0}, {49.558093, 0.7720923, 1.605E-5, 2.325E-6}, {100.464441, 1.020955, 4.0117E-4, 5.69E-7}, {113.665524, 0.877097, -1.2067E-4, -2.38E-6}, {74.005947, 0.5211258, 0.00133982, 1.8516E-5}, {131.784057, 1.1022057, 2.6006E-4, -6.36E-7}};
    private static final double[][] el_peri = new double[][]{{77.456119, 1.5564775, 2.9589E-4, 5.6E-8}, {131.563707, 1.4022188, -0.00107337, -5.315E-6}, {102.937348, 1.7195269, 4.5962E-4, 4.99E-7}, {336.060234, 1.8410331, 1.3515E-4, 3.18E-7}, {14.331309, 1.6126668, 0.00103127, -4.569E-6}, {93.056787, 1.9637694, 8.3757E-4, 4.899E-6}, {173.005159, 1.4863784, 2.145E-4, 4.33E-7}, {48.123691, 1.4262677, 3.7918E-4, -3.0E-9}};
    private static final double[][] el_incl = new double[][]{{7.004986, 0.0018215, -1.809E-5, 5.3E-8}, {3.394662, 0.0010037, -8.8E-7, -7.0E-9}, {0.0, 0.0, 0.0, 0.0}, {1.849726, -6.01E-4, 1.276E-5, -6.0E-9}, {1.30327, -0.0054966, 4.65E-6, -4.0E-9}, {2.488878, -0.0037363, -1.516E-5, 8.9E-8}, {0.773196, 7.744E-4, 3.749E-5, -9.2E-8}, {1.769952, -0.0093082, -7.08E-6, 2.8E-8}};
    private static final double[][] el_ecce = new double[][]{{0.20563175, 2.0406E-5, -2.84E-8, -1.7E-10}, {0.00677188, -4.7766E-5, 9.75E-8, 4.4E-10}, {0.01670862, -4.2037E-5, -1.236E-7, 4.0E-11}, {0.09340062, 9.0483E-5, -8.06E-8, -3.5E-10}, {0.04849485, 1.63244E-4, -4.719E-7, -1.97E-9}, {0.05550862, -3.46818E-4, -6.456E-7, 3.38E-9}, {0.0462959, -2.7337E-5, 7.9E-8, 2.5E-10}, {0.00898809, 6.408E-6, -8.0E-10, -5.0E-11}};
    private static final double[][] el_sema = new double[][]{{0.38709831, 0.0, 0.0, 0.0}, {0.72332982, 0.0, 0.0, 0.0}, {1.000001018, 0.0, 0.0, 0.0}, {1.523679342, 0.0, 0.0, 0.0}, {5.202603191, 1.913E-7, 0.0, 0.0}, {9.554909596, 2.1389E-6, 0.0, 0.0}, {19.218446062, -3.72E-8, 9.8E-10, 0.0}, {30.110386869, -1.663E-7, 6.9E-10, 0.0}};
    private static final double[] plmass = new double[]{6023600.0, 408523.5, 328900.5, 3098710.0, 1047.35, 3498.0, 22960.0, 19314.0, 1.3E8};
    private static final int[] ipl_to_elem = new int[]{2, 0, 0, 1, 3, 4, 5, 6, 7, 0, 0, 0, 0, 0, 2};

    private double log10(double d) {
        return Math.log(d) / lnlog;
    }

    Swecl() {
        this(null, null, null, null);
        this.sw = new SwissEph();
        this.sl = new SwissLib();
        this.sm = new Swemmoon();
        this.swed = new SwissData();
    }

    Swecl(SwissEph swissEph, SwissLib swissLib, Swemmoon swemmoon, SwissData swissData) {
        this.sw = swissEph;
        this.sl = swissLib;
        this.sm = swemmoon;
        this.swed = swissData;
        if (swissEph == null) {
            this.sw = new SwissEph();
        }
        if (swissLib == null) {
            this.sl = new SwissLib();
        }
        if (swemmoon == null) {
            this.sm = new Swemmoon();
        }
        if (swissData == null) {
            this.swed = new SwissData();
        }
    }

    int swe_sol_eclipse_where(double d, int n, double[] dArray, double[] dArray2, StringBuffer stringBuffer) {
        double[] dArray3 = new double[10];
        int n2 = this.eclipse_where(d, 0, null, n &= 7, dArray, dArray3, stringBuffer);
        if (n2 < 0) {
            return n2;
        }
        int n3 = this.eclipse_how(d, 0, null, n, dArray[0], dArray[1], 0.0, dArray2, stringBuffer);
        if (n3 == -1) {
            return n3;
        }
        dArray2[3] = dArray3[0];
        return n2;
    }

    int swe_lun_occult_where(double d, int n, StringBuffer stringBuffer, int n2, double[] dArray, double[] dArray2, StringBuffer stringBuffer2) {
        int n3;
        double[] dArray3 = new double[10];
        n2 &= 7;
        if (n == 144340) {
            n = 9;
        }
        if ((n3 = this.eclipse_where(d, n, stringBuffer, n2, dArray, dArray3, stringBuffer2)) < 0) {
            return n3;
        }
        int n4 = this.eclipse_how(d, n, stringBuffer, n2, dArray[0], dArray[1], 0.0, dArray2, stringBuffer2);
        if (n4 == -1) {
            return n4;
        }
        dArray2[3] = dArray3[0];
        return n3;
    }

    private int eclipse_where(double d, int n, StringBuffer stringBuffer, int n2, double[] dArray, double[] dArray2, StringBuffer stringBuffer2) {
        int n3;
        block26: {
            double d2;
            double d3;
            double d4;
            double d5;
            int n4;
            n3 = 0;
            int n5 = 0;
            double[] dArray3 = new double[6];
            double[] dArray4 = new double[6];
            double[] dArray5 = new double[6];
            double[] dArray6 = new double[6];
            double[] dArray7 = new double[6];
            double[] dArray8 = new double[6];
            double[] dArray9 = new double[6];
            double[] dArray10 = new double[6];
            double[] dArray11 = new double[6];
            double[] dArray12 = new double[16];
            double[] dArray13 = new double[6];
            double[] dArray14 = new double[6];
            double[] dArray15 = new double[6];
            double[] dArray16 = new double[6];
            double d6 = 4.263523251942522E-5;
            double d7 = 0.9966471803021038;
            boolean bl = false;
            Epsilon epsilon = this.swed.oec;
            for (n4 = 0; n4 < 10; ++n4) {
                dArray2[n4] = 0.0;
            }
            int n6 = 0x900 | n2;
            int n7 = n6 | 0x2000;
            double d8 = SweDate.getDeltaT(d);
            double d9 = d + d8;
            n3 = this.sw.swe_calc(d9, 1, n6 |= 0x1000, dArray6, stringBuffer2);
            if (n3 == -1) {
                return n3;
            }
            n3 = this.sw.swe_calc(d9, 1, n7, dArray14, stringBuffer2);
            if (n3 == -1) {
                return n3;
            }
            n3 = this.calc_planet_star(d9, n, stringBuffer, n6, dArray7, stringBuffer2);
            if (n3 == -1) {
                return n3;
            }
            n3 = this.calc_planet_star(d9, n, stringBuffer, n7, dArray15, stringBuffer2);
            if (n3 == -1) {
                return n3;
            }
            for (n4 = 0; n4 <= 2; ++n4) {
                dArray9[n4] = dArray7[n4];
            }
            for (n4 = 0; n4 <= 2; ++n4) {
                dArray8[n4] = dArray6[n4];
            }
            double d10 = (n6 & 0x40) != 0 ? this.sl.swe_sidtime0(d, epsilon.eps * 57.2957795130823, 0.0) * 15.0 * 0.0174532925199433 : this.sl.swe_sidtime(d) * 15.0 * 0.0174532925199433;
            double d11 = stringBuffer != null && stringBuffer.length() > 0 ? 0.0 : (n < 21 ? SwephData.pla_diam[n] / 2.0 / 1.4959787066E11 : (n > 10000 ? this.swed.ast_diam / 2.0 * 1000.0 / 1.4959787066E11 : 0.0));
            while (true) {
                double d12;
                double d13;
                for (n4 = 0; n4 <= 2; ++n4) {
                    dArray7[n4] = dArray9[n4];
                    dArray6[n4] = dArray8[n4];
                }
                for (n4 = 0; n4 <= 2; ++n4) {
                    dArray16[n4] = dArray14[n4];
                }
                this.sl.swi_polcart(dArray16, dArray6);
                dArray6[2] = dArray6[2] / d7;
                double d14 = Math.sqrt(this.sl.square_sum(dArray6));
                for (n4 = 0; n4 <= 2; ++n4) {
                    dArray16[n4] = dArray15[n4];
                }
                this.sl.swi_polcart(dArray16, dArray7);
                dArray7[2] = dArray7[2] / d7;
                for (n4 = 0; n4 <= 2; ++n4) {
                    dArray3[n4] = dArray6[n4] - dArray7[n4];
                    dArray4[n4] = dArray8[n4] - dArray9[n4];
                }
                double d15 = Math.sqrt(this.sl.square_sum(dArray3));
                d5 = Math.sqrt(this.sl.square_sum(dArray4));
                for (n4 = 0; n4 <= 2; ++n4) {
                    int n8 = n4;
                    dArray3[n8] = dArray3[n8] / d15;
                    int n9 = n4;
                    dArray4[n9] = dArray4[n9] / d5;
                    dArray5[n4] = dArray6[n4] / d14;
                }
                double d16 = (d11 - 1.1618815109677577E-5) / d15;
                d4 = Math.sqrt(1.0 - d16 * d16);
                double d17 = (d11 + 1.1618815109677577E-5) / d15;
                d3 = Math.sqrt(1.0 - d17 * d17);
                double d18 = -this.sw.dot_prod(dArray6, dArray3);
                double d19 = Math.sqrt(d14 * d14 - d18 * d18);
                double d20 = (d18 / d15 * (d11 * 2.0 - 2.3237630219355155E-5) - 2.3237630219355155E-5) / d4;
                double d21 = (d18 / d15 * (d11 * 2.0 + 2.3237630219355155E-5) + 2.3237630219355155E-5) / d3;
                dArray2[2] = d19;
                dArray2[3] = d20;
                dArray2[4] = d21;
                dArray2[5] = d4;
                dArray2[6] = d3;
                n4 = 2;
                while (n4 < 5) {
                    int n10 = n4++;
                    dArray2[n10] = dArray2[n10] * 1.4959787066E8;
                }
                n3 = 0;
                if (d6 * d4 >= d19) {
                    n3 |= 1;
                } else if (d19 <= d6 * d4 + Math.abs(d20) / 2.0) {
                    n3 |= 2;
                } else if (d19 <= d6 * d3 + d21 / 2.0) {
                    n3 |= 0x12;
                } else {
                    if (stringBuffer2 != null) {
                        stringBuffer2.setLength(0);
                        stringBuffer2.append("no solar eclipse at tjd = " + d9);
                    }
                    for (n4 = 0; n4 < 10; ++n4) {
                        dArray[n4] = 0.0;
                    }
                    dArray2[0] = 0.0;
                    n3 = 0;
                    d13 = 0.0;
                    bl = true;
                }
                d13 = d18 * d18 + d6 * d6 - d14 * d14;
                d13 = d13 > 0.0 ? Math.sqrt(d13) : 0.0;
                d2 = d18 - d13;
                for (n4 = 0; n4 <= 2; ++n4) {
                    dArray10[n4] = dArray6[n4] + d2 * dArray3[n4];
                }
                for (n4 = 0; n4 <= 2; ++n4) {
                    dArray11[n4] = dArray10[n4];
                }
                dArray11[2] = dArray11[2] * d7;
                this.sl.swi_cartpol(dArray11, dArray11);
                if (n5 > 0) break;
                double d22 = Math.cos(dArray11[1]);
                double d23 = Math.sin(dArray11[1]);
                double d24 = 0.003352819697896193;
                double d25 = 1.0 / Math.sqrt(d22 * d22 + (1.0 - d24) * (1.0 - d24) * d23 * d23);
                d7 = d12 = (1.0 - d24) * (1.0 - d24) * d25;
                ++n5;
            }
            this.sl.swi_polcart(dArray11, dArray11);
            this.sl.swi_cartpol(dArray10, dArray10);
            dArray10[0] = dArray10[0] - d10;
            dArray10[0] = dArray10[0] * 57.2957795130823;
            dArray10[1] = dArray10[1] * 57.2957795130823;
            dArray10[0] = this.sl.swe_degnorm(dArray10[0]);
            if (dArray10[0] > 180.0) {
                dArray10[0] = dArray10[0] - 360.0;
            }
            dArray12[0] = dArray10[0];
            dArray12[1] = dArray10[1];
            dArray[0] = dArray10[0];
            dArray[1] = dArray10[1];
            for (n4 = 0; n4 <= 2; ++n4) {
                dArray13[n4] = dArray8[n4] - dArray11[n4];
            }
            d2 = Math.sqrt(this.sl.square_sum(dArray13));
            dArray2[0] = (d2 / d5 * (d11 * 2.0 - 2.3237630219355155E-5) - 2.3237630219355155E-5) * d4;
            dArray2[0] = dArray2[0] * 1.4959787066E8;
            dArray2[1] = (d2 / d5 * (d11 * 2.0 + 2.3237630219355155E-5) + 2.3237630219355155E-5) * d3;
            dArray2[1] = dArray2[1] * 1.4959787066E8;
            if ((n3 & 0x10) != 0 || bl) break block26;
            n3 = dArray2[0] > 0.0 ? (n3 |= 8) : (n3 |= 4);
        }
        return n3;
    }

    private int calc_planet_star(double d, int n, StringBuffer stringBuffer, int n2, double[] dArray, StringBuffer stringBuffer2) {
        int n3 = 0;
        if (stringBuffer == null || stringBuffer.length() == 0) {
            n3 = this.sw.swe_calc(d, n, n2, dArray, stringBuffer2);
        } else {
            n3 = this.sw.swe_fixstar(stringBuffer, d, n2, dArray, stringBuffer2);
            if (n3 == 0) {
                if ((n2 & 0x1000) != 0) {
                    int n4 = 0;
                    while (n4 < 3) {
                        int n5 = n4++;
                        dArray[n5] = dArray[n5] * 1.0E8;
                    }
                } else {
                    dArray[2] = dArray[2] * 1.0E8;
                }
            }
        }
        return n3;
    }

    int swe_sol_eclipse_how(double d, int n, double[] dArray, double[] dArray2, StringBuffer stringBuffer) {
        double[] dArray3 = new double[10];
        double[] dArray4 = new double[20];
        int n2 = this.eclipse_how(d, 0, null, n &= 7, dArray[0], dArray[1], dArray[2], dArray2, stringBuffer);
        if (n2 == -1) {
            return n2;
        }
        int n3 = this.eclipse_where(d, 0, null, n, dArray4, dArray3, stringBuffer);
        if (n3 == -1) {
            return n3;
        }
        if (n2 != 0) {
            n2 |= n3 & 3;
        }
        dArray2[3] = dArray3[0];
        return n2;
    }

    private int eclipse_how(double d, int n, StringBuffer stringBuffer, int n2, double d2, double d3, double d4, double[] dArray, StringBuffer stringBuffer2) {
        int n3;
        int n4 = 0;
        double[] dArray2 = new double[6];
        double[] dArray3 = new double[6];
        double[] dArray4 = new double[6];
        double[] dArray5 = new double[6];
        double[] dArray6 = new double[6];
        double[] dArray7 = new double[6];
        int n5 = 0x8800 | n2;
        int n6 = n5 | 0x1000;
        double[] dArray8 = new double[6];
        for (n3 = 0; n3 < 10; ++n3) {
            dArray[n3] = 0.0;
        }
        double d5 = d + SweDate.getDeltaT(d);
        this.sw.swe_set_topo(d2, d3, d4);
        if (this.calc_planet_star(d5, n, stringBuffer, n5, dArray4, stringBuffer2) == -1) {
            return -1;
        }
        if (this.sw.swe_calc(d5, 1, n5, dArray5, stringBuffer2) == -1) {
            return -1;
        }
        if (this.calc_planet_star(d5, n, stringBuffer, n6, dArray2, stringBuffer2) == -1) {
            return -1;
        }
        if (this.sw.swe_calc(d5, 1, n6, dArray3, stringBuffer2) == -1) {
            return -1;
        }
        double d6 = stringBuffer != null && stringBuffer.length() > 0 ? 0.0 : (n < 21 ? SwephData.pla_diam[n] / 2.0 / 1.4959787066E11 : (n > 10000 ? this.swed.ast_diam / 2.0 * 1000.0 / 1.4959787066E11 : 0.0));
        double d7 = this.sl.swi_epsiln(d5);
        double d8 = (n5 & 0x40) != 0 ? this.sl.swe_sidtime0(d, d7 * 57.2957795130823, 0.0) * 15.0 : this.sl.swe_sidtime(d) * 15.0;
        double d9 = d8 + d2;
        double d10 = this.sl.swe_degnorm(dArray4[0] - d9);
        dArray8[0] = this.sl.swe_degnorm(d10 - 90.0);
        dArray8[1] = dArray4[1];
        dArray8[2] = dArray4[2];
        this.sl.swe_cotrans(dArray8, 0, dArray8, 0, 90.0 - d3);
        double d11 = Math.asin(1.1618815109677577E-5 / dArray5[2]) * 57.2957795130823;
        double d12 = Math.asin(d6 / dArray4[2]) * 57.2957795130823;
        double d13 = d12 + d11;
        double d14 = d12 - d11;
        for (n3 = 0; n3 < 3; ++n3) {
            dArray6[n3] = dArray2[n3] / dArray4[2];
            dArray7[n3] = dArray3[n3] / dArray5[2];
        }
        double d15 = Math.acos(this.sl.swi_dot_prod_unit(dArray6, dArray7)) * 57.2957795130823;
        if (d15 < d14) {
            n4 = 8;
        } else if (d15 < Math.abs(d14)) {
            n4 = 4;
        } else if (d15 < d13) {
            n4 = 16;
        } else {
            n4 = 0;
            if (stringBuffer2 != null) {
                stringBuffer2.setLength(0);
                stringBuffer2.append("no solar eclipse at tjd = " + d);
            }
        }
        double d16 = Math.asin(d12 / 2.0 * 0.0174532925199433) * 2.0;
        double d17 = Math.asin(d11 / 2.0 * 0.0174532925199433) * 2.0;
        double d18 = Math.asin(d15 / 2.0 * 0.0174532925199433) * 2.0;
        double d19 = Math.asin((-d15 + d12 + d11) * 0.0174532925199433 / 2.0) * 2.0;
        dArray[0] = d16 > 0.0 ? d19 / d16 / 2.0 : 100.0;
        dArray[1] = d16 > 0.0 ? d17 / d16 : 0.0;
        if (n4 == 0 || d16 == 0.0) {
            dArray[2] = 100.0;
        } else if (n4 == 4 || n4 == 8) {
            dArray[2] = d17 * d17 / d16 / d16;
        } else {
            double d20 = 2.0 * d18 * d17;
            double d21 = 2.0 * d18 * d16;
            if (d20 < 1.0E-9) {
                dArray[2] = d17 * d17 / d16 / d16;
            } else {
                if ((d20 = (d18 * d18 + d17 * d17 - d16 * d16) / d20) > 1.0) {
                    d20 = 1.0;
                }
                if (d20 < -1.0) {
                    d20 = -1.0;
                }
                if ((d21 = (d18 * d18 + d16 * d16 - d17 * d17) / d21) > 1.0) {
                    d21 = 1.0;
                }
                if (d21 < -1.0) {
                    d21 = -1.0;
                }
                d20 = Math.acos(d20);
                d21 = Math.acos(d21);
                double d22 = d20 * d17 * d17 / 2.0;
                double d23 = d21 * d16 * d16 / 2.0;
                dArray[2] = ((d22 -= Math.cos(d20) * Math.sin(d20) * d17 * d17 / 2.0) + (d23 -= Math.cos(d21) * Math.sin(d21) * d16 * d16 / 2.0)) * 2.0 / Math.PI / d16 / d16;
            }
        }
        dArray[7] = d15;
        double d24 = -(34.4556 + 2.12 * Math.sqrt(d4)) / 60.0;
        if (dArray8[1] + d12 + Math.abs(d24) >= 0.0 && n4 != 0) {
            n4 |= 0x80;
        }
        dArray[4] = this.sl.swe_degnorm(90.0 - dArray8[0]);
        dArray[5] = dArray8[1];
        return n4;
    }

    int swe_sol_eclipse_when_glob(double d, int n, int n2, double[] dArray, int n3, StringBuffer stringBuffer) {
        int n4;
        block67: {
            double d2;
            int n5;
            double d3;
            double d4;
            double d5;
            double d6;
            int n6;
            int n7 = 0;
            int n8 = 0;
            n4 = 0;
            int n9 = 0;
            double d7 = 6378.14;
            DblObj dblObj = new DblObj();
            double[] dArray2 = new double[6];
            double[] dArray3 = new double[6];
            double[] dArray4 = new double[6];
            double[] dArray5 = new double[6];
            double[] dArray6 = new double[10];
            double[] dArray7 = new double[3];
            DblObj dblObj2 = new DblObj();
            double d8 = 0.08333333333333333;
            double d9 = 0.006944444444444445;
            DblObj dblObj3 = new DblObj();
            DblObj dblObj4 = new DblObj();
            double[] dArray8 = new double[20];
            double[] dArray9 = new double[20];
            double[] dArray10 = new double[6];
            double[] dArray11 = new double[6];
            int n10 = 1;
            boolean bl = false;
            int n11 = 0x800 | (n &= 7);
            int n12 = n11 | 0x1000;
            if (n2 == 17) {
                if (stringBuffer != null) {
                    stringBuffer.setLength(0);
                    stringBuffer.append("central partial eclipses do not exist");
                }
                return -1;
            }
            if (n2 == 0) {
                n2 = 63;
            }
            if (n3 != 0) {
                n10 = -1;
            }
            double d10 = (int)((d - 2451545.0) / 365.2425 * 12.3685);
            d10 -= (double)n10;
            while (true) {
                int n13;
                n4 = 0;
                bl = false;
                for (n6 = 0; n6 <= 9; ++n6) {
                    dArray[n6] = 0.0;
                }
                double d11 = d10 / 1236.85;
                double d12 = d11 * d11;
                double d13 = d12 * d11;
                double d14 = d13 * d11;
                double d15 = this.sl.swe_degnorm(160.7108 + 390.67050274 * d10 - 0.0016341 * d12 - 2.27E-6 * d13 + 1.1E-8 * d14);
                if (d15 > 180.0) {
                    d15 -= 180.0;
                }
                if (d15 > 21.0 && d15 < 159.0) {
                    d10 += (double)n10;
                    continue;
                }
                d6 = 2451550.09765 + 29.530588853 * d10 + 1.337E-4 * d12 - 1.5E-7 * d13 + 7.3E-10 * d14;
                double d16 = this.sl.swe_degnorm(2.5534 + 29.10535669 * d10 - 2.18E-5 * d12 - 1.1E-7 * d13);
                double d17 = this.sl.swe_degnorm(201.5643 + 385.81693528 * d10 + 0.1017438 * d12 + 1.239E-5 * d13 + 5.8E-8 * d14);
                double d18 = 1.0 - 0.002516 * d11 - 7.4E-6 * d12;
                d6 = d6 - 0.4075 * Math.sin(d17 *= 0.0174532925199433) + 0.1721 * d18 * Math.sin(d16 *= 0.0174532925199433);
                double d19 = 1.0;
                if (d6 < 2000000.0) {
                    d19 = 5.0;
                }
                double d20 = 4.0;
                for (d5 = d19; d5 > 1.0E-4; d5 /= d20) {
                    n6 = 0;
                    d4 = d6 - d5;
                    while (n6 <= 2) {
                        if (this.sw.swe_calc(d4, 0, n11, dArray4, stringBuffer) == -1) {
                            return -1;
                        }
                        if (this.sw.swe_calc(d4, 1, n11, dArray5, stringBuffer) == -1) {
                            return -1;
                        }
                        if (this.sw.swe_calc(d4, 0, n12, dArray2, stringBuffer) == -1) {
                            return -1;
                        }
                        if (this.sw.swe_calc(d4, 1, n12, dArray3, stringBuffer) == -1) {
                            return -1;
                        }
                        for (n13 = 0; n13 < 3; ++n13) {
                            dArray10[n13] = dArray2[n13] / dArray4[2];
                            dArray11[n13] = dArray3[n13] / dArray5[2];
                        }
                        dArray7[n6] = Math.acos(this.sl.swi_dot_prod_unit(dArray10, dArray11)) * 57.2957795130823;
                        double d21 = Math.asin(1.1618815109677577E-5 / dArray5[2]) * 57.2957795130823;
                        double d22 = Math.asin(0.004652472638342832 / dArray4[2]) * 57.2957795130823;
                        int n14 = n6++;
                        dArray7[n14] = dArray7[n14] - (d21 + d22);
                        d4 += d5;
                    }
                    this.find_maximum(dArray7[0], dArray7[1], dArray7[2], d5, dblObj, dblObj2);
                    d6 += dblObj.val + d5;
                }
                d6 -= SweDate.getDeltaT(d6);
                d3 = d6;
                n4 = this.eclipse_where(d6, 0, null, n, dArray8, dArray6, stringBuffer);
                if (n4 == -1) {
                    return n4;
                }
                n9 = n4;
                n9 = this.eclipse_how(d6, 0, null, n, dArray8[0], dArray8[1], 0.0, dArray9, stringBuffer);
                if (n9 == -1) {
                    return n9;
                }
                if (n9 == 0) {
                    d10 += (double)n10;
                    continue;
                }
                dArray[0] = d6;
                if (n3 != 0 && dArray[0] >= d - 1.0E-4 || n3 == 0 && dArray[0] <= d + 1.0E-4) {
                    d10 += (double)n10;
                    continue;
                }
                n4 = this.eclipse_where(d6, 0, null, n, dArray8, dArray6, stringBuffer);
                if (n4 == -1) {
                    return n4;
                }
                if (n4 == 0) {
                    n4 = 18;
                    dArray[4] = dArray[5] = d6;
                    bl = true;
                }
                if ((n2 & 2) == 0 && (n4 & 2) != 0) {
                    d10 += (double)n10;
                    continue;
                }
                if ((n2 & 1) == 0 && (n4 & 1) != 0) {
                    d10 += (double)n10;
                    continue;
                }
                if ((n2 & 8) == 0 && (n4 & 8) != 0) {
                    d10 += (double)n10;
                    continue;
                }
                if ((n2 & 0x10) == 0 && (n4 & 0x10) != 0) {
                    d10 += (double)n10;
                    continue;
                }
                if ((n2 & 0x24) == 0 && (n4 & 4) != 0) {
                    d10 += (double)n10;
                    continue;
                }
                if (bl) break block67;
                int n15 = (n4 & 0x10) != 0 ? 0 : ((n4 & 2) != 0 ? 1 : 2);
                double d23 = d8;
                double d24 = d9;
                for (int i = 0; i <= n15; ++i) {
                    if (i == 0) {
                        n7 = 2;
                        n8 = 3;
                    } else if (i == 1) {
                        if ((n4 & 0x10) != 0) continue;
                        n7 = 4;
                        n8 = 5;
                    } else if (i == 2) {
                        if ((n4 & 2) != 0) continue;
                        n7 = 6;
                        n8 = 7;
                    }
                    n6 = 0;
                    d4 = d6 - d23;
                    while (n6 <= 2) {
                        n9 = this.eclipse_where(d4, 0, null, n, dArray8, dArray6, stringBuffer);
                        if (n9 == -1) {
                            return n9;
                        }
                        if (i == 0) {
                            dArray7[n6] = dArray6[4] / 2.0 + d7 / dArray6[5] - dArray6[2];
                        } else if (i == 1) {
                            dArray7[n6] = Math.abs(dArray6[3]) / 2.0 + d7 / dArray6[6] - dArray6[2];
                        } else if (i == 2) {
                            dArray7[n6] = d7 / dArray6[6] - dArray6[2];
                        }
                        ++n6;
                        d4 += d23;
                    }
                    this.find_zero(dArray7[0], dArray7[1], dArray7[2], d23, dblObj3, dblObj4);
                    dArray[n7] = d6 + dblObj3.val + d23;
                    dArray[n8] = d6 + dblObj4.val + d23;
                    n13 = 0;
                    d5 = d24;
                    while (n13 < 3) {
                        for (n5 = n7; n5 <= n8; n5 += n8 - n7) {
                            n6 = 0;
                            d4 = dArray[n5] - d5;
                            while (n6 < 2) {
                                n9 = this.eclipse_where(d4, 0, null, n, dArray8, dArray6, stringBuffer);
                                if (n9 == -1) {
                                    return n9;
                                }
                                if (i == 0) {
                                    dArray7[n6] = dArray6[4] / 2.0 + d7 / dArray6[5] - dArray6[2];
                                } else if (i == 1) {
                                    dArray7[n6] = Math.abs(dArray6[3]) / 2.0 + d7 / dArray6[6] - dArray6[2];
                                } else if (i == 2) {
                                    dArray7[n6] = d7 / dArray6[6] - dArray6[2];
                                }
                                ++n6;
                                d4 += d5;
                            }
                            dblObj3.val = dArray7[1] / ((dArray7[1] - dArray7[0]) / d5);
                            int n16 = n5;
                            dArray[n16] = dArray[n16] - dblObj3.val;
                        }
                        ++n13;
                        d5 /= 3.0;
                    }
                }
                if ((n4 & 4) != 0) {
                    n9 = this.eclipse_where(dArray[0], 0, null, n, dArray8, dArray6, stringBuffer);
                    if (n9 == -1) {
                        return n9;
                    }
                    dArray7[0] = dArray6[0];
                    n9 = this.eclipse_where(dArray[4], 0, null, n, dArray8, dArray6, stringBuffer);
                    if (n9 == -1) {
                        return n9;
                    }
                    dArray7[1] = dArray6[0];
                    n9 = this.eclipse_where(dArray[5], 0, null, n, dArray8, dArray6, stringBuffer);
                    if (n9 == -1) {
                        return n9;
                    }
                    dArray7[2] = dArray6[0];
                    if (dArray7[0] * dArray7[1] < 0.0 || dArray7[0] * dArray7[2] < 0.0) {
                        n4 |= 0x20;
                        n4 &= 0xFFFFFFFB;
                    }
                }
                if ((n2 & 4) == 0 && (n4 & 4) != 0) {
                    d10 += (double)n10;
                    continue;
                }
                if ((n2 & 0x20) != 0 || (n4 & 0x20) == 0) break;
                d10 += (double)n10;
            }
            int n17 = 2;
            for (n6 = 0; n6 < 2; ++n6) {
                n5 = n6 + n17;
                d2 = dArray[n5] + SweDate.getDeltaT(dArray[n5]);
                if (this.sw.swe_calc(d2, 0, n11, dArray4, stringBuffer) == -1) {
                    return -1;
                }
                if (this.sw.swe_calc(d2, 1, n11, dArray5, stringBuffer) == -1) {
                    return -1;
                }
                dArray7[n6] = this.sl.swe_degnorm(dArray4[0] - dArray5[0]);
                if (!(dArray7[n6] > 180.0)) continue;
                int n18 = n6;
                dArray7[n18] = dArray7[n18] - 360.0;
            }
            if (dArray7[0] * dArray7[1] >= 0.0) {
                dArray[1] = 0.0;
            } else {
                d6 = d3;
                d5 = 0.1;
                dblObj3.val = (dArray[3] - dArray[2]) / 2.0;
                if (dblObj3.val < d5) {
                    d5 = dblObj3.val / 2.0;
                }
                n5 = 0;
                while (d5 > 0.01) {
                    n6 = 0;
                    d4 = d6;
                    while (n6 <= 1) {
                        d2 = d4 + SweDate.getDeltaT(d4);
                        if (this.sw.swe_calc(d2, 0, n11, dArray4, stringBuffer) == -1) {
                            return -1;
                        }
                        if (this.sw.swe_calc(d2, 1, n11, dArray5, stringBuffer) == -1) {
                            return -1;
                        }
                        dArray7[n6] = this.sl.swe_degnorm(dArray4[0] - dArray5[0]);
                        if (dArray7[n6] > 180.0) {
                            int n19 = n6;
                            dArray7[n19] = dArray7[n19] - 360.0;
                        }
                        if (dArray7[n6] > 180.0) {
                            int n20 = n6;
                            dArray7[n20] = dArray7[n20] - 360.0;
                        }
                        ++n6;
                        d4 -= d5;
                    }
                    double d25 = (dArray7[1] - dArray7[0]) / d5;
                    if (d25 < 1.0E-10) break;
                    dblObj3.val = dArray7[0] / d25;
                    d6 += dblObj3.val;
                    ++n5;
                    d5 /= 3.0;
                }
                dArray[1] = d6;
            }
        }
        return n4;
    }

    int swe_lun_occult_when_glob(double d, int n, StringBuffer stringBuffer, int n2, int n3, double[] dArray, int n4, StringBuffer stringBuffer2) {
        double d2;
        double d3;
        double d4;
        int n5;
        int n6;
        boolean bl;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        double d5 = 6378.14;
        double d6 = 0.0;
        DblObj dblObj = new DblObj();
        double[] dArray2 = new double[6];
        double[] dArray3 = new double[6];
        double[] dArray4 = new double[6];
        double[] dArray5 = new double[6];
        double[] dArray6 = new double[10];
        double[] dArray7 = new double[20];
        DblObj dblObj2 = new DblObj();
        double d7 = 0.08333333333333333;
        double d8 = 0.006944444444444445;
        DblObj dblObj3 = new DblObj();
        DblObj dblObj4 = new DblObj();
        double d9 = 10.0;
        double d10 = 6.0;
        int n11 = 10;
        double[] dArray8 = new double[20];
        int n12 = 1;
        boolean bl2 = false;
        boolean bl3 = bl = (n4 & 0x8000) != 0;
        if (n == 144340) {
            n = 9;
        }
        int n13 = 0x800 | (n2 &= 7);
        int n14 = n13 | 0x1000;
        n4 = (int)((long)n4 & 1L);
        if (n3 == 17) {
            if (stringBuffer2 != null) {
                stringBuffer2.setLength(0);
                stringBuffer2.append("central partial eclipses do not exist");
            }
            return -1;
        }
        if (n3 == 0) {
            n3 = 63;
        }
        n9 = 0;
        bl2 = false;
        if ((n4 & 0x4000) != 0) {
            bl2 = true;
        }
        for (n6 = 0; n6 <= 9; ++n6) {
            dArray[n6] = 0.0;
        }
        if (n4 != 0) {
            n12 = -1;
        }
        double d11 = d - (double)n12 * 0.001;
        while (true) {
            n6 = 0;
            while (n6 < n11) {
                if (this.calc_planet_star(d11, n, stringBuffer, n14, dArray2, stringBuffer2) == -1) {
                    return -1;
                }
                if (this.sw.swe_calc(d11, 1, n14, dArray3, stringBuffer2) == -1) {
                    return -1;
                }
                dArray7[n6] = Math.acos(this.sl.swi_dot_prod_unit(dArray2, dArray3)) * 57.2957795130823;
                if (n6 > 1 && dArray7[n6] > dArray7[n6 - 1] && dArray7[n6 - 2] > dArray7[n6 - 1]) {
                    d6 = d11 - (double)n12 * d10;
                    break;
                }
                if (n6 == n11 - 1) {
                    for (n5 = 0; n5 < n11; ++n5) {
                        System.out.print(dArray7[n5] + " ");
                    }
                    System.err.println("problem planet");
                    System.exit(0);
                }
                ++n6;
                d11 += (double)n12 * d10;
            }
            double d12 = stringBuffer != null && stringBuffer.length() > 0 ? 0.0 : (n < 21 ? SwephData.pla_diam[n] / 2.0 / 1.4959787066E11 : (n > 10000 ? this.swed.ast_diam / 2.0 * 1000.0 / 1.4959787066E11 : 0.0));
            double d13 = d10;
            double d14 = 3.0;
            for (d4 = d13; d4 > 1.0E-4; d4 /= d14) {
                n6 = 0;
                d11 = d6 - d4;
                while (n6 <= 2) {
                    if (this.calc_planet_star(d11, n, stringBuffer, n13, dArray4, stringBuffer2) == -1) {
                        return -1;
                    }
                    if (this.sw.swe_calc(d11, 1, n13, dArray5, stringBuffer2) == -1) {
                        return -1;
                    }
                    if (this.calc_planet_star(d11, n, stringBuffer, n14, dArray2, stringBuffer2) == -1) {
                        return -1;
                    }
                    if (this.sw.swe_calc(d11, 1, n14, dArray3, stringBuffer2) == -1) {
                        return -1;
                    }
                    dArray7[n6] = Math.acos(this.sl.swi_dot_prod_unit(dArray2, dArray3)) * 57.2957795130823;
                    double d15 = Math.asin(1.1618815109677577E-5 / dArray5[2]) * 57.2957795130823;
                    double d16 = Math.asin(d12 / dArray4[2]) * 57.2957795130823;
                    int n15 = n6++;
                    dArray7[n15] = dArray7[n15] - (d15 + d16);
                    d11 += d4;
                }
                this.find_maximum(dArray7[0], dArray7[1], dArray7[2], d4, dblObj, dblObj2);
                d6 += dblObj.val + d4;
            }
            d6 -= SweDate.getDeltaT(d6);
            d3 = d6;
            n9 = this.eclipse_where(d6, n, stringBuffer, n2, dArray8, dArray6, stringBuffer2);
            if (n9 == -1) {
                return n9;
            }
            n10 = n9;
            if (n10 == 0) {
                if (bl) {
                    dArray[0] = d6;
                    return 0;
                }
                d11 = d6 + (double)n12 * d9;
                continue;
            }
            dArray[0] = d6;
            if (n4 != 0 && dArray[0] >= d - 1.0E-4 || n4 == 0 && dArray[0] <= d + 1.0E-4) {
                d11 = d6 + (double)n12 * d9;
                continue;
            }
            n9 = this.eclipse_where(d6, n, stringBuffer, n2, dArray8, dArray6, stringBuffer2);
            if (n9 == -1) {
                return n9;
            }
            if (n9 == 0) {
                n9 = 18;
                dArray[4] = dArray[5] = d6;
                n9 = 18;
                dArray[4] = dArray[5] = d6;
                bl2 = true;
            }
            if ((n3 & 2) == 0 && (n9 & 2) != 0) {
                d11 = d6 + (double)n12 * d9;
                continue;
            }
            if ((n3 & 1) == 0 && (n9 & 1) != 0) {
                d11 = d6 + (double)n12 * d9;
                continue;
            }
            if ((n3 & 8) == 0 && (n9 & 8) != 0) {
                d11 = d6 + (double)n12 * d9;
                continue;
            }
            if ((n3 & 0x10) == 0 && (n9 & 0x10) != 0) {
                d11 = d6 + (double)n12 * d9;
                continue;
            }
            if ((n3 & 0x24) == 0 && (n9 & 4) != 0) {
                d11 = d6 + (double)n12 * d9;
                continue;
            }
            if (bl2) {
                return n9;
            }
            int n16 = (n9 & 0x10) != 0 ? 0 : ((n9 & 2) != 0 ? 1 : 2);
            double d17 = d7;
            double d18 = d8;
            for (int i = 0; i <= n16; ++i) {
                if (i == 0) {
                    n7 = 2;
                    n8 = 3;
                } else if (i == 1) {
                    if ((n9 & 0x10) != 0) continue;
                    n7 = 4;
                    n8 = 5;
                } else if (i == 2) {
                    if ((n9 & 2) != 0) continue;
                    n7 = 6;
                    n8 = 7;
                }
                n6 = 0;
                d11 = d6 - d17;
                while (n6 <= 2) {
                    n10 = this.eclipse_where(d11, n, stringBuffer, n2, dArray8, dArray6, stringBuffer2);
                    if (n10 == -1) {
                        return n10;
                    }
                    if (i == 0) {
                        dArray7[n6] = dArray6[4] / 2.0 + d5 / dArray6[5] - dArray6[2];
                    } else if (i == 1) {
                        dArray7[n6] = Math.abs(dArray6[3]) / 2.0 + d5 / dArray6[6] - dArray6[2];
                    } else if (i == 2) {
                        dArray7[n6] = d5 / dArray6[6] - dArray6[2];
                    }
                    ++n6;
                    d11 += d17;
                }
                this.find_zero(dArray7[0], dArray7[1], dArray7[2], d17, dblObj3, dblObj4);
                dArray[n7] = d6 + dblObj3.val + d17;
                dArray[n8] = d6 + dblObj4.val + d17;
                int n17 = 0;
                d4 = d18;
                while (n17 < 3) {
                    for (n5 = n7; n5 <= n8; n5 += n8 - n7) {
                        n6 = 0;
                        d11 = dArray[n5] - d4;
                        while (n6 < 2) {
                            n10 = this.eclipse_where(d11, n, stringBuffer, n2, dArray8, dArray6, stringBuffer2);
                            if (n10 == -1) {
                                return n10;
                            }
                            if (i == 0) {
                                dArray7[n6] = dArray6[4] / 2.0 + d5 / dArray6[5] - dArray6[2];
                            } else if (i == 1) {
                                dArray7[n6] = Math.abs(dArray6[3]) / 2.0 + d5 / dArray6[6] - dArray6[2];
                            } else if (i == 2) {
                                dArray7[n6] = d5 / dArray6[6] - dArray6[2];
                            }
                            ++n6;
                            d11 += d4;
                        }
                        dblObj3.val = dArray7[1] / ((dArray7[1] - dArray7[0]) / d4);
                        int n18 = n5;
                        dArray[n18] = dArray[n18] - dblObj3.val;
                    }
                    ++n17;
                    d4 /= 3.0;
                }
            }
            if ((n9 & 4) != 0) {
                n10 = this.eclipse_where(dArray[0], n, stringBuffer, n2, dArray8, dArray6, stringBuffer2);
                if (n10 == -1) {
                    return n10;
                }
                dArray7[0] = dArray6[0];
                n10 = this.eclipse_where(dArray[4], n, stringBuffer, n2, dArray8, dArray6, stringBuffer2);
                if (n10 == -1) {
                    return n10;
                }
                dArray7[1] = dArray6[0];
                n10 = this.eclipse_where(dArray[5], n, stringBuffer, n2, dArray8, dArray6, stringBuffer2);
                if (n10 == -1) {
                    return n10;
                }
                dArray7[2] = dArray6[0];
                if (dArray7[0] * dArray7[1] < 0.0 || dArray7[0] * dArray7[2] < 0.0) {
                    n9 |= 0x20;
                    n9 &= 0xFFFFFFFB;
                }
            }
            if ((n3 & 4) == 0 && (n9 & 4) != 0) {
                d11 = d6 + (double)n12 * d9;
                continue;
            }
            if ((n3 & 0x20) != 0 || (n9 & 0x20) == 0) break;
            d11 = d6 + (double)n12 * d9;
        }
        int n19 = 2;
        for (n6 = 0; n6 < 2; ++n6) {
            n5 = n6 + n19;
            d2 = dArray[n5] + SweDate.getDeltaT(dArray[n5]);
            if (this.calc_planet_star(d2, n, stringBuffer, n13, dArray4, stringBuffer2) == -1) {
                return -1;
            }
            if (this.sw.swe_calc(d2, 1, n13, dArray5, stringBuffer2) == -1) {
                return -1;
            }
            dArray7[n6] = this.sl.swe_degnorm(dArray4[0] - dArray5[0]);
            if (!(dArray7[n6] > 180.0)) continue;
            int n20 = n6;
            dArray7[n20] = dArray7[n20] - 360.0;
        }
        if (dArray7[0] * dArray7[1] >= 0.0) {
            dArray[1] = 0.0;
        } else {
            d6 = d3;
            d4 = 0.1;
            dblObj3.val = (dArray[3] - dArray[2]) / 2.0;
            if (dblObj3.val < d4) {
                d4 = dblObj3.val / 2.0;
            }
            n5 = 0;
            while (d4 > 0.01) {
                n6 = 0;
                d11 = d6;
                while (n6 <= 1) {
                    d2 = d11 + SweDate.getDeltaT(d11);
                    if (this.calc_planet_star(d2, n, stringBuffer, n13, dArray4, stringBuffer2) == -1) {
                        return -1;
                    }
                    if (this.sw.swe_calc(d2, 1, n13, dArray5, stringBuffer2) == -1) {
                        return -1;
                    }
                    dArray7[n6] = this.sl.swe_degnorm(dArray4[0] - dArray5[0]);
                    if (dArray7[n6] > 180.0) {
                        int n21 = n6;
                        dArray7[n21] = dArray7[n21] - 360.0;
                    }
                    if (dArray7[n6] > 180.0) {
                        int n22 = n6;
                        dArray7[n22] = dArray7[n22] - 360.0;
                    }
                    ++n6;
                    d11 -= d4;
                }
                double d19 = (dArray7[1] - dArray7[0]) / d4;
                if (d19 < 1.0E-10) break;
                dblObj3.val = dArray7[0] / d19;
                d6 += dblObj3.val;
                ++n5;
                d4 /= 3.0;
            }
            dArray[1] = d6;
        }
        return n9;
    }

    int swe_sol_eclipse_when_loc(double d, int n, double[] dArray, double[] dArray2, double[] dArray3, int n2, StringBuffer stringBuffer) {
        int n3 = 0;
        int n4 = 0;
        double[] dArray4 = new double[20];
        double[] dArray5 = new double[10];
        n3 = this.eclipse_when_loc(d, n &= 7, dArray, dArray2, dArray3, n2, stringBuffer);
        if (n3 <= 0) {
            return n3;
        }
        n4 = this.eclipse_where(dArray2[0], 0, null, n, dArray4, dArray5, stringBuffer);
        if (n4 == -1) {
            return n4;
        }
        dArray3[3] = dArray5[0];
        return n3 |= n4 & 2;
    }

    int swe_lun_occult_when_loc(double d, int n, StringBuffer stringBuffer, int n2, double[] dArray, double[] dArray2, double[] dArray3, int n3, StringBuffer stringBuffer2) {
        int n4 = 0;
        int n5 = 0;
        double[] dArray4 = new double[20];
        double[] dArray5 = new double[10];
        if (n == 144340) {
            n = 9;
        }
        if ((n4 = this.occult_when_loc(d, n, stringBuffer, n2 &= 7, dArray, dArray2, dArray3, n3, stringBuffer2)) <= 0) {
            return n4;
        }
        n5 = this.eclipse_where(dArray2[0], n, stringBuffer, n2, dArray4, dArray5, stringBuffer2);
        if (n5 == -1) {
            return n5;
        }
        dArray3[3] = dArray5[0];
        return n4 |= n5 & 2;
    }

    private int eclipse_when_loc(double d, int n, double[] dArray, double[] dArray2, double[] dArray3, int n2, StringBuffer stringBuffer) {
        int n3 = 0;
        DblObj dblObj = new DblObj();
        double[] dArray4 = new double[6];
        double[] dArray5 = new double[6];
        double[] dArray6 = new double[6];
        double[] dArray7 = new double[6];
        double[] dArray8 = new double[6];
        double[] dArray9 = new double[6];
        double[] dArray10 = new double[3];
        DblObj dblObj2 = new DblObj();
        double d2 = 0.0013888888888888887;
        double d3 = 1.1574074074074075E-4;
        double d4 = 0.08333333333333333;
        double d5 = 0.006944444444444445;
        DblObj dblObj3 = new DblObj();
        DblObj dblObj4 = new DblObj();
        int n4 = 0x8800 | n;
        int n5 = n4 | 0x1000;
        this.sw.swe_set_topo(dArray[0], dArray[1], dArray[2]);
        double d6 = (int)((d - 2451545.0) / 365.2425 * 12.3685);
        d6 = n2 != 0 ? (d6 += 1.0) : (d6 -= 1.0);
        while (true) {
            int n6;
            int n7;
            int n8;
            double d7;
            double d8;
            double d9;
            int n9;
            double d10;
            double d11;
            double d12;
            double d13;
            double d14;
            double d15;
            double d16;
            if ((d16 = (d15 = this.sl.swe_degnorm(160.7108 + 390.67050274 * d6 - 0.0016341 * (d14 = (d13 = d6 / 1236.85) * d13) - 2.27E-6 * (d12 = d14 * d13) + 1.1E-8 * (d11 = d12 * d13)))) > 180.0) {
                d16 -= 180.0;
            }
            if (d16 > 21.0 && d16 < 159.0) {
                if (n2 != 0) {
                    d6 -= 1.0;
                    continue;
                }
                d6 += 1.0;
                continue;
            }
            double d17 = 2451550.09765 + 29.530588853 * d6 + 1.337E-4 * d14 - 1.5E-7 * d12 + 7.3E-10 * d11;
            double d18 = this.sl.swe_degnorm(2.5534 + 29.10535669 * d6 - 2.18E-5 * d14 - 1.1E-7 * d12);
            double d19 = this.sl.swe_degnorm(201.5643 + 385.81693528 * d6 + 0.1017438 * d14 + 1.239E-5 * d12 + 5.8E-8 * d11);
            double d20 = this.sl.swe_degnorm(124.7746 - 1.5637558 * d6 + 0.0020691 * d14 + 2.15E-6 * d12);
            double d21 = 1.0 - 0.002516 * d13 - 7.4E-6 * d14;
            double d22 = this.sl.swe_degnorm(299.77 + 0.107408 * d6 - 0.009173 * d14);
            d15 *= 0.0174532925199433;
            d20 *= 0.0174532925199433;
            d22 *= 0.0174532925199433;
            d17 = d17 - 0.4075 * Math.sin(d19 *= 0.0174532925199433) + 0.1721 * d21 * Math.sin(d18 *= 0.0174532925199433);
            this.sw.swe_set_topo(dArray[0], dArray[1], dArray[2]);
            double d23 = 2.0;
            double d24 = 0.5;
            if (d17 < 1900000.0) {
                d24 = 2.0;
            }
            for (d10 = d24; d10 > 1.0E-5; d10 /= d23) {
                if (d10 < 0.1) {
                    d23 = 3.0;
                }
                n9 = 0;
                d9 = d17 - d10;
                while (n9 <= 2) {
                    if (this.sw.swe_calc(d9, 0, n5, dArray4, stringBuffer) == -1) {
                        return -1;
                    }
                    if (this.sw.swe_calc(d9, 0, n4, dArray6, stringBuffer) == -1) {
                        return -1;
                    }
                    if (this.sw.swe_calc(d9, 1, n5, dArray5, stringBuffer) == -1) {
                        return -1;
                    }
                    if (this.sw.swe_calc(d9, 1, n4, dArray7, stringBuffer) == -1) {
                        return -1;
                    }
                    d8 = Math.sqrt(this.sl.square_sum(dArray5));
                    d7 = Math.sqrt(this.sl.square_sum(dArray4));
                    for (n8 = 0; n8 < 3; ++n8) {
                        dArray8[n8] = dArray4[n8] / d7;
                        dArray9[n8] = dArray5[n8] / d8;
                    }
                    dArray10[n9] = Math.acos(this.sl.swi_dot_prod_unit(dArray8, dArray9)) * 57.2957795130823;
                    ++n9;
                    d9 += d10;
                }
                this.find_maximum(dArray10[0], dArray10[1], dArray10[2], d10, dblObj, dblObj2);
                d17 += dblObj.val + d10;
            }
            if (this.sw.swe_calc(d17, 0, n5, dArray4, stringBuffer) == -1) {
                return -1;
            }
            if (this.sw.swe_calc(d17, 0, n4, dArray6, stringBuffer) == -1) {
                return -1;
            }
            if (this.sw.swe_calc(d17, 1, n5, dArray5, stringBuffer) == -1) {
                return -1;
            }
            if (this.sw.swe_calc(d17, 1, n4, dArray7, stringBuffer) == -1) {
                return -1;
            }
            dblObj2.val = Math.acos(this.sl.swi_dot_prod_unit(dArray4, dArray5)) * 57.2957795130823;
            double d25 = Math.asin(1.1618815109677577E-5 / dArray7[2]) * 57.2957795130823;
            double d26 = Math.asin(0.004652472638342832 / dArray6[2]) * 57.2957795130823;
            double d27 = d26 + d25;
            double d28 = d26 - d25;
            if (dblObj2.val > d27) {
                if (n2 != 0) {
                    d6 -= 1.0;
                    continue;
                }
                d6 += 1.0;
                continue;
            }
            dArray2[0] = d17 - SweDate.getDeltaT(d17);
            if (n2 != 0 && dArray2[0] >= d - 1.0E-4 || n2 == 0 && dArray2[0] <= d + 1.0E-4) {
                if (n2 != 0) {
                    d6 -= 1.0;
                    continue;
                }
                d6 += 1.0;
                continue;
            }
            if (dblObj2.val < d28) {
                n3 = 8;
            } else if (dblObj2.val < Math.abs(d28)) {
                n3 = 4;
            } else if (dblObj2.val <= d27) {
                n3 = 16;
            }
            double d29 = dblObj2.val;
            if (dblObj2.val > Math.abs(d28)) {
                dArray2[3] = 0.0;
                dArray2[2] = 0.0;
            } else {
                dArray10[1] = Math.abs(d28) - d29;
                d9 = d17 - d2;
                for (n9 = 0; n9 <= 2; n9 += 2) {
                    if (this.sw.swe_calc(d9, 0, n5, dArray4, stringBuffer) == -1) {
                        return -1;
                    }
                    if (this.sw.swe_calc(d9, 1, n5, dArray5, stringBuffer) == -1) {
                        return -1;
                    }
                    d8 = Math.sqrt(this.sl.square_sum(dArray5));
                    d7 = Math.sqrt(this.sl.square_sum(dArray4));
                    d25 = Math.asin(1.1618815109677577E-5 / d8) * 57.2957795130823;
                    d26 = Math.asin(0.004652472638342832 / d7) * 57.2957795130823;
                    d28 = d26 - d25;
                    for (n8 = 0; n8 < 3; ++n8) {
                        dArray8[n8] = dArray4[n8] / d7;
                        dArray9[n8] = dArray5[n8] / d8;
                    }
                    dblObj2.val = Math.acos(this.sl.swi_dot_prod_unit(dArray8, dArray9)) * 57.2957795130823;
                    dArray10[n9] = Math.abs(d28) - dblObj2.val;
                    d9 = d17 + d2;
                }
                this.find_zero(dArray10[0], dArray10[1], dArray10[2], d2, dblObj3, dblObj4);
                dArray2[2] = d17 + dblObj3.val + d2;
                dArray2[3] = d17 + dblObj4.val + d2;
                n7 = 0;
                d10 = d3;
                while (n7 < 2) {
                    n6 = 2;
                    while (n6 <= 3) {
                        if (this.sw.swe_calc(dArray2[n6], 0, n5 | 0x100, dArray4, stringBuffer) == -1) {
                            return -1;
                        }
                        if (this.sw.swe_calc(dArray2[n6], 1, n5 | 0x100, dArray5, stringBuffer) == -1) {
                            return -1;
                        }
                        for (n9 = 0; n9 < 2; ++n9) {
                            if (n9 == 1) {
                                for (n8 = 0; n8 < 3; ++n8) {
                                    int n10 = n8;
                                    dArray4[n10] = dArray4[n10] - dArray4[n8 + 3] * d10;
                                    int n11 = n8;
                                    dArray5[n11] = dArray5[n11] - dArray5[n8 + 3] * d10;
                                }
                            }
                            d8 = Math.sqrt(this.sl.square_sum(dArray5));
                            d7 = Math.sqrt(this.sl.square_sum(dArray4));
                            d25 = Math.asin(1.1618815109677577E-5 / d8) * 57.2957795130823;
                            d26 = Math.asin(0.004652472638342832 / d7) * 57.2957795130823;
                            d28 = d26 - d25;
                            for (n8 = 0; n8 < 3; ++n8) {
                                dArray8[n8] = dArray4[n8] / d7;
                                dArray9[n8] = dArray5[n8] / d8;
                            }
                            dblObj2.val = Math.acos(this.sl.swi_dot_prod_unit(dArray8, dArray9)) * 57.2957795130823;
                            dArray10[n9] = Math.abs(d28) - dblObj2.val;
                        }
                        dblObj3.val = -dArray10[0] / ((dArray10[0] - dArray10[1]) / d10);
                        int n12 = n6++;
                        dArray2[n12] = dArray2[n12] + dblObj3.val;
                    }
                    ++n7;
                    d10 /= 10.0;
                }
                dArray2[2] = dArray2[2] - SweDate.getDeltaT(dArray2[2]);
                dArray2[3] = dArray2[3] - SweDate.getDeltaT(dArray2[3]);
            }
            dArray10[1] = d27 - d29;
            d9 = d17 - d4;
            for (n9 = 0; n9 <= 2; n9 += 2) {
                if (this.sw.swe_calc(d9, 0, n5, dArray4, stringBuffer) == -1) {
                    return -1;
                }
                if (this.sw.swe_calc(d9, 1, n5, dArray5, stringBuffer) == -1) {
                    return -1;
                }
                d8 = Math.sqrt(this.sl.square_sum(dArray5));
                d7 = Math.sqrt(this.sl.square_sum(dArray4));
                d25 = Math.asin(1.1618815109677577E-5 / d8) * 57.2957795130823;
                d26 = Math.asin(0.004652472638342832 / d7) * 57.2957795130823;
                d27 = d26 + d25;
                for (n8 = 0; n8 < 3; ++n8) {
                    dArray8[n8] = dArray4[n8] / d7;
                    dArray9[n8] = dArray5[n8] / d8;
                }
                dblObj2.val = Math.acos(this.sl.swi_dot_prod_unit(dArray8, dArray9)) * 57.2957795130823;
                dArray10[n9] = d27 - dblObj2.val;
                d9 = d17 + d4;
            }
            this.find_zero(dArray10[0], dArray10[1], dArray10[2], d4, dblObj3, dblObj4);
            dArray2[1] = d17 + dblObj3.val + d4;
            dArray2[4] = d17 + dblObj4.val + d4;
            n7 = 0;
            d10 = d5;
            while (n7 < 3) {
                for (n6 = 1; n6 <= 4; n6 += 3) {
                    if (this.sw.swe_calc(dArray2[n6], 0, n5 | 0x100, dArray4, stringBuffer) == -1) {
                        return -1;
                    }
                    if (this.sw.swe_calc(dArray2[n6], 1, n5 | 0x100, dArray5, stringBuffer) == -1) {
                        return -1;
                    }
                    for (n9 = 0; n9 < 2; ++n9) {
                        if (n9 == 1) {
                            for (n8 = 0; n8 < 3; ++n8) {
                                int n13 = n8;
                                dArray4[n13] = dArray4[n13] - dArray4[n8 + 3] * d10;
                                int n14 = n8;
                                dArray5[n14] = dArray5[n14] - dArray5[n8 + 3] * d10;
                            }
                        }
                        d8 = Math.sqrt(this.sl.square_sum(dArray5));
                        d7 = Math.sqrt(this.sl.square_sum(dArray4));
                        d25 = Math.asin(1.1618815109677577E-5 / d8) * 57.2957795130823;
                        d26 = Math.asin(0.004652472638342832 / d7) * 57.2957795130823;
                        d27 = d26 + d25;
                        for (n8 = 0; n8 < 3; ++n8) {
                            dArray8[n8] = dArray4[n8] / d7;
                            dArray9[n8] = dArray5[n8] / d8;
                        }
                        dblObj2.val = Math.acos(this.sl.swi_dot_prod_unit(dArray8, dArray9)) * 57.2957795130823;
                        dArray10[n9] = Math.abs(d27) - dblObj2.val;
                    }
                    dblObj3.val = -dArray10[0] / ((dArray10[0] - dArray10[1]) / d10);
                    int n15 = n6;
                    dArray2[n15] = dArray2[n15] + dblObj3.val;
                }
                ++n7;
                d10 /= 10.0;
            }
            dArray2[1] = dArray2[1] - SweDate.getDeltaT(dArray2[1]);
            dArray2[4] = dArray2[4] - SweDate.getDeltaT(dArray2[4]);
            block25: for (n9 = 4; n9 >= 0; --n9) {
                if (dArray2[n9] == 0.0) continue;
                if (this.eclipse_how(dArray2[n9], 0, null, n, dArray[0], dArray[1], dArray[2], dArray3, stringBuffer) == -1) {
                    return -1;
                }
                if (!(dArray3[5] > 0.0)) continue;
                n3 |= 0x80;
                switch (n9) {
                    case 0: {
                        n3 |= 0x100;
                        continue block25;
                    }
                    case 1: {
                        n3 |= 0x200;
                        continue block25;
                    }
                    case 2: {
                        n3 |= 0x400;
                        continue block25;
                    }
                    case 3: {
                        n3 |= 0x800;
                        continue block25;
                    }
                    case 4: {
                        n3 |= 0x1000;
                        continue block25;
                    }
                }
            }
            if ((n3 & 0x80) != 0) break;
            if (n2 != 0) {
                d6 -= 1.0;
                continue;
            }
            d6 += 1.0;
        }
        return n3;
    }

    /*
     * Unable to fully structure code
     */
    private int occult_when_loc(double var1_1, int var3_2, StringBuffer var4_3, int var5_4, double[] var6_5, double[] var7_6, double[] var8_7, int var9_8, StringBuffer var10_9) {
        var15_10 = 0;
        var22_11 = new DblObj();
        var23_12 = new double[6];
        var24_13 = new double[6];
        var25_14 = new double[6];
        var26_15 = new double[6];
        var27_16 = new double[6];
        var28_17 = new double[6];
        var41_18 = new double[20];
        var44_19 = new DblObj();
        var45_20 = 0.0013888888888888887;
        var47_21 = 1.1574074074074075E-4;
        var49_22 = 0.08333333333333333;
        var51_23 = 0.006944444444444445;
        var53_24 = new DblObj();
        var54_25 = new DblObj();
        var59_26 = 6.0;
        var61_27 = 10;
        var64_28 = 32768 | var5_4;
        var65_29 = var64_28 & -32769;
        var66_30 = var64_28 | 4096;
        var67_31 = var65_29 | 4096;
        var68_32 = 1;
        var69_33 = (var9_8 & 32768) != 0;
        var70_34 = false;
        var9_8 = (int)((long)var9_8 & 1L);
        var15_10 = 0;
        for (var11_35 = 0; var11_35 <= 9; ++var11_35) {
            var7_6[var11_35] = 0.0;
        }
        if (var9_8 != 0) {
            var68_32 = -1;
        }
        var16_36 = var1_1 - (double)var68_32 * 0.1;
        var18_37 = var1_1;
        while (true) {
            var11_35 = 0;
            while (var11_35 < var61_27) {
                if (this.calc_planet_star(var16_36, var3_2, var4_3, var67_31, var23_12, var10_9) == -1) {
                    return -1;
                }
                if (this.sw.swe_calc(var16_36, 1, var67_31, var24_13, var10_9) == -1) {
                    return -1;
                }
                var41_18[var11_35] = Math.acos(this.sl.swi_dot_prod_unit(var23_12, var24_13)) * 57.2957795130823;
                if (var11_35 > 1 && var41_18[var11_35] > var41_18[var11_35 - 1] && var41_18[var11_35 - 2] > var41_18[var11_35 - 1]) {
                    var18_37 = var16_36 - (double)var68_32 * var59_26;
                    break;
                }
                if (var11_35 == var61_27 - 1) {
                    for (var12_38 = 0; var12_38 < var61_27; ++var12_38) {
                        System.out.print(var41_18[var12_38] + " ");
                    }
                    System.out.print("swe_lun_occult_when_loc(): problem planet\n");
                    return -1;
                }
                ++var11_35;
                var16_36 += (double)var68_32 * var59_26;
            }
            var62_51 = var4_3 != null && var4_3.length() > 0 ? 0.0 : (var3_2 < 21 ? SwephData.pla_diam[var3_2] / 2.0 / 1.4959787066E11 : (var3_2 > 10000 ? this.swed.ast_diam / 2.0 * 1000.0 / 1.4959787066E11 : 0.0));
            var55_49 = 3.0;
            for (var20_41 = var57_50 = var59_26; var20_41 > 1.0E-5; var20_41 /= var55_49) {
                if (var20_41 < 0.01) {
                    var55_49 = 3.0;
                }
                var11_35 = 0;
                var16_36 = var18_37 - var20_41;
                while (var11_35 <= 2) {
                    if (this.calc_planet_star(var16_36, var3_2, var4_3, var66_30, var23_12, var10_9) == -1) {
                        return -1;
                    }
                    if (this.calc_planet_star(var16_36, var3_2, var4_3, var64_28, var25_14, var10_9) == -1) {
                        return -1;
                    }
                    if (this.sw.swe_calc(var16_36, 1, var66_30, var24_13, var10_9) == -1) {
                        return -1;
                    }
                    if (this.sw.swe_calc(var16_36, 1, var64_28, var26_15, var10_9) == -1) {
                        return -1;
                    }
                    if (!(var20_41 < 1.0) || !(Math.abs(var25_14[1] - var26_15[1]) > 2.0)) ** GOTO lbl76
                    if (!var69_33) {
                        var16_36 = var18_37 + (double)(var68_32 * 2);
                    } else {
                        var70_34 = true;
lbl76:
                        // 2 sources

                        var41_18[var11_35] = Math.acos(this.sl.swi_dot_prod_unit(var23_12, var24_13)) * 57.2957795130823;
                        var33_44 = Math.asin(1.1618815109677577E-5 / var26_15[2]) * 57.2957795130823;
                        var35_45 = Math.asin(var62_51 / var25_14[2]) * 57.2957795130823;
                        v0 = var11_35;
                        var41_18[v0] = var41_18[v0] - (var33_44 + var35_45);
                    }
                    ++var11_35;
                    var16_36 += var20_41;
                }
                this.find_maximum(var41_18[0], var41_18[1], var41_18[2], var20_41, var22_11, var44_19);
                var18_37 += var22_11.val + var20_41;
            }
            if (var70_34) {
                var7_6[0] = var18_37;
                return 0;
            }
            if (this.calc_planet_star(var18_37, var3_2, var4_3, var66_30, var23_12, var10_9) == -1) {
                return -1;
            }
            if (this.calc_planet_star(var18_37, var3_2, var4_3, var64_28, var25_14, var10_9) == -1) {
                return -1;
            }
            if (this.sw.swe_calc(var18_37, 1, var66_30, var24_13, var10_9) == -1) {
                return -1;
            }
            if (this.sw.swe_calc(var18_37, 1, var64_28, var26_15, var10_9) == -1) {
                return -1;
            }
            var44_19.val = Math.acos(this.sl.swi_dot_prod_unit(var23_12, var24_13)) * 57.2957795130823;
            var33_44 = Math.asin(1.1618815109677577E-5 / var26_15[2]) * 57.2957795130823;
            var35_45 = Math.asin(var62_51 / var25_14[2]) * 57.2957795130823;
            var37_46 = var35_45 + var33_44;
            var39_47 = var35_45 - var33_44;
            if (var44_19.val > var37_46) {
                if (var69_33) {
                    var7_6[0] = var18_37;
                    return 0;
                }
                var16_36 = var18_37 + (double)var68_32;
                continue;
            }
            var7_6[0] = var18_37 - SweDate.getDeltaT(var18_37);
            if (var9_8 != 0 && var7_6[0] >= var1_1 - 1.0E-4 || var9_8 == 0 && var7_6[0] <= var1_1 + 1.0E-4) {
                var16_36 = var18_37 + (double)var68_32;
                continue;
            }
            if (var44_19.val < var39_47) {
                var15_10 = 8;
            } else if (var44_19.val < Math.abs(var39_47)) {
                var15_10 = 4;
            } else if (var44_19.val <= var37_46) {
                var15_10 = 16;
            }
            var42_48 = var44_19.val;
            if (var44_19.val > Math.abs(var39_47)) {
                var7_6[3] = 0.0;
                var7_6[2] = 0.0;
            } else {
                var41_18[1] = Math.abs(var39_47) - var42_48;
                var16_36 = var18_37 - var45_20;
                for (var11_35 = 0; var11_35 <= 2; var11_35 += 2) {
                    if (this.calc_planet_star(var16_36, var3_2, var4_3, var66_30, var23_12, var10_9) == -1) {
                        return -1;
                    }
                    if (this.sw.swe_calc(var16_36, 1, var66_30, var24_13, var10_9) == -1) {
                        return -1;
                    }
                    var29_42 = Math.sqrt(this.sl.square_sum(var24_13));
                    var31_43 = Math.sqrt(this.sl.square_sum(var23_12));
                    var33_44 = Math.asin(1.1618815109677577E-5 / var29_42) * 57.2957795130823;
                    var35_45 = Math.asin(var62_51 / var31_43) * 57.2957795130823;
                    var39_47 = var35_45 - var33_44;
                    for (var13_39 = 0; var13_39 < 3; ++var13_39) {
                        var27_16[var13_39] = var23_12[var13_39] / var31_43;
                        var28_17[var13_39] = var24_13[var13_39] / var29_42;
                    }
                    var44_19.val = Math.acos(this.sl.swi_dot_prod_unit(var27_16, var28_17)) * 57.2957795130823;
                    var41_18[var11_35] = Math.abs(var39_47) - var44_19.val;
                    var16_36 = var18_37 + var45_20;
                }
                this.find_zero(var41_18[0], var41_18[1], var41_18[2], var45_20, var53_24, var54_25);
                var7_6[2] = var18_37 + var53_24.val + var45_20;
                var7_6[3] = var18_37 + var54_25.val + var45_20;
                var14_40 = 0;
                var20_41 = var47_21;
                while (var14_40 < 2) {
                    var12_38 = 2;
                    while (var12_38 <= 3) {
                        if (this.calc_planet_star(var7_6[var12_38], var3_2, var4_3, var66_30 | 256, var23_12, var10_9) == -1) {
                            return -1;
                        }
                        if (this.sw.swe_calc(var7_6[var12_38], 1, var66_30 | 256, var24_13, var10_9) == -1) {
                            return -1;
                        }
                        for (var11_35 = 0; var11_35 < 2; ++var11_35) {
                            if (var11_35 == 1) {
                                for (var13_39 = 0; var13_39 < 3; ++var13_39) {
                                    v1 = var13_39;
                                    var23_12[v1] = var23_12[v1] - var23_12[var13_39 + 3] * var20_41;
                                    v2 = var13_39;
                                    var24_13[v2] = var24_13[v2] - var24_13[var13_39 + 3] * var20_41;
                                }
                            }
                            var29_42 = Math.sqrt(this.sl.square_sum(var24_13));
                            var31_43 = Math.sqrt(this.sl.square_sum(var23_12));
                            var33_44 = Math.asin(1.1618815109677577E-5 / var29_42) * 57.2957795130823;
                            var35_45 = Math.asin(var62_51 / var31_43) * 57.2957795130823;
                            var39_47 = var35_45 - var33_44;
                            for (var13_39 = 0; var13_39 < 3; ++var13_39) {
                                var27_16[var13_39] = var23_12[var13_39] / var31_43;
                                var28_17[var13_39] = var24_13[var13_39] / var29_42;
                            }
                            var44_19.val = Math.acos(this.sl.swi_dot_prod_unit(var27_16, var28_17)) * 57.2957795130823;
                            var41_18[var11_35] = Math.abs(var39_47) - var44_19.val;
                        }
                        var53_24.val = -var41_18[0] / ((var41_18[0] - var41_18[1]) / var20_41);
                        v3 = var12_38++;
                        var7_6[v3] = var7_6[v3] + var53_24.val;
                    }
                    ++var14_40;
                    var20_41 /= 10.0;
                }
                var7_6[2] = var7_6[2] - SweDate.getDeltaT(var7_6[2]);
                var7_6[3] = var7_6[3] - SweDate.getDeltaT(var7_6[3]);
            }
            var41_18[1] = var37_46 - var42_48;
            var16_36 = var18_37 - var49_22;
            for (var11_35 = 0; var11_35 <= 2; var11_35 += 2) {
                if (this.calc_planet_star(var16_36, var3_2, var4_3, var66_30, var23_12, var10_9) == -1) {
                    return -1;
                }
                if (this.sw.swe_calc(var16_36, 1, var66_30, var24_13, var10_9) == -1) {
                    return -1;
                }
                var29_42 = Math.sqrt(this.sl.square_sum(var24_13));
                var31_43 = Math.sqrt(this.sl.square_sum(var23_12));
                var33_44 = Math.asin(1.1618815109677577E-5 / var29_42) * 57.2957795130823;
                var35_45 = Math.asin(var62_51 / var31_43) * 57.2957795130823;
                var37_46 = var35_45 + var33_44;
                for (var13_39 = 0; var13_39 < 3; ++var13_39) {
                    var27_16[var13_39] = var23_12[var13_39] / var31_43;
                    var28_17[var13_39] = var24_13[var13_39] / var29_42;
                }
                var44_19.val = Math.acos(this.sl.swi_dot_prod_unit(var27_16, var28_17)) * 57.2957795130823;
                var41_18[var11_35] = var37_46 - var44_19.val;
                var16_36 = var18_37 + var49_22;
            }
            this.find_zero(var41_18[0], var41_18[1], var41_18[2], var49_22, var53_24, var54_25);
            var7_6[1] = var18_37 + var53_24.val + var49_22;
            var7_6[4] = var18_37 + var54_25.val + var49_22;
            var14_40 = 0;
            var20_41 = var51_23;
            while (var14_40 < 3) {
                for (var12_38 = 1; var12_38 <= 4; var12_38 += 3) {
                    if (this.calc_planet_star(var7_6[var12_38], var3_2, var4_3, var66_30 | 256, var23_12, var10_9) == -1) {
                        return -1;
                    }
                    if (this.sw.swe_calc(var7_6[var12_38], 1, var66_30 | 256, var24_13, var10_9) == -1) {
                        return -1;
                    }
                    for (var11_35 = 0; var11_35 < 2; ++var11_35) {
                        if (var11_35 == 1) {
                            for (var13_39 = 0; var13_39 < 3; ++var13_39) {
                                v4 = var13_39;
                                var23_12[v4] = var23_12[v4] - var23_12[var13_39 + 3] * var20_41;
                                v5 = var13_39;
                                var24_13[v5] = var24_13[v5] - var24_13[var13_39 + 3] * var20_41;
                            }
                        }
                        var29_42 = Math.sqrt(this.sl.square_sum(var24_13));
                        var31_43 = Math.sqrt(this.sl.square_sum(var23_12));
                        var33_44 = Math.asin(1.1618815109677577E-5 / var29_42) * 57.2957795130823;
                        var35_45 = Math.asin(var62_51 / var31_43) * 57.2957795130823;
                        var37_46 = var35_45 + var33_44;
                        for (var13_39 = 0; var13_39 < 3; ++var13_39) {
                            var27_16[var13_39] = var23_12[var13_39] / var31_43;
                            var28_17[var13_39] = var24_13[var13_39] / var29_42;
                        }
                        var44_19.val = Math.acos(this.sl.swi_dot_prod_unit(var27_16, var28_17)) * 57.2957795130823;
                        var41_18[var11_35] = Math.abs(var37_46) - var44_19.val;
                    }
                    var53_24.val = -var41_18[0] / ((var41_18[0] - var41_18[1]) / var20_41);
                    v6 = var12_38;
                    var7_6[v6] = var7_6[v6] + var53_24.val;
                }
                ++var14_40;
                var20_41 /= 10.0;
            }
            var7_6[1] = var7_6[1] - SweDate.getDeltaT(var7_6[1]);
            var7_6[4] = var7_6[4] - SweDate.getDeltaT(var7_6[4]);
            block27: for (var11_35 = 4; var11_35 >= 0; --var11_35) {
                if (var7_6[var11_35] == 0.0) continue;
                if (this.eclipse_how(var7_6[var11_35], var3_2, var4_3, var5_4, var6_5[0], var6_5[1], var6_5[2], var8_7, var10_9) == -1) {
                    return -1;
                }
                if (!(var8_7[5] > 0.0)) continue;
                var15_10 |= 128;
                switch (var11_35) {
                    case 0: {
                        var15_10 |= 256;
                        continue block27;
                    }
                    case 1: {
                        var15_10 |= 512;
                        continue block27;
                    }
                    case 2: {
                        var15_10 |= 1024;
                        continue block27;
                    }
                    case 3: {
                        var15_10 |= 2048;
                        continue block27;
                    }
                    case 4: {
                        var15_10 |= 4096;
                        continue block27;
                    }
                }
            }
            if ((var15_10 & 128) != 0) break;
            var16_36 = var18_37 + (double)var68_32;
        }
        return var15_10;
    }

    void swe_azalt(double d, int n, double[] dArray, double d2, double d3, double[] dArray2, double[] dArray3) {
        double[] dArray4 = new double[6];
        double[] dArray5 = new double[3];
        double d4 = this.sl.swe_degnorm(this.sl.swe_sidtime(d) * 15.0 + dArray[0]);
        for (int i = 0; i < 2; ++i) {
            dArray5[i] = dArray2[i];
        }
        dArray5[2] = 1.0;
        if (n == 0) {
            double d5 = d + SweDate.getDeltaT(d);
            this.sw.swe_calc(d5, -1, 0, dArray4, null);
            double d6 = dArray4[0];
            this.sl.swe_cotrans(dArray5, 0, dArray5, 0, -d6);
        }
        double d7 = this.sl.swe_degnorm(dArray5[0] - d4);
        dArray4[0] = this.sl.swe_degnorm(d7 - 90.0);
        dArray4[1] = dArray5[1];
        dArray4[2] = 1.0;
        this.sl.swe_cotrans(dArray4, 0, dArray4, 0, 90.0 - dArray[1]);
        dArray4[0] = this.sl.swe_degnorm(dArray4[0] + 90.0);
        dArray3[0] = 360.0 - dArray4[0];
        dArray3[1] = dArray4[1];
        if (d2 == 0.0) {
            d2 = 1013.25 * Math.pow(1.0 - 0.0065 * dArray[2] / 288.0, 5.255);
        }
        dArray3[2] = this.swe_refrac(dArray4[1], d2, d3, 0);
    }

    void swe_azalt_rev(double d, int n, double[] dArray, double[] dArray2, double[] dArray3) {
        double[] dArray4 = new double[6];
        double[] dArray5 = new double[3];
        double d2 = dArray[0];
        double d3 = dArray[1];
        double d4 = this.sl.swe_degnorm(this.sl.swe_sidtime(d) * 15.0 + d2);
        for (int i = 0; i < 2; ++i) {
            dArray5[i] = dArray2[i];
        }
        dArray5[2] = 1.0;
        dArray5[0] = 360.0 - dArray5[0];
        dArray5[0] = this.sl.swe_degnorm(dArray5[0] - 90.0);
        this.sl.swe_cotrans(dArray5, 0, dArray5, 0, d3 - 90.0);
        dArray5[0] = this.sl.swe_degnorm(dArray5[0] + d4 + 90.0);
        dArray3[0] = dArray5[0];
        dArray3[1] = dArray5[1];
        if (n == 0) {
            double d5 = d + SweDate.getDeltaT(d);
            this.sw.swe_calc(d5, -1, 0, dArray4, null);
            double d6 = dArray4[0];
            this.sl.swe_cotrans(dArray5, 0, dArray4, 0, d6);
            dArray3[0] = dArray4[0];
            dArray3[1] = dArray4[1];
        }
    }

    double swe_refrac(double d, double d2, double d3, int n) {
        double d4;
        double d5 = d2 / 1010.0 * 283.0 / (273.0 + d3);
        if (n == 0) {
            double d6;
            double d7 = d;
            if (d7 > 15.0) {
                double d8 = Math.tan((90.0 - d7) * 0.0174532925199433);
                d6 = 58.276 * d8 - 0.0824 * d8 * d8 * d8;
                d6 *= d5 / 3600.0;
            } else if (d7 > -5.0) {
                double d9 = d7 + 10.3 / (d7 + 5.11);
                d6 = d9 + 1.0E-10 >= 90.0 ? 0.0 : 1.02 / Math.tan(d9 * 0.0174532925199433);
                d6 *= d5 / 60.0;
            } else {
                d6 = 0.0;
            }
            double d10 = d7;
            if (d10 + d6 > 0.0) {
                d10 += d6;
            }
            return d10;
        }
        double d11 = d;
        double d12 = d11 + 7.31 / (d11 + 4.4);
        if (d12 + 1.0E-10 >= 90.0) {
            d4 = 0.0;
        } else {
            d4 = 1.0 / Math.tan(d12 * 0.0174532925199433);
            d4 -= 0.06 * Math.sin(14.7 * d4 + 13.0);
        }
        d4 *= d5 / 60.0;
        double d13 = d11;
        if (d11 - d4 > 0.0) {
            d13 = d11 - d4;
        }
        return d13;
    }

    int swe_lun_eclipse_how(double d, int n, double[] dArray, double[] dArray2, StringBuffer stringBuffer) {
        double[] dArray3 = new double[10];
        return this.lun_eclipse_how(d, n &= 0xFFFF7FFF, dArray2, dArray3, stringBuffer);
    }

    private int lun_eclipse_how(double d, int n, double[] dArray, double[] dArray2, StringBuffer stringBuffer) {
        int n2;
        int n3 = 0;
        double[] dArray3 = new double[6];
        double[] dArray4 = new double[6];
        double[] dArray5 = new double[6];
        double[] dArray6 = new double[6];
        double[] dArray7 = new double[6];
        for (n2 = 0; n2 < 10; ++n2) {
            dArray2[n2] = 0.0;
        }
        for (n2 = 0; n2 < 20; ++n2) {
            dArray[n2] = 0.0;
        }
        int n4 = 0x900 | n;
        double d2 = SweDate.getDeltaT(d);
        double d3 = d + d2;
        if (this.sw.swe_calc(d3, 1, n4 |= 0x1000, dArray4, stringBuffer) == -1) {
            return -1;
        }
        double d4 = Math.sqrt(this.sl.square_sum(dArray4));
        if (this.sw.swe_calc(d3, 0, n4, dArray5, stringBuffer) == -1) {
            return -1;
        }
        double d5 = Math.sqrt(this.sl.square_sum(dArray5));
        for (n2 = 0; n2 < 3; ++n2) {
            dArray6[n2] = dArray5[n2] / d5;
            dArray7[n2] = dArray4[n2] / d4;
        }
        double d6 = Math.acos(this.sl.swi_dot_prod_unit(dArray6, dArray7)) * 57.2957795130823;
        for (n2 = 0; n2 <= 2; ++n2) {
            int n5 = n2;
            dArray5[n5] = dArray5[n5] - dArray4[n2];
        }
        for (n2 = 0; n2 <= 2; ++n2) {
            dArray4[n2] = -dArray4[n2];
        }
        for (n2 = 0; n2 <= 2; ++n2) {
            dArray3[n2] = dArray4[n2] - dArray5[n2];
        }
        double d7 = Math.sqrt(this.sl.square_sum(dArray3));
        n2 = 0;
        while (n2 <= 2) {
            int n6 = n2++;
            dArray3[n6] = dArray3[n6] / d7;
        }
        double d8 = 0.004609837405823407 / d7;
        double d9 = Math.sqrt(1.0 - d8 * d8);
        double d10 = 0.004695107870862257 / d7;
        double d11 = Math.sqrt(1.0 - d10 * d10);
        double d12 = -this.sw.dot_prod(dArray4, dArray3);
        double d13 = Math.sqrt(d4 * d4 - d12 * d12);
        double d14 = Math.abs(d12 / d7 * 0.009219674811646815 - 8.527046503885043E-5) * 1.02 / d9;
        double d15 = (d12 / d7 * 0.009390215741724514 + 8.527046503885043E-5) * 1.02 / d11;
        dArray2[0] = d13;
        dArray2[1] = d14 /= d9;
        dArray2[2] = d15 /= d11;
        dArray2[3] = d9;
        dArray2[4] = d11;
        n3 = 0;
        if (d14 / 2.0 >= d13 + 1.1618815109677577E-5 / d9) {
            n3 = 4;
            dArray[0] = (d14 / 2.0 - d13 + 1.1618815109677577E-5) / 2.3237630219355155E-5;
        } else if (d14 / 2.0 >= d13 - 1.1618815109677577E-5 / d9) {
            n3 = 16;
            dArray[0] = (d14 / 2.0 - d13 + 1.1618815109677577E-5) / 2.3237630219355155E-5;
        } else if (d15 / 2.0 >= d13 - 1.1618815109677577E-5 / d11) {
            n3 = 64;
            dArray[0] = 0.0;
        } else if (stringBuffer != null) {
            stringBuffer.setLength(0);
            stringBuffer.append("no lunar eclipse at tjd = " + d3);
        }
        dArray[1] = (d15 / 2.0 - d13 + 1.1618815109677577E-5) / 2.3237630219355155E-5;
        if (n3 != 0) {
            dArray[7] = 180.0 - Math.abs(d6);
        }
        return n3;
    }

    int swe_lun_eclipse_when(double d, int n, int n2, double[] dArray, int n3, StringBuffer stringBuffer) {
        int n4;
        double d2;
        double d3;
        int n5;
        double d4;
        int n6;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        DblObj dblObj = new DblObj();
        double[] dArray2 = new double[6];
        double[] dArray3 = new double[6];
        double[] dArray4 = new double[10];
        double[] dArray5 = new double[3];
        DblObj dblObj2 = new DblObj();
        double d5 = 0.08333333333333333;
        double d6 = 0.006944444444444445;
        DblObj dblObj3 = new DblObj();
        DblObj dblObj4 = new DblObj();
        double[] dArray6 = new double[20];
        double[] dArray7 = new double[6];
        double[] dArray8 = new double[6];
        int n11 = 1;
        int n12 = 0x800 | (n &= 7);
        int n13 = n12 | 0x1000;
        if (n2 == 0) {
            n2 = 84;
        }
        if (n3 != 0) {
            n11 = -1;
        }
        double d7 = (int)((d - 2451545.0) / 365.2425 * 12.3685);
        d7 -= (double)n11;
        while (true) {
            n9 = 0;
            for (n6 = 0; n6 <= 9; ++n6) {
                dArray[n6] = 0.0;
            }
            double d8 = d7 + 0.5;
            double d9 = d8 / 1236.85;
            double d10 = d9 * d9;
            double d11 = d10 * d9;
            double d12 = d11 * d9;
            double d13 = this.sl.swe_degnorm(160.7108 + 390.67050274 * d8 - 0.0016341 * d10 - 2.27E-6 * d11 + 1.1E-8 * d12);
            double d14 = d13;
            if (d14 > 180.0) {
                d14 -= 180.0;
            }
            if (d14 > 21.0 && d14 < 159.0) {
                d7 += (double)n11;
                continue;
            }
            d4 = 2451550.09765 + 29.530588853 * d8 + 1.337E-4 * d10 - 1.5E-7 * d11 + 7.3E-10 * d12;
            double d15 = this.sl.swe_degnorm(2.5534 + 29.10535669 * d8 - 2.18E-5 * d10 - 1.1E-7 * d11);
            double d16 = this.sl.swe_degnorm(201.5643 + 385.81693528 * d8 + 0.1017438 * d10 + 1.239E-5 * d11 + 5.8E-8 * d12);
            double d17 = this.sl.swe_degnorm(124.7746 - 1.5637558 * d8 + 0.0020691 * d10 + 2.15E-6 * d11);
            double d18 = 1.0 - 0.002516 * d9 - 7.4E-6 * d10;
            double d19 = this.sl.swe_degnorm(299.77 + 0.107408 * d8 - 0.009173 * d10);
            double d20 = (d13 *= 0.0174532925199433) - 0.02665 * Math.sin(d17 *= 0.0174532925199433) * 0.0174532925199433;
            d4 = d4 - 0.4075 * Math.sin(d16 *= 0.0174532925199433) + 0.1721 * d18 * Math.sin(d15 *= 0.0174532925199433) + 0.0161 * Math.sin(2.0 * d16) - 0.0097 * Math.sin(2.0 * d20) + 0.0073 * d18 * Math.sin(d16 - d15) - 0.005 * d18 * Math.sin(d16 + d15) - 0.0023 * Math.sin(d16 - 2.0 * d20) + 0.0021 * d18 * Math.sin(2.0 * d15) + 0.0012 * Math.sin(d16 + 2.0 * d20) + 6.0E-4 * d18 * Math.sin(2.0 * d16 + d15) - 4.0E-4 * Math.sin(3.0 * d16) - 3.0E-4 * d18 * Math.sin(d15 + 2.0 * d20) + 3.0E-4 * Math.sin(d19 *= 0.0174532925199433) - 2.0E-4 * d18 * Math.sin(d15 - 2.0 * d20) - 2.0E-4 * d18 * Math.sin(2.0 * d16 - d15) - 2.0E-4 * Math.sin(d17);
            double d21 = 0.1;
            if (d4 < 2000000.0) {
                d21 = 5.0;
            }
            double d22 = 4.0;
            n5 = 0;
            for (d3 = d21; d3 > 0.001; d3 /= d22) {
                n6 = 0;
                d2 = d4 - d3;
                while (n6 <= 2) {
                    if (this.sw.swe_calc(d2, 0, n13, dArray2, stringBuffer) == -1) {
                        return -1;
                    }
                    if (this.sw.swe_calc(d2, 1, n13, dArray3, stringBuffer) == -1) {
                        return -1;
                    }
                    for (n4 = 0; n4 < 3; ++n4) {
                        int n14 = n4;
                        dArray2[n14] = dArray2[n14] - dArray3[n4];
                        dArray3[n4] = -dArray3[n4];
                    }
                    double d23 = Math.sqrt(this.sl.square_sum(dArray2));
                    double d24 = Math.sqrt(this.sl.square_sum(dArray3));
                    for (n4 = 0; n4 < 3; ++n4) {
                        dArray7[n4] = dArray2[n4] / d23;
                        dArray8[n4] = dArray3[n4] / d24;
                    }
                    dArray5[n6] = Math.acos(this.sl.swi_dot_prod_unit(dArray7, dArray8)) * 57.2957795130823;
                    double d25 = Math.asin(4.263523251942522E-5 / d24) * 57.2957795130823;
                    double d26 = Math.asin(0.004652472638342832 / d23) * 57.2957795130823;
                    int n15 = n6++;
                    dArray5[n15] = dArray5[n15] - (d25 + d26);
                    d2 += d3;
                }
                this.find_maximum(dArray5[0], dArray5[1], dArray5[2], d3, dblObj, dblObj2);
                d4 += dblObj.val + d3;
                ++n5;
            }
            if ((n9 = this.swe_lun_eclipse_how(d4 -= SweDate.getDeltaT(d4), n, null, dArray6, stringBuffer)) == -1) {
                return n9;
            }
            if (n9 == 0) {
                d7 += (double)n11;
                continue;
            }
            dArray[0] = d4;
            if (n3 != 0 && dArray[0] >= d - 1.0E-4 || n3 == 0 && dArray[0] <= d + 1.0E-4) {
                d7 += (double)n11;
                continue;
            }
            if ((n2 & 0x40) == 0 && (n9 & 0x40) != 0) {
                d7 += (double)n11;
                continue;
            }
            if ((n2 & 0x10) == 0 && (n9 & 0x10) != 0) {
                d7 += (double)n11;
                continue;
            }
            if ((n2 & 4) != 0 || (n9 & 4) == 0) break;
            d7 += (double)n11;
        }
        int n16 = (n9 & 0x40) != 0 ? 0 : ((n9 & 0x10) != 0 ? 1 : 2);
        double d27 = d5;
        double d28 = d6;
        for (int i = 0; i <= n16; ++i) {
            if (i == 0) {
                n7 = 6;
                n8 = 7;
            } else if (i == 1) {
                n7 = 2;
                n8 = 3;
            } else if (i == 2) {
                n7 = 4;
                n8 = 5;
            }
            n6 = 0;
            d2 = d4 - d27;
            while (n6 <= 2) {
                n10 = this.lun_eclipse_how(d2, n, dArray6, dArray4, stringBuffer);
                if (n10 == -1) {
                    return n10;
                }
                if (i == 0) {
                    dArray5[n6] = dArray4[2] / 2.0 + 1.1618815109677577E-5 / dArray4[4] - dArray4[0];
                } else if (i == 1) {
                    dArray5[n6] = dArray4[1] / 2.0 + 1.1618815109677577E-5 / dArray4[3] - dArray4[0];
                } else if (i == 2) {
                    dArray5[n6] = dArray4[1] / 2.0 - 1.1618815109677577E-5 / dArray4[3] - dArray4[0];
                }
                ++n6;
                d2 += d27;
            }
            this.find_zero(dArray5[0], dArray5[1], dArray5[2], d27, dblObj3, dblObj4);
            d28 = (dblObj3.val + d27) / 2.0;
            dArray[n7] = d4 + dblObj3.val + d27;
            dArray[n8] = d4 + dblObj4.val + d27;
            n4 = 0;
            d3 = d28 / 2.0;
            while (n4 < 3) {
                for (n5 = n7; n5 <= n8; n5 += n8 - n7) {
                    n6 = 0;
                    d2 = dArray[n5] - d3;
                    while (n6 < 2) {
                        n10 = this.lun_eclipse_how(d2, n, dArray6, dArray4, stringBuffer);
                        if (n10 == -1) {
                            return n10;
                        }
                        if (i == 0) {
                            dArray5[n6] = dArray4[2] / 2.0 + 1.1618815109677577E-5 / dArray4[4] - dArray4[0];
                        } else if (i == 1) {
                            dArray5[n6] = dArray4[1] / 2.0 + 1.1618815109677577E-5 / dArray4[3] - dArray4[0];
                        } else if (i == 2) {
                            dArray5[n6] = dArray4[1] / 2.0 - 1.1618815109677577E-5 / dArray4[3] - dArray4[0];
                        }
                        ++n6;
                        d2 += d3;
                    }
                    dblObj3.val = dArray5[1] / ((dArray5[1] - dArray5[0]) / d3);
                    int n17 = n5;
                    dArray[n17] = dArray[n17] - dblObj3.val;
                }
                ++n4;
                d3 /= 2.0;
            }
        }
        return n9;
    }

    int swe_pheno(double d, int n, int n2, double[] dArray, StringBuffer stringBuffer) {
        int n3;
        double[] dArray2 = new double[6];
        double[] dArray3 = new double[6];
        double[] dArray4 = new double[6];
        double[] dArray5 = new double[6];
        double[] dArray6 = new double[6];
        double d2 = 0.0;
        double[] dArray7 = new double[2];
        if (n == 144340) {
            n = 9;
        }
        for (n3 = 0; n3 < 20; ++n3) {
            dArray[n3] = 0.0;
        }
        if (n > 10000 && n <= 10004) {
            n = n - 10000 - 1 + 17;
        }
        int n4 = (n2 &= 0x8677) & 0x477;
        n4 |= 8;
        if (this.sw.swe_calc(d, n, n2 | 0x1000, dArray2, stringBuffer) == -1) {
            return -1;
        }
        if (this.sw.swe_calc(d, n, n2, dArray5, stringBuffer) == -1) {
            return -1;
        }
        if (n == 1 && this.sw.swe_calc(d, 0, n2 | 0x1000, dArray4, stringBuffer) == -1) {
            return -1;
        }
        if (n != 0 && n != 14 && n != 10 && n != 11 && n != 12 && n != 13) {
            d2 = dArray5[2] * 1.4959787066E11 / 2.99792458E8 / 86400.0;
            if ((n2 & 0x10) != 0) {
                d2 = 0.0;
            }
            if (this.sw.swe_calc(d - d2, n, n4 | 0x1000, dArray3, stringBuffer) == -1) {
                return -1;
            }
            if (this.sw.swe_calc(d - d2, n, n4, dArray6, stringBuffer) == -1) {
                return -1;
            }
            dArray[0] = Math.acos(this.sl.swi_dot_prod_unit(dArray2, dArray3)) * 57.2957795130823;
            dArray[1] = (1.0 + Math.cos(dArray[0] * 0.0174532925199433)) / 2.0;
        }
        double d3 = n < 21 ? SwephData.pla_diam[n] : (n > 10000 ? this.swed.ast_diam * 1000.0 : 0.0);
        dArray[3] = dArray5[2] < d3 / 2.0 / 1.4959787066E11 ? 180.0 : Math.asin(d3 / 2.0 / 1.4959787066E11 / dArray5[2]) * 2.0 * 57.2957795130823;
        if (n > 10000 || n < 21 && mag_elem[n][0] < 99.0) {
            if (n == 0) {
                double d4 = dArray[3] / (Math.asin(SwephData.pla_diam[0] / 2.0 / 1.4959787066E11) * 2.0 * 57.2957795130823);
                d4 *= d4;
                dArray[4] = mag_elem[n][0] - 2.5 * this.log10(d4);
            } else if (n == 1) {
                double d5 = dArray[3] / (Math.asin(SwephData.pla_diam[1] / 2.0 / 3.844E8) * 2.0 * 57.2957795130823);
                for (n3 = 0; n3 < 3; ++n3) {
                    int n5 = n3;
                    dArray4[n5] = dArray4[n5] - dArray2[n3];
                }
                double d6 = Math.sqrt(this.sl.square_sum(dArray4));
                d5 *= d5 * dArray[1];
                dArray[4] = mag_elem[n][0] - 2.5 * this.log10(d5 *= d6 * d6);
            } else if (n == 6) {
                double d7;
                double d8 = (d - d2 - 2451545.0) / 36525.0;
                double d9 = (28.075216 - 0.012998 * d8 + 4.0E-6 * d8 * d8) * 0.0174532925199433;
                double d10 = (169.50847 + 1.394681 * d8 + 4.12E-4 * d8 * d8) * 0.0174532925199433;
                double d11 = Math.abs(Math.sin(d9) * Math.cos(dArray5[1] * 0.0174532925199433) * Math.sin(dArray5[0] * 0.0174532925199433 - d10) - Math.cos(d9) * Math.sin(dArray5[1] * 0.0174532925199433));
                double d12 = Math.atan2(Math.sin(d9) * Math.tan(dArray6[1] * 0.0174532925199433) + Math.cos(d9) * Math.sin(dArray6[0] * 0.0174532925199433 - d10), Math.cos(dArray6[0] * 0.0174532925199433 - d10)) * 57.2957795130823;
                double d13 = this.sl.swe_degnorm(d12 - (d7 = Math.atan2(Math.sin(d9) * Math.tan(dArray5[1] * 0.0174532925199433) + Math.cos(d9) * Math.sin(dArray5[0] * 0.0174532925199433 - d10), Math.cos(dArray5[0] * 0.0174532925199433 - d10)) * 57.2957795130823));
                if (d13 > 10.0) {
                    d13 = 360.0 - d13;
                }
                dArray[4] = 5.0 * this.log10(dArray6[2] * dArray5[2]) + mag_elem[n][1] * d11 + mag_elem[n][2] * d11 * d11 + mag_elem[n][3] * d13 + mag_elem[n][0];
            } else if (n < 15) {
                dArray[4] = 5.0 * this.log10(dArray6[2] * dArray5[2]) + mag_elem[n][1] * dArray[0] / 100.0 + mag_elem[n][2] * dArray[0] * dArray[0] / 10000.0 + mag_elem[n][3] * dArray[0] * dArray[0] * dArray[0] / 1000000.0 + mag_elem[n][0];
            } else if (n < 21 || n > 10000) {
                double d14 = Math.pow(2.718281828459, -3.33 * Math.pow(Math.tan(dArray[0] * 0.0174532925199433 / 2.0), 0.63));
                double d15 = Math.pow(2.718281828459, -1.87 * Math.pow(Math.tan(dArray[0] * 0.0174532925199433 / 2.0), 1.22));
                if (n < 21) {
                    dArray7[0] = mag_elem[n][0];
                    dArray7[1] = mag_elem[n][1];
                } else if (n == 11566) {
                    dArray7[0] = 16.9;
                    dArray7[1] = 0.15;
                } else {
                    dArray7[0] = this.swed.ast_H;
                    dArray7[1] = this.swed.ast_G;
                }
                dArray[4] = 5.0 * this.log10(dArray6[2] * dArray5[2]) + dArray7[0] - 2.5 * this.log10((1.0 - dArray7[1]) * d14 + dArray7[1] * d15);
            } else {
                dArray[4] = 0.0;
            }
        }
        if (n != 0 && n != 14) {
            if (this.sw.swe_calc(d, 0, n2 | 0x1000, dArray3, stringBuffer) == -1) {
                return -1;
            }
            if (this.sw.swe_calc(d, 0, n2, dArray6, stringBuffer) == -1) {
                return -1;
            }
            dArray[2] = Math.acos(this.sl.swi_dot_prod_unit(dArray2, dArray3)) * 57.2957795130823;
        }
        return 0;
    }

    int swe_pheno_ut(double d, int n, int n2, double[] dArray, StringBuffer stringBuffer) {
        return this.swe_pheno(d + SweDate.getDeltaT(d), n, n2, dArray, stringBuffer);
    }

    private int find_maximum(double d, double d2, double d3, double d4, DblObj dblObj, DblObj dblObj2) {
        double d5 = d2;
        double d6 = (d3 - d) / 2.0;
        double d7 = (d3 + d) / 2.0 - d5;
        double d8 = -d6 / 2.0 / d7;
        double d9 = (4.0 * d7 * d5 - d6 * d6) / 4.0 / d7;
        dblObj.val = (d8 - 1.0) * d4;
        if (dblObj2 != null) {
            dblObj2.val = d9;
        }
        return 0;
    }

    private int find_zero(double d, double d2, double d3, double d4, DblObj dblObj, DblObj dblObj2) {
        double d5 = (d3 - d) / 2.0;
        double d6 = d2;
        double d7 = (d3 + d) / 2.0 - d6;
        if (d5 * d5 - 4.0 * d7 * d6 < 0.0) {
            return -1;
        }
        double d8 = (-d5 + Math.sqrt(d5 * d5 - 4.0 * d7 * d6)) / 2.0 / d7;
        double d9 = (-d5 - Math.sqrt(d5 * d5 - 4.0 * d7 * d6)) / 2.0 / d7;
        dblObj.val = (d8 - 1.0) * d4;
        dblObj2.val = (d9 - 1.0) * d4;
        return 0;
    }

    int swe_rise_trans(double d, int n, StringBuffer stringBuffer, int n2, int n3, double[] dArray, double d2, double d3, DblObj dblObj, StringBuffer stringBuffer2) {
        int n4;
        double d4;
        double d5;
        boolean bl;
        int n5 = -1;
        double d6 = d + SweDate.getDeltaT(d);
        double[] dArray2 = new double[6];
        double[][] dArray3 = new double[20][6];
        double[] dArray4 = new double[6];
        double[] dArray5 = new double[4];
        double[] dArray6 = new double[20];
        double[] dArray7 = new double[20];
        double[] dArray8 = new double[6];
        double[] dArray9 = new double[6];
        DblObj dblObj2 = new DblObj();
        DblObj dblObj3 = new DblObj();
        double d7 = 0.0;
        int n6 = n2;
        int n7 = 14;
        double d8 = 0.08333333333333333;
        boolean bl2 = bl = stringBuffer != null && stringBuffer.length() > 0;
        if (n == 144340) {
            n = 9;
        }
        n6 &= 7;
        dblObj.val = 0.0;
        n6 |= 0x8800;
        this.sw.swe_set_topo(dArray[0], dArray[1], dArray[2]);
        if ((n3 & 0xC) != 0) {
            return this.calc_mer_trans(d, n, n2, n3, dArray, stringBuffer, dblObj, stringBuffer2);
        }
        if ((n3 & 3) == 0) {
            n3 |= 1;
        }
        if (bl && this.sw.swe_fixstar(stringBuffer, d6, n6, dArray2, stringBuffer2) == -1) {
            return -1;
        }
        int n8 = 0;
        double d9 = d - d8;
        while (n8 <= n7) {
            dArray6[n8] = d9;
            if (!bl && this.sw.swe_calc(d5 = d9 + SweDate.getDeltaT(d9), n, n6, dArray2, stringBuffer2) == -1) {
                return -1;
            }
            if (n8 == 0) {
                d7 = bl ? 0.0 : ((n3 & 0x100) != 0 ? 0.0 : (n < 21 ? SwephData.pla_diam[n] : (n > 10000 ? this.swed.ast_diam * 1000.0 : 0.0)));
            }
            d4 = Math.asin(d7 / 2.0 / 1.4959787066E11 / dArray2[2]) * 57.2957795130823;
            this.swe_azalt(d9, 1, dArray, d2, d3, dArray2, dArray3[n8]);
            double[] dArray10 = dArray3[n8];
            dArray10[1] = dArray10[1] + d4;
            if ((n3 & 0x200) != 0) {
                dArray7[n8] = dArray3[n8][1];
            } else {
                this.swe_azalt_rev(d9, 1, dArray, dArray3[n8], dArray2);
                this.swe_azalt(d9, 1, dArray, d2, d3, dArray2, dArray3[n8]);
                dArray7[n8] = dArray3[n8][2];
            }
            int n9 = 0;
            if (n8 > 1) {
                dArray9[0] = dArray3[n8 - 2][1];
                dArray9[1] = dArray3[n8 - 1][1];
                dArray9[2] = dArray3[n8][1];
                if (dArray9[1] > dArray9[0] && dArray9[1] > dArray9[2]) {
                    n9 = 1;
                }
                if (dArray9[1] < dArray9[0] && dArray9[1] < dArray9[2]) {
                    n9 = 2;
                }
            }
            if (n9 != 0) {
                double d10 = d8;
                double d11 = d9 - d10;
                this.find_maximum(dArray9[0], dArray9[1], dArray9[2], d10, dblObj2, dblObj3);
                d11 += dblObj2.val + d10;
                d10 /= 3.0;
                while (d10 > 1.0E-4) {
                    double d12 = d11 - d10;
                    for (n4 = 0; n4 < 3; ++n4) {
                        d5 = d12 + SweDate.getDeltaT(d12);
                        if (!bl && this.sw.swe_calc(d5, n, n6, dArray2, stringBuffer2) == -1) {
                            return -1;
                        }
                        this.swe_azalt(d12, 1, dArray, d2, d3, dArray2, dArray4);
                        dArray9[n4] = dArray4[1];
                        d12 += d10;
                    }
                    this.find_maximum(dArray9[0], dArray9[1], dArray9[2], d10, dblObj2, dblObj3);
                    d11 += dblObj2.val + d10;
                    d10 /= 3.0;
                }
                dArray5[++n5] = d11;
            }
            ++n8;
            d9 += d8;
        }
        block3: for (n4 = 0; n4 <= n5; ++n4) {
            for (int i = 1; i <= n7; ++i) {
                if (!(dArray5[n4] < dArray6[i])) continue;
                for (int j = n7; j >= i; --j) {
                    dArray6[j + 1] = dArray6[j];
                    dArray7[j + 1] = dArray7[j];
                }
                dArray6[i] = dArray5[n4];
                if (!bl && this.sw.swe_calc(d5 = dArray6[i] + SweDate.getDeltaT(dArray6[i]), n, n6, dArray2, stringBuffer2) == -1) {
                    return -1;
                }
                d4 = Math.asin(d7 / 2.0 / 1.4959787066E11 / dArray2[2]) * 57.2957795130823;
                this.swe_azalt(dArray6[i], 1, dArray, d2, d3, dArray2, dArray4);
                dArray4[1] = dArray4[1] + d4;
                if ((n3 & 0x200) != 0) {
                    dArray7[i] = dArray4[1];
                } else {
                    this.swe_azalt_rev(dArray6[i], 1, dArray, dArray4, dArray2);
                    this.swe_azalt(dArray6[i], 1, dArray, d2, d3, dArray2, dArray4);
                    dArray7[i] = dArray4[2];
                }
                ++n7;
                continue block3;
            }
        }
        dblObj.val = 0.0;
        for (n8 = 1; n8 <= n7; ++n8) {
            if (dArray7[n8 - 1] * dArray7[n8] >= 0.0 || dArray7[n8 - 1] < dArray7[n8] && (n3 & 1) == 0 || dArray7[n8 - 1] > dArray7[n8] && (n3 & 2) == 0) continue;
            dArray9[0] = dArray7[n8 - 1];
            dArray9[1] = dArray7[n8];
            dArray8[0] = dArray6[n8 - 1];
            dArray8[1] = dArray6[n8];
            for (n4 = 0; n4 < 20; ++n4) {
                double d13;
                d9 = (dArray8[0] + dArray8[1]) / 2.0;
                if (!bl && this.sw.swe_calc(d5 = d9 + SweDate.getDeltaT(d9), n, n6, dArray2, stringBuffer2) == -1) {
                    return -1;
                }
                d4 = Math.asin(d7 / 2.0 / 1.4959787066E11 / dArray2[2]) * 57.2957795130823;
                this.swe_azalt(d9, 1, dArray, d2, d3, dArray2, dArray4);
                dArray4[1] = dArray4[1] + d4;
                if ((n3 & 0x200) != 0) {
                    d13 = dArray4[1];
                } else {
                    this.swe_azalt_rev(d9, 1, dArray, dArray4, dArray2);
                    this.swe_azalt(d9, 1, dArray, d2, d3, dArray2, dArray4);
                    d13 = dArray4[2];
                }
                if (d13 * dArray9[0] <= 0.0) {
                    dArray9[1] = d13;
                    dArray8[1] = d9;
                    continue;
                }
                dArray9[0] = d13;
                dArray8[0] = d9;
            }
            if (!(d9 > d)) continue;
            dblObj.val = d9;
            return 0;
        }
        if (stringBuffer2 != null) {
            stringBuffer2.append("rise or set not found for planet ").append(n);
        }
        return -2;
    }

    private int calc_mer_trans(double d, int n, int n2, int n3, double[] dArray, StringBuffer stringBuffer, DblObj dblObj, StringBuffer stringBuffer2) {
        double d2 = d + SweDate.getDeltaT(d);
        double[] dArray2 = new double[6];
        double[] dArray3 = new double[6];
        int n4 = n2;
        boolean bl = stringBuffer != null && stringBuffer.length() > 0;
        n4 &= 7;
        dblObj.val = 0.0;
        n4 |= 0x8800;
        double d3 = this.sl.swe_sidtime(d) + dArray[0] / 15.0;
        if (d3 >= 24.0) {
            d3 -= 24.0;
        }
        if (d3 < 0.0) {
            d3 += 24.0;
        }
        d3 *= 15.0;
        if (bl ? this.sw.swe_fixstar(stringBuffer, d2, n4, dArray2, stringBuffer2) == -1 : this.sw.swe_calc(d2, n, n4, dArray2, stringBuffer2) == -1) {
            return -1;
        }
        dArray3[0] = dArray2[0];
        dArray3[1] = dArray2[1];
        double d4 = d;
        double d5 = d3;
        if ((n3 & 8) != 0) {
            d5 = this.sl.swe_degnorm(d5 + 180.0);
        }
        for (int i = 0; i < 4; ++i) {
            double d6;
            double d7;
            double d8 = this.sl.swe_degnorm(dArray3[0] - d5);
            if (i > 0 && d8 > 180.0) {
                d8 -= 360.0;
            }
            if ((d7 = this.sl.swe_sidtime(d4 += d8 / 361.0) + dArray[0] / 15.0) >= 24.0) {
                d7 -= 24.0;
            }
            if (d7 < 0.0) {
                d7 += 24.0;
            }
            d5 = d7 *= 15.0;
            if ((n3 & 8) != 0) {
                d5 = this.sl.swe_degnorm(d5 + 180.0);
            }
            if (bl || this.sw.swe_calc(d6 = d4 + SweDate.getDeltaT(d4), n, n4, dArray3, stringBuffer2) != -1) continue;
            return -1;
        }
        dblObj.val = d4;
        return 0;
    }

    int swe_nod_aps(double d, int n, int n2, int n3, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, StringBuffer stringBuffer) {
        int n4;
        double d2;
        double[] dArray5;
        double d3;
        double d4;
        int n5;
        double d5 = (d - 2451545.0) / 36525.0;
        double[] dArray6 = new double[6];
        double[] dArray7 = new double[24];
        double[] dArray8 = new double[6];
        double[] dArray9 = new double[6];
        int n6 = 0;
        double[][] dArray10 = new double[3][6];
        double[] dArray11 = new double[6];
        double[] dArray12 = new double[6];
        double[][] dArray13 = new double[3][6];
        double[][] dArray14 = new double[3][6];
        double[][] dArray15 = new double[3][6];
        double[][] dArray16 = new double[3][6];
        double[] dArray17 = new double[6];
        double[] dArray18 = new double[6];
        PlanData planData = this.swed.pldat[0];
        PlanData planData2 = this.swed.pldat[10];
        PlanData planData3 = new PlanData();
        double[] dArray19 = planData2.x;
        double[] dArray20 = planData.x;
        boolean bl = false;
        boolean bl2 = (n2 & 0x410) == 0;
        boolean bl3 = (n2 & 0x10) == 0 && (n2 & 0x200) == 0;
        boolean bl4 = (n3 & 0x100) != 0;
        boolean bl5 = false;
        if (n == 144340) {
            n = 9;
        }
        double[] dArray21 = dArray7;
        double[] dArray22 = dArray7;
        double[] dArray23 = dArray7;
        double[] dArray24 = dArray7;
        this.sw.swi_force_app_pos_etc();
        n3 %= 256;
        int n7 = n;
        if (n == 0) {
            n7 = 14;
        }
        if (n == 1) {
            bl3 = false;
            if ((n2 & 8) == 0) {
                bl2 = false;
            }
        }
        int n8 = n2 & 0x47 | 0x100 | 0x10;
        if (n7 != 1) {
            n8 |= 8;
        }
        if (n == 10 || n == 11 || n == 12 || n == 13 || n < 0 || n >= 23 && n <= 10000) {
            int n9;
            if (stringBuffer != null) {
                stringBuffer.setLength(0);
                stringBuffer.append("nodes/apsides for planet " + n + " are not implemented");
            }
            if (dArray != null) {
                for (n9 = 0; n9 <= 5; ++n9) {
                    dArray[n9] = 0.0;
                }
            }
            if (dArray2 != null) {
                for (n9 = 0; n9 <= 5; ++n9) {
                    dArray2[n9] = 0.0;
                }
            }
            if (dArray4 != null) {
                for (n9 = 0; n9 <= 5; ++n9) {
                    dArray4[n9] = 0.0;
                }
            }
            if (dArray3 != null) {
                for (n9 = 0; n9 <= 5; ++n9) {
                    dArray3[n9] = 0.0;
                }
            }
            return -1;
        }
        for (n5 = 0; n5 < 24; ++n5) {
            dArray7[n5] = 0.0;
        }
        if ((n3 == 0 || (n3 & 1) != 0) && (n >= 0 && n <= 8 || n == 14)) {
            double d6;
            double d7;
            double d8;
            double d9;
            if (n == 1) {
                DblObj dblObj = new DblObj();
                dblObj.val = dArray21[0];
                DblObj dblObj2 = new DblObj();
                dblObj2.val = dArray21[3];
                DblObj dblObj3 = new DblObj();
                dblObj3.val = dArray23[12];
                DblObj dblObj4 = new DblObj();
                dblObj4.val = dArray23[15];
                this.sm.swi_mean_lunar_elements(d, dblObj, dblObj2, dblObj3, dblObj4);
                dArray21[0] = dblObj.val;
                dArray21[3] = dblObj2.val;
                dArray23[12] = dblObj3.val;
                dArray23[15] = dblObj4.val;
                d9 = 5.1453964;
                d8 = 0.0;
                d4 = 0.054900489;
                d7 = 0.0;
                d3 = 0.002569555290487047;
                d6 = 0.0;
            } else {
                int n10 = ipl_to_elem[n];
                double[] dArray25 = el_incl[n10];
                d9 = dArray25[0] + dArray25[1] * d5 + dArray25[2] * d5 * d5 + dArray25[3] * d5 * d5 * d5;
                d8 = dArray25[1] / 36525.0;
                dArray25 = el_sema[n10];
                d3 = dArray25[0] + dArray25[1] * d5 + dArray25[2] * d5 * d5 + dArray25[3] * d5 * d5 * d5;
                d6 = dArray25[1] / 36525.0;
                dArray25 = el_ecce[n10];
                d4 = dArray25[0] + dArray25[1] * d5 + dArray25[2] * d5 * d5 + dArray25[3] * d5 * d5 * d5;
                d7 = dArray25[1] / 36525.0;
                dArray25 = el_node[n10];
                dArray21[0] = dArray25[0] + dArray25[1] * d5 + dArray25[2] * d5 * d5 + dArray25[3] * d5 * d5 * d5;
                dArray21[3] = dArray25[1] / 36525.0;
                dArray25 = el_peri[n10];
                dArray23[12] = dArray25[0] + dArray25[1] * d5 + dArray25[2] * d5 * d5 + dArray25[3] * d5 * d5 * d5;
                dArray23[15] = dArray25[1] / 36525.0;
            }
            dArray22[6] = this.sl.swe_degnorm(dArray21[0] + 180.0);
            dArray22[9] = dArray21[3];
            double d10 = dArray23[12] = this.sl.swe_degnorm(dArray23[12] - dArray21[0]);
            double d11 = dArray23[15] = this.sl.swe_degnorm(dArray23[12] + dArray23[15] - dArray21[3]);
            this.sl.swe_cotrans(dArray23, 12, dArray23, 12, -d9);
            this.sl.swe_cotrans(dArray23, 15, dArray23, 15, -d9 - d8);
            dArray23[12] = this.sl.swe_degnorm(dArray23[12] + dArray21[0]);
            dArray23[15] = this.sl.swe_degnorm(dArray23[15] + dArray21[0] + dArray21[3]);
            dArray23[15] = this.sl.swe_degnorm(dArray23[15] - dArray23[12]);
            dArray23[14] = d3 * (1.0 - d4);
            dArray23[17] = (d3 + d6) * (1.0 - d4 - d7) - dArray23[14];
            dArray24[18] = this.sl.swe_degnorm(dArray23[12] + 180.0);
            dArray24[19] = -dArray23[13];
            dArray24[21] = dArray23[15];
            dArray24[22] = -dArray23[16];
            if (bl4) {
                dArray24[20] = d3 * d4 * 2.0;
                dArray24[23] = (d3 + d6) * (d4 + d7) * 2.0 - dArray24[20];
            } else {
                dArray24[20] = d3 * (1.0 + d4);
                dArray24[23] = (d3 + d6) * (1.0 + d4 + d7) - dArray24[20];
            }
            double d12 = Math.atan(Math.tan(-d10 * 0.0174532925199433 / 2.0) * Math.sqrt((1.0 - d4) / (1.0 + d4))) * 2.0;
            double d13 = Math.atan(Math.tan(-d11 * 0.0174532925199433 / 2.0) * Math.sqrt((1.0 - d4 - d7) / (1.0 + d4 + d7))) * 2.0;
            dArray21[2] = d3 * (Math.cos(d12) - d4) / Math.cos(d10 * 0.0174532925199433);
            dArray21[5] = (d3 + d6) * (Math.cos(d13) - d4 - d7) / Math.cos(d11 * 0.0174532925199433);
            dArray21[5] = dArray21[5] - dArray21[2];
            d12 = Math.atan(Math.tan((180.0 - d10) * 0.0174532925199433 / 2.0) * Math.sqrt((1.0 - d4) / (1.0 + d4))) * 2.0;
            d13 = Math.atan(Math.tan((180.0 - d11) * 0.0174532925199433 / 2.0) * Math.sqrt((1.0 - d4 - d7) / (1.0 + d4 + d7))) * 2.0;
            dArray22[8] = d3 * (Math.cos(d12) - d4) / Math.cos((180.0 - d10) * 0.0174532925199433);
            dArray22[11] = (d3 + d6) * (Math.cos(d13) - d4 - d7) / Math.cos((180.0 - d11) * 0.0174532925199433);
            dArray22[11] = dArray22[11] - dArray22[8];
            n5 = 0;
            dArray5 = dArray7;
            n6 = 0;
            while (n5 < 4) {
                int n11 = 0 + n6;
                dArray5[n11] = dArray5[n11] * 0.0174532925199433;
                int n12 = 1 + n6;
                dArray5[n12] = dArray5[n12] * 0.0174532925199433;
                int n13 = 3 + n6;
                dArray5[n13] = dArray5[n13] * 0.0174532925199433;
                int n14 = 4 + n6;
                dArray5[n14] = dArray5[n14] * 0.0174532925199433;
                this.sl.swi_polcart_sp(dArray5, n6, dArray5, n6);
                ++n5;
                n6 += 6;
            }
        } else {
            int n15;
            int n16;
            double d14;
            double d15;
            if (this.sw.swe_calc(d, n7, n8, dArray6, stringBuffer) == -1) {
                return -1;
            }
            int n17 = n2 & 7 | 0x20 | 0x800 | 0x1000 | 0x10 | 0x40 | 0x100;
            bl5 = false;
            if (n7 != 1) {
                if ((n3 & 4) != 0 && dArray6[2] > 6.0) {
                    n17 |= 0x4000;
                    bl5 = true;
                } else {
                    n17 |= 8;
                }
            }
            if (n7 == 1) {
                d2 = 1.0E-4;
                d15 = 1.0E-15;
                d14 = 8.997011693402468E-10;
            } else {
                double d16 = n7 >= 2 && n7 <= 9 || n7 == 14 ? 1.0 / plmass[ipl_to_elem[n]] : 0.0;
                d2 = 0.001 * dArray6[2];
                d15 = 1.0E-15 * d2 / 1.0E-4;
                d14 = 1.32712440017987E20 * (1.0 + d16) / 1.4959787066E11 / 1.4959787066E11 / 1.4959787066E11 * 86400.0 * 86400.0;
            }
            if ((n2 & 0x100) != 0) {
                n16 = 0;
                n15 = 2;
            } else {
                n15 = 0;
                n16 = 0;
                d2 = 0.0;
            }
            n5 = n16;
            d5 = d - d2;
            while (n5 <= n15) {
                if (n16 == n15) {
                    d5 = d;
                }
                if (this.sw.swe_calc(d5, n7, n17, dArray10[n5], stringBuffer) == -1) {
                    return -1;
                }
                if (n7 == 14) {
                    if (this.sw.swe_calc(d5, 1, n17 & 0xFFFFBFF7, dArray12, stringBuffer) == -1) {
                        return -1;
                    }
                    for (n4 = 0; n4 <= 2; ++n4) {
                        double[] dArray26 = dArray10[n5];
                        int n18 = n4;
                        dArray26[n18] = dArray26[n18] + dArray12[n4] / 82.30055985272827;
                    }
                }
                this.sw.swi_plan_for_osc_elem(n8, d5, dArray10[n5]);
                ++n5;
                d5 += d2;
            }
            for (n5 = n16; n5 <= n15; ++n5) {
                if (Math.abs(dArray10[n5][5]) < d15) {
                    dArray10[n5][5] = d15;
                }
                double d17 = dArray10[n5][2] / dArray10[n5][5];
                double d18 = dArray10[n5][5] / Math.abs(dArray10[n5][5]);
                for (n4 = 0; n4 <= 2; ++n4) {
                    dArray13[n5][n4] = (dArray10[n5][n4] - d17 * dArray10[n5][n4 + 3]) * d18;
                    dArray14[n5][n4] = -dArray13[n5][n4];
                }
            }
            for (n5 = n16; n5 <= n15; ++n5) {
                double d19 = Math.sqrt(dArray13[n5][0] * dArray13[n5][0] + dArray13[n5][1] * dArray13[n5][1]);
                double d20 = dArray13[n5][0] / d19;
                double d21 = dArray13[n5][1] / d19;
                this.sl.swi_cross_prod(dArray10[n5], 0, dArray10[n5], 3, dArray11, 0);
                d19 = dArray11[0] * dArray11[0] + dArray11[1] * dArray11[1];
                double d22 = d19 + dArray11[2] * dArray11[2];
                double d23 = Math.sqrt(d22);
                d19 = Math.sqrt(d19);
                double d24 = d19 / d23;
                double d25 = Math.sqrt(1.0 - d24 * d24);
                double d26 = dArray10[n5][0] * d20 + dArray10[n5][1] * d21;
                double d27 = dArray10[n5][2] / d24;
                double d28 = Math.atan2(d27, d26);
                d23 = Math.sqrt(this.sl.square_sum(dArray10[n5]));
                double d29 = this.sl.square_sum(dArray10[n5], 3);
                d3 = 1.0 / (2.0 / d23 - d29 / d14);
                double d30 = d22 / d14;
                d4 = Math.sqrt(1.0 - d30 / d3);
                double d31 = 1.0 / d4 * (1.0 - d23 / d3);
                double d32 = 1.0 / d4 / Math.sqrt(d3 * d14) * this.sw.dot_prod(dArray10[n5], dArray10[n5], 3);
                double d33 = 2.0 * Math.atan(Math.sqrt((1.0 + d4) / (1.0 - d4)) * d32 / (1.0 + d31));
                dArray15[n5][0] = this.sl.swi_mod2PI(d28 - d33);
                dArray15[n5][1] = 0.0;
                dArray15[n5][2] = d3 * (1.0 - d4);
                this.sl.swi_polcart(dArray15[n5], dArray15[n5]);
                this.sl.swi_coortrf2(dArray15[n5], dArray15[n5], -d24, d25);
                this.sl.swi_cartpol(dArray15[n5], dArray15[n5]);
                double[] dArray27 = dArray15[n5];
                dArray27[0] = dArray27[0] + Math.atan2(d21, d20);
                dArray16[n5][0] = this.sl.swi_mod2PI(dArray15[n5][0] + Math.PI);
                dArray16[n5][1] = -dArray15[n5][1];
                dArray16[n5][2] = bl4 ? d3 * d4 * 2.0 : d3 * (1.0 + d4);
                this.sl.swi_polcart(dArray15[n5], dArray15[n5]);
                this.sl.swi_polcart(dArray16[n5], dArray16[n5]);
                d33 = this.sl.swi_mod2PI(d33 - d28);
                double d34 = this.sl.swi_mod2PI(d33 + Math.PI);
                d31 = Math.cos(2.0 * Math.atan(Math.tan(d33 / 2.0) / Math.sqrt((1.0 + d4) / (1.0 - d4))));
                double d35 = Math.cos(2.0 * Math.atan(Math.tan(d34 / 2.0) / Math.sqrt((1.0 + d4) / (1.0 - d4))));
                double d36 = d3 * (1.0 - d4 * d31);
                double d37 = d3 * (1.0 - d4 * d35);
                double d38 = Math.sqrt(this.sl.square_sum(dArray13[n5]));
                double d39 = Math.sqrt(this.sl.square_sum(dArray14[n5]));
                n4 = 0;
                while (n4 <= 2) {
                    double[] dArray28 = dArray13[n5];
                    int n19 = n4;
                    dArray28[n19] = dArray28[n19] * (d36 / d38);
                    double[] dArray29 = dArray14[n5];
                    int n20 = n4++;
                    dArray29[n20] = dArray29[n20] * (d37 / d39);
                }
            }
            for (n5 = 0; n5 <= 2; ++n5) {
                if ((n2 & 0x100) != 0) {
                    dArray23[n5 + 12] = dArray15[1][n5];
                    dArray23[n5 + 3 + 12] = (dArray15[2][n5] - dArray15[0][n5]) / d2 / 2.0;
                    dArray24[n5 + 18] = dArray16[1][n5];
                    dArray24[n5 + 3 + 18] = (dArray16[2][n5] - dArray16[0][n5]) / d2 / 2.0;
                    dArray21[n5] = dArray13[1][n5];
                    dArray21[n5 + 3] = (dArray13[2][n5] - dArray13[0][n5]) / d2 / 2.0;
                    dArray22[n5 + 6] = dArray14[1][n5];
                    dArray22[n5 + 3 + 6] = (dArray14[2][n5] - dArray14[0][n5]) / d2 / 2.0;
                    continue;
                }
                dArray23[n5 + 12] = dArray15[0][n5];
                dArray23[n5 + 3 + 12] = 0.0;
                dArray24[n5 + 18] = dArray16[0][n5];
                dArray24[n5 + 3 + 18] = 0.0;
                dArray21[n5] = dArray13[0][n5];
                dArray21[n5 + 3] = 0.0;
                dArray22[n5 + 6] = dArray14[0][n5];
                dArray22[n5 + 3 + 6] = 0.0;
            }
            bl = true;
        }
        if (n7 == 1 && (n2 & 0x4008) != 0) {
            this.sw.swi_force_app_pos_etc();
            if (this.sw.swe_calc(d, 0, n8, dArray6, stringBuffer) == -1) {
                return -1;
            }
        } else if (this.sw.swe_calc(d, n7, n8 | n2 & 0x8000, dArray6, stringBuffer) == -1) {
            return -1;
        }
        if ((n2 & 0x8000) != 0) {
            if (this.sw.swi_get_observer(d, n2, false, dArray8, stringBuffer) != 0) {
                return -1;
            }
        } else {
            for (n5 = 0; n5 <= 5; ++n5) {
                dArray8[n5] = 0.0;
            }
        }
        if ((n2 & 0x4008) != 0) {
            if ((n2 & 8) != 0 && (n2 & 4) == 0) {
                for (n5 = 0; n5 <= 5; ++n5) {
                    dArray8[n5] = dArray19[n5];
                }
            }
        } else if (n == 0 && (n2 & 4) == 0) {
            for (n5 = 0; n5 <= 5; ++n5) {
                dArray8[n5] = dArray19[n5];
            }
        } else {
            for (n5 = 0; n5 <= 5; ++n5) {
                int n21 = n5;
                dArray8[n21] = dArray8[n21] + dArray20[n5];
            }
        }
        Epsilon epsilon = (n2 & 0x20) != 0 ? this.swed.oec2000 : this.swed.oec;
        int n22 = 0;
        dArray5 = dArray7;
        n6 = 0;
        while (n22 < 4) {
            if (n7 == 14 && n22 <= 1) {
                for (n5 = 0; n5 <= 5; ++n5) {
                    dArray5[n5 + n6] = 0.0;
                }
            } else {
                if (bl && (n2 & 0x40) == 0) {
                    this.sl.swi_coortrf2(dArray5, n6, dArray5, n6, -this.swed.nut.snut, this.swed.nut.cnut);
                    if ((n2 & 0x100) != 0) {
                        this.sl.swi_coortrf2(dArray5, 3 + n6, dArray5, 3 + n6, -this.swed.nut.snut, this.swed.nut.cnut);
                    }
                }
                this.sl.swi_coortrf2(dArray5, n6, dArray5, n6, -epsilon.seps, epsilon.ceps);
                this.sl.swi_coortrf2(dArray5, 3 + n6, dArray5, 3 + n6, -epsilon.seps, epsilon.ceps);
                if (bl && (n2 & 0x40) == 0) {
                    this.sw.swi_nutate(dArray5, n6, n2, true);
                }
                this.sl.swi_precess(dArray5, n6, d, 1);
                if ((n2 & 0x100) != 0) {
                    this.sw.swi_precess_speed(dArray5, n6, d, 1);
                }
                if (n7 == 1) {
                    for (n5 = 0; n5 <= 5; ++n5) {
                        int n23 = n5 + n6;
                        dArray5[n23] = dArray5[n23] + dArray20[n5];
                    }
                } else if ((n2 & 4) == 0 && !bl5) {
                    for (n4 = 0; n4 <= 5; ++n4) {
                        int n24 = n4 + n6;
                        dArray5[n24] = dArray5[n24] + dArray19[n4];
                    }
                }
                for (n4 = 0; n4 <= 5; ++n4) {
                    int n25 = n4 + n6;
                    dArray5[n25] = dArray5[n25] - dArray8[n4];
                }
                if (n == 0 && (n2 & 0x4008) == 0) {
                    for (n4 = 0; n4 <= 5; ++n4) {
                        dArray5[n4 + n6] = -dArray5[n4 + n6];
                    }
                }
                d2 = Math.sqrt(this.sl.square_sum(dArray5, n6)) * 1.4959787066E11 / 2.99792458E8 / 86400.0;
                if (bl3) {
                    this.sw.swi_deflect_light(dArray5, n6, d2, n2);
                }
                if (bl2) {
                    this.sw.swi_aberr_light(dArray5, n6, dArray8, n2);
                    if ((n2 & 0x100) != 0) {
                        if (this.sw.swe_calc(d - d2, n7, n8 | n2 & 0x8000, dArray18, stringBuffer) == -1) {
                            return -1;
                        }
                        if ((n2 & 0x8000) != 0) {
                            for (n5 = 0; n5 <= 5; ++n5) {
                                dArray17[n5] = this.swed.topd.xobs[n5];
                            }
                        } else {
                            for (n5 = 0; n5 <= 5; ++n5) {
                                dArray17[n5] = 0.0;
                            }
                        }
                        if ((n2 & 0x4008) != 0) {
                            if ((n2 & 8) != 0 && (n2 & 4) == 0) {
                                for (n5 = 0; n5 <= 5; ++n5) {
                                    dArray17[n5] = dArray19[n5];
                                }
                            }
                        } else if (n == 0 && (n2 & 4) == 0) {
                            for (n5 = 0; n5 <= 5; ++n5) {
                                dArray17[n5] = dArray19[n5];
                            }
                        } else {
                            for (n5 = 0; n5 <= 5; ++n5) {
                                int n26 = n5;
                                dArray17[n26] = dArray17[n26] + dArray20[n5];
                            }
                        }
                        for (n5 = 3; n5 <= 5; ++n5) {
                            int n27 = n5 + n6;
                            dArray5[n27] = dArray5[n27] + (dArray8[n5] - dArray17[n5]);
                        }
                        if (this.sw.swe_calc(d, 0, n8 | n2 & 0x8000, dArray18, stringBuffer) == -1) {
                            return -1;
                        }
                    }
                }
                for (n4 = 0; n4 <= 5; ++n4) {
                    dArray9[n4] = dArray5[n4 + n6];
                }
                if ((n2 & 0x20) == 0) {
                    this.sl.swi_precess(dArray5, n6, d, -1);
                    if ((n2 & 0x100) != 0) {
                        this.sw.swi_precess_speed(dArray5, n6, d, -1);
                    }
                }
                if ((n2 & 0x40) == 0) {
                    this.sw.swi_nutate(dArray5, n6, n2, false);
                }
                for (n4 = 0; n4 <= 5; ++n4) {
                    planData3.xreturn[18 + n4] = dArray5[n4 + n6];
                }
                this.sl.swi_coortrf2(dArray5, n6, dArray5, n6, epsilon.seps, epsilon.ceps);
                if ((n2 & 0x100) != 0) {
                    this.sl.swi_coortrf2(dArray5, 3 + n6, dArray5, 3 + n6, epsilon.seps, epsilon.ceps);
                }
                if ((n2 & 0x40) == 0) {
                    this.sl.swi_coortrf2(dArray5, n6, dArray5, n6, this.swed.nut.snut, this.swed.nut.cnut);
                    if ((n2 & 0x100) != 0) {
                        this.sl.swi_coortrf2(dArray5, 3 + n6, dArray5, 3 + n6, this.swed.nut.snut, this.swed.nut.cnut);
                    }
                }
                for (n4 = 0; n4 <= 5; ++n4) {
                    planData3.xreturn[6 + n4] = dArray5[n4 + n6];
                }
                if ((n2 & 0x10000) != 0) {
                    if ((this.swed.sidd.sid_mode & 0x100) != 0) {
                        if (this.sw.swi_trop_ra2sid_lon(dArray9, planData3.xreturn, 6, planData3.xreturn, 18, n2, stringBuffer) != 0) {
                            return -1;
                        }
                    } else if ((this.swed.sidd.sid_mode & 0x200) != 0) {
                        if (this.sw.swi_trop_ra2sid_lon_sosy(dArray9, planData3.xreturn, 6, planData3.xreturn, 18, n2, stringBuffer) != 0) {
                            return -1;
                        }
                    } else {
                        this.sl.swi_cartpol_sp(planData3.xreturn, 6, planData3.xreturn, 0);
                        planData3.xreturn[0] = planData3.xreturn[0] - this.sw.swe_get_ayanamsa(d) * 0.0174532925199433;
                        this.sl.swi_polcart_sp(planData3.xreturn, 0, planData3.xreturn, 6);
                    }
                }
                if ((n2 & 0x1000) != 0 && (n2 & 0x800) != 0) {
                    for (n4 = 0; n4 <= 5; ++n4) {
                        dArray5[n4 + n6] = planData3.xreturn[18 + n4];
                    }
                } else if ((n2 & 0x1000) != 0) {
                    for (n4 = 0; n4 <= 5; ++n4) {
                        dArray5[n4 + n6] = planData3.xreturn[6 + n4];
                    }
                } else {
                    this.sl.swi_cartpol_sp(planData3.xreturn, 18, planData3.xreturn, 12);
                    this.sl.swi_cartpol_sp(planData3.xreturn, 6, planData3.xreturn, 0);
                    for (n4 = 0; n4 < 2; ++n4) {
                        int n28 = n4;
                        planData3.xreturn[n28] = planData3.xreturn[n28] * 57.2957795130823;
                        int n29 = n4 + 3;
                        planData3.xreturn[n29] = planData3.xreturn[n29] * 57.2957795130823;
                        int n30 = n4 + 12;
                        planData3.xreturn[n30] = planData3.xreturn[n30] * 57.2957795130823;
                        int n31 = n4 + 15;
                        planData3.xreturn[n31] = planData3.xreturn[n31] * 57.2957795130823;
                    }
                    if ((n2 & 0x800) != 0) {
                        for (n4 = 0; n4 <= 5; ++n4) {
                            dArray5[n4 + n6] = planData3.xreturn[12 + n4];
                        }
                    } else {
                        for (n4 = 0; n4 <= 5; ++n4) {
                            dArray5[n4 + n6] = planData3.xreturn[n4];
                        }
                    }
                }
            }
            ++n22;
            n6 += 6;
        }
        for (n5 = 0; n5 <= 5; ++n5) {
            if (n5 > 2 && (n2 & 0x100) == 0) {
                dArray24[n5 + 18] = 0.0;
                dArray23[n5 + 12] = 0.0;
                dArray22[n5 + 6] = 0.0;
                dArray21[n5] = 0.0;
            }
            if (dArray != null) {
                dArray[n5] = dArray21[n5];
            }
            if (dArray2 != null) {
                dArray2[n5] = dArray22[n5 + 6];
            }
            if (dArray3 != null) {
                dArray3[n5] = dArray23[n5 + 12];
            }
            if (dArray4 == null) continue;
            dArray4[n5] = dArray24[n5 + 18];
        }
        return 0;
    }

    int swe_nod_aps_ut(double d, int n, int n2, int n3, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, StringBuffer stringBuffer) {
        return this.swe_nod_aps(d + SweDate.getDeltaT(d), n, n2, n3, dArray, dArray2, dArray3, dArray4, stringBuffer);
    }

    int swe_gauquelin_sector(double d, int n, StringBuffer stringBuffer, int n2, int n3, double[] dArray, double d2, double d3, DblObj dblObj, StringBuffer stringBuffer2) {
        DblObj dblObj2 = new DblObj();
        boolean bl = true;
        boolean bl2 = true;
        double[] dArray2 = new double[3];
        double[] dArray3 = new double[6];
        double[] dArray4 = new double[2];
        int n4 = n2 & 7;
        boolean bl3 = stringBuffer != null && stringBuffer.length() > 0;
        int n5 = 256;
        boolean bl4 = false;
        if (n == 144340) {
            n = 9;
        }
        if ((n3 & 2) == 0) {
            double d4 = d + SweDate.getDeltaT(d);
            double d5 = this.sl.swi_epsiln(d4) * 57.2957795130823;
            this.sl.swi_nutation(d4, dArray4);
            dArray4[0] = dArray4[0] * 57.2957795130823;
            dArray4[1] = dArray4[1] * 57.2957795130823;
            double d6 = this.sl.swe_degnorm(this.sl.swe_sidtime0(d, d5 + dArray4[1], dArray4[0]) * 15.0 + dArray[0]);
            if (bl3 ? this.sw.swe_fixstar(stringBuffer, d4, n2, dArray3, stringBuffer2) == -1 : this.sw.swe_calc(d4, n, n2, dArray3, stringBuffer2) == -1) {
                return -1;
            }
            if ((n3 & 1) != 0) {
                dArray3[1] = 0.0;
            }
            dblObj.val = this.sw.swe_house_pos(d6, dArray[1], d5 + dArray4[1], 71, dArray3, null);
            return 0;
        }
        if (n3 == 2) {
            n5 |= 0x200;
        }
        dblObj2.val = dArray2[0];
        int n6 = this.swe_rise_trans(d, n, stringBuffer, n4, 1 | n5, dArray, d2, d3, dblObj2, stringBuffer2);
        dArray2[0] = dblObj2.val;
        if (n6 == -1) {
            return -1;
        }
        if (n6 == -2) {
            bl = false;
        }
        dblObj2.val = dArray2[1];
        n6 = this.swe_rise_trans(d, n, stringBuffer, n4, 2 | n5, dArray, d2, d3, dblObj2, stringBuffer2);
        dArray2[1] = dblObj2.val;
        if (n6 == -1) {
            return -1;
        }
        if (n6 == -2) {
            bl2 = false;
        }
        if (dArray2[0] < dArray2[1] && bl) {
            bl4 = false;
            double d7 = d - 1.2;
            if (bl2) {
                d7 = dArray2[1] - 1.2;
            }
            bl2 = true;
            dblObj2.val = dArray2[1];
            n6 = this.swe_rise_trans(d7, n, stringBuffer, n4, 2 | n5, dArray, d2, d3, dblObj2, stringBuffer2);
            dArray2[1] = dblObj2.val;
            if (n6 == -1) {
                return -1;
            }
            if (n6 == -2) {
                bl2 = false;
            }
        } else if (dArray2[0] >= dArray2[1] && bl2) {
            bl4 = true;
            double d8 = d - 1.2;
            if (bl) {
                d8 = dArray2[0] - 1.2;
            }
            bl = true;
            dblObj2.val = dArray2[0];
            n6 = this.swe_rise_trans(d8, n, stringBuffer, n4, 1 | n5, dArray, d2, d3, dblObj2, stringBuffer2);
            dArray2[0] = dblObj2.val;
            if (n6 == -1) {
                return -1;
            }
            if (n6 == -2) {
                bl = false;
            }
        }
        if (bl && bl2) {
            dblObj.val = bl4 ? (d - dArray2[0]) / (dArray2[1] - dArray2[0]) * 18.0 + 1.0 : (d - dArray2[1]) / (dArray2[0] - dArray2[1]) * 18.0 + 19.0;
            return 0;
        }
        dblObj.val = 0.0;
        if (stringBuffer2 != null) {
            stringBuffer2.append("rise or set not found for planet ").append(n);
        }
        return -1;
    }
}

