/*
 * Decompiled with CFR 0.152.
 */
package swisseph;

import java.util.StringTokenizer;
import swisseph.DblObj;
import swisseph.IntObj;
import swisseph.SweDate;
import swisseph.Swenut2000a;
import swisseph.SwissData;

public class SwissLib {
    static final boolean PREC_WILLIAMS_1994 = true;
    static final boolean PREC_SIMON_1994 = false;
    static final boolean PREC_LASKAR_1986 = false;
    static final boolean PREC_BRETAGNON_2003 = false;
    static final boolean PREC_IAU_1976 = false;
    static final boolean PREC_IAU_2003 = true;
    static final boolean NUT_IAU_1980 = false;
    static final boolean NUT_IAU_2000A = false;
    static final boolean NUT_IAU_2000B = true;
    static final double PREC_IAU_1976_CTIES = 2.0;
    static final double PREC_IAU_2003_CTIES = 75.0;
    SwissData swed;
    static final double[] pAcof = new double[]{-8.66E-10, -4.759E-8, 2.424E-7, 1.3095E-5, 1.7451E-4, -0.0018055, -0.235316, 0.076, 110.5407, 50287.7};
    static final double[] nodecof = new double[]{6.6402E-16, -2.69151E-15, -1.547021E-12, 7.521313E-12, 1.9E-10, -3.54E-9, -1.8103E-7, 1.26E-7, 7.436169E-5, -0.04207794833, 3.052115282424};
    static final double[] inclcof = new double[]{1.2147E-16, 7.3759E-17, -8.26287E-14, 2.50341E-13, 2.4650839E-11, -5.4000441E-11, 1.32115526E-9, -6.012E-7, -1.62442E-5, 0.00227850649, 0.0};
    static final double PREC_IAU_CTIES = 2.0;

    public SwissLib() {
        this(null);
    }

    public SwissLib(SwissData swissData) {
        this.swed = swissData;
        if (this.swed == null) {
            this.swed = new SwissData();
        }
    }

    public double square_sum(double[] dArray) {
        return dArray[0] * dArray[0] + dArray[1] * dArray[1] + dArray[2] * dArray[2];
    }

    public double square_sum(double[] dArray, int n) {
        return dArray[n] * dArray[n] + dArray[1 + n] * dArray[1 + n] + dArray[2 + n] * dArray[2 + n];
    }

    public double swe_degnorm(double d) {
        if (Double.doubleToLongBits(d) == -4531507609219491683L) {
            d = Double.longBitsToDouble(-4531507609219491682L);
        } else if (Double.doubleToLongBits(d) == -4531404703936197856L) {
            d = Double.longBitsToDouble(-4531404703936197855L);
        } else if (Double.doubleToLongBits(d) == -4532053966826609004L) {
            d = Double.longBitsToDouble(-4532053966826609003L);
        } else if (Double.doubleToLongBits(d) == 4656693294511473960L) {
            d = Double.longBitsToDouble(4656693294511473959L);
        }
        double d2 = d % 360.0;
        if (Math.abs(d2) < 1.0E-13) {
            d2 = 0.0;
        }
        if (d2 < 0.0) {
            d2 += 360.0;
        }
        return d2;
    }

    public double swe_radnorm(double d) {
        double d2 = d % (Math.PI * 2);
        if (Math.abs(d2) < 1.0E-13) {
            d2 = 0.0;
        }
        if (d2 < 0.0) {
            d2 += Math.PI * 2;
        }
        return d2;
    }

    public double swe_deg_midp(double d, double d2) {
        double d3 = this.swe_degnorm((d + d2) / 2.0);
        return d3;
    }

    public double swe_rad_midp(double d, double d2) {
        return 0.0174532925199433 * this.swe_deg_midp(d * 57.2957795130823, d2 * 57.2957795130823);
    }

    public double swi_mod2PI(double d) {
        double d2 = d % (Math.PI * 2);
        if (d2 < 0.0) {
            d2 += Math.PI * 2;
        }
        return d2;
    }

    public double swi_angnorm(double d) {
        if (d < 0.0) {
            return d + Math.PI * 2;
        }
        if (d >= Math.PI * 2) {
            return d - Math.PI * 2;
        }
        return d;
    }

    public void swi_cross_prod(double[] dArray, int n, double[] dArray2, int n2, double[] dArray3, int n3) {
        dArray3[0 + n3] = dArray[1 + n] * dArray2[2 + n2] - dArray[2 + n] * dArray2[1 + n2];
        dArray3[1 + n3] = dArray[2 + n] * dArray2[0 + n2] - dArray[0 + n] * dArray2[2 + n2];
        dArray3[2 + n3] = dArray[0 + n] * dArray2[1 + n2] - dArray[1 + n] * dArray2[0 + n2];
    }

    public double swi_echeb(double d, double[] dArray, int n, int n2) {
        if (Double.doubleToLongBits(dArray[0]) == -4629862475185489266L) {
            dArray[0] = Double.longBitsToDouble(-4629862475185489267L);
        }
        if (Double.doubleToLongBits(dArray[5]) == 4591554683707967254L) {
            dArray[5] = Double.longBitsToDouble(4591554683707967255L);
        }
        if (Double.doubleToLongBits(dArray[6]) == -4650564622438720972L) {
            dArray[6] = Double.longBitsToDouble(-4650564622438720971L);
        }
        if (Double.doubleToLongBits(dArray[10]) == 4536761645709362926L) {
            dArray[10] = Double.longBitsToDouble(4536761645709362925L);
        }
        double d2 = d * 2.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        for (int i = n2 - 1; i >= 0; --i) {
            d4 = d5;
            d5 = d3;
            d3 = d2 * d5 - d4 + dArray[i + n];
        }
        return (d3 - d4) * 0.5;
    }

    public double swi_edcheb(double d, double[] dArray, int n, int n2) {
        double d2 = d * 2.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        for (int i = n2 - 1; i >= 1; --i) {
            double d9 = i + i;
            double d10 = dArray[i + n] * d9 + d5;
            d4 = d2 * d8 - d7 + d10;
            d3 = d7;
            d7 = d8;
            d8 = d4;
            d5 = d6;
            d6 = d10;
        }
        return (d4 - d3) * 0.5;
    }

    public void swe_cotrans(double[] dArray, double[] dArray2, double d) {
        this.swe_cotrans(dArray, 0, dArray2, 0, d);
    }

    public void swe_cotrans(double[] dArray, int n, double[] dArray2, int n2, double d) {
        int n3;
        double[] dArray3 = new double[6];
        double d2 = d * 0.0174532925199433;
        for (n3 = 0; n3 <= 1; ++n3) {
            dArray3[n3] = dArray[n3 + n];
        }
        dArray3[0] = dArray3[0] * 0.0174532925199433;
        dArray3[1] = dArray3[1] * 0.0174532925199433;
        dArray3[2] = 1.0;
        for (n3 = 3; n3 <= 5; ++n3) {
            dArray3[n3] = 0.0;
        }
        this.swi_polcart(dArray3, dArray3);
        this.swi_coortrf(dArray3, dArray3, d2);
        this.swi_cartpol(dArray3, dArray3);
        dArray2[n2] = dArray3[0] * 57.2957795130823;
        dArray2[1 + n2] = dArray3[1] * 57.2957795130823;
        dArray2[2 + n2] = dArray[2 + n];
    }

    public void swe_cotrans_sp(double[] dArray, double[] dArray2, double d) {
        double[] dArray3 = new double[6];
        double d2 = d * 0.0174532925199433;
        for (int i = 0; i <= 5; ++i) {
            dArray3[i] = dArray[i];
        }
        dArray3[0] = dArray3[0] * 0.0174532925199433;
        dArray3[1] = dArray3[1] * 0.0174532925199433;
        dArray3[2] = 1.0;
        dArray3[3] = dArray3[3] * 0.0174532925199433;
        dArray3[4] = dArray3[4] * 0.0174532925199433;
        this.swi_polcart_sp(dArray3, dArray3);
        this.swi_coortrf(dArray3, dArray3, d2);
        this.swi_coortrf(dArray3, 3, dArray3, 3, d2);
        this.swi_cartpol_sp(dArray3, dArray2);
        dArray2[0] = dArray2[0] * 57.2957795130823;
        dArray2[1] = dArray2[1] * 57.2957795130823;
        dArray2[2] = dArray[2];
        dArray2[3] = dArray2[3] * 57.2957795130823;
        dArray2[4] = dArray2[4] * 57.2957795130823;
        dArray2[5] = dArray[5];
    }

    public void swi_coortrf(double[] dArray, double[] dArray2, double d) {
        this.swi_coortrf(dArray, 0, dArray2, 0, d);
    }

    public void swi_coortrf(double[] dArray, int n, double[] dArray2, int n2, double d) {
        double[] dArray3 = new double[3];
        double d2 = Math.sin(d);
        double d3 = Math.cos(d);
        dArray3[0] = dArray[n];
        dArray3[1] = dArray[1 + n] * d3 + dArray[2 + n] * d2;
        dArray3[2] = -dArray[1 + n] * d2 + dArray[2 + n] * d3;
        dArray2[0 + n2] = dArray3[0];
        dArray2[1 + n2] = dArray3[1];
        dArray2[2 + n2] = dArray3[2];
    }

    public void swi_coortrf2(double[] dArray, double[] dArray2, double d, double d2) {
        this.swi_coortrf2(dArray, 0, dArray2, 0, d, d2);
    }

    public void swi_coortrf2(double[] dArray, int n, double[] dArray2, int n2, double d, double d2) {
        double[] dArray3 = new double[]{dArray[0 + n], dArray[1 + n] * d2 + dArray[2 + n] * d, -dArray[1 + n] * d + dArray[2 + n] * d2};
        dArray2[0 + n2] = dArray3[0];
        dArray2[1 + n2] = dArray3[1];
        dArray2[2 + n2] = dArray3[2];
    }

    public void swi_cartpol(double[] dArray, double[] dArray2) {
        this.swi_cartpol(dArray, 0, dArray2, 0);
    }

    public void swi_cartpol(double[] dArray, int n, double[] dArray2, int n2) {
        double[] dArray3 = new double[3];
        if (dArray[0 + n] == 0.0 && dArray[1 + n] == 0.0 && dArray[2 + n] == 0.0) {
            dArray2[2 + n2] = 0.0;
            dArray2[1 + n2] = 0.0;
            dArray2[0 + n2] = 0.0;
            return;
        }
        double d = dArray[0 + n] * dArray[0 + n] + dArray[1 + n] * dArray[1 + n];
        dArray3[2] = Math.sqrt(d + dArray[2 + n] * dArray[2 + n]);
        d = Math.sqrt(d);
        dArray3[0] = Math.atan2(dArray[1 + n], dArray[0 + n]);
        if (dArray3[0] < 0.0) {
            dArray3[0] = dArray3[0] + Math.PI * 2;
        }
        dArray3[1] = Math.atan(dArray[2 + n] / d);
        dArray2[0 + n2] = dArray3[0];
        dArray2[1 + n2] = dArray3[1];
        dArray2[2 + n2] = dArray3[2];
    }

    public void swi_polcart(double[] dArray, double[] dArray2) {
        this.swi_polcart(dArray, 0, dArray2, 0);
    }

    public void swi_polcart(double[] dArray, int n, double[] dArray2, int n2) {
        double[] dArray3 = new double[3];
        double d = Math.cos(dArray[n + 1]);
        dArray3[0] = dArray[n + 2] * d * Math.cos(dArray[n]);
        dArray3[1] = dArray[n + 2] * d * Math.sin(dArray[n]);
        dArray3[2] = dArray[n + 2] * Math.sin(dArray[n + 1]);
        dArray2[n2] = dArray3[0];
        dArray2[n2 + 1] = dArray3[1];
        dArray2[n2 + 2] = dArray3[2];
    }

    public void swi_cartpol_sp(double[] dArray, double[] dArray2) {
        this.swi_cartpol_sp(dArray, 0, dArray2, 0);
    }

    public void swi_cartpol_sp(double[] dArray, int n, double[] dArray2, int n2) {
        double[] dArray3 = new double[6];
        double[] dArray4 = new double[6];
        if (dArray[0 + n] == 0.0 && dArray[1 + n] == 0.0 && dArray[2 + n] == 0.0) {
            dArray2[4 + n2] = 0.0;
            dArray2[3 + n2] = 0.0;
            dArray2[1 + n2] = 0.0;
            dArray2[0 + n2] = 0.0;
            dArray2[5 + n2] = Math.sqrt(this.square_sum(dArray, 3 + n));
            this.swi_cartpol(dArray, 3 + n, dArray2, 0 + n2);
            dArray2[2 + n2] = 0.0;
            return;
        }
        if (dArray[3 + n] == 0.0 && dArray[4 + n] == 0.0 && dArray[5 + n] == 0.0) {
            dArray2[5 + n2] = 0.0;
            dArray2[4 + n2] = 0.0;
            dArray2[3 + n2] = 0.0;
            this.swi_cartpol(dArray, n, dArray2, n2);
            return;
        }
        double d = dArray[0 + n] * dArray[0 + n] + dArray[1 + n] * dArray[1 + n];
        dArray4[2] = Math.sqrt(d + dArray[2 + n] * dArray[2 + n]);
        d = Math.sqrt(d);
        dArray4[0] = Math.atan2(dArray[1 + n], dArray[0 + n]);
        if (dArray4[0] < 0.0) {
            dArray4[0] = dArray4[0] + Math.PI * 2;
        }
        dArray4[1] = Math.atan(dArray[2 + n] / d);
        double d2 = dArray[0 + n] / d;
        double d3 = dArray[1 + n] / d;
        double d4 = d / dArray4[2];
        double d5 = dArray[2 + n] / dArray4[2];
        dArray3[3] = dArray[3 + n] * d2 + dArray[4 + n] * d3;
        dArray3[4] = -dArray[3 + n] * d3 + dArray[4 + n] * d2;
        dArray2[3 + n2] = dArray3[4] / d;
        dArray3[4] = -d5 * dArray3[3] + d4 * dArray[5 + n];
        dArray3[5] = d4 * dArray3[3] + d5 * dArray[5 + n];
        dArray2[4 + n2] = dArray3[4] / dArray4[2];
        dArray2[5 + n2] = dArray3[5];
        dArray2[0 + n2] = dArray4[0];
        dArray2[1 + n2] = dArray4[1];
        dArray2[2 + n2] = dArray4[2];
    }

    public void swi_polcart_sp(double[] dArray, double[] dArray2) {
        this.swi_polcart_sp(dArray, 0, dArray2, 0);
    }

    public void swi_polcart_sp(double[] dArray, int n, double[] dArray2, int n2) {
        double[] dArray3 = new double[6];
        if (dArray[3 + n] == 0.0 && dArray[4 + n] == 0.0 && dArray[5 + n] == 0.0) {
            dArray2[5 + n2] = 0.0;
            dArray2[4 + n2] = 0.0;
            dArray2[3 + n2] = 0.0;
            this.swi_polcart(dArray, n, dArray2, n2);
            return;
        }
        double d = Math.cos(dArray[0 + n]);
        double d2 = Math.sin(dArray[0 + n]);
        double d3 = Math.cos(dArray[1 + n]);
        double d4 = Math.sin(dArray[1 + n]);
        dArray3[0] = dArray[2 + n] * d3 * d;
        dArray3[1] = dArray[2 + n] * d3 * d2;
        dArray3[2] = dArray[2 + n] * d4;
        double d5 = dArray[2 + n];
        double d6 = Math.sqrt(dArray3[0] * dArray3[0] + dArray3[1] * dArray3[1]);
        dArray3[5] = dArray[5 + n];
        dArray3[4] = dArray[4 + n] * d5;
        dArray2[5 + n2] = d4 * dArray3[5] + d3 * dArray3[4];
        dArray3[3] = d3 * dArray3[5] - d4 * dArray3[4];
        dArray3[4] = dArray[3 + n] * d6;
        dArray2[3 + n2] = d * dArray3[3] - d2 * dArray3[4];
        dArray2[4 + n2] = d2 * dArray3[3] + d * dArray3[4];
        dArray2[0 + n2] = dArray3[0];
        dArray2[1 + n2] = dArray3[1];
        dArray2[2 + n2] = dArray3[2];
    }

    public double swi_dot_prod_unit(double[] dArray, double[] dArray2) {
        double d = dArray[0] * dArray2[0] + dArray[1] * dArray2[1] + dArray[2] * dArray2[2];
        double d2 = Math.sqrt(dArray[0] * dArray[0] + dArray[1] * dArray[1] + dArray[2] * dArray[2]);
        double d3 = Math.sqrt(dArray2[0] * dArray2[0] + dArray2[1] * dArray2[1] + dArray2[2] * dArray2[2]);
        d /= d2;
        if ((d /= d3) > 1.0) {
            d = 1.0;
        }
        if (d < -1.0) {
            d = -1.0;
        }
        return d;
    }

    public double swi_epsiln(double d) {
        double d2 = (d - 2451545.0) / 36525.0;
        double d3 = Math.abs(d2) <= 75.0 ? (((((-4.34E-8 * d2 - 5.76E-7) * d2 + 0.0020034) * d2 - 1.831E-4) * d2 - 46.836769) * d2 + 84381.406) * 0.0174532925199433 / 3600.0 : ((((-1.0E-6 * d2 + 0.002) * d2 - 1.74E-4) * d2 - 46.83396) * d2 + 84381.409) * 0.0174532925199433 / 3600.0;
        return d3;
    }

    public int swi_precess(double[] dArray, double d, int n) {
        return this.swi_precess(dArray, 0, d, n);
    }

    public int swi_precess(double[] dArray, int n, double d, int n2) {
        double[] dArray2 = new double[3];
        if (d == 2451545.0) {
            return 0;
        }
        double d2 = (d - 2451545.0) / 36525.0;
        if (!(Math.abs(d2) <= 75.0)) {
            int n3;
            double d3 = n2 == 1 ? this.swi_epsiln(d) : this.swi_epsiln(2451545.0);
            double d4 = Math.sin(d3);
            double d5 = Math.cos(d3);
            dArray2[0] = dArray[0 + n];
            double d6 = d5 * dArray[1 + n] + d4 * dArray[2 + n];
            dArray2[2] = -d4 * dArray[1 + n] + d5 * dArray[2 + n];
            dArray2[1] = d6;
            d2 /= 10.0;
            int n4 = 0;
            double d7 = pAcof[n4];
            ++n4;
            for (n3 = 0; n3 < 9; ++n3) {
                d7 = d7 * d2 + pAcof[n4];
                ++n4;
            }
            d7 *= 4.848136811095361E-6 * d2;
            n4 = 0;
            double d8 = nodecof[n4];
            ++n4;
            for (n3 = 0; n3 < 10; ++n3) {
                d8 = d8 * d2 + nodecof[n4];
                ++n4;
            }
            d6 = n2 == 1 ? d8 + d7 : d8;
            double d9 = Math.cos(d6);
            double d10 = Math.sin(d6);
            d6 = d9 * dArray2[0] + d10 * dArray2[1];
            dArray2[1] = -d10 * dArray2[0] + d9 * dArray2[1];
            dArray2[0] = d6;
            n4 = 0;
            d6 = inclcof[n4];
            ++n4;
            for (n3 = 0; n3 < 10; ++n3) {
                d6 = d6 * d2 + inclcof[n4];
                ++n4;
            }
            if (n2 == 1) {
                d6 = -d6;
            }
            d9 = Math.cos(d6);
            d10 = Math.sin(d6);
            d6 = d9 * dArray2[1] + d10 * dArray2[2];
            dArray2[2] = -d10 * dArray2[1] + d9 * dArray2[2];
            dArray2[1] = d6;
            d6 = n2 == 1 ? -d8 : -d8 - d7;
            d9 = Math.cos(d6);
            d10 = Math.sin(d6);
            d6 = d9 * dArray2[0] + d10 * dArray2[1];
            dArray2[1] = -d10 * dArray2[0] + d9 * dArray2[1];
            dArray2[0] = d6;
            d3 = n2 == 1 ? this.swi_epsiln(2451545.0) : this.swi_epsiln(d);
            d4 = Math.sin(d3);
            d5 = Math.cos(d3);
            d6 = d5 * dArray2[1] - d4 * dArray2[2];
            dArray2[2] = d4 * dArray2[1] + d5 * dArray2[2];
            dArray2[1] = d6;
            for (n3 = 0; n3 < 3; ++n3) {
                dArray[n3 + n] = dArray2[n3];
            }
            return 0;
        }
        double d11 = (((((-3.173E-7 * d2 - 5.971E-6) * d2 + 0.01801828) * d2 + 0.2988499) * d2 + 2306.083227) * d2 + 2.650545) * 0.0174532925199433 / 3600.0;
        double d12 = (((((-2.904E-7 * d2 - 2.8596E-5) * d2 + 0.01826837) * d2 + 1.0927348) * d2 + 2306.077181) * d2 - 2.650545) * 0.0174532925199433 / 3600.0;
        double d13 = ((((-1.1274E-7 * d2 - 7.089E-6) * d2 - 0.04182264) * d2 - 0.4294934) * d2 + 2004.191903) * d2 * 0.0174532925199433 / 3600.0;
        double d14 = Math.sin(d13);
        double d15 = Math.cos(d13);
        double d16 = Math.sin(d11);
        double d17 = Math.cos(d11);
        double d18 = Math.sin(d12);
        double d19 = Math.cos(d12);
        double d20 = d17 * d15;
        double d21 = d16 * d15;
        if (n2 < 0) {
            dArray2[0] = (d20 * d19 - d16 * d18) * dArray[0 + n] - (d21 * d19 + d17 * d18) * dArray[1 + n] - d14 * d19 * dArray[2 + n];
            dArray2[1] = (d20 * d18 + d16 * d19) * dArray[0 + n] - (d21 * d18 - d17 * d19) * dArray[1 + n] - d14 * d18 * dArray[2 + n];
            dArray2[2] = d17 * d14 * dArray[0 + n] - d16 * d14 * dArray[1 + n] + d15 * dArray[2 + n];
        } else {
            dArray2[0] = (d20 * d19 - d16 * d18) * dArray[0 + n] + (d20 * d18 + d16 * d19) * dArray[1 + n] + d17 * d14 * dArray[2 + n];
            dArray2[1] = -(d21 * d19 + d17 * d18) * dArray[0 + n] - (d21 * d18 - d17 * d19) * dArray[1 + n] - d16 * d14 * dArray[2 + n];
            dArray2[2] = -d14 * d19 * dArray[0 + n] - d14 * d18 * dArray[1 + n] + d15 * dArray[2 + n];
        }
        for (int i = 0; i < 3; ++i) {
            dArray[i + n] = dArray2[i];
        }
        return 0;
    }

    int swi_nutation(double d, double[] dArray) {
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = (d - 2451545.0) / 36525.0;
        double d5 = this.swe_degnorm((485868.249036 + d4 * (1.7179159232178E9 + d4 * (31.8792 + d4 * (0.051635 + d4 * -2.447E-4)))) / 3600.0) * 0.0174532925199433;
        double d6 = this.swe_degnorm((1287104.79305 + d4 * (1.295965810481E8 + d4 * (-0.5532 + d4 * (1.36E-4 + d4 * -1.149E-5)))) / 3600.0) * 0.0174532925199433;
        double d7 = this.swe_degnorm((335779.526232 + d4 * (1.7395272628478E9 + d4 * (-12.7512 + d4 * (-0.001037 + d4 * 4.17E-6)))) / 3600.0) * 0.0174532925199433;
        double d8 = this.swe_degnorm((1072260.70369 + d4 * (1.602961601209E9 + d4 * (-6.3706 + d4 * (0.006593 + d4 * -3.169E-5)))) / 3600.0) * 0.0174532925199433;
        double d9 = this.swe_degnorm((450160.398036 + d4 * (-6962890.5431 + d4 * (7.4722 + d4 * (0.007702 + d4 * -5.939E-5)))) / 3600.0) * 0.0174532925199433;
        int n = 77;
        for (int i = n - 1; i >= 0; --i) {
            int n2 = i * 5;
            double d10 = this.swe_radnorm((double)Swenut2000a.nls[n2 + 0] * d5 + (double)Swenut2000a.nls[n2 + 1] * d6 + (double)Swenut2000a.nls[n2 + 2] * d7 + (double)Swenut2000a.nls[n2 + 3] * d8 + (double)Swenut2000a.nls[n2 + 4] * d9);
            double d11 = Math.sin(d10);
            double d12 = Math.cos(d10);
            int n3 = i * 6;
            d2 += ((double)Swenut2000a.cls[n3 + 0] + (double)Swenut2000a.cls[n3 + 1] * d4) * d11 + (double)Swenut2000a.cls[n3 + 2] * d12;
            d3 += ((double)Swenut2000a.cls[n3 + 3] + (double)Swenut2000a.cls[n3 + 4] * d4) * d12 + (double)Swenut2000a.cls[n3 + 5] * d11;
        }
        dArray[0] = d2 * 2.7777777777777777E-11;
        dArray[1] = d3 * 2.7777777777777777E-11;
        dArray[0] = dArray[0] * 0.0174532925199433;
        dArray[1] = dArray[1] * 0.0174532925199433;
        return 0;
    }

    void swi_bias(double[] dArray, int n, boolean bl) {
        int n2;
        double[] dArray2 = new double[6];
        double[][] dArray3 = new double[3][3];
        dArray3[0][0] = 0.9999999999999942;
        dArray3[0][1] = 7.07827948E-8;
        dArray3[0][2] = -8.05621738E-8;
        dArray3[1][0] = -7.07827974E-8;
        dArray3[1][1] = 0.9999999999999969;
        dArray3[1][2] = -3.30604088E-8;
        dArray3[2][0] = 8.05621715E-8;
        dArray3[2][1] = 3.30604145E-8;
        dArray3[2][2] = 0.9999999999999962;
        if (bl) {
            for (n2 = 0; n2 <= 2; ++n2) {
                dArray2[n2] = dArray[0] * dArray3[n2][0] + dArray[1] * dArray3[n2][1] + dArray[2] * dArray3[n2][2];
                if ((n & 0x100) == 0) continue;
                dArray2[n2 + 3] = dArray[3] * dArray3[n2][0] + dArray[4] * dArray3[n2][1] + dArray[5] * dArray3[n2][2];
            }
        } else {
            for (n2 = 0; n2 <= 2; ++n2) {
                dArray2[n2] = dArray[0] * dArray3[0][n2] + dArray[1] * dArray3[1][n2] + dArray[2] * dArray3[2][n2];
                if ((n & 0x100) == 0) continue;
                dArray2[n2 + 3] = dArray[3] * dArray3[0][n2] + dArray[4] * dArray3[1][n2] + dArray[5] * dArray3[2][n2];
            }
        }
        for (n2 = 0; n2 <= 2; ++n2) {
            dArray[n2] = dArray2[n2];
        }
        if ((n & 0x100) != 0) {
            for (n2 = 3; n2 <= 5; ++n2) {
                dArray[n2] = dArray2[n2];
            }
        }
    }

    void swi_icrs2fk5(double[] dArray, int n, boolean bl) {
        int n2;
        double[] dArray2 = new double[6];
        double[][] dArray3 = new double[3][3];
        dArray3[0][0] = 0.9999999999999928;
        dArray3[0][1] = 1.110223287E-7;
        dArray3[0][2] = 4.41180557E-8;
        dArray3[1][0] = -1.11022333E-7;
        dArray3[1][1] = 0.9999999999999891;
        dArray3[1][2] = 9.64779176E-8;
        dArray3[2][0] = -4.4118045E-8;
        dArray3[2][1] = -9.64779225E-8;
        dArray3[2][2] = 0.9999999999999943;
        if (bl) {
            for (n2 = 0; n2 <= 2; ++n2) {
                dArray2[n2] = dArray[0] * dArray3[n2][0] + dArray[1] * dArray3[n2][1] + dArray[2] * dArray3[n2][2];
                if ((n & 0x100) == 0) continue;
                dArray2[n2 + 3] = dArray[3] * dArray3[n2][0] + dArray[4] * dArray3[n2][1] + dArray[5] * dArray3[n2][2];
            }
        } else {
            for (n2 = 0; n2 <= 2; ++n2) {
                dArray2[n2] = dArray[0] * dArray3[0][n2] + dArray[1] * dArray3[1][n2] + dArray[2] * dArray3[2][n2];
                if ((n & 0x100) == 0) continue;
                dArray2[n2 + 3] = dArray[3] * dArray3[0][n2] + dArray[4] * dArray3[1][n2] + dArray[5] * dArray3[2][n2];
            }
        }
        for (n2 = 0; n2 <= 5; ++n2) {
            dArray[n2] = dArray2[n2];
        }
    }

    public int swi_cutstr(String string, String string2, String[] stringArray, int n) {
        int n2;
        if ((string = string.trim()).indexOf(10) >= 0) {
            string = string.substring(0, string.indexOf(10));
        }
        if (string.indexOf(13) >= 0) {
            string = string.substring(0, string.indexOf(13));
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2, true);
        for (n2 = 0; stringTokenizer.hasMoreTokens() && n2 < 20; ++n2) {
            String string3 = stringTokenizer.nextToken();
            while (string3.endsWith("\\") && stringTokenizer.hasMoreTokens()) {
                string3 = string3.substring(0, string3.length() - 1) + stringTokenizer.nextToken();
                if (!stringTokenizer.hasMoreTokens()) continue;
                string3 = string3 + stringTokenizer.nextToken();
            }
            stringArray[n2] = string3;
            if (!stringTokenizer.hasMoreTokens()) continue;
            stringTokenizer.nextToken();
        }
        stringArray[19] = "";
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[19] = stringArray[19] + stringTokenizer.nextToken();
        }
        if (n2 < n) {
            stringArray[n2] = null;
        }
        return n2;
    }

    public double swe_sidtime0(double d, double d2, double d3) {
        double d4 = d;
        double d5 = Math.floor(d4);
        double d6 = d - d5;
        if (d6 < 0.5) {
            d5 -= 0.5;
            d6 += 0.5;
        } else {
            d5 += 0.5;
            d6 -= 0.5;
        }
        d6 *= 86400.0;
        double d7 = (d5 - 2451545.0) / 36525.0;
        double d8 = (d5 + SweDate.getDeltaT(d5) - 2451545.0) / 36525.0;
        double d9 = (((-2.454E-9 * d8 - 1.99708E-6) * d8 - 2.926E-7) * d8 + 0.09277211) * d8 * d8 + 307.4771013 * (d8 - d7) + 8640184.79447825 * d7 + 24110.5493771;
        double d10 = 1.0 + ((((-1.227E-8 * d8 - 7.98832E-6) * d8 - 8.778E-7) * d8 + 0.18554422) * d8 + 8640184.79447825) / 3.15576E9;
        double d11 = 240.0 * d3 * Math.cos(d2 * 0.0174532925199433);
        d9 = d9 + d10 * d6 + d11;
        d9 -= 86400.0 * Math.floor(d9 / 86400.0);
        return d9 /= 3600.0;
    }

    public double swe_sidtime(double d) {
        double[] dArray = new double[2];
        double d2 = d + SweDate.getDeltaT(d);
        double d3 = this.swi_epsiln(d2) * 57.2957795130823;
        this.swi_nutation(d2, dArray);
        int n = 0;
        while (n < 2) {
            int n2 = n++;
            dArray[n2] = dArray[n2] * 57.2957795130823;
        }
        double d4 = this.swe_sidtime0(d, d3 + dArray[1], dArray[0]);
        return d4;
    }

    public String swi_gen_filename(SweDate sweDate, int n) {
        String string;
        int n2 = 6;
        switch (n) {
            case 1: {
                string = "semo";
                break;
            }
            case 0: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "sepl";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                string = "seas";
                break;
            }
            default: {
                String string2 = "00000" + (n - 10000);
                string2 = string2.substring(string2.length() - 6);
                if (n - 10000 <= 99999) {
                    string2 = string2.substring(1);
                }
                String string3 = "ast" + (n - 10000) / 1000 + this.swed.DIR_GLUE + "se" + string2 + "." + "se1";
                return string3;
            }
        }
        if (sweDate.getJulDay() >= 2305447.5) {
            sweDate.setCalendarType(true, false);
        } else {
            sweDate.setCalendarType(false, false);
        }
        int n3 = sweDate.getYear();
        int n4 = n3 < 0 ? -1 : 1;
        int n5 = n3 / 100;
        if (n4 < 0 && n3 % 100 != 0) {
            --n5;
        }
        while (n5 % n2 != 0) {
            --n5;
        }
        string = n5 < 0 ? string + "m" : string + "_";
        n5 = Math.abs(n5);
        string = string + (n5 < 10 ? "0" : "") + n5 + "." + "se1";
        return string;
    }

    public void swe_split_deg(double d, int n, IntObj intObj, IntObj intObj2, IntObj intObj3, DblObj dblObj, IntObj intObj4) {
        double d2 = 0.0;
        intObj4.val = 1;
        if (d < 0.0) {
            intObj4.val = -1;
            d = -d;
        }
        if ((n & 4) != 0) {
            d2 = 0.5;
        } else if ((n & 2) != 0) {
            d2 = 0.008333333333333333;
        } else if ((n & 1) != 0) {
            d2 = 1.388888888888889E-4;
        }
        if ((n & 0x20) != 0) {
            if ((int)(d + d2) - (int)d > 0) {
                d2 = 0.0;
            }
        } else if ((n & 0x10) != 0 && d % 30.0 + d2 >= 30.0) {
            d2 = 0.0;
        }
        d += d2;
        if ((n & 8) != 0) {
            intObj4.val = (int)(d / 30.0);
            d %= 30.0;
        }
        intObj.val = (int)d;
        intObj2.val = (int)((d -= (double)intObj.val) * 60.0);
        intObj3.val = (int)((d -= (double)intObj2.val / 60.0) * 3600.0);
        if ((n & 7) == 0) {
            dblObj.val = d * 3600.0 - (double)intObj3.val;
        }
    }

    public double swi_kepler(double d, double d2, double d3) {
        double d4 = 1.0;
        if (d3 < 0.4) {
            while (d4 > 1.0E-12) {
                double d5 = d;
                d = d2 + d3 * Math.sin(d5);
                d4 = Math.abs(d - d5);
            }
        } else {
            while (d4 > 1.0E-12) {
                double d6 = d;
                double d7 = (d2 + d3 * Math.sin(d6) - d6) / (1.0 - d3 * Math.cos(d6));
                d4 = Math.abs(d7);
                if (d4 < 0.01) {
                    d = d6 + d7;
                    continue;
                }
                d = this.swi_mod2PI(d6 + d7);
                d4 = Math.abs(d - d6);
            }
        }
        return d;
    }

    public void swi_FK4_FK5(double[] dArray, double d) {
        if (dArray[0] == 0.0 && dArray[1] == 0.0 && dArray[2] == 0.0) {
            return;
        }
        this.swi_cartpol(dArray, dArray);
        dArray[0] = dArray[0] + (0.035 + 0.085 * (d - 2433282.42345905) / 36524.2198782) / 3600.0 * 15.0 * 0.0174532925199433;
        dArray[3] = dArray[3] + 1.6924042333443586E-10;
        this.swi_polcart(dArray, dArray);
    }

    public void swi_FK5_FK4(double[] dArray, double d) {
        if (dArray[0] == 0.0 && dArray[1] == 0.0 && dArray[2] == 0.0) {
            return;
        }
        this.swi_cartpol(dArray, dArray);
        dArray[0] = dArray[0] - (0.035 + 0.085 * (d - 2433282.42345905) / 36524.2198782) / 3600.0 * 15.0 * 0.0174532925199433;
        dArray[3] = dArray[3] - 1.6924042333443586E-10;
        this.swi_polcart(dArray, dArray);
    }

    public int swe_d2l(double d) {
        if (d >= 0.0) {
            return (int)(d + 0.5);
        }
        return -((int)(0.5 - d));
    }

    public double swe_difdeg2n(double d, double d2) {
        double d3 = this.swe_degnorm(d - d2);
        if (d3 >= 180.0) {
            return d3 - 360.0;
        }
        return d3;
    }

    public double swe_difrad2n(double d, double d2) {
        double d3 = this.swe_radnorm(d - d2);
        if (d3 >= Math.PI) {
            return d3 - Math.PI * 2;
        }
        return d3;
    }

    public static synchronized double atof(String string) {
        int n;
        string = string.trim();
        for (n = 0; n < string.length() && (Character.isDigit(string.charAt(n)) || string.charAt(n) == '.'); ++n) {
        }
        String string2 = string.substring(0, n).trim();
        if (string2.length() == 0 || string2.replace('.', ' ').trim().length() == 0) {
            return 0.0;
        }
        return Double.valueOf(string2);
    }

    public static synchronized int atoi(String string) {
        int n;
        string = string.trim();
        for (n = 0; n < string.length() && Character.isDigit(string.charAt(n)); ++n) {
        }
        String string2 = string.substring(0, n).trim();
        if (string2.length() == 0 || string2.replace('.', ' ').trim().length() == 0) {
            return 0;
        }
        return Integer.valueOf(string2);
    }
}

