/*
 * Decompiled with CFR 0.152.
 */
package swisseph;

import swisseph.SwephData;
import swisseph.SwissEph;
import swisseph.SwissephException;
import swisseph.TransitCalculator;

public class TCPlanet
extends TransitCalculator {
    private int planet;
    private int idx = 0;
    private int tflags = 0;
    private int flags = 0;
    private double min = 0.0;
    private double max = 0.0;
    private double offset = 0.0;
    double minVal = 0.0;
    double maxVal = 0.0;

    public TCPlanet(SwissEph swissEph, int n, int n2, double d) {
        this.tflags = n2;
        int n3 = 2065935;
        if ((n2 & 8) != 0) {
            n3 |= 0x600;
        }
        if ((n2 & ~n3) != 0) {
            throw new IllegalArgumentException("Invalid flag(s): " + (n2 & ~n3));
        }
        int n4 = n2 & 0xE0000;
        if (n4 != 131072 && n4 != 262144 && n4 != 524288) {
            throw new IllegalArgumentException("Invalid flag combination '" + n2 + "': specify at least exactly one of SEFLG_TRANSIT_LONGITUDE (" + 131072 + "), SEFLG_TRANSIT_LATITUDE (" + 262144 + "), SEFLG_TRANSIT_DISTANCE (" + 524288 + ").");
        }
        if (n < 0 || n > 22 || n == 14) {
            throw new IllegalArgumentException("Unsupported planet number " + n + " (" + swissEph.swe_get_planet_name(n) + ")");
        }
        if ((n2 & 8) != 0 && (n == 12 || n == 13 || n == 10 || n == 11)) {
            throw new IllegalArgumentException("Unsupported planet number " + n + " (" + swissEph.swe_get_planet_name(n) + ") for heliocentric " + "calculations");
        }
        this.planet = n;
        this.sw = swissEph;
        if (this.sw == null) {
            this.sw = new SwissEph();
        }
        if ((n2 & 0x40000) != 0) {
            this.idx = 1;
        } else if ((n2 & 0x80000) != 0) {
            this.idx = 2;
        }
        if ((n2 & 0x100000) != 0) {
            this.idx += 3;
            n2 |= 0x100;
        }
        this.flags = n2 &= 0xFFE1FFFF;
        this.rollover = this.idx == 0;
        this.offset = this.checkOffset(d);
        this.max = this.getSpeed(false);
        this.min = this.getSpeed(true);
    }

    @Override
    public boolean getRollover() {
        return this.rollover;
    }

    @Override
    public void setOffset(double d) {
        this.offset = this.checkOffset(d);
    }

    @Override
    public double getOffset() {
        return this.offset;
    }

    @Override
    public Object[] getObjectIdentifiers() {
        return new Object[]{"" + this.planet};
    }

    @Override
    protected double calc(double d) {
        double[] dArray = new double[6];
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.sw.swe_calc(d, this.planet, this.flags, dArray, stringBuffer);
        if (n < 0) {
            throw new SwissephException(d, 0, "Calculation failed with return code " + n + ":\n" + stringBuffer.toString());
        }
        return dArray[this.idx];
    }

    @Override
    protected double getMaxSpeed() {
        return this.max;
    }

    @Override
    protected double getMinSpeed() {
        return this.min;
    }

    @Override
    protected double getTimePrecision(double d) {
        double d2 = Math.max(Math.abs(this.min), Math.abs(this.max));
        if (d2 != 0.0) {
            return d / d2;
        }
        return 1.0E-9;
    }

    @Override
    protected double getDegreePrecision(double d) {
        double d2 = 0.005;
        if (this.idx > 2) {
            d2 = 0.002;
        } else if (this.planet >= 0 && this.planet <= 5) {
            if (d < 1980.0 || d > 2099.0) {
                d2 = 0.08;
            }
        } else if (d >= 1900.0 && d < 1980.0) {
            d2 = 0.08;
        } else if (d < 1900.0 || d > 2099.0) {
            d2 = 1.0;
        }
        d2 /= 3600.0;
        d2 *= 0.5;
        switch (this.idx) {
            case 0: 
            case 1: 
            case 3: 
            case 4: {
                break;
            }
            case 2: 
            case 5: {
                d2 *= this.sw.ext.maxBaryDist[this.planet];
            }
        }
        return d2;
    }

    private double checkOffset(double d) {
        if (this.rollover) {
            while (d < 0.0) {
                d += 360.0;
            }
            d %= 360.0;
            this.minVal = 0.0;
            this.maxVal = 360.0;
        } else if (this.idx == 1) {
            while (d < -90.0) {
                d += 180.0;
            }
            while (d > 90.0) {
                d -= 180.0;
            }
            this.minVal = -90.0;
            this.maxVal = 90.0;
        }
        return d;
    }

    private double getSpeed(boolean bl) {
        boolean bl2;
        boolean bl3 = (this.tflags & 0x40000) != 0;
        boolean bl4 = (this.tflags & 0x80000) != 0;
        boolean bl5 = (this.tflags & 0x100000) != 0;
        boolean bl6 = (this.tflags & 0x8000) != 0;
        boolean bl7 = bl2 = (this.tflags & 8) != 0;
        if (bl6) {
            if (!this.sw.swed.geopos_is_set) {
                throw new IllegalArgumentException("Geographic position is not set for requested topocentric calculations.");
            }
            if (this.sw.swed.topd.geoalt > 50000.0) {
                throw new IllegalArgumentException("Topocentric transit calculations are restricted to a maximum altitude of 50km so far.");
            }
            if (this.sw.swed.topd.geoalt < -1.2E7) {
                throw new IllegalArgumentException("Topocentric transit calculations are restricted to a minimum altitude of -12000km so far.");
            }
            if (bl5) {
                if (bl3) {
                    return bl ? SwephData.minTopoLatAccel[this.planet] : SwephData.maxTopoLatAccel[this.planet];
                }
                if (bl4) {
                    return bl ? SwephData.minTopoDistAccel[this.planet] : SwephData.maxTopoDistAccel[this.planet];
                }
                return bl ? SwephData.minTopoLonAccel[this.planet] : SwephData.maxTopoLonAccel[this.planet];
            }
            if (bl3) {
                return bl ? SwephData.minTopoLatSpeed[this.planet] : SwephData.maxTopoLatSpeed[this.planet];
            }
            if (bl4) {
                return bl ? SwephData.minTopoDistSpeed[this.planet] : SwephData.maxTopoDistSpeed[this.planet];
            }
            return bl ? SwephData.minTopoLonSpeed[this.planet] : SwephData.maxTopoLonSpeed[this.planet];
        }
        if (bl2) {
            if (bl5) {
                if (bl3) {
                    return bl ? SwephData.minHelioLatAccel[this.planet] : SwephData.maxHelioLatAccel[this.planet];
                }
                if (bl4) {
                    return bl ? SwephData.minHelioDistAccel[this.planet] : SwephData.maxHelioDistAccel[this.planet];
                }
                return bl ? SwephData.minHelioLonAccel[this.planet] : SwephData.maxHelioLonAccel[this.planet];
            }
            if (bl3) {
                return bl ? SwephData.minHelioLatSpeed[this.planet] : SwephData.maxHelioLatSpeed[this.planet];
            }
            if (bl4) {
                return bl ? SwephData.minHelioDistSpeed[this.planet] : SwephData.maxHelioDistSpeed[this.planet];
            }
            return bl ? SwephData.minHelioLonSpeed[this.planet] : SwephData.maxHelioLonSpeed[this.planet];
        }
        if (bl5) {
            if (bl3) {
                return bl ? SwephData.minLatAccel[this.planet] : SwephData.maxLatAccel[this.planet];
            }
            if (bl4) {
                return bl ? SwephData.minDistAccel[this.planet] : SwephData.maxDistAccel[this.planet];
            }
            return bl ? SwephData.minLonAccel[this.planet] : SwephData.maxLonAccel[this.planet];
        }
        if (bl3) {
            return bl ? SwephData.minLatSpeed[this.planet] : SwephData.maxLatSpeed[this.planet];
        }
        if (bl4) {
            return bl ? SwephData.minDistSpeed[this.planet] : SwephData.maxDistSpeed[this.planet];
        }
        return bl ? SwephData.minLonSpeed[this.planet] : SwephData.maxLonSpeed[this.planet];
    }

    public String toString() {
        return "[Planet:" + this.planet + "];Offset:" + this.getOffset();
    }
}

