/*
 * Decompiled with CFR 0.152.
 */
package swisseph;

import swisseph.SwephData;
import swisseph.SwissEph;
import swisseph.SwissephException;
import swisseph.TransitCalculator;

public class TCPlanetPlanet
extends TransitCalculator {
    private int pl1;
    private int pl2;
    private int idx = 0;
    private int tflags = 0;
    private int flags = 0;
    private boolean calcYoga = false;
    private double maxSpeed1;
    private double minSpeed1;
    private double maxSpeed2;
    private double minSpeed2;
    private double minSpeed;
    private double maxSpeed;
    private double offset = 0.0;
    double minVal = 0.0;
    double maxVal = 0.0;

    public TCPlanetPlanet(SwissEph swissEph, int n, int n2, int n3, double d) {
        this.sw = swissEph;
        if (this.sw == null) {
            this.sw = new SwissEph();
        }
        this.tflags = n3;
        int n4 = 4163087;
        if ((n3 & 8) != 0) {
            n4 |= 0x600;
        }
        if ((n3 & ~n4) != 0) {
            throw new IllegalArgumentException("Invalid flag(s): " + (n3 & ~n4));
        }
        int n5 = n3 & 0xE0000;
        if (n5 != 131072 && n5 != 262144 && n5 != 524288) {
            throw new IllegalArgumentException("Invalid flag combination '" + n3 + "': specify at least exactly one of SEFLG_TRANSIT_LONGITUDE (" + 131072 + "), SEFLG_TRANSIT_LATITUDE (" + 262144 + "), SEFLG_TRANSIT_DISTANCE (" + 524288 + ").");
        }
        if (n < 0 || n > 22 || n == 14) {
            throw new IllegalArgumentException("Unsupported planet number " + n + " (" + swissEph.swe_get_planet_name(n) + ")");
        }
        if (n2 < 0 || n2 > 22 || n2 == 14) {
            throw new IllegalArgumentException("Unsupported planet number " + n + " (" + swissEph.swe_get_planet_name(n) + ")");
        }
        if ((n3 & 8) != 0 && (n == 12 || n == 13 || n == 10 || n == 11)) {
            throw new IllegalArgumentException("Unsupported planet number " + n + " (" + swissEph.swe_get_planet_name(n) + ") for heliocentric " + "calculations");
        }
        if ((n3 & 8) != 0 && (n2 == 12 || n2 == 13 || n2 == 10 || n2 == 11)) {
            throw new IllegalArgumentException("Unsupported planet number " + n2 + " (" + swissEph.swe_get_planet_name(n2) + ") for heliocentric " + "calculations");
        }
        if (n == n2) {
            throw new IllegalArgumentException("Transiting and referred planet have to be different!");
        }
        this.pl1 = n;
        this.pl2 = n2;
        boolean bl = this.calcYoga = (n3 & 0x200000) != 0;
        if ((n3 & 0x40000) != 0) {
            this.idx = 1;
        } else if ((n3 & 0x80000) != 0) {
            this.idx = 2;
        }
        if ((n3 & 0x100000) != 0) {
            this.idx += 3;
            n3 |= 0x100;
        }
        this.flags = n3 &= 0xFFC1FFFF;
        this.rollover = this.idx == 0;
        this.offset = this.checkOffset(d);
        this.maxSpeed1 = this.getSpeed(false, n);
        this.minSpeed1 = this.getSpeed(true, n);
        this.maxSpeed2 = this.getSpeed(false, n2);
        this.minSpeed2 = this.getSpeed(true, n2);
        if (this.calcYoga) {
            this.minSpeed = this.minSpeed1 + this.minSpeed2;
            this.maxSpeed = this.maxSpeed1 + this.maxSpeed2;
        } else if (this.rollover) {
            this.minSpeed = this.maxSpeed1 > this.maxSpeed2 ? this.minSpeed1 - this.maxSpeed2 : this.minSpeed2 - this.maxSpeed1;
            this.maxSpeed = this.maxSpeed1 > this.maxSpeed2 ? this.maxSpeed1 - this.minSpeed2 : this.maxSpeed2 - this.minSpeed1;
        } else {
            this.minSpeed = Math.max(this.minSpeed1 - this.maxSpeed2, this.minSpeed2 - this.maxSpeed1);
            this.maxSpeed = Math.max(this.maxSpeed1 - this.minSpeed2, this.maxSpeed2 - this.minSpeed1);
        }
    }

    @Override
    public boolean getRollover() {
        return this.rollover;
    }

    @Override
    public void setOffset(double d) {
        this.offset = this.checkOffset(d);
    }

    @Override
    public double getOffset() {
        return this.offset;
    }

    @Override
    public Object[] getObjectIdentifiers() {
        return new Object[]{"" + this.pl1, "" + this.pl2};
    }

    @Override
    protected double getMaxSpeed() {
        return this.maxSpeed;
    }

    @Override
    protected double getMinSpeed() {
        return this.minSpeed;
    }

    @Override
    protected double calc(double d) {
        StringBuffer stringBuffer = new StringBuffer();
        double[] dArray = new double[6];
        double[] dArray2 = new double[6];
        int n = this.sw.swe_calc(d, this.pl1, this.flags, dArray, stringBuffer);
        if (n < 0) {
            throw new SwissephException(d, 0, "Calculation failed with return code " + n + ":\n" + stringBuffer.toString());
        }
        n = this.sw.swe_calc(d, this.pl2, this.flags, dArray2, stringBuffer);
        if (n < 0) {
            throw new SwissephException(d, 0, "Calculation failed with return code " + n + ":\n" + stringBuffer.toString());
        }
        return dArray[this.idx] + (this.calcYoga ? dArray2[this.idx] : -dArray2[this.idx]);
    }

    @Override
    protected double getTimePrecision(double d) {
        double d2 = Math.min(Math.abs(this.minSpeed1), Math.abs(this.minSpeed2));
        double d3 = Math.min(Math.abs(this.maxSpeed1), Math.abs(this.maxSpeed2));
        double d4 = Math.max(Math.abs(d2), Math.abs(d3));
        if (d4 != 0.0) {
            return d / d4;
        }
        return 1.0E-9;
    }

    @Override
    protected double getDegreePrecision(double d) {
        double d2 = 0.005;
        if (this.idx > 2) {
            d2 = 0.002;
        } else {
            if (this.pl1 >= 0 && this.pl1 <= 5) {
                if (d < 1980.0 || d > 2099.0) {
                    d2 = 0.08;
                }
            } else if (d >= 1900.0 && d < 1980.0) {
                d2 = 0.08;
            } else if (d < 1900.0 || d > 2099.0) {
                d2 = 1.0;
            }
            if (this.pl2 >= 0 && this.pl2 <= 5) {
                if (d < 1980.0 || d > 2099.0) {
                    d2 = Math.max(0.08, d2);
                }
            } else if (d >= 1900.0 && d < 1980.0) {
                d2 = Math.max(0.08, d2);
            } else if (d < 1900.0 || d > 2099.0) {
                d2 = Math.max(1.0, d2);
            }
        }
        d2 /= 3600.0;
        d2 *= 0.5;
        switch (this.idx) {
            case 0: 
            case 1: 
            case 3: 
            case 4: {
                break;
            }
            case 2: 
            case 5: {
                d2 *= Math.max(this.sw.ext.maxBaryDist[this.pl1], this.sw.ext.maxBaryDist[this.pl2]);
            }
        }
        return d2;
    }

    private double checkOffset(double d) {
        if (this.rollover) {
            while (d < 0.0) {
                d += 360.0;
            }
            d %= 360.0;
            this.minVal = 0.0;
            this.maxVal = 360.0;
        } else if (this.idx == 1) {
            while (d < -90.0) {
                d += 180.0;
            }
            while (d > 90.0) {
                d -= 180.0;
            }
            this.minVal = -90.0;
            this.maxVal = 90.0;
        }
        return d;
    }

    private double getSpeed(boolean bl, int n) {
        boolean bl2;
        boolean bl3 = (this.tflags & 0x40000) != 0;
        boolean bl4 = (this.tflags & 0x80000) != 0;
        boolean bl5 = (this.tflags & 0x100000) != 0;
        boolean bl6 = (this.tflags & 0x8000) != 0;
        boolean bl7 = bl2 = (this.tflags & 8) != 0;
        if (bl6) {
            if (!this.sw.swed.geopos_is_set) {
                throw new IllegalArgumentException("Geographic position is not set for requested topocentric calculations.");
            }
            if (this.sw.swed.topd.geoalt > 50000.0) {
                throw new IllegalArgumentException("Topocentric transit calculations are restricted to a maximum altitude of 50km so far.");
            }
            if (this.sw.swed.topd.geoalt < -1.2E7) {
                throw new IllegalArgumentException("Topocentric transit calculations are restricted to a minimum altitude of -12000km so far.");
            }
            if (bl5) {
                if (bl3) {
                    return bl ? SwephData.minTopoLatAccel[n] : SwephData.maxTopoLatAccel[n];
                }
                if (bl4) {
                    return bl ? SwephData.minTopoDistAccel[n] : SwephData.maxTopoDistAccel[n];
                }
                return bl ? SwephData.minTopoLonAccel[n] : SwephData.maxTopoLonAccel[n];
            }
            if (bl3) {
                return bl ? SwephData.minTopoLatSpeed[n] : SwephData.maxTopoLatSpeed[n];
            }
            if (bl4) {
                return bl ? SwephData.minTopoDistSpeed[n] : SwephData.maxTopoDistSpeed[n];
            }
            return bl ? SwephData.minTopoLonSpeed[n] : SwephData.maxTopoLonSpeed[n];
        }
        if (bl2) {
            if (bl5) {
                if (bl3) {
                    return bl ? SwephData.minHelioLatAccel[n] : SwephData.maxHelioLatAccel[n];
                }
                if (bl4) {
                    return bl ? SwephData.minHelioDistAccel[n] : SwephData.maxHelioDistAccel[n];
                }
                return bl ? SwephData.minHelioLonAccel[n] : SwephData.maxHelioLonAccel[n];
            }
            if (bl3) {
                return bl ? SwephData.minHelioLatSpeed[n] : SwephData.maxHelioLatSpeed[n];
            }
            if (bl4) {
                return bl ? SwephData.minHelioDistSpeed[n] : SwephData.maxHelioDistSpeed[n];
            }
            return bl ? SwephData.minHelioLonSpeed[n] : SwephData.maxHelioLonSpeed[n];
        }
        if (bl5) {
            if (bl3) {
                return bl ? SwephData.minLatAccel[n] : SwephData.maxLatAccel[n];
            }
            if (bl4) {
                return bl ? SwephData.minDistAccel[n] : SwephData.maxDistAccel[n];
            }
            return bl ? SwephData.minLonAccel[n] : SwephData.maxLonAccel[n];
        }
        if (bl3) {
            return bl ? SwephData.minLatSpeed[n] : SwephData.maxLatSpeed[n];
        }
        if (bl4) {
            return bl ? SwephData.minDistSpeed[n] : SwephData.maxDistSpeed[n];
        }
        return bl ? SwephData.minLonSpeed[n] : SwephData.maxLonSpeed[n];
    }

    public String toString() {
        return "[Planets:" + this.pl1 + "/" + this.pl2 + "];Offset:" + this.getOffset();
    }
}

