/*
 * Decompiled with CFR 0.152.
 */
package org.mvel.optimizers.impl.refl;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.mvel.ASTNode;
import org.mvel.Accessor;
import org.mvel.AccessorNode;
import org.mvel.CompileException;
import org.mvel.ConversionException;
import org.mvel.DataConversion;
import org.mvel.ExecutableStatement;
import org.mvel.MVEL;
import org.mvel.OptimizationFailure;
import org.mvel.PropertyAccessException;
import org.mvel.SetAccessor;
import org.mvel.integration.VariableResolverFactory;
import org.mvel.optimizers.AbstractOptimizer;
import org.mvel.optimizers.AccessorOptimizer;
import org.mvel.optimizers.impl.refl.ArrayAccessor;
import org.mvel.optimizers.impl.refl.ArrayAccessorNest;
import org.mvel.optimizers.impl.refl.ArrayLength;
import org.mvel.optimizers.impl.refl.ConstructorAccessor;
import org.mvel.optimizers.impl.refl.DynamicFieldAccessor;
import org.mvel.optimizers.impl.refl.DynamicSetterAccessor;
import org.mvel.optimizers.impl.refl.FieldAccessor;
import org.mvel.optimizers.impl.refl.Fold;
import org.mvel.optimizers.impl.refl.GetterAccessor;
import org.mvel.optimizers.impl.refl.IndexedCharSeqAccessor;
import org.mvel.optimizers.impl.refl.IndexedCharSeqAccessorNest;
import org.mvel.optimizers.impl.refl.ListAccessor;
import org.mvel.optimizers.impl.refl.ListAccessorNest;
import org.mvel.optimizers.impl.refl.MapAccessor;
import org.mvel.optimizers.impl.refl.MapAccessorNest;
import org.mvel.optimizers.impl.refl.MethodAccessor;
import org.mvel.optimizers.impl.refl.SetterAccessor;
import org.mvel.optimizers.impl.refl.StaticReferenceAccessor;
import org.mvel.optimizers.impl.refl.StaticVarAccessor;
import org.mvel.optimizers.impl.refl.ThisValueAccessor;
import org.mvel.optimizers.impl.refl.Union;
import org.mvel.optimizers.impl.refl.VariableAccessor;
import org.mvel.optimizers.impl.refl.collection.ArrayCreator;
import org.mvel.optimizers.impl.refl.collection.ExprValueAccessor;
import org.mvel.optimizers.impl.refl.collection.ListCreator;
import org.mvel.optimizers.impl.refl.collection.MapCreator;
import org.mvel.util.ArrayTools;
import org.mvel.util.CollectionParser;
import org.mvel.util.MethodStub;
import org.mvel.util.ParseTools;
import org.mvel.util.PropertyTools;
import org.mvel.util.StringAppender;

public class ReflectiveAccessorOptimizer
extends AbstractOptimizer
implements AccessorOptimizer {
    private AccessorNode rootNode;
    private AccessorNode currNode;
    private Object ctx;
    private Object thisRef;
    private Object val;
    private VariableResolverFactory variableFactory;
    private static final int DONE = -1;
    private static final Object[] EMPTYARG = new Object[0];
    private static final Class[] EMPTYCLS = new Class[0];
    private boolean first = true;
    private static final Map<Integer, Accessor> REFLECTIVE_ACCESSOR_CACHE = new WeakHashMap<Integer, Accessor>();
    private Class returnType;

    public ReflectiveAccessorOptimizer() {
    }

    private ReflectiveAccessorOptimizer(char[] property, Object ctx, Object thisRef, VariableResolverFactory variableFactory) {
        this.expr = property;
        this.length = property != null ? property.length : 0;
        this.ctx = ctx;
        this.variableFactory = variableFactory;
        this.thisRef = thisRef;
    }

    private static int createSignatureHash(String expr, Object ctx) {
        if (ctx == null) {
            return expr.hashCode();
        }
        return expr.hashCode() + ctx.getClass().hashCode();
    }

    public static Object get(String expression, Object ctx) {
        int hash = ReflectiveAccessorOptimizer.createSignatureHash(expression, ctx);
        if (REFLECTIVE_ACCESSOR_CACHE.containsKey(new Integer(hash))) {
            return REFLECTIVE_ACCESSOR_CACHE.get(new Integer(hash)).getValue(ctx, null, null);
        }
        Accessor accessor = new ReflectiveAccessorOptimizer().optimizeAccessor(expression.toCharArray(), ctx, null, null, false);
        REFLECTIVE_ACCESSOR_CACHE.put(new Integer(hash), accessor);
        return accessor.getValue(ctx, null, null);
    }

    public Accessor optimizeAccessor(char[] property, Object ctx, Object thisRef, VariableResolverFactory factory, boolean root) {
        this.currNode = null;
        this.rootNode = null;
        this.cursor = 0;
        this.start = 0;
        this.first = true;
        this.expr = property;
        this.length = property.length;
        this.ctx = ctx;
        this.thisRef = thisRef;
        this.variableFactory = factory;
        return this.compileGetChain();
    }

    public SetAccessor optimizeSetAccessor(char[] property, Object ctx, Object thisRef, VariableResolverFactory factory, boolean rootThisRef, Object value) {
        this.currNode = null;
        this.rootNode = null;
        this.cursor = 0;
        this.start = 0;
        this.first = true;
        this.expr = property;
        this.length = property.length;
        this.ctx = ctx;
        this.thisRef = thisRef;
        this.variableFactory = factory;
        char[] root = null;
        boolean col = false;
        int split = -1;
        int i = property.length - 1;
        while (i != 0) {
            switch (property[i]) {
                case '[': {
                    split = i;
                    col = true;
                    break;
                }
                case '.': {
                    split = i;
                }
            }
            if (split != -1) break;
            --i;
        }
        if (split != -1) {
            root = ParseTools.subset(property, 0, split++);
            property = ParseTools.subset(property, split, property.length - split);
        }
        Accessor rootAccessor = null;
        if (root != null) {
            this.expr = root;
            this.length = root.length;
            rootAccessor = this.compileGetChain();
            ctx = this.val;
        }
        try {
            this.expr = property;
            this.length = property.length;
            this.start = 0;
            this.cursor = 0;
            this.whiteSpaceSkip();
            if (col) {
                int start = this.cursor;
                this.whiteSpaceSkip();
                if (this.cursor == this.length) {
                    throw new PropertyAccessException("unterminated '['");
                }
                if (!this.scanTo(']')) {
                    throw new PropertyAccessException("unterminated '['");
                }
                String ex = new String(property, start, this.cursor - start);
                if (ctx instanceof Map) {
                    ((Map)ctx).put(MVEL.eval(ex, ctx, this.variableFactory), value);
                    return new SetAccessor(rootAccessor, new MapAccessorNest(ex));
                }
                if (ctx instanceof List) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("java.lang.Integer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    ((List)ctx).set((Integer)MVEL.eval(ex, ctx, this.variableFactory, clazz), value);
                    return new SetAccessor(rootAccessor, new ListAccessorNest(ex));
                }
                if (ctx instanceof Object[]) {
                    try {
                        Class<?> clazz = Class.forName("java.lang.Integer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    ((Object[])ctx)[((Integer)MVEL.eval((String)ex, (Object)ctx, (VariableResolverFactory)this.variableFactory, clazz)).intValue()] = value;
                    return new SetAccessor(rootAccessor, new ArrayAccessorNest(ex));
                }
                throw new PropertyAccessException("cannot bind to collection property: " + new String(property) + ": not a recognized collection type: " + ctx.getClass());
            }
            String tk = new String(property);
            Member member = PropertyTools.getFieldOrWriteAccessor(ctx.getClass(), tk);
            if (member instanceof Field) {
                Field fld = (Field)member;
                if (value != null && !fld.getType().isAssignableFrom(value.getClass())) {
                    if (!DataConversion.canConvert(fld.getType(), value.getClass())) {
                        throw new ConversionException("cannot convert type: " + value.getClass() + ": to " + fld.getType());
                    }
                    fld.set(ctx, DataConversion.convert(value, fld.getType()));
                    return new SetAccessor(rootAccessor, new DynamicFieldAccessor(fld));
                }
                fld.set(ctx, value);
                return new SetAccessor(rootAccessor, new FieldAccessor(fld));
            }
            if (member != null) {
                Method meth = (Method)member;
                if (value != null && !meth.getParameterTypes()[0].isAssignableFrom(value.getClass())) {
                    if (!DataConversion.canConvert(meth.getParameterTypes()[0], value.getClass())) {
                        throw new ConversionException("cannot convert type: " + value.getClass() + ": to " + meth.getParameterTypes()[0]);
                    }
                    meth.invoke(ctx, DataConversion.convert(value, meth.getParameterTypes()[0]));
                    return new SetAccessor(rootAccessor, new SetterAccessor(meth));
                }
                meth.invoke(ctx, value);
                return new SetAccessor(rootAccessor, new DynamicSetterAccessor(meth));
            }
            if (ctx instanceof Map) {
                ((Map)ctx).put(tk, value);
                return new SetAccessor(rootAccessor, new MapAccessorNest(tk));
            }
            throw new PropertyAccessException("could not access property (" + tk + ") in: " + ctx.getClass().getName());
        }
        catch (InvocationTargetException e) {
            throw new PropertyAccessException("could not access property", e);
        }
        catch (IllegalAccessException e) {
            throw new PropertyAccessException("could not access property", e);
        }
    }

    private Accessor compileGetChain() {
        Object curr = this.ctx;
        try {
            while (this.cursor < this.length) {
                switch (this.nextSubToken()) {
                    case 0: {
                        curr = this.getBeanProperty(curr, this.capture());
                        break;
                    }
                    case 1: {
                        curr = this.getMethod(curr, this.capture());
                        break;
                    }
                    case 2: {
                        curr = this.getCollectionProperty(curr, this.capture());
                        break;
                    }
                }
                this.first = false;
                if (curr == null) continue;
                this.returnType = curr.getClass();
            }
            this.val = curr;
            return this.rootNode;
        }
        catch (InvocationTargetException e) {
            throw new PropertyAccessException(new String(this.expr), e);
        }
        catch (IllegalAccessException e) {
            throw new PropertyAccessException(new String(this.expr), e);
        }
        catch (IndexOutOfBoundsException e) {
            throw new PropertyAccessException(new String(this.expr), e);
        }
        catch (PropertyAccessException e) {
            throw new CompileException(e.getMessage(), e);
        }
        catch (CompileException e) {
            throw e;
        }
        catch (NullPointerException e) {
            throw new PropertyAccessException(new String(this.expr), e);
        }
        catch (Exception e) {
            throw new CompileException(e.getMessage(), e);
        }
    }

    private void addAccessorNode(AccessorNode an) {
        if (this.rootNode == null) {
            this.rootNode = this.currNode = an;
        } else {
            this.currNode = this.currNode.setNextNode(an);
        }
    }

    private Object getBeanProperty(Object ctx, String property) throws IllegalAccessException, InvocationTargetException {
        Member member;
        if (this.first && this.variableFactory != null && this.variableFactory.isResolveable(property)) {
            this.addAccessorNode(new VariableAccessor(property, this.variableFactory));
            return this.variableFactory.getVariableResolver(property).getValue();
        }
        Class<?> cls = ctx instanceof Class ? (Class<?>)ctx : (ctx != null ? ctx.getClass() : null);
        Member member2 = member = cls != null ? PropertyTools.getFieldOrAccessor(cls, property) : null;
        if (member instanceof Field) {
            this.addAccessorNode(new FieldAccessor((Field)member));
            return ((Field)member).get(ctx);
        }
        if (member != null) {
            Object o;
            try {
                o = ((Method)member).invoke(ctx, EMPTYARG);
                this.addAccessorNode(new GetterAccessor((Method)member));
            }
            catch (IllegalAccessException e) {
                Method iFaceMeth = ParseTools.determineActualTargetMethod((Method)member);
                this.addAccessorNode(new GetterAccessor(iFaceMeth));
                o = iFaceMeth.invoke(ctx, EMPTYARG);
            }
            return o;
        }
        if (ctx instanceof Map && ((Map)ctx).containsKey(property)) {
            this.addAccessorNode(new MapAccessor(property));
            return ((Map)ctx).get(property);
        }
        if ("this".equals(property)) {
            this.addAccessorNode(new ThisValueAccessor());
            return this.thisRef;
        }
        if (LITERALS.containsKey(property)) {
            ctx = LITERALS.get(property);
            this.addAccessorNode(new StaticReferenceAccessor(ctx));
            return ctx;
        }
        Object tryStaticMethodRef = this.tryStaticAccess();
        if (tryStaticMethodRef != null) {
            if (tryStaticMethodRef instanceof Class) {
                this.addAccessorNode(new StaticReferenceAccessor(tryStaticMethodRef));
                return tryStaticMethodRef;
            }
            this.addAccessorNode(new StaticVarAccessor((Field)tryStaticMethodRef));
            return ((Field)tryStaticMethodRef).get(null);
        }
        if (ctx instanceof Class) {
            Class c = (Class)ctx;
            Method[] methodArray = c.getMethods();
            int n = 0;
            int n2 = methodArray.length;
            while (n < n2) {
                Method m = methodArray[n];
                if (property.equals(m.getName())) {
                    this.addAccessorNode(new StaticReferenceAccessor(m));
                    return m;
                }
                ++n;
            }
        }
        throw new PropertyAccessException(property);
    }

    private Object getCollectionProperty(Object ctx, String prop) throws Exception {
        if (prop.length() > 0) {
            ctx = this.getBeanProperty(ctx, prop);
        }
        int start = ++this.cursor;
        this.whiteSpaceSkip();
        if (this.cursor == this.length) {
            throw new CompileException("unterminated '['");
        }
        if (!this.scanTo(']')) {
            throw new CompileException("unterminated '['");
        }
        String item = new String(this.expr, start, this.cursor - start);
        boolean itemSubExpr = true;
        Object idx = null;
        try {
            idx = new Integer(Integer.parseInt(item));
            itemSubExpr = false;
        }
        catch (Exception exception) {
            // empty catch block
        }
        ExecutableStatement itemStmt = null;
        if (itemSubExpr) {
            itemStmt = (ExecutableStatement)ParseTools.subCompileExpression(item);
            idx = itemStmt.getValue(ctx, this.thisRef, this.variableFactory);
        }
        ++this.cursor;
        if (ctx instanceof Map) {
            if (itemSubExpr) {
                this.addAccessorNode(new MapAccessorNest(itemStmt));
            } else {
                this.addAccessorNode(new MapAccessor(new Integer(Integer.parseInt(item))));
            }
            return ((Map)ctx).get(idx);
        }
        if (ctx instanceof List) {
            if (itemSubExpr) {
                this.addAccessorNode(new ListAccessorNest(itemStmt));
            } else {
                this.addAccessorNode(new ListAccessor(Integer.parseInt(item)));
            }
            return ((List)ctx).get((Integer)idx);
        }
        if (ctx instanceof Object[]) {
            if (itemSubExpr) {
                this.addAccessorNode(new ArrayAccessorNest(itemStmt));
            } else {
                this.addAccessorNode(new ArrayAccessor(Integer.parseInt(item)));
            }
            return ((Object[])ctx)[(Integer)idx];
        }
        if (ctx instanceof CharSequence) {
            if (itemSubExpr) {
                this.addAccessorNode(new IndexedCharSeqAccessorNest(itemStmt));
            } else {
                this.addAccessorNode(new IndexedCharSeqAccessor(Integer.parseInt(item)));
            }
            return new Character(((CharSequence)ctx).charAt((Integer)idx));
        }
        throw new CompileException("illegal use of []: unknown type: " + (ctx == null ? null : ctx.getClass().getName()));
    }

    private Object getMethod(Object ctx, String name) throws Exception {
        Accessor[] es;
        Object[] args;
        if (this.first && this.variableFactory != null && this.variableFactory.isResolveable(name)) {
            Object ptr = this.variableFactory.getVariableResolver(name).getValue();
            if (ptr instanceof Method) {
                ctx = ((Method)ptr).getDeclaringClass();
                name = ((Method)ptr).getName();
            } else if (ptr instanceof MethodStub) {
                ctx = ((MethodStub)ptr).getClassReference();
                name = ((MethodStub)ptr).getMethodName();
            } else {
                throw new OptimizationFailure("attempt to optimize a method call for a reference that does not point to a method: " + name + " (reference is type: " + (ctx != null ? ctx.getClass().getName() : null) + ")");
            }
            this.first = false;
        }
        int st = this.cursor;
        this.cursor = ParseTools.balancedCapture(this.expr, this.cursor, '(');
        String tk = this.cursor - st > 1 ? new String(this.expr, st + 1, this.cursor - st - 1) : "";
        ++this.cursor;
        if (tk.length() == 0) {
            args = ParseTools.EMPTY_OBJ_ARR;
            es = null;
        } else {
            String[] subtokens = ParseTools.parseParameterList(tk.toCharArray(), 0, -1);
            es = new ExecutableStatement[subtokens.length];
            args = new Object[subtokens.length];
            int i = 0;
            while (i < subtokens.length) {
                es[i] = (ExecutableStatement)ParseTools.subCompileExpression(subtokens[i]);
                args[i] = es[i].getValue(this.ctx, this.thisRef, this.variableFactory);
                ++i;
            }
        }
        Class<?> cls = ctx instanceof Class ? ctx : ctx.getClass();
        Class[] parameterTypes = null;
        Method m = ParseTools.getBestCandidate(args, name, cls.getMethods());
        if (m != null) {
            parameterTypes = m.getParameterTypes();
        }
        if (m == null && (m = ParseTools.getBestCandidate(args, name, cls.getClass().getDeclaredMethods())) != null) {
            parameterTypes = m.getParameterTypes();
        }
        if (m == null) {
            StringAppender errorBuild = new StringAppender();
            int i = 0;
            while (i < args.length) {
                errorBuild.append(args[i] != null ? args[i].getClass().getName() : null);
                if (i < args.length - 1) {
                    errorBuild.append(", ");
                }
                ++i;
            }
            if ("size".equals(name) && args.length == 0 && cls.isArray()) {
                this.addAccessorNode(new ArrayLength());
                return new Integer(Array.getLength(ctx));
            }
            throw new PropertyAccessException("unable to resolve method: " + cls.getName() + "." + name + "(" + errorBuild.toString() + ") [arglength=" + args.length + "]");
        }
        if (es != null) {
            int i = 0;
            while (i < es.length) {
                ExecutableStatement cExpr = (ExecutableStatement)es[i];
                if (cExpr.getKnownIngressType() == null) {
                    cExpr.setKnownIngressType(parameterTypes[i]);
                    cExpr.computeTypeConversionRule();
                }
                if (!cExpr.isConvertableIngressEgress()) {
                    args[i] = DataConversion.convert(args[i], parameterTypes[i]);
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < args.length) {
                args[i] = DataConversion.convert(args[i], parameterTypes[i]);
                ++i;
            }
        }
        this.addAccessorNode(new MethodAccessor(ParseTools.getWidenedTarget(m), (ExecutableStatement[])es));
        return m.invoke(ctx, args);
    }

    public Object getValue(Object ctx, Object elCtx, VariableResolverFactory variableFactory) throws Exception {
        return this.rootNode.getValue(ctx, elCtx, variableFactory);
    }

    public static void main(String[] args) {
        new ReflectiveAccessorOptimizer().optimizeCollection("[test, foo, bar, {1,2,3}]".toCharArray(), null, null, null);
    }

    private Accessor _getAccessor(Object o) {
        Class<?> clazz;
        if (o instanceof List) {
            Class<?> clazz2;
            Accessor[] a = new Accessor[((List)o).size()];
            int i = 0;
            Iterator iterator = ((List)o).iterator();
            while (iterator.hasNext()) {
                Object item = iterator.next();
                a[i++] = this._getAccessor(item);
            }
            try {
                clazz2 = Class.forName("java.util.List");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            this.returnType = clazz2;
            return new ListCreator(a);
        }
        if (o instanceof Map) {
            Class<?> clazz3;
            Accessor[] k = new Accessor[((Map)o).size()];
            Accessor[] v = new Accessor[k.length];
            int i = 0;
            Iterator iterator = ((Map)o).keySet().iterator();
            while (iterator.hasNext()) {
                Object item = iterator.next();
                k[i] = this._getAccessor(item);
                v[i++] = this._getAccessor(((Map)o).get(item));
            }
            try {
                clazz3 = Class.forName("java.util.Map");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            this.returnType = clazz3;
            return new MapCreator(k, v);
        }
        if (o instanceof Object[]) {
            Class<?> clazz4;
            Accessor[] a = new Accessor[((Object[])o).length];
            int i = 0;
            Object[] objectArray = (Object[])o;
            int n = 0;
            int n2 = objectArray.length;
            while (n < n2) {
                Object item = objectArray[n];
                a[i++] = this._getAccessor(item);
                ++n;
            }
            try {
                clazz4 = Class.forName("[Ljava.lang.Object;");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            this.returnType = clazz4;
            return new ArrayCreator(a);
        }
        try {
            clazz = Class.forName("java.lang.Object");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        this.returnType = clazz;
        return new ExprValueAccessor((String)o);
    }

    public Accessor optimizeCollection(char[] property, Object ctx, Object thisRef, VariableResolverFactory factory) {
        CollectionParser parser = new CollectionParser();
        ctx = ((List)parser.parseCollection(property)).get(0);
        Accessor root = this._getAccessor(ctx);
        int end = parser.getCursor() + 2;
        if (end < property.length) {
            return new Union(root, ParseTools.subset(property, end));
        }
        return root;
    }

    public Accessor optimizeObjectCreation(char[] property, Object ctx, Object thisRef, VariableResolverFactory factory) {
        this.expr = property;
        this.length = property.length;
        this.cursor = 0;
        try {
            return this.compileConstructor(property, ctx, factory);
        }
        catch (CompileException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CompileException("could not create constructor: " + e.getMessage(), e);
        }
    }

    public Accessor optimizeFold(char[] property, Object ctx, Object thisRef, VariableResolverFactory factory) {
        this.expr = property;
        this.length = property.length;
        this.cursor = 0;
        this.greedy = false;
        if (this.expr[this.cursor] == '(') {
            this.length = this.cursor = ParseTools.balancedCapture(this.expr, this.cursor, '(');
            this.cursor = 1;
        }
        ASTNode var = this.nextToken();
        if (!this.nextToken().isOperator(new Integer(34))) {
            throw new CompileException("expected fold operator");
        }
        this.greedy = true;
        Fold fold = new Fold(var.getNameAsArray(), new ExprValueAccessor(this.nextToken().getName()));
        if (this.length < property.length - 1) {
            this.cursor += 2;
            Union union = new Union(fold, ParseTools.subset(property, this.cursor));
            this.val = union.getValue(ctx, thisRef, factory);
            return union;
        }
        this.val = fold.getValue(ctx, thisRef, factory);
        return fold;
    }

    private void setRootNode(AccessorNode rootNode) {
        this.rootNode = this.currNode = rootNode;
    }

    private AccessorNode getRootNode() {
        return this.rootNode;
    }

    public Object getResultOptPass() {
        return this.val;
    }

    public AccessorNode compileConstructor(char[] expression, Object ctx, VariableResolverFactory vars) throws InstantiationException, IllegalAccessException, InvocationTargetException, ClassNotFoundException, NoSuchMethodException {
        String[] cnsRes = ParseTools.captureContructorAndResidual(expression);
        String[] constructorParms = ParseTools.parseMethodOrConstructor(cnsRes[0].toCharArray());
        if (constructorParms != null) {
            String s = new String(ParseTools.subset(expression, 0, ArrayTools.findFirst('(', expression)));
            Class cls = ParseTools.findClass(vars, s);
            ExecutableStatement[] cStmts = new ExecutableStatement[constructorParms.length];
            int i = 0;
            while (i < constructorParms.length) {
                cStmts[i] = (ExecutableStatement)ParseTools.subCompileExpression(constructorParms[i]);
                ++i;
            }
            Object[] parms = new Object[constructorParms.length];
            int i2 = 0;
            while (i2 < constructorParms.length) {
                parms[i2] = cStmts[i2].getValue(ctx, vars);
                ++i2;
            }
            Constructor cns = ParseTools.getBestConstructorCanadidate(parms, cls);
            if (cns == null) {
                throw new CompileException("unable to find constructor for: " + cls.getName());
            }
            int i3 = 0;
            while (i3 < parms.length) {
                parms[i3] = DataConversion.convert(parms[i3], cns.getParameterTypes()[i3]);
                ++i3;
            }
            AccessorNode ca = new ConstructorAccessor(cns, cStmts);
            if (cnsRes.length > 1) {
                ReflectiveAccessorOptimizer compiledOptimizer = new ReflectiveAccessorOptimizer(cnsRes[1].toCharArray(), cns.newInstance(parms), ctx, vars);
                compiledOptimizer.setRootNode(ca);
                compiledOptimizer.compileGetChain();
                ca = compiledOptimizer.getRootNode();
                this.val = compiledOptimizer.getResultOptPass();
            }
            return ca;
        }
        Constructor<?> cns = Thread.currentThread().getContextClassLoader().loadClass(new String(expression)).getConstructor(EMPTYCLS);
        AccessorNode ca = new ConstructorAccessor(cns, null);
        if (cnsRes.length > 1) {
            ReflectiveAccessorOptimizer compiledOptimizer = new ReflectiveAccessorOptimizer(cnsRes[1].toCharArray(), cns.newInstance(null), ctx, vars);
            compiledOptimizer.setRootNode(ca);
            compiledOptimizer.compileGetChain();
            ca = compiledOptimizer.getRootNode();
            this.val = compiledOptimizer.getResultOptPass();
        }
        return ca;
    }

    public Class getEgressType() {
        return this.returnType;
    }
}

