/*
 * Decompiled with CFR 0.152.
 */
package org.drools.xml;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.ListIterator;
import org.drools.lang.descr.AccumulateDescr;
import org.drools.lang.descr.BaseDescr;
import org.drools.lang.descr.PatternDescr;
import org.drools.xml.BaseAbstractHandler;
import org.drools.xml.Configuration;
import org.drools.xml.Handler;
import org.drools.xml.XmlPackageReader;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class AccumulateHelperHandler
extends BaseAbstractHandler
implements Handler {
    AccumulateHelperHandler(XmlPackageReader xmlPackageReader) {
        this.xmlPackageReader = xmlPackageReader;
        if (this.validParents == null && this.validPeers == null) {
            this.validParents = new HashSet();
            this.validParents.add(AccumulateDescr.class);
            this.validPeers = new HashSet();
            this.validPeers.add(null);
            this.validPeers.add(PatternDescr.class);
            this.validPeers.add(BaseDescr.class);
            this.allowNesting = true;
        }
    }

    public Object end(String uri, String localName) throws SAXException {
        Configuration config = this.xmlPackageReader.endConfiguration();
        BaseDescr baseDescr = (BaseDescr)this.xmlPackageReader.getCurrent();
        String expression = config.getText();
        if (expression == null) {
            throw new SAXParseException("<" + localName + "> must have some content", this.xmlPackageReader.getLocator());
        }
        LinkedList parents = this.xmlPackageReader.getParents();
        ListIterator ite = parents.listIterator(parents.size());
        ite.previous();
        Object parent = ite.previous();
        AccumulateDescr accumulate = (AccumulateDescr)parent;
        if (localName.equals("init")) {
            accumulate.setInitCode(expression.trim());
        } else if (localName.equals("action")) {
            accumulate.setActionCode(expression.trim());
        } else if (localName.equals("result")) {
            accumulate.setResultCode(expression.trim());
        } else if (localName.equals("reverse")) {
            accumulate.setReverseCode(expression.trim());
        } else if (localName.equals("external-function")) {
            accumulate.setExternalFunction(true);
            accumulate.setFunctionIdentifier(config.getAttribute("evaluator"));
            accumulate.setExpression(config.getAttribute("expression"));
        }
        return null;
    }

    public Class generateNodeFor() {
        return BaseDescr.class;
    }

    public Object start(String uri, String localName, Attributes attrs) throws SAXException {
        this.xmlPackageReader.startConfiguration(localName, attrs);
        return new BaseDescr();
    }
}

