/*

	This is the source code of

   	M A I T R E Y A
    ===============

	Open source platform for Vedic and western astrology

  File           ApplicationWindow.h
  Release        4.1
  Author         Martin Pettau
  Copyright (C)  2003-2006 by the author

  Released under the Artistic License as published by the
  Free Software Foundation, read the file 'COPYING' for more information.

*/

#ifndef _APPLICATIONWINDOW_H_
#define _APPLICATIONWINDOW_H_

#ifdef __GNUG__
	#pragma interface "ApplicationWindow.h"
#endif

#include <wx/app.h>
#include <wx/frame.h>

class AppMenuBar;
class ChildWindow;
class Document;
class DocumentManager;
class MainWindowControl;
class MyStatusbar;
class MyToolBar;

class wxEvent;
class wxLog;
class wxListEvent;
class wxTextCtrl;

/*****************************************************
**
**   CLASS MaitreyaApp  
**
******************************************************/
class MaitreyaApp : public wxApp
{
public:
  MaitreyaApp();

protected:
	virtual bool OnInit();
	virtual int OnExit();
};

/*****************************************************
**
**   CLASS ApplicationWindow  
**
******************************************************/
class ApplicationWindow : public wxFrame
{
	DECLARE_CLASS( ApplicationWindow )
public:
	//ApplicationWindow( const wxChar *title, wxLocale& m_locale, int xpos, int ypos, int width, int height );
	ApplicationWindow( const wxChar *title, int xpos, int ypos, int width, int height );
	~ApplicationWindow();
	void NewFile();
	bool OpenFile( wxString );
	void CreateNewChild( Document* );

protected:
	void AddChild( ChildWindow* );
	void SetActiveChild( ChildWindow* );
	void OnChildClose( ChildWindow* );
	void updateMenusAndToolbars( ChildWindow* );
	void OnOpenRecent( wxCommandEvent& );
	void OnFileNew( wxCommandEvent& );
	void OnFileOpen( wxCommandEvent& );
	void OnFileQuit( wxCommandEvent& );
	void OnNewChild( wxCommandEvent& );
	void OnChildCommand( wxCommandEvent& );
	void OnSaveConfig( wxCommandEvent& );
	void OnConfigure( wxCommandEvent& );
	void OnLocationDialog( wxCommandEvent& );
	void OnAppAbout( wxCommandEvent& );
	void OnAppHelp( wxCommandEvent& );
	void OnClose( wxCloseEvent& );
	void showStatusBar();
	void showToolBars();
	void OnToggleToolBars( wxCommandEvent& );
	void OnToggleStatusBar( wxCommandEvent& );
	void OnToggleIcons( wxCommandEvent& );
	void OnConfigChanged( wxCommandEvent& );
	void OnDropFilesEvent( wxDropFilesEvent& );
	wxStatusBar* OnCreateStatusBar(int number, long style, wxWindowID id, const wxString& name);
	void saveConfig();
	void OnEventTest( wxCommandEvent& );
	void OnListItemSelected( wxListEvent& );
	void OnChildFocusEvent( wxCommandEvent& );
	void OnChildCloseEvent( wxCommandEvent& );
	void OnNewChildEvent( wxCommandEvent& );
	void OnDocSavedEvent( wxCommandEvent& );
	void OnDocUpdateEvent( wxCommandEvent& );
	void OnCreateEntryChart( wxCommandEvent& );
	void echo( const wxChar* );

	DocumentManager *docmanager;
	MyStatusbar *statusbar;
	MainWindowControl *listctrl;
	wxLog *m_logTargetOld;
	wxTextCtrl *m_text;
	AppMenuBar *menubar;
	MyToolBar *maintoolbar;
	bool docommands;
	DECLARE_EVENT_TABLE()
};

#endif

