/*

	This is the source code of

   	M A I T R E Y A
    ===============

	Open source platform for Vedic and western astrology

  File           Base.h
  Release        4.1
  Author         Martin Pettau
  Copyright (C)  2003-2006 by the author

  Released under the Artistic License as published by the
  Free Software Foundation, read the file 'COPYING' for more information.

*/


#ifndef _BASE_H_
#define _BASE_H_

#ifdef __GNUG__
	#pragma interface "Base.h"
#endif

#include "Session.h"

#include <wx/dynarray.h>
#include <wx/event.h>
#include <wx/intl.h>
#include <wx/textctrl.h>
#include <wx/scrolwin.h>
#include <wx/splitter.h>
#include <wx/statusbr.h>


class Horoscope;
class wxDC;
class wxTimer;
class wxTimerEvent;
class wxHtmlWindow;
class wxWindow;
class Writer;

class Document;
WX_DECLARE_LIST( Document, Documents );

class ChildWindow;
WX_DECLARE_LIST( ChildWindow, ChildWindowList );

//class GraphicalDasaItem;
//WX_DECLARE_LIST( GraphicalDasaItem, GraphicalDasaItems );

#define TOOLPANEL 20000

#define DEFAULT_DIALOG_STYLE wxRESIZE_BORDER|wxSYSTEM_MENU|wxMAXIMIZE_BOX|wxCLOSE_BOX|wxCAPTION

BEGIN_DECLARE_EVENT_TYPES()
  DECLARE_EVENT_TYPE( TOOLPANEL_CHANGED, 20003 )
  DECLARE_EVENT_TYPE( TOOLPANEL_CREATEDOC, 20004 )
END_DECLARE_EVENT_TYPES()

enum { CHILD_FIRST = wxID_HIGHEST + 100, CHILD_CLOSE, CHILD_CLOSE_DOC, CHILD_EDITDATA,
	VIEW_PREFERINDIAN, VIEW_PREFERWESTERN, CHILD_WSHOWASPECTS, CHILD_WSHOWRETRO,
	CHILD_WSHOWHOUSES, CHILD_WSHOWURANIAN,
	CHILD_ISHOWRETRO, CHILD_ISHOWARUDHA, CHILD_ISHOWLAGNAS, CHILD_ISHOWEAST, CHILD_ISHOWNORTH,
	CHILD_ISHOWSOUTH, CHILD_EXPORT, CHILD_SAVETEXT, CHILD_ANIMATE, CHILD_DUMMY, CHILD_HSEBERTIN,
	CHILD_HSWITTE, CHILD_MAIN_ISTYLE, CHILD_MAIN_SHOW_NAVAMSA, CHILD_MAIN_SHOW_KARAKA,
	CHILD_MAIN_SHOW_SHASTIAMSA, CHILD_MAIN_SHOW_NAKSHATRA, CHILD_MAIN_SHOW_DASAVARGA,
	CHILD_MAIN_SHOW_BHAVA, CHILD_MAIN_SHOW_KP, CHILD_MAIN_SHOW_LAGNAS, CHILD_MAIN_SHOW_UPA,
	CHILD_MAIN_SHOW_ASHTAKA, CHILD_MAIN_SHOW_PADA, CHILD_SELECT_FONT, CHILD_MAIN_WSTYLE,
	CHILD_MAIN_SHOW_IHOUSES, CHILD_MAIN_SHOW_WHOUSES, CHILD_MAIN_SHOW_HOUSEPOS, CHILD_MAIN_SHOW_URANIAN,
	CHILD_COPY, CHILD_SELECT_ALL, CHILD_PARTNER_TEXT, CHILD_PARTNER_COMPOSIT,
	CHILD_SAVE, CHILD_SAVEAS, CHILD_TEXTCTRL, CHILD_PRINT, CHILD_QUICKPRINT,
	CHILD_NEW_TEXT, CHILD_NEW_TRANSIT, CHILD_NEW_SBC, CHILD_NEW_SOLAR, CHILD_NEW_YOGA,
	CHILD_NEW_GRAPHICALDASA,
	CHILD_NEW_DASA, CHILD_NEW_MIDPOINT, CHILD_NEW_WCHART, CHILD_NEW_PLANETLIST, 
	CHILD_NEW_RASI
};

enum { VIEW_TEXT, VIEW_TRANSIT, VIEW_SBC, VIEW_SOLAR, VIEW_YOGA, VIEW_GRAPHICALDASA, VIEW_DASA, VIEW_MIDPOINT,
	VIEW_GRAPHIC, VIEW_PLANETLIST, VIEW_HORA, VIEW_ECLIPSE, VIEW_PARTNER, VIEW_EPHEM, VIEW_MULTIPLE };

#define CHILD_LAST CHILD_NEWRASI+50

enum { APP_FIRST = wxID_HIGHEST + 1, APP_FILENEW, APP_FILE_NEW_SIMPLE, APP_NEW_MULTIPLE,
	APP_FILEOPEN, APP_FILEQUIT, APP_LISTCTRL, APP_SHOWHORA, APP_SHOWECLIPSE, APP_NEW_PARTNER,
	APP_HELP, APP_SHOWEPHEM, APP_SHOWSTATUSBAR, APP_SHOWMAINTOOLBAR, APP_SAVECONFIG,
	APP_CONFIGURE, APP_LOCATION, APP_ABOUT, APP_LIST_BIGICONS, APP_LIST_SMALLICONS, APP_LIST_TABLE,
	APP_FILERECENT
};

#define APP_LAST APP_FILERECENT+100
#define CONFIG_DIALOG APP_FILERECENT+2100

// Color helper
void getRGB( const int &color, unsigned char &red, unsigned char &green, unsigned char &blue );
int setRGB( const unsigned char &red, const unsigned char &green, const unsigned char &blue );


// Message box functions
int doMessageBox( wxWindow *parent, const wxString message, const long style = wxOK | wxICON_INFORMATION );
void tellThatRestartIsRecommended( wxWindow* );

int mapCommand2ViewId( const int &command, int &vedic, int &subtype );

// Sizing stuff
wxSize getSizeForViewId( const int &viewId, const bool vedic = true );
void setConfigSizeForViewId( const int &viewId, const wxSize &size, const bool vedic = true );
void moveWindow2Center( wxWindow *w );

/*****************************************************
**
**   CLASS MyEventPropagator
**
******************************************************/
class MyEventPropagator : public wxEvtHandler
{
public:
	MyEventPropagator();

protected:
	virtual void OnContextMenuEvent( wxMouseEvent& event);
	void OnKeyDown( wxKeyEvent& );

private:
	DECLARE_CLASS( MyEventPropagator )
	DECLARE_EVENT_TABLE()
};

/*****************************************************
**
**   CLASS MySplitter
**
******************************************************/
class MySplitter : public wxSplitterWindow
{
public:
	MySplitter( wxWindow *parent, const wxWindowID = -1, const wxPoint &pos = wxDefaultPosition,
		const wxSize size = wxDefaultSize, long style=wxSP_3D );

protected:
	void OnMouseRight( wxMouseEvent& );
	void OnPaint( wxPaintEvent& );
	virtual void OnSize( wxSizeEvent& );
	void OnPositionChanged( wxSplitterEvent& );

private:
	DECLARE_CLASS( MySplitter )
	DECLARE_EVENT_TABLE()
};

/*****************************************************
**
**   CLASS MyStatusbar  
**
******************************************************/
class MyStatusbar : public wxStatusBar
{
	DECLARE_CLASS( MyStatusbar )
public:
	MyStatusbar( wxWindow *parent );
	~MyStatusbar();
	void StartPlanetTimer( bool );
	void echo( const wxChar*, const int = 1 );
	DECLARE_EVENT_TABLE()
private:
	wxTimer *planettimer, *msgtimer;
	void OnPlanetTimer( wxTimerEvent& );
	void OnMessageTimer( wxTimerEvent& );
};

/*****************************************************
**
**   CLASS TextWidget
**
******************************************************/
class TextWidget : public wxWindow
{
public:
	TextWidget( wxWindow *parent, const int &htmlmode, wxWindowID id = -1, const wxPoint& pos = wxDefaultPosition,
	    const wxSize& size = wxDefaultSize );
	void doExport( wxString& );
	void doCopy();
	void selectAll();
	void setContents( const wxString& );
	Writer *getWriter() { return writer; }

protected:
	wxTextCtrl *textctrl;
	wxHtmlWindow *htmlctrl;
	int htmlmode;
	Writer *writer;
	virtual void OnSize( wxSizeEvent& );

private:
	DECLARE_CLASS( TextWidget )
	DECLARE_EVENT_TABLE()
};

/*****************************************************
**
**   CLASS PlanetaryPositionTextCtrl
**
******************************************************/
class  PlanetaryPositionTextCtrl : public  TextWidget
{
public:
	PlanetaryPositionTextCtrl( wxWindow *parent, Horoscope *h, const int htmlmode = true, wxWindowID id = -1,
		const wxPoint& pos = wxDefaultPosition, const wxSize& size = wxDefaultSize );
	void setPreferVedic( const bool &v ) { preferVedic = v; }
	void setPrefix( const wxString &s ) { prefix = s; }
	void setEmptyMessage( const wxString &s ) { emptyMessage = s; }
	void setEmpty( const bool e = true ) { isEmpty = e; }
	void dump();
	void setIStyle( const int &style ) { istyle = style; }
	void setWStyle( const int &style ) { wstyle = style; }
	bool dispatchCommand( const int &command );

protected:
	Horoscope *horoscope;
	wxString emptyMessage, prefix;
	bool preferVedic, isEmpty;
	int istyle, wstyle;

private:
	DECLARE_CLASS( PlanetaryPositionTextCtrl )
	//DECLARE_EVENT_TABLE()
};

/*****************************************************
**
**   CLASS Align
**
******************************************************/
class Align
{
public:
	static int Center, VCenter, Bottom, Top, HCenter, Left, Right;
};

/*****************************************************
**
**   CLASS DcHelper
**
******************************************************/
class DcHelper
{
public:
	DcHelper( wxDC *d ) { dc = d; }
	void drawTextFormatted( const wxRect &rect, const wxString t, const int& align );

protected:
	wxDC* dc;

private:
	DcHelper() {} // not available
};

/*****************************************************
**
**   CLASS ExportableScrollWidget
**
******************************************************/
class ExportableScrollWidget :  public wxScrolledWindow
{
public:
  ExportableScrollWidget( wxWindow *parent, wxWindowID id = -1, const wxPoint& pos = wxDefaultPosition,
		const wxSize& size = wxDefaultSize );
	void setPreferVedic( bool b ) { preferVedic = b; }
	void doExport();

protected:
	wxDC* dc;
	int hborder, vborder;
	bool preferVedic;

	void OnPaint( wxPaintEvent& );
	virtual void doPaint( wxDC* ) = 0;

	void OnMouseMotion( wxMouseEvent& );
	void OnMouseLeftDown( wxMouseEvent& );
	void OnMouseLeftUp( wxMouseEvent& );
	void OnMouseLeave( wxMouseEvent& );
	void drawTextFormatted( const wxRect &rect, const wxString t, const int& align );
	void drawSimpleText( const wxRect &r, const wxString &s );
	bool dragMode;
	int scrollx, scrolly;
	int mousex, mousey;

private:
	DECLARE_CLASS( ExportableScrollWidget )
	DECLARE_EVENT_TABLE()
};


#endif

