/*

	This is the source code of

   	M A I T R E Y A
    ===============

	Open source platform for Vedic and western astrology

  File           ChildWindow.h
  Release        4.1
  Author         Martin Pettau
  Copyright (C)  2003-2006 by the author

  Released under the Artistic License as published by the
  Free Software Foundation, read the file 'COPYING' for more information.

*/

#ifndef _CHILDWINDOW_H_
#define _CHILDWINDOW_H_

#ifdef __GNUG__
	#pragma interface "ChildWindow.h"
#endif

#include <wx/frame.h>
#include <vector>

#include "Base.h"

class Document;
class DocumentManager;
class MView;
class ViewContainer;
class ViewNode;
class wxMenu;
class wxImageList;

using namespace std;

BEGIN_DECLARE_EVENT_TYPES()
  DECLARE_EVENT_TYPE( CHILD_ADDTORECENT, 9600 )
  DECLARE_EVENT_TYPE( CHILD_SETACTIVE, 9601 )
  DECLARE_EVENT_TYPE( CHILD_CLOSED, 9602 )
  DECLARE_EVENT_TYPE( CHILD_ADDED, 9603 )
END_DECLARE_EVENT_TYPES()

/*****************************************************
**
**   CLASS ChildWindow  
**
******************************************************/
class ChildWindow : public wxFrame
{
public:
	ChildWindow( wxFrame *parent, Document *doc, const wxSize& size = wxDefaultSize, const bool ismain = false );
	~ChildWindow();

	virtual bool dispatchCommand( const int &command );

	virtual bool getPreferVedic() = 0;
	virtual bool supportsEWToggle() = 0;
	virtual void setTitle() {}
	virtual int getViewId() = 0;

	virtual void OnDataChanged();
	Document *getDoc() { return doc; }
	virtual const wxChar *getWindowLabel( const bool shortname = false ) { return wxT("DUMMY"; ) }
	void setMainWindow( const bool& );
	bool isMainWindow() { return ismainwindow; }
	void showContextMenu( wxMenu *menu, const int &x, const int &y );
	virtual wxMenu *getContextMenu() = 0;
	void OnActivate( wxActivateEvent& );
	virtual void postCreate() = 0;

protected:
	virtual void OnClose( wxCloseEvent &event );
	virtual void OnCommand( wxCommandEvent &event );
	Document *doc;

private:
	void OnKeyDown( wxKeyEvent& );

	bool ismainwindow;
	bool isvalid;

	DECLARE_CLASS( ChildWindow )
	DECLARE_EVENT_TABLE()
};

/*****************************************************
**
**   CLASS SimpleChildWindow  
**
******************************************************/
class SimpleChildWindow : public ChildWindow
{
public:
	SimpleChildWindow( wxFrame *parent, Document *doc, const wxSize& size = wxDefaultSize, const bool ismain = false );
	~SimpleChildWindow();
	void insertView( MView* );
	MView *getView( const int = 0 ) { return view; }
	virtual void OnDataChanged();
	virtual bool getPreferVedic();
	virtual bool supportsEWToggle();
	virtual void setTitle();
	virtual const wxChar *getWindowLabel( const bool shortname = false );
	virtual wxMenu *getContextMenu();
	virtual int getViewId();
	virtual void postCreate();

protected:
	void OnActivate( wxActivateEvent& );
	void OnSize( wxSizeEvent& );

private:
	MView *view;
	DECLARE_CLASS( SimpleChildWindow )
	DECLARE_EVENT_TABLE()
};

/*****************************************************
**
**   CLASS MultipleChildWindow  
**
******************************************************/
class MultipleChildWindow : public ChildWindow
{
public:
	MultipleChildWindow( wxFrame *parent, Document *doc, const wxSize& size = wxDefaultSize, const bool ismain = false );
	~MultipleChildWindow();
	void initViews( ViewContainer* );
	virtual void OnDataChanged();
	virtual bool getPreferVedic();
	virtual bool supportsEWToggle();
	virtual void setTitle();
	virtual const wxChar *getWindowLabel( const bool shortname = false );
	virtual wxMenu *getContextMenu();
	virtual int getViewId() { return VIEW_MULTIPLE; }
	virtual void postCreate();
	ViewContainer* getViewContainer() { return container; }

protected:
	wxWindow *insertNode( wxWindow *parent, ViewNode* );
	vector<MView*> viewlist;
	void OnActivate( wxActivateEvent& );
	void OnSize( wxSizeEvent& );
	void postCreateNode( ViewNode* );
	ViewContainer *container;
	wxImageList *imagelist;

private:
	DECLARE_CLASS( MultipleChildWindow )
	DECLARE_EVENT_TABLE()
};

/*****************************************************
**
**   CLASS ChildWindowFactory  
**
******************************************************/
class ChildWindowFactory
{
public:
	ChildWindow *createPartnerWindow( wxFrame*, DocumentManager* );
	ChildWindow *createMainWindow( wxFrame*, Document* );
	ChildWindow *createChild( wxFrame *parent, Document *doc, const int id, const bool &vedic );
};

#endif

