/*

	This is the source code of

   	M A I T R E Y A
    ===============

	Open source platform for Vedic and western astrology

  File           DasaGraphicView.h
  Release        4.1
  Author         Martin Pettau
  Copyright (C)  2003-2006 by the author

  Released under the Artistic License as published by the
  Free Software Foundation, read the file 'COPYING' for more information.

*/

#ifndef _DASAGRAPHICVIEW_H_
#define _DASAGRAPHICVIEW_H_

#ifdef __GNUG__
	#pragma interface "DasaGraphicView.h"
#endif

#include "Base.h"
#include "MView.h"

#include <vector>

using namespace std;

class wxDC;
class wxMouseEvent;
class Horoscope;
class DasaGraphicWidget;
class Dasa;
class DasaExpert;

/*****************************************************
**
**   CLASS DasaGraphicView  
**
******************************************************/
class DasaGraphicView : public MView
{
public:
	DasaGraphicView( MViewInfo );
	virtual const wxChar *getWindowLabel( const bool shortname = false );
	virtual bool dispatchCommand( const int &command );
	int getIStyle();
	void doExport();
	void OnNow( wxCommandEvent& );

protected:
	DasaGraphicWidget *swidget;
	virtual void OnDataChanged();
	void SetContextMenuInfo( ContextMenuInfo& );
	virtual void OnToolbarCommand();
	void OnDasas( wxCommandEvent& );
	void OnYear( wxCommandEvent& );
	virtual void initToolItems();
	void OnMouseWheelEvent( wxMouseEvent& );

private:
	DECLARE_CLASS( DasaGraphicView )
	DECLARE_EVENT_TABLE()
};

/*****************************************************
**
**   CLASS GraphicalDasaItem  
**
******************************************************/
class GraphicalDasaItem
{
public:
	GraphicalDasaItem( DasaExpert *e, Dasa *d ) { expert = e; dasa = d; }
	Dasa* dasa;
	//GraphicalDasaItems depitems;
	vector<GraphicalDasaItem*> depitems;
	DasaExpert *expert;
	wxString name;

protected:

private:

};

/*****************************************************
**
**   CLASS DasaGraphicWidget  
**
******************************************************/
class DasaGraphicWidget : public ExportableScrollWidget
{
public:
	DasaGraphicWidget( wxWindow *parent, Horoscope *doc, wxWindowID id = -1, const wxPoint& pos = wxDefaultPosition,
		const wxSize& size = wxDefaultSize, long style = wxHSCROLL | wxVSCROLL | wxSUNKEN_BORDER );
	~DasaGraphicWidget();

	int getIStyle() { return istyle; }
	void setIStyle( int style ) { istyle = style; }
	void setZoom( const int = -0 );
	void setYear( const int& );
	void OnDataChanged();
	int getBirthYear() { return birthyear; }
	int getTotalYears() { return totalyears; }
	wxArrayInt dasas;

protected:
	int istyle;
	Horoscope *doc;
	vector <GraphicalDasaItem*> dasaitems;

	virtual void doPaint( wxDC* );
	void clearDasaItems();

private:
	int getX4Jd( const double &jd );
	void paintDasa( const int& );
	void showDasaBar( Dasa *dasa, DasaExpert*, double y );
	void paintRuler();
	wxColour getFgColour( const int &i, const bool &pdasa );
	wxColour getBgColour( const int &i, const bool &pdasa );
	int zoom;
	double xleft, xright, ytop, ybottom;
	double startjd, endjd;
	int birthyear, totalyears, ycursor, ybar;

	DECLARE_CLASS( DasaGraphicWidget )
	DECLARE_EVENT_TABLE()
};

#endif

