/*

	This is the source code of

   	M A I T R E Y A
    ===============

	Open source platform for Vedic and western astrology

  File           DasaView.h
  Release        4.1
  Author         Martin Pettau
  Copyright (C)  2003-2006 by the author

  Released under the Artistic License as published by the
  Free Software Foundation, read the file 'COPYING' for more information.

*/

#ifndef _DASA_VIEW_H_
#define _DASA_VIEW_H_

#ifdef __GNUG__
	#pragma interface "DasaView.h"
#endif

#include "MView.h"

#include <wx/treebase.h>  // for wxTreeItemId
#include "mytreectrl.h"

class Dasa;
class DasaExpert;
class DasaPanel;
class DasaListViewItem;
class Horoscope;
class MyTreeCtrl;


/*****************************************************
**
**   CLASS DasaView  
**
******************************************************/
class DasaView : public MView
{
public:
	DasaView( MViewInfo );
	virtual const wxChar *getWindowLabel( const bool shortname = false );

protected:
	virtual void showToolPanel( const bool b );
	void updateDetailPanel( DasaListViewItem* );
	void clearDetailPanel();
	void expand( MyTreeEvent& event );
	void collapse( MyTreeEvent& event );
	void OnSelChanging( MyTreeEvent& event );
	void OnDataChanged();
	void updateDasa( wxTreeItemId masterid );
	MyTreeCtrl *treectrl;
	wxTreeItemId rootid, baseid, specialid, conditionalid;
	void OnEntryChart( wxCommandEvent& );
	double currentjd;
	void OnMouseWheelEvent( wxMouseEvent& );

private:
	DECLARE_CLASS( DasaView )
	DECLARE_EVENT_TABLE()
};

/*****************************************************
**
**   CLASS DasaListViewItem  
**
******************************************************/
class DasaListViewItem : public MyTreeItemData
{
public:

	DasaListViewItem( DasaExpert*, Horoscope* );
	~DasaListViewItem();

	DasaExpert *getExpert() { return expert; }
	Horoscope *getHoroscope() { return horoscope; }
	virtual bool isRootItem() = 0;

protected:

	DasaExpert *expert;
	Horoscope *horoscope;
};

/*****************************************************
**
**   CLASS DasaMainListViewItem  
**
******************************************************/
class DasaMainListViewItem : public DasaListViewItem
{
public:

	DasaMainListViewItem( DasaExpert*, Horoscope*, int varga = 0 );

	int getVarga() { return varga; }
	virtual bool isRootItem() { return true; }

protected:

	int varga;
};

/*****************************************************
**
**   CLASS DasaDependendViewItem  
**
******************************************************/
class DasaDependendViewItem : public DasaListViewItem
{
public:

	DasaDependendViewItem( DasaExpert*, Dasa*, Horoscope* );

	Dasa *getDasa() { return dasa; }
	void setDasa( Dasa *d ) { dasa = d; }
	virtual bool isRootItem() { return false; }
	wxString writeContents();

protected:
	Dasa *dasa;
};

#endif

