/*

	This is the source code of

   	M A I T R E Y A
    ===============

	Open source platform for Vedic and western astrology

  File           Document.h
  Release        4.1
  Author         Martin Pettau
  Copyright (C)  2003-2006 by the author

  Released under the Artistic License as published by the
  Free Software Foundation, read the file 'COPYING' for more information.

*/

#ifndef _DOCUMENT_H_
#define _DOCUMENT_H_

#ifdef __GNUG__
	#pragma interface "Document.h"
#endif

#include "Horoscope.h"

#include "Base.h"

#include <wx/object.h>
#include <wx/timer.h>
#include <vector>

BEGIN_DECLARE_EVENT_TYPES()
	DECLARE_EVENT_TYPE( DOC_SAVED, 9610 )
	DECLARE_EVENT_TYPE( DOC_UPDATED, 9611 )
	DECLARE_EVENT_TYPE( CREATE_ENTRY_CHART, 9612 )
END_DECLARE_EVENT_TYPES()

class ChildWindow;
class DocumentManager;

using namespace std;

/*****************************************************
**
**   CLASS Document  
**
******************************************************/
class Document : public Horoscope, wxEvtHandler
{
	DECLARE_CLASS( Document )
public:
	Document();
#ifdef _WX_WANT_NEW_SIZET_WXCHAR_INT
	void *operator new ( size_t size, const wxChar *fileName = NULL, int lineNum = 0 );
#endif

#ifdef _WX_WANT_DELETE_VOID
	void operator delete ( void * buf );
#endif

	~Document();
	void addChildWindow( ChildWindow* );
	void releaseChildWindow( ChildWindow *child );
	void setMainWindow( ChildWindow* );
	ChildWindow *getMainWindow() { return mainwindow; }
	bool save();
	bool saveAs();
	bool queryClose();
	bool isDirty() { return dirty; }
	void setDirty( const bool &d ) { dirty = d; }
	void updateAllChildWindows();
	void closeDependenChildWindows();
	void editData();
	void doPrint();
	void doQuickPrint();
	void StartTimer( bool b );
	bool isAnimated() { return timer->IsRunning(); }

	DECLARE_EVENT_TABLE()
protected:
	wxTimer *timer;
	void OnTimer( wxTimerEvent &event );
	bool dirty;
	ChildWindowList childlist;
	ChildWindow *mainwindow;
};

/*****************************************************
**
**   CLASS DocumentListener  
**
******************************************************/
class DocumentListener : public wxObject
{
public:
	DocumentListener( DocumentManager *manager ) : wxObject() { this->manager = manager; }
	virtual ~DocumentListener() {}
	virtual void documentListChanged() = 0;

protected:
	DocumentManager *manager;

private:
	DECLARE_CLASS( DocumentListener )
};

/*****************************************************
**
**   CLASS DocumentManager  
**
******************************************************/
class DocumentManager
{
public:
	void addDoc( Document* );
	void deleteDoc( Document* );
	void updateAllDocs();

	void addClient( DocumentListener* );
	void deleteClient( DocumentListener* );
	int getNbDocuments();
	Document *getDocument( const int &i );

protected:
	Documents docs;
	vector<DocumentListener*> clients;

private:

};


#endif

