/*

	This is the source code of

   	M A I T R E Y A
    ===============

	Open source platform for Vedic and western astrology

  File           EphemView.h
  Release        4.1
  Author         Martin Pettau
  Copyright (C)  2003-2006 by the author

  Released under the Artistic License as published by the
  Free Software Foundation, read the file 'COPYING' for more information.

*/

#ifndef _EPHEMVIEW_H_
#define _EPHEMVIEW_H_

#ifdef __GNUG__
	#pragma interface "EphemView.h"
#endif

#include "Base.h"
#include "MView.h"

class ChildWindow;
class EphemExpert;
class EphemWidget;

/*****************************************************
**
**   CLASS EphemView  
**
******************************************************/
class EphemView : public MView
{
public:
	EphemView( MViewInfo );
	~EphemView();
	virtual const wxChar *getWindowLabel( const bool shortname = false );
	virtual void OnPreferVedic( bool b );

protected:
	EphemExpert *expert;
	EphemWidget *ewidget;
	TextWidget *theText;
	int month, oldmonth, year, planets, mode, tz, dasa;
	bool gmode, updateView;

	virtual void updateText();
	virtual void OnToolbarCommand();
	void OnYearSpin( wxSpinEvent& );
	void OnMonthSpin( wxSpinEvent& );
	void OnNow( wxCommandEvent& );
	void OnChoiceTZ( wxCommandEvent& );
	void initClientView();
	void setMaxDeg( const int& );
	void OnIdle( wxIdleEvent& );
	virtual void initToolItems();
	void OnMouseWheelEvent( wxMouseEvent& );

private:
	DECLARE_CLASS( EphemView )
	DECLARE_EVENT_TABLE()
};

/*****************************************************
**
**   CLASS EphemWidget
**
******************************************************/
class EphemWidget :  public ExportableScrollWidget
{
public:
  EphemWidget( wxWindow *parent, EphemExpert* );
	~EphemWidget();
	void setMaxDeg( const double &m ) { max_deg = m; }
	void setFilter( const int &f ) { filter = f; }

protected:

private:
	double xleft, xright, ytop, ybottom, max_deg;
	int zoom;
	int scrollx, scrolly, filter;
	EphemExpert *expert;

	void doPaint( wxDC* );
	void setZoom( const int z );
	void paintRuler();
	void paintPlanets();
	void setLineStyle( const int &planet );

	DECLARE_CLASS( EphemWidget )
	DECLARE_EVENT_TABLE()
};

#endif

