/*

	This is the source code of

   	M A I T R E Y A
    ===============

	Open source platform for Vedic and western astrology

  File           GraphicView.h
  Release        4.1
  Author         Martin Pettau
  Copyright (C)  2003-2006 by the author

  Released under the Artistic License as published by the
  Free Software Foundation, read the file 'COPYING' for more information.

*/

#ifndef _GRAPHICVIEW_H_
#define _GRAPHICVIEW_H_

#ifdef __GNUG__
	#pragma interface "GraphicView.h"
#endif

#include "Base.h"
#include "MView.h"
#include <wx/window.h>
#include <wx/splitter.h>

class wxDC;
class wxFrame;
class Document;
class Horoscope;
class GraphicWidget;
class ChildWindow;

/*****************************************************
**
**   CLASS GraphicView  
**
******************************************************/
class GraphicView : public MView
{
public:
	GraphicView( MViewInfo info );
	~GraphicView();
	virtual const wxChar *getWindowLabel( const bool shortname = false );
	virtual bool dispatchCommand( const int &command );
	virtual void OnPreferVedic( bool f );
	int getIStyle();
	int getWStyle();
	void doExport();

protected:
	virtual void OnSize( wxSizeEvent& );
	GraphicWidget *gwidget;
	void SetContextMenuInfo( ContextMenuInfo& );

private:
	DECLARE_CLASS( GraphicView )
	DECLARE_EVENT_TABLE()
};

/*****************************************************
**
**   CLASS GraphicWidget  
**
******************************************************/
class GraphicWidget : public ExportableScrollWidget
{
public:
	GraphicWidget( wxWindow *parent, Horoscope*, bool indian, int varga = 0, wxWindowID id = -1,
		const wxPoint& pos = wxDefaultPosition, const wxSize& = wxDefaultSize );
	int getIStyle() { return istyle; }
	void setIStyle( int style ) { istyle = style; }
	int getWStyle() { return wstyle; }
	void setWStyle( int style ) { wstyle = style; }
	int getVarga() { return varga; }
	bool preferVedic;
	void setBlank( const bool b ) { isBlank = b; }
	bool dispatchCommand( const int& );

protected:
	int istyle, wstyle;
	Horoscope *doc;
	virtual void doPaint( wxDC* );
	int varga;
	bool isBlank;

private:
	DECLARE_CLASS( GraphicWidget )
	DECLARE_EVENT_TABLE()
};

#endif

