/*

	This is the source code of

   	M A I T R E Y A
    ===============

	Open source platform for Vedic and western astrology

  File           IconProvider.cpp
  Release        4.1
  Author         Martin Pettau
  Copyright (C)  2003-2006 by the author

  Released under the Artistic License as published by the
  Free Software Foundation, read the file 'COPYING' for more information.

*/

#ifdef __GNUG__
	#pragma implementation "IconProvider.h"
#endif

#include "IconProvider.h"
#include "Base.h"

#include <wx/image.h>
#include <wx/imaglist.h>
#include <wx/log.h>

#include <stdarg.h>

#include "pics/new.xpm"
#include "pics/open.xpm"
#include "pics/save.xpm"
#include "pics/saveas.xpm"
#include "pics/close.xpm"
#include "pics/quit.xpm"
#include "pics/info.xpm"
#include "pics/now.xpm"
#include "pics/goto.xpm"
#include "pics/copy.xpm"
#include "pics/text.xpm"
#include "pics/hora.xpm"
#include "pics/document.xpm"
#include "pics/maitreya.xpm"
#include "pics/edit.xpm"
#include "pics/calculation.xpm"
#include "pics/chart.xpm"
#include "pics/chart9.xpm"
#include "pics/config.xpm"
#include "pics/east_sel.xpm"
#include "pics/west_sel.xpm"
#include "pics/expert.xpm"
#include "pics/print.xpm"
#include "pics/quickprint.xpm"
#include "pics/sbc.xpm"
#include "pics/transit.xpm"
#include "pics/midpoint.xpm"
#include "pics/partner.xpm"
#include "pics/wchart.xpm"
#include "pics/eclipse.xpm"
#include "pics/ephem.xpm"
#include "pics/world.xpm"
#include "pics/piebald.xpm"
#include "pics/rainbow.xpm"
#include "pics/graphicaldasa.xpm"
#include "pics/solar.xpm"
#include "pics/appearance.xpm"

#include "pics/help.xpm"
#include "pics/dasa.xpm"
#include "pics/dasa_folder.xpm"
#include "pics/dasa_folder_e.xpm"
#include "pics/mahadasa.xpm"
#include "pics/mahadasa_e.xpm"
#include "pics/dasatree1.xpm"
#include "pics/dasatree1e.xpm"
#include "pics/dasatree2.xpm"
#include "pics/dasatree2e.xpm"
#include "pics/dasatree3.xpm"
#include "pics/dasatree3e.xpm"
#include "pics/dasatree4.xpm"
#include "pics/dasatree4e.xpm"
#include "pics/dasatree5.xpm"
#include "pics/dasatree5e.xpm"
#include "pics/yoga.xpm"


/*****************************************************
**
**   IconProvider   ---   getIcon 
**
******************************************************/
wxIcon IconProvider::getIcon( const int &index )
{
#ifdef __WXMSW__
	switch( index )
	{
		case BITMAP_MAITREYA: return wxIcon( wxT( "a_maitreya_icon" ), wxBITMAP_TYPE_ICO_RESOURCE ); break;
		case BITMAP_DOCUMENT: return wxIcon( wxT( "document_icon" ), wxBITMAP_TYPE_ICO_RESOURCE ); break;
		case BITMAP_TEXT: return wxIcon( wxT( "text_icon" ), wxBITMAP_TYPE_ICO_RESOURCE ); break;
		case BITMAP_CHART: return wxIcon( wxT( "chart_icon" ), wxBITMAP_TYPE_ICO_RESOURCE ); break;
		case BITMAP_CHART9: return wxIcon( wxT( "chart9_icon" ), wxBITMAP_TYPE_ICO_RESOURCE ); break;
		case BITMAP_WCHART: return wxIcon( wxT( "wchart_icon" ), wxBITMAP_TYPE_ICO_RESOURCE ); break;
		case BITMAP_DASA: return wxIcon( wxT( "dasa_icon" ), wxBITMAP_TYPE_ICO_RESOURCE ); break;
		case BITMAP_HORA: return wxIcon( wxT( "hora_icon" ), wxBITMAP_TYPE_ICO_RESOURCE ); break;
		case BITMAP_MIDPOINT: return wxIcon( wxT( "midpoint_icon" ), wxBITMAP_TYPE_ICO_RESOURCE ); break;		
		case BITMAP_TRANSIT: return wxIcon( wxT( "transit_icon" ), wxBITMAP_TYPE_ICO_RESOURCE ); break;
		case BITMAP_EPHEM: return wxIcon( wxT( "ephem_icon" ), wxBITMAP_TYPE_ICO_RESOURCE ); break;
		case BITMAP_GRAPHICALDASA: return wxIcon( wxT( "graphicaldasa_icon" ), wxBITMAP_TYPE_ICO_RESOURCE ); break;
		case BITMAP_ECLIPSE: return wxIcon( wxT( "eclipse_icon" ), wxBITMAP_TYPE_ICO_RESOURCE ); break;
		case BITMAP_PARTNER: return wxIcon( wxT( "partner_icon" ), wxBITMAP_TYPE_ICO_RESOURCE ); break;
		case BITMAP_SBC: return wxIcon( wxT( "sbc_icon" ), wxBITMAP_TYPE_ICO_RESOURCE ); break;
		case BITMAP_SOLAR: return wxIcon( wxT( "solar_icon" ), wxBITMAP_TYPE_ICO_RESOURCE ); break;
		case BITMAP_WORLD: return wxIcon( wxT( "world_icon" ), wxBITMAP_TYPE_ICO_RESOURCE ); break;		
		case BITMAP_EDIT: return wxIcon( wxT( "edit_icon" ), wxBITMAP_TYPE_ICO_RESOURCE ); break;
		case BITMAP_CONFIG: return wxIcon( wxT( "config_icon" ), wxBITMAP_TYPE_ICO_RESOURCE ); break;
		case BITMAP_YOGA: return wxIcon( wxT( "yoga_icon" ), wxBITMAP_TYPE_ICO_RESOURCE ); break;
		default: return wxIcon( wxT( "a_maitreya_icon" ), wxBITMAP_TYPE_ICO_RESOURCE ); break;
	}
#else	
	switch( index )
	{
		case BITMAP_MAITREYA: return wxIcon( maitreya_xpm ); break;
		case BITMAP_DOCUMENT: return wxIcon( document_xpm ); break;
		case BITMAP_TEXT: return wxIcon( text_xpm ); break;
		case BITMAP_CHART: return wxIcon( chart_xpm ); break;
		case BITMAP_CHART9: return wxIcon( chart9_xpm ); break;
		case BITMAP_WCHART: return wxIcon( wchart_xpm ); break;
		case BITMAP_DASA: return wxIcon( dasa_xpm ); break;
		case BITMAP_HORA: return wxIcon( hora_xpm ); break;
		case BITMAP_TRANSIT: return wxIcon( transit_xpm ); break;
		case BITMAP_MIDPOINT: return wxIcon( midpoint_xpm ); break;
		case BITMAP_EPHEM: return wxIcon( ephem_xpm ); break;
		case BITMAP_GRAPHICALDASA: return wxIcon( graphicaldasa_xpm ); break;
		case BITMAP_ECLIPSE: return wxIcon( eclipse_xpm ); break;
		case BITMAP_PARTNER: return wxIcon( partner_xpm ); break;
		case BITMAP_SBC: return wxIcon( sbc_xpm ); break;
		case BITMAP_SOLAR: return wxIcon( solar_xpm ); break;
		case BITMAP_WORLD: return wxIcon( world_xpm ); break;
		case BITMAP_EDIT: return wxIcon( edit_xpm ); break;
		case BITMAP_CONFIG: return wxIcon( config_xpm ); break;
		case BITMAP_YOGA: return wxIcon( yoga_xpm ); break;
		default:
			wxLogError( wxT( "Cannot find bitmap #%d, using default" ), index );
			return wxIcon( maitreya_xpm );
		break;
	}
#endif
}

/*****************************************************
**
**   IconProvider   ---   getMenuBitmap 
**
******************************************************/
wxBitmap IconProvider::getMenuBitmap( const int &index )
{
	return wxBitmap( getBitmap( index ).ConvertToImage().Scale( 16, 16 ));
}

/*****************************************************
**
**   IconProvider   ---   getBitmap 
**
******************************************************/
wxBitmap IconProvider::getBitmap( const int &index )
{
	switch( index )
	{
		case BITMAP_NEW: return wxBitmap( new_xpm ); break;
		case BITMAP_OPEN: return wxBitmap( open_xpm ); break;
		case BITMAP_SAVE: return wxBitmap( save_xpm ); break;
		case BITMAP_SAVEAS: return wxBitmap( saveas_xpm ); break;
		case BITMAP_CLOSE: return wxBitmap( close_xpm ); break;
		case BITMAP_QUIT: return wxBitmap( quit_xpm ); break;
		case BITMAP_INFO: return wxBitmap( info_xpm ); break;
		case BITMAP_NOW: return wxBitmap( now_xpm ); break;
		case BITMAP_GOTO: return wxBitmap( goto_xpm ); break;
		case BITMAP_TEXT: return wxBitmap( text_xpm ); break;
		case BITMAP_HELP: return wxBitmap( help_xpm ); break;
		case BITMAP_HORA: return wxBitmap( hora_xpm ); break;
		case BITMAP_DOCUMENT: return wxBitmap( document_xpm ); break;
		case BITMAP_MAITREYA: return wxBitmap( maitreya_xpm ); break;
		case BITMAP_EDIT: return wxBitmap( edit_xpm ); break;
		case BITMAP_CHART: return wxBitmap( chart_xpm ); break;
		case BITMAP_CHART9: return wxBitmap( chart9_xpm ); break;
		case BITMAP_CONFIG: return wxBitmap( config_xpm ); break;
		case BITMAP_WEST_SEL: return wxBitmap( west_sel_xpm ); break;
		case BITMAP_EAST_SEL: return wxBitmap( east_sel_xpm ); break;
		case BITMAP_CALCULATION: return wxBitmap( calculation_xpm ); break;
		case BITMAP_APPEARANCE: return wxBitmap( appearance_xpm ); break;
		case BITMAP_COPY: return wxBitmap( copy_xpm ); break;
		case BITMAP_PRINT: return wxBitmap( print_xpm ); break;
		case BITMAP_QUICKPRINT: return wxBitmap( quickprint_xpm ); break;
		case BITMAP_TRANSIT: return wxBitmap( transit_xpm ); break;
		case BITMAP_MIDPOINT: return wxBitmap( midpoint_xpm ); break;
		case BITMAP_PARTNER: return wxBitmap( partner_xpm ); break;
		case BITMAP_WCHART: return wxBitmap( wchart_xpm ); break;
		case BITMAP_ECLIPSE: return wxBitmap( eclipse_xpm ); break;
		case BITMAP_EPHEM: return wxBitmap( ephem_xpm ); break;
		case BITMAP_GRAPHICALDASA: return wxBitmap( graphicaldasa_xpm ); break;
		case BITMAP_DASA: return wxBitmap( dasa_xpm ); break;
		case BITMAP_SBC: return wxBitmap( sbc_xpm ); break;
		case BITMAP_SOLAR: return wxBitmap( solar_xpm ); break;
		case BITMAP_WORLD: return wxBitmap( world_xpm ); break;
		case BITMAP_EXPERT: return wxBitmap( expert_xpm ); break;
		case BITMAP_RAINBOW: return wxBitmap( rainbow_xpm ); break;
		case BITMAP_PIEBALD: return wxBitmap( piebald_xpm ); break;
		case BITMAP_DASA_FOLDER: return wxBitmap( dasa_folder_xpm ); break;
		case BITMAP_MAHADASA: return wxBitmap( mahadasa_xpm ); break;
		case BITMAP_DASATREE1: return wxBitmap( dasatree1_xpm ); break;
		case BITMAP_DASATREE2: return wxBitmap( dasatree2_xpm ); break;
		case BITMAP_DASATREE3: return wxBitmap( dasatree3_xpm ); break;
		case BITMAP_DASATREE4: return wxBitmap( dasatree4_xpm ); break;
		case BITMAP_DASATREE5: return wxBitmap( dasatree5_xpm ); break;
		case BITMAP_DASA_FOLDERE: return wxBitmap( dasa_folder_e_xpm ); break;
		case BITMAP_MAHADASAE: return wxBitmap( mahadasa_e_xpm ); break;
		case BITMAP_DASATREE1E: return wxBitmap( dasatree1e_xpm ); break;
		case BITMAP_DASATREE2E: return wxBitmap( dasatree2e_xpm ); break;
		case BITMAP_DASATREE3E: return wxBitmap( dasatree3e_xpm ); break;
		case BITMAP_DASATREE4E: return wxBitmap( dasatree4e_xpm ); break;
		case BITMAP_DASATREE5E: return wxBitmap( dasatree5e_xpm ); break;
		case BITMAP_YOGA: return wxBitmap( yoga_xpm ); break;
		default:
			wxLogError( wxT( "Cannot find bitmap #%d, using default" ), index );
			return wxBitmap( maitreya_xpm );
		break;
	}
}

/**************************************************************
***
**
***
***************************************************************/
wxImageList *IconProvider::createImageList( char *fmt, ... )
{
	wxImageList *imagelist;
	if ( *fmt == 's' ) imagelist = new wxImageList( 16, 16, true );
	else imagelist = new wxImageList( 24, 24, true );
	va_list ap;
	va_start(ap, fmt);
	while ( *fmt )
	{
		switch( *fmt++ )
		{
			case 'b':
				imagelist->Add( getBitmap( va_arg( ap, int )));
			break;
			case 's':
				imagelist->Add( getMenuBitmap( va_arg( ap, int )));
			break;
			case 'i':
				imagelist->Add( getIcon( va_arg( ap, int )));
			break;
		}
	}
	va_end(ap);
	return imagelist;
}

/*****************************************************
**
**   IconProvider   ---   getWindowIcon 
**
******************************************************/
wxIcon IconProvider::getWindowIcon( const int id )
{
	switch( id )
	{
		case VIEW_TEXT:
			return getIcon( BITMAP_TEXT );
		break;
		case VIEW_TRANSIT:
			return getIcon( BITMAP_TRANSIT );
		break;
		case VIEW_SBC:
			return getIcon( BITMAP_SBC );
		break;
		case VIEW_SOLAR:
			return getIcon( BITMAP_SOLAR );
		break;
		case VIEW_DASA:
			return getIcon( BITMAP_DASA );
		break;
		case VIEW_GRAPHICALDASA:
			return getIcon( BITMAP_GRAPHICALDASA );
		break;
		case VIEW_MIDPOINT:
			return getIcon( BITMAP_MIDPOINT );
		break;
		case VIEW_GRAPHIC:
			return getIcon( BITMAP_CHART );
		break;
		case VIEW_PLANETLIST:
			return getIcon( BITMAP_DOCUMENT );
		break;
		case VIEW_HORA:
			return getIcon( BITMAP_HORA );
		break;
		case VIEW_ECLIPSE:
			return getIcon( BITMAP_ECLIPSE );
		break;
		case VIEW_PARTNER:
			return getIcon( BITMAP_PARTNER );
		break;
		case VIEW_EPHEM:
			return getIcon( BITMAP_EPHEM );
		break;
		case VIEW_YOGA:
			return getIcon( BITMAP_YOGA );
		break;
		default:
			return getIcon( BITMAP_HORA );
		break;
	}
}




