/*

	This is the source code of

   	M A I T R E Y A
    ===============

	Open source platform for Vedic and western astrology

  File           MView.cpp
  Release        4.1
  Author         Martin Pettau
  Copyright (C)  2003-2006 by the author

  Released under the Artistic License as published by the
  Free Software Foundation, read the file 'COPYING' for more information.

*/

#ifdef __GNUG__
	#pragma implementation "MView.h"
#endif

#include "MView.h"
#include "ChildWindow.h"

#include <wx/string.h>

#include <wx/dcclient.h>
#include <wx/event.h>
#include <wx/layout.h>
#include <wx/log.h>
#include <wx/menu.h>
#include <wx/panel.h>
#include <wx/sizer.h>
#include <wx/toolbar.h>

#include "Base.h"
#include "Document.h"
#include "IconProvider.h"
#include "MenuProvider.h"
#include "ToolPanel.h"

#include "Conf.h"

extern Config *config;

IMPLEMENT_CLASS( MView, wxWindow )
BEGIN_EVENT_TABLE( MView, wxWindow )
	EVT_SIZE( MView::OnSize )
	EVT_RIGHT_DOWN( MView::OnContextMenuEvent )
	EVT_MENU_RANGE( CHILD_CLOSE, CHILD_NEW_RASI+30, MView::OnCommand )
END_EVENT_TABLE()

IMPLEMENT_CLASS( EmptyView, MView )
BEGIN_EVENT_TABLE( EmptyView, MView )
	EVT_PAINT( EmptyView::OnPaint )
END_EVENT_TABLE()

/*****************************************************
**
**   MViewInfo   ---   Constructor 
**
******************************************************/
MViewInfo::MViewInfo( wxWindow *w, ChildWindow *cw, int vid, Document *d, bool stb )
{
	parent = w;
	frame = cw;
	doc = d;
	showtoolbar = stb;
	id = -1;
	viewId = vid;
	vedic = config->preferVedic;
	varga = -1;
	mode = -1;
	type = -1;
	istyle = wstyle = 0;
	pos = wxDefaultPosition;
	size = wxDefaultSize;
	singleMode = false;
}

/*****************************************************
**
**   MView   ---   Constructor 
**
******************************************************/
MView::MView( MViewInfo info )
	: wxWindow( info.parent, info.id ),
		viewinfo( info ),
		doc( info.doc ),
		preferVedic( info.vedic ),
		istyle( info.istyle ),
		wstyle( info.wstyle ),
		showtoolbar( info.showtoolbar )
{
	widget = 0;
	PushEventHandler( new MyEventPropagator() );
	supportEWToggle = isMainWindow = false;
	detailpanel = 0;
	toolbar = 0;
	toolbar = ( showtoolbar ? ToolbarFactory().createToolbar( this, info.viewId ) : 0 );
}

/*****************************************************
**
**   MView   ---   OnCommand 
**
******************************************************/
void MView::OnCommand( wxCommandEvent &event )
{
	bool b = dispatchCommand( event.GetId() );
	if ( ! b ) event.Skip();
}

/*****************************************************
**
**   MView   ---   DoGetBestSize
**
******************************************************/
wxSize MView::DoGetBestSize() const
{
	return wxSize( 200, 200 );
}

/*****************************************************
**
**   MView   ---   OnChoiceCommand 
**
******************************************************/
void MView::OnChoiceCommand( wxCommandEvent &event )
{
	OnToolbarCommand();
	widget->SetFocus();
}

/*****************************************************
**
**   MView   ---   OnSpinCommand 
**
******************************************************/
void MView::OnSpinCommand( wxSpinEvent &event )
{
	OnToolbarCommand();
}

/*****************************************************
**
**   MView   ---   OnGeneralCommand 
**
******************************************************/
void MView::OnGeneralCommand( wxCommandEvent &event )
{
	OnToolbarCommand();
}

/*****************************************************
**
**   MView   ---   OnSize 
**
******************************************************/
void MView::OnSize( wxSizeEvent &event )
{
	//printf( "MView::OnSize x %d y %d\n", event.GetSize().x, event.GetSize().y );
	Layout(); // Needed because the widget will not resize
}

/*****************************************************
**
**   MView   ---   OnPreferVedic 
**
******************************************************/
void MView::OnPreferVedic( bool f )
{
	preferVedic = f;
	viewinfo.frame->setTitle();
	Refresh();
}

/*****************************************************
**
**   MView   ---   OnDataChanged 
**
******************************************************/
void MView::OnDataChanged()
{
	Refresh();
}

/*****************************************************
**
**   MView   ---   dispatchCommand 
**
******************************************************/
bool MView::dispatchCommand( const int &command )
{
	switch( command )
	{
		case VIEW_PREFERINDIAN:
			OnPreferVedic( true );
			return true;
		break;
		case VIEW_PREFERWESTERN:
			OnPreferVedic( false );
			return true;
		break;
		default:
			return false;
		break;
	}
}

/*****************************************************
**
**   MView   ---   SetContextMenuInfo 
**
******************************************************/
void MView::SetContextMenuInfo( ContextMenuInfo &menuinfo )
{
	menuinfo.preferVedic = preferVedic;
	menuinfo.supportsEWToggle = supportsEWToggle();
	menuinfo.isDoc = ( doc ? true : false );
	if ( doc ) menuinfo.animate = doc->isAnimated();
}

/*****************************************************
**
**   MView   ---   OnContextMenuEvent 
**
******************************************************/
void MView::OnContextMenuEvent( wxMouseEvent& event)
{
	int x, y;
	x = event.m_x;
	y = event.m_y;
	wxWindow *window = (wxWindow*)event.GetEventObject();
	window->ClientToScreen( &x, &y );
	this->ScreenToClient( &x, &y );
	wxMenu *menu = getContextMenu();
	PopupMenu( menu, x, y );
	delete menu;
}

/**************************************************************
***
**
***
***************************************************************/
wxMenu *MView::getContextMenu()
{
	ContextMenuInfo menuinfo( this );
	SetContextMenuInfo( menuinfo );
	return ContextMenuProvider().getContextMenu( menuinfo );
}

/*****************************************************
**
**   MView   ---   doLayout 
**
******************************************************/
void MView::doLayout()
{
	//printf( "MView::doLayout\n" );
	wxBoxSizer* sizer = new wxBoxSizer( wxVERTICAL );
	if( toolbar )
	{
		sizer->Add( toolbar, 0, wxEXPAND );
		//sizer->Add( toolbar, 1, wxEXPAND );
		sizer->Add( widget, 1, wxEXPAND | wxALL, config->childFrameWidth );
	}
	else { sizer->Add( widget, 1, wxEXPAND | wxALL, config->childFrameWidth ); }
	if ( detailpanel ) sizer->Add( detailpanel, 0, wxEXPAND, 0 );
  SetSizer( sizer );
  sizer->Fit( this ); // Needed by Windows (view change in ephemeris and partner view)
	viewinfo.frame->SendSizeEvent(); // Needed by Windows
}

/*****************************************************
**
**   MView   ---   getTitle 
**
******************************************************/
wxString MView::getTitle()
{
	wxString label, s = wxT( "empty" );
	if ( doc )
	{
		label = getWindowLabel( true );
		if ( label.Len() > 0 ) s.sprintf( wxT( "%s <%s>" ), doc->getHName(), getWindowLabel( true ) );
		else s = doc->getHName();
	}
	else { s = getWindowLabel(); }
	return s;
}

/*****************************************************
**
**   EmptyView   ---   Constructor 
**
******************************************************/
EmptyView::EmptyView( MViewInfo info )
 : MView( info )
{
}

/*****************************************************
**
**   EmptyView   ---   Destructor 
**
******************************************************/
EmptyView::~EmptyView()
{
}

/*****************************************************
**
**   EmptyView   ---   OnPaint 
**
******************************************************/
void EmptyView::OnPaint( wxPaintEvent& ) 
{  
	int w, h;
  wxPaintDC dc( this );
	//dc.SetPen( wxPen( "RED", 1, wxSOLID ));
	dc.GetSize( &w, &h );
	dc.DrawLine( 0, 0, w, h );
	dc.DrawLine( 0, h, w, 0 );
}

/**************************************************************
***
**   ViewFactory   ---   createView
***
***************************************************************/
MView *ViewFactory::createView( MViewInfo info )
{
	MView * view = 0;
	switch( info.viewId )
	{
		case VIEW_TEXT:
			view = createTextView( info );
		break;
		case VIEW_GRAPHICALDASA:
			view = createGraphicalDasaView( info );
		break;
		case VIEW_PLANETLIST:
			view = createMainView( info );
		break;
		case VIEW_GRAPHIC:
			view = createGraphicView( info );
		break;
		case VIEW_DASA:
			view = createDasaView( info );
		break;
		case VIEW_MIDPOINT:
			view = createMidpointView( info );
		break;
		case VIEW_TRANSIT:
			view = createTransitView( info );
		break;
		case VIEW_SOLAR:
			view = createSolarView( info );
		break;
		case VIEW_SBC:
			view = createSbcView( info );
		break;
		case VIEW_HORA:
			view = createHoraView( info );
		break;
		case VIEW_ECLIPSE:
			view = createEclipseView( info );
		break;
		case VIEW_EPHEM:
			view = createEphemView( info );
		break;
		default:
			wxLogError( wxT( "ViewFactory::createView unknown id %d" ), info.viewId );
		break;
	}
	return view;
}

