/*

	This is the source code of

   	M A I T R E Y A
    ===============

	Open source platform for Vedic and western astrology

  File           MView.h
  Release        4.1
  Author         Martin Pettau
  Copyright (C)  2003-2006 by the author

  Released under the Artistic License as published by the
  Free Software Foundation, read the file 'COPYING' for more information.

*/

#ifndef _MVIEW_H_
#define _MVIEW_H_

#ifdef __GNUG__
	#pragma interface "MView.h"
#endif

#include <wx/window.h>

class ChildWindow;

class ContextMenuInfo;
class Document;
class DocumentManager;
class wxPanel;
class wxMenu;
class wxSizeEvent;
class wxCommandEvent;
class wxSpinEvent;
class wxToolBar;

/*****************************************************
**
**   CLASS MViewInfo
**
******************************************************/
class MViewInfo
{
public:
	MViewInfo( wxWindow*, ChildWindow*, int vid, Document* = 0, bool = true );
	wxWindow *parent;
	ChildWindow *frame;
	Document *doc;
	wxWindowID id;
	int viewId;
	bool showtoolbar;
	bool vedic;
	int varga;
	int mode, type;
	int istyle, wstyle;
	wxPoint pos;
	wxSize size;
	bool singleMode;
};

/*****************************************************
**
**   CLASS MView  
**
******************************************************/
class MView : public wxWindow
{
public:
	MView( MViewInfo );
	Document *getDoc() { return doc; }
	bool getPreferVedic() { return preferVedic; }
	int getWStyle() { return wstyle; }
	int getIStyle() { return istyle; }
	virtual bool supportsEWToggle() { return supportEWToggle; }
	virtual void OnPreferVedic( bool f );
	virtual void OnDataChanged();
	virtual const wxChar *getWindowLabel( const bool shortname = false ) { return wxT( "---" ); }
	wxMenu *getContextMenu();
	virtual bool dispatchCommand( const int &command );
	virtual wxString getTitle();
	virtual void SetContextMenuInfo( ContextMenuInfo& );
	void doLayout();
	virtual wxSize DoGetBestSize() const;
	MViewInfo *getViewInfo() { return &viewinfo; }
	virtual void postCreate() {}
	wxWindow *getWidget() { return widget; }

protected:
	MViewInfo viewinfo;
	Document *doc;
	bool preferVedic, supportEWToggle, isMainWindow;
	int istyle, wstyle;
	wxWindow *widget;
	void OnContextMenuEvent( wxMouseEvent& );
	wxToolBar *toolbar;
	wxPanel *detailpanel;
	bool showtoolbar;
	virtual void initToolItems() {}

	virtual void OnChoiceCommand( wxCommandEvent& );
	virtual void OnSpinCommand( wxSpinEvent& );
	virtual void OnGeneralCommand( wxCommandEvent& );
	virtual void OnCommand( wxCommandEvent& );
	virtual void OnToolbarCommand() {}
	virtual void OnSize( wxSizeEvent& );

private:
	DECLARE_CLASS( MView )
	DECLARE_EVENT_TABLE()
};

/*****************************************************
**
**   CLASS EmptyView  
**
******************************************************/
class EmptyView : public MView
{
public:
	EmptyView( MViewInfo );
	~EmptyView();
	void OnPaint( wxPaintEvent& );

protected:

private:
	DECLARE_CLASS( EmptyView )
	DECLARE_EVENT_TABLE()
};

/*****************************************************
**
**   CLASS ViewFactory  
**
******************************************************/
class ViewFactory
{
public:
	MView *createView( MViewInfo );
	MView *createPartnerView( MViewInfo, DocumentManager* );

private:
	MView *createMidpointView( MViewInfo );
	MView *createTransitView( MViewInfo );
	MView *createSolarView( MViewInfo );
	MView *createSbcView( MViewInfo );
	MView *createDasaView( MViewInfo );
	MView *createGraphicView( MViewInfo );
	MView *createMainView( MViewInfo info );
	MView *createTextView( MViewInfo );
	MView *createGraphicalDasaView( MViewInfo );

	MView *createHoraView( MViewInfo );
	MView *createEphemView( MViewInfo );
	MView *createEclipseView( MViewInfo );
};

#endif

