/*

	This is the source code of

   	M A I T R E Y A
    ===============

	Open source platform for Vedic and western astrology

  File           MainWindowControl.cpp
  Release        4.1
  Author         Martin Pettau
  Copyright (C)  2003-2006 by the author

  Released under the Artistic License as published by the
  Free Software Foundation, read the file 'COPYING' for more information.

*/

#ifdef __GNUG__
	#pragma implementation "MainWindowControl.h"
#endif

#include "MainWindowControl.h"

#include "MView.h"
#include "ChildWindow.h"
#include "Document.h"
#include "FontProvider.h"
#include "IconProvider.h"
#include "MenuProvider.h"

#include "func.h"
#include "Conf.h"
#include "DataSet.h"
#include "Lang.h"

#include <wx/imaglist.h>
#include <wx/listctrl.h>
#include <wx/log.h>
#include <wx/listimpl.cpp>
#include <wx/menu.h>

#include <wx/string.h>

WX_DEFINE_LIST( ChildWindowList );
WX_DEFINE_LIST( Documents );

extern Config *config;

IMPLEMENT_CLASS( MainWindowControl, wxWindow )
BEGIN_EVENT_TABLE( MainWindowControl, wxWindow )
	EVT_SIZE( MainWindowControl::OnSize )
	EVT_LIST_ITEM_ACTIVATED( LISTCTRL_ID, MainWindowControl::OnListItemActivated )
END_EVENT_TABLE()

/*****************************************************
**
**   CLASS MainWindowControlEvtHandler  
**
******************************************************/
class MainWindowControlEvtHandler : public wxEvtHandler
{
 DECLARE_CLASS( MainWindowControlEvtHandler )
public:
	MainWindowControlEvtHandler( MainWindowControl *listctrl ) { this->listctrl = listctrl; }

private:
  virtual void OnContextMenuEvent( wxMouseEvent& event) { listctrl->OnRightDown( event ); }
	MainWindowControl *listctrl;
  DECLARE_EVENT_TABLE()
};

IMPLEMENT_CLASS( MainWindowControlEvtHandler, wxEvtHandler )
BEGIN_EVENT_TABLE( MainWindowControlEvtHandler, wxEvtHandler)
	EVT_RIGHT_DOWN( MainWindowControlEvtHandler::OnContextMenuEvent )
END_EVENT_TABLE()

/*****************************************************
**
**   MainWindowControl   ---   Constructor 
**
******************************************************/
MainWindowControl::MainWindowControl( wxWindow* parent, wxWindowID id )
	: wxWindow( parent, id )
{
	listctrl = 0;
  bigIconList = IconProvider::createImageList( "bbbbbbbbbbbbbbbb", BITMAP_HORA, BITMAP_DOCUMENT,
    BITMAP_TEXT, BITMAP_DASA, BITMAP_TRANSIT, BITMAP_EPHEM, BITMAP_MIDPOINT, BITMAP_CHART,
    BITMAP_CHART9, BITMAP_WCHART, BITMAP_PARTNER, BITMAP_SBC, BITMAP_GRAPHICALDASA, BITMAP_ECLIPSE,
		BITMAP_YOGA, BITMAP_SOLAR );
  smallIconList = IconProvider::createImageList( "ssssssssssssssss", BITMAP_HORA, BITMAP_DOCUMENT,
    BITMAP_TEXT, BITMAP_DASA, BITMAP_TRANSIT, BITMAP_EPHEM, BITMAP_MIDPOINT, BITMAP_CHART,
    BITMAP_CHART9, BITMAP_WCHART, BITMAP_PARTNER, BITMAP_SBC, BITMAP_GRAPHICALDASA, BITMAP_ECLIPSE,
		BITMAP_YOGA, BITMAP_SOLAR );
	activeitem = -1;
	recreate();
}

/*****************************************************
**
**   MainWindowControl   ---   Destructor 
**
******************************************************/
MainWindowControl::~MainWindowControl()
{
	delete listctrl;
	delete smallIconList;
	delete bigIconList;
}

/*****************************************************
**
**   MainWindowControl   ---   recreate 
**
******************************************************/
void MainWindowControl::recreate()
{
	wxListItem itemCol;

	if ( listctrl ) delete listctrl;
	int width = GetParent()->GetSize().GetWidth() / 4 - 2;
	switch( config->listStyle )
	{
		case 1:
			listctrl = new wxListCtrl( this, LISTCTRL_ID, wxDefaultPosition, wxDefaultSize,
				wxLC_SMALL_ICON|wxLC_SINGLE_SEL|wxSUNKEN_BORDER );
			listctrl->SetImageList( smallIconList, wxIMAGE_LIST_SMALL );
		break;
		case 2:
			listctrl = new wxListCtrl( this, LISTCTRL_ID, wxDefaultPosition, wxDefaultSize,
				wxLC_REPORT|wxLC_SINGLE_SEL|wxSUNKEN_BORDER );
			listctrl->SetImageList( smallIconList, wxIMAGE_LIST_SMALL );
			itemCol.m_mask = wxLIST_MASK_TEXT | wxLIST_MASK_IMAGE;
			itemCol.m_text = _( "Type" );
			itemCol.m_image = -1;
			listctrl->InsertColumn(0, itemCol);
			itemCol.m_text = _( "Name" );
			listctrl->InsertColumn(1, itemCol);
			itemCol.m_text = _( "Date" );
			listctrl->InsertColumn(2, itemCol);
			itemCol.m_text = _( "Location" );
			listctrl->InsertColumn(3, itemCol);
			listctrl->SetColumnWidth( 0, width );
			listctrl->SetColumnWidth( 1, width );
			listctrl->SetColumnWidth( 2, width );
			listctrl->SetColumnWidth( 3, width );
		break;
		default:
			listctrl = new wxListCtrl( this, LISTCTRL_ID, wxDefaultPosition, wxDefaultSize,
				wxLC_ICON|wxLC_SINGLE_SEL|wxSUNKEN_BORDER );
			listctrl->SetImageList( bigIconList, wxIMAGE_LIST_NORMAL );
		break;
	}
	for ( ChildWindowList::Node *node = windowlist.GetFirst(); node; node = node->GetNext() )
	{
		insertListItem( node->GetData() );
	}

	listctrl->SetFont( *FontProvider().getDefaultFont() );
	listctrl->SetSize( GetSize() );
	listctrl->Arrange();
	if ( activeitem != -1 ) listctrl->SetItemState( activeitem ,wxLIST_STATE_SELECTED, wxLIST_STATE_SELECTED);
	listctrl->PushEventHandler( new MainWindowControlEvtHandler( this ));
	listctrl->Show( true );
}

/*****************************************************
**
**   MainWindowControl   ---   getNumberOfEntries 
**
******************************************************/
int MainWindowControl::getNumberOfEntries()
{
	return windowlist.GetCount();
}

/***********************************************
***
**  MainWindowControl   ---   setActiveItem
***
***********************************************/
void MainWindowControl::setActiveItem( const int &i )
{
	activeitem = i;
}

/***********************************************
***
**  MainWindowControl   ---   getActiveChild
***
***********************************************/
ChildWindow *MainWindowControl::getActiveChild()
{
	if ( activeitem == -1 ) return 0;
	else return windowlist.Item( activeitem )->GetData();
}

/*****************************************************
**
**   MainWindowControl   ---   arrangeIcons
**
******************************************************/
void MainWindowControl::arrangeIcons()
{
	listctrl->SetSize( listctrl->GetSize() );
}

/*****************************************************
**
**   MainWindowControl   ---   updateItemLabel 
**
******************************************************/
void MainWindowControl::updateItemLabel( ChildWindow *child, const int &pos )
{
	Formatter *formatter = Formatter::get();
	wxString name, s;

	Document *doc = child->getDoc();

	if ( config->listStyle == 2 )
	{
		listctrl->SetItem( pos, 0, child->getWindowLabel() );
		if ( doc )
		{
			Document *doc = child->getDoc();
			listctrl->SetItem( pos, 1, doc->getHName() );
			Location *location = doc->getLocation();
			listctrl->SetItem( pos, 2,
				formatter->getFullDateStringFromJD( doc->getJD() + ( location->getTimeZone() + location->getDST())/24 ) );
			listctrl->SetItem( pos, 3, doc->getLocation()->getLocName() );
		}
	}
	else
	{
		if ( doc )
		{
			name = doc->getHName();
			if ( child->isMainWindow() )
			{
				if ( name.Len() > 12 ) s.Printf( wxT( "%s..." ), name.Left( 12 ).c_str() );
				else s = doc->getHName();
			}
			else
			{
				if ( name.Len() > 10 ) s.Printf( wxT( "%s...<%s>" ), name.Left( 10 ).c_str(),
					child->getWindowLabel( true ) );
				else s.Printf( wxT( "%s <%s>" ), doc->getHName(), child->getWindowLabel( true ) );
			}
		}
		else
			{ s = child->getWindowLabel( true ); }
		listctrl->SetItemText( pos, s );
	}
}

/*****************************************************
**
**   MainWindowControl   ---   insertListItem 
**
******************************************************/
void MainWindowControl::insertListItem( ChildWindow *item )
{
	int i = getIconIndex( item );
	int pos = listctrl->InsertItem( listctrl->GetItemCount(), wxT( "--" ), i );
	updateItemLabel( item, pos );
	listctrl->SetItemState( pos,wxLIST_STATE_SELECTED, wxLIST_STATE_SELECTED);
}

/*****************************************************
**
**   MainWindowControl   ---   updateItemLabels 
**
******************************************************/
void MainWindowControl::updateItemLabels()
{
	int i = 0;
	for ( ChildWindowList::Node *node = windowlist.GetFirst(); node; node = node->GetNext() )
	{
		ChildWindow *item = node->GetData();
		updateItemLabel( item, i );
		i++;
	}
}

/*****************************************************
**
**   MainWindowControl   ---   getIconIndex 
**
******************************************************/
int MainWindowControl::getIconIndex( ChildWindow *child )
{
  wxString cname = child->GetClassInfo()->GetClassName();
  if ( cname == wxT( "MultipleChildWindow" )) return 1;
  else if ( cname != wxT( "SimpleChildWindow" )) return 1;
  MView *view = ((SimpleChildWindow*)child)->getView();
  if ( ! view ) return BITMAP_HORA;
  wxString viewname = view->GetClassInfo()->GetClassName();

  if ( viewname == wxT( "MainView" )) return 1;
  else if ( viewname == wxT( "DefaultTextView" )) return 2;
  else if ( viewname == wxT( "DasaView" )) return 3;
  else if ( viewname == wxT( "TransitView" )) return 4;
  else if ( viewname == wxT( "EphemView" )) return 5;
  else if ( viewname == wxT( "MidpointView" )) return 6;
  else if ( viewname == wxT( "GraphicView" )) return 7;
  else if ( viewname == wxT( "PartnerView" )) return 10;
  else if ( viewname == wxT( "SbcView" )) return 11;
  else if ( viewname == wxT( "DasaGraphicView" )) return 12;
  else if ( viewname == wxT( "EclipseView" )) return 13;
  else if ( viewname == wxT( "YogaView" )) return 14;
  else if ( viewname == wxT( "SolarView" )) return 15;
  else return 0;
}

/*****************************************************
**
**   MainWindowControl   ---   addEntry 
**
******************************************************/
void MainWindowControl::addEntry( ChildWindow *child )
{
	windowlist.Append( child );
	insertListItem( child );
}

/*****************************************************
**
**   MainWindowControl   ---   deleteEntry 
**
******************************************************/
void MainWindowControl::deleteEntry( ChildWindow *child )
{
	int i = 0;
	for ( ChildWindowList::Node *node = windowlist.GetFirst(); node; node = node->GetNext() )
	{
		ChildWindow *current = node->GetData();
		if ( current == child )
		{
			windowlist.DeleteNode( node );
			listctrl->DeleteItem( i );
			//recreate();
			break;
		}
		i++;
	}
	if ( windowlist.GetCount() == 0 )
	{
		activeitem = -1;
	}
	else
	{
		if ( activeitem == i ) selectItem( i == 0 ? 0 : i - 1 );
	}
	listctrl->Arrange();
}

/*****************************************************
**
**   MainWindowControl   ---   OnSize 
**
******************************************************/
void MainWindowControl::OnSize( wxSizeEvent &event )
{
	listctrl->SetSize( event.GetSize() );
	listctrl->Arrange();
	//listctrl->SetSize( wxSize( 100, 100 ));
}

/***********************************************
***
**  MainWindowControl   ---   getChild
***
***********************************************/
ChildWindow *MainWindowControl::getChild( const int &i )
{
	return windowlist.Item( i )->GetData();
}

/*****************************************************
**
**   MainWindowControl   ---   selectItem 
**
******************************************************/
void MainWindowControl::selectItem( const int &i )
{
	//printf( "MainWindowControl::selectItem -->  Active item %d -- i %d\n", activeitem, i );
	if ( activeitem == i ) return;
	activeitem = i;
	listctrl->SetItemState( i, wxLIST_STATE_SELECTED, wxLIST_STATE_SELECTED );
}

/*****************************************************
**
**   MainWindowControl   ---   OnListItemActivated 
**
******************************************************/
void MainWindowControl::OnListItemActivated( wxListEvent& event )
{
	ChildWindow *child = windowlist.Item( event.GetIndex() )->GetData();
	if ( ! child )
	{
		wxLogError( wxT( "Error: can't find child  %ld in list"),  event.GetIndex() );
		return;
	}
	child->Raise();
}

/*****************************************************
**
**   MainWindowControl   ---   OnListItemSelected 
**
******************************************************/
void MainWindowControl::OnListItemSelected( wxListEvent& event )
{
	ChildWindow *child = windowlist.Item( event.GetIndex() )->GetData();
	if ( ! child )
	{
		wxLogError( wxT( "Error: can't find child %ld in list" ), event.GetIndex() );
		return;
	}
}

/*****************************************************
**
**   MainWindowControl   ---   OnRightDown 
**
******************************************************/
void MainWindowControl::OnRightDown( wxMouseEvent &event )
{
	int flag = wxLIST_HITTEST_ONITEM;
  wxMenu *menu = 0;

	long int i = listctrl->HitTest( event.GetPosition(), flag );

	if ( i == -1 ) { menu = ContextMenuProvider().getAppWindowContextMenu(); }
	else
	{
		selectItem( i );
		ChildWindow *child = windowlist.Item( i )->GetData();
		menu  = child->getContextMenu();
	}
  PopupMenu( menu, event.GetX(), event.GetY() );
  delete menu;
}



