/*

	This is the source code of

   	M A I T R E Y A
    ===============

	Open source platform for Vedic and western astrology

  File           MainWindowControl.h
  Release        4.1
  Author         Martin Pettau
  Copyright (C)  2003-2006 by the author

  Released under the Artistic License as published by the
  Free Software Foundation, read the file 'COPYING' for more information.

*/
#ifndef MAINWINDOWCONTROL_H_
#define MAINWINDOWCONTROL_H_

#ifdef __GNUG__
	#pragma interface "MainWindowControl.h"
#endif

#include <wx/window.h>

#include "Base.h"

class ChildWindow;
class Document;
class wxImageList;
class wxListCtrl;
class wxListEvent;
class wxMouseEvent;
class wxSizeEvent;

#define LISTCTRL_ID 12000

/*****************************************************
**
**   CLASS MainWindowControl  
**
******************************************************/
class MainWindowControl : public wxWindow
{
	DECLARE_CLASS( MainWindowControl )
public:
	MainWindowControl( wxWindow* parent, wxWindowID id );
	~MainWindowControl();
	void recreate();
	void addEntry( ChildWindow* );
	void deleteEntry( ChildWindow* );
	int getNumberOfEntries();
	ChildWindow *getChild( const int& );
	void selectItem( const int & );
	void setActiveItem( const int & );
	void OnRightDown( wxMouseEvent &event );
	void updateItemLabels();
	ChildWindow *getActiveChild();
	void arrangeIcons();

	DECLARE_EVENT_TABLE()
private:
	int activeitem;
	void insertListItem( ChildWindow *item );
	void updateItemLabel( ChildWindow *item, const int &pos );
	void OnSize( wxSizeEvent& );
	wxListCtrl *listctrl;
	ChildWindowList windowlist;
	wxImageList *smallIconList, *bigIconList;
	int getIconIndex( ChildWindow *item );
	void OnListItemActivated( wxListEvent& );
	void OnListItemSelected( wxListEvent& );
};


#endif

