/*

	This is the source code of

   	M A I T R E Y A
    ===============

	Open source platform for Vedic and western astrology

  File           MenuProvider.cpp
  Release        4.1
  Author         Martin Pettau
  Copyright (C)  2003-2006 by the author

  Released under the Artistic License as published by the
  Free Software Foundation, read the file 'COPYING' for more information.

*/

#ifdef __GNUG__
	#pragma implementation "MenuProvider.h"
#endif

#include "MenuProvider.h"

#include <wx/log.h>

#include "Base.h"
#include "ChildWindow.h"
#include "MView.h"
#include "Shortcuts.h"
#include "IconProvider.h"

#include "func.h"
#include "Conf.h"
#include "Varga.h"

extern Config *config;

/*****************************************************
**
**   AppMenuBar   ---   Constructor 
**
******************************************************/
AppMenuBar::AppMenuBar( int style )
 : wxMenuBar( style )
{
	int i;
  size_t n;
  wxString rfiles, s;
  VargaExpert expert;

  recentmenu = new wxMenu();
  rfiles = config->recentFileList;
  i = rfiles.Find( '\t' );
  while( i != -1 )
  {
    recentfiles.Add( rfiles.Left( i ));
    rfiles = rfiles.Right( rfiles.Len() - i - 1 );
    i = rfiles.Find( '\t' );
  }
  if ( rfiles.Len() > 0 ) recentfiles.Add( rfiles );
  for( n = 0; n < recentfiles.GetCount(); n++ ) recentmenu->Append( APP_FILERECENT + n, recentfiles[n] );

  filemenu = new wxMenu();
	appendMenuItem( filemenu, _( "&New" ), APP_FILENEW, BITMAP_NEW );
	appendMenuItem( filemenu, _( "&Open" ), APP_FILEOPEN, BITMAP_OPEN );
  filemenu->Append( APP_FILERECENT, _("Open &Recent"), recentmenu );
  filemenu->AppendSeparator();
	appendMenuItem( filemenu, _( "&Quit" ), APP_FILEQUIT, BITMAP_QUIT );
  Append( filemenu, _( "&File" ));

	horoscopemenu = new wxMenu();
	appendMenuItem( horoscopemenu, _( "&Birth Data" ), CHILD_EDITDATA, BITMAP_EDIT );
  horoscopemenu->AppendSeparator();
	appendMenuItem( horoscopemenu, _( "&Close Document" ), CHILD_CLOSE_DOC, BITMAP_CLOSE );
	appendMenuItem( horoscopemenu, _( "&Save" ), CHILD_SAVE, BITMAP_SAVE );
	appendMenuItem( horoscopemenu, _( "Save &As" ), CHILD_SAVEAS, BITMAP_SAVEAS );
  horoscopemenu->AppendSeparator();
	appendMenuItem( horoscopemenu, _( "&Quick Print" ), CHILD_QUICKPRINT, BITMAP_QUICKPRINT );
	appendMenuItem( horoscopemenu, _( "&Print" ), CHILD_PRINT, BITMAP_PRINT );
  horoscopemenu->AppendSeparator();
  horoscopemenu->Append( CHILD_ANIMATE, _("A&nimate" ), wxT( "" ), true );
	// isn't checkable
  //wxMenuItem *aaa = new wxMenuItem( horoscopemenu, CHILD_ANIMATE, _("A&nimate" ), wxT( "" ), wxITEM_CHECK );
  //horoscopemenu->Append( aaa );
  Append( horoscopemenu, _( "&Document" ));

  imenu = new wxMenu();
	imenu->Append( CHILD_DUMMY, _( "&Varga"), getVargaMenu() );
	appendMenuItem( imenu, _( "&Text Window" ), CHILD_NEW_TEXT, BITMAP_TEXT );
  imenu->AppendSeparator();
	appendMenuItem( imenu, _( "&Dasa Tree" ), CHILD_NEW_DASA, BITMAP_DASA );
	appendMenuItem( imenu, _( "Dasa &Graphical" ), CHILD_NEW_GRAPHICALDASA, BITMAP_GRAPHICALDASA );
  imenu->AppendSeparator();
	appendMenuItem( imenu, _( "&Sarvatobhadra" ), CHILD_NEW_SBC, BITMAP_SBC );
	appendMenuItem( imenu, _( "T&ajaka (Annual Chart)" ), CHILD_NEW_SOLAR, BITMAP_SOLAR );
  Append( imenu, _( "&Vedic"));

  wmenu = new wxMenu();
	appendMenuItem( wmenu, _( "&Chart Graphic" ), CHILD_NEW_WCHART, BITMAP_WCHART );
	appendMenuItem( wmenu, _( "&Text Window" ), CHILD_NEW_TEXT, BITMAP_TEXT );
  wmenu->AppendSeparator();
	appendMenuItem( wmenu, _( "&Midpoint" ), CHILD_NEW_MIDPOINT, BITMAP_MIDPOINT );
	appendMenuItem( wmenu, _( "T&ransit" ), CHILD_NEW_TRANSIT, BITMAP_TRANSIT );
  wmenu->AppendSeparator();
	appendMenuItem( wmenu, _( "&Solar (Annual Chart)" ), CHILD_NEW_SOLAR, BITMAP_SOLAR );
  Append( wmenu, _( "&Western"));

  extramenu = new wxMenu();
	appendMenuItem( extramenu, _( "&Ephemeris" ), APP_SHOWEPHEM, BITMAP_EPHEM );
	appendMenuItem( extramenu, _( "Ecl&ipses" ), APP_SHOWECLIPSE, BITMAP_ECLIPSE );
	appendMenuItem( extramenu, _( "&Hora" ), APP_SHOWHORA, BITMAP_HORA );
	appendMenuItem( extramenu, _( "&Partner" ), APP_NEW_PARTNER, BITMAP_PARTNER );
  extramenu->AppendSeparator();
	appendMenuItem( extramenu, _( "&Configuration" ), APP_CONFIGURE, BITMAP_CONFIG );
	appendMenuItem( extramenu, _( "&Location Database" ), APP_LOCATION, BITMAP_WORLD );
	appendMenuItem( extramenu, _( "&Save Configuration" ), APP_SAVECONFIG, BITMAP_SAVE );
  extramenu->AppendSeparator();
  wxMenu *iconmenu = new wxMenu();
	iconmenu->AppendRadioItem( APP_LIST_BIGICONS, _( "&Big Icons" ) );
	iconmenu->AppendRadioItem( APP_LIST_SMALLICONS, _( "&Small Icons" ) );
	iconmenu->AppendRadioItem( APP_LIST_TABLE, _( "&Table" ) );
	switch( config->listStyle )
	{
		case 1: iconmenu->Check( APP_LIST_SMALLICONS, true ); break;
		case 2: iconmenu->Check( APP_LIST_TABLE, true ); break;
		default: iconmenu->Check( APP_LIST_BIGICONS, true ); break;
	}
  extramenu->Append( APP_LISTCTRL, _("&Window List"), iconmenu );
  extramenu->Append( APP_SHOWMAINTOOLBAR, _( "Show &Toolbar" ), wxT( "" ), true);
  extramenu->Check( APP_SHOWMAINTOOLBAR, config->showMainToolbar );
  extramenu->Append( APP_SHOWSTATUSBAR, _("Show Status&bar" ), wxT( "" ), true );
  extramenu->Check( APP_SHOWSTATUSBAR, config->showStatusBar );
  Append( extramenu, _( "&Extras"));

  helpmenu = new wxMenu();
	appendMenuItem( helpmenu, _( "&Documentation" ), APP_HELP, BITMAP_HELP );
	appendMenuItem( helpmenu, _( "&About" ), APP_ABOUT, BITMAP_INFO );
  Append( helpmenu, _( "&Help"));
}

/**************************************************************
***
**
***
***************************************************************/
void appendMenuItem( wxMenu *menu, const wxChar *title, const int &id, const int bitmap, const bool checkable )
{
	wxString s;
	ShortcutManager m;

	wxString sc = m.getMenushortcut( id );
	if ( sc.IsEmpty() ) s = title;
	else s.sprintf( wxT( "%s\t%s" ), title, sc.c_str() );
	wxMenuItem *item = new wxMenuItem( menu, id, s );
	if ( bitmap != -1 ) item->SetBitmap( IconProvider::getMenuBitmap( bitmap ));
  menu->Append( item );
}

/*****************************************************
**
**   AppMenuBar   ---   updateMenus 
**
******************************************************/
void AppMenuBar::updateMenus( const bool &isWin, const bool &isDoc, const bool &animated, const int &checkEW )
{
	wxLogMessage( wxT( "Start MenuProvider::updateMenus isWin %d isDoc %d animated %d checkEW %d" ),
		isWin, isDoc, animated, checkEW );
  filemenu->Enable( CHILD_SAVE, isDoc );
  filemenu->Enable( CHILD_SAVEAS, isDoc );
  filemenu->Enable( CHILD_CLOSE, isWin );
  filemenu->Enable( CHILD_PRINT, isDoc );

  EnableTop( 1, isDoc );
  EnableTop( 2, isDoc );
  EnableTop( 3, isDoc );
  if ( isDoc ) horoscopemenu->Check( CHILD_ANIMATE, animated );

	wxLogMessage( wxT( "End MenuProvider::updateMenusAndToolbars" ));
}

/*****************************************************
**
**   AppMenuBar   ---   addToRecentFiles 
**
******************************************************/
void AppMenuBar::addToRecentFiles( const wxString &filename )
{
  unsigned int maxrecent = config->maxRecentFiles;
  unsigned int recentcount = recentmenu->GetMenuItemCount();
  size_t n;
   
  // clear recent file menu
  for( n = 0; n < recentcount; n++ ) recentmenu->Delete( APP_FILERECENT + n );
  
  // Clear obsolete items ( if number of files has changed via ConfigDialog)
  if ( recentfiles.GetCount() > maxrecent )
  {
    for( n = 0; n < recentfiles.GetCount() - maxrecent; n++ )
      recentfiles.RemoveAt( maxrecent + n );
  }
   
  // update file list
  for( n = 0; n < recentfiles.GetCount(); n++ )
  {
    if ( recentfiles[n] == filename )
    {
      recentfiles.RemoveAt( n );
      break;
    }
  }
  if ( recentfiles.GetCount() == (unsigned int)config->maxRecentFiles ) recentfiles.RemoveAt( recentfiles.GetCount() - 1 );
  recentfiles.Insert( filename, 0 );
  for( n = 0; n < recentfiles.GetCount(); n++ ) recentmenu->Append( APP_FILERECENT + n, recentfiles[n] );
}

/*****************************************************
**
**   AppMenuBar   ---   getRecentFilesEntry 
**
******************************************************/
wxString AppMenuBar::getRecentFilesEntry( const int &index )
{
	//return recentmenu->GetLabel( index ); --> underscores will be doubled
	return recentfiles[ index - APP_FILERECENT ];
}

/*****************************************************
**
**   AppMenuBar   ---   saveRecentFiles 
**
******************************************************/
void AppMenuBar::saveRecentFiles()
{
	wxString rfiles = wxT( "" );
  size_t n;
  
  for( n = 0; n < recentfiles.GetCount(); n++ )
  {
    if ( n > 0 ) rfiles += wxT( "\t" );
    rfiles += recentfiles[n];
  }
	config->recentFileList = rfiles;
}

/*****************************************************
**
**   ContextMenuInfo   ---   Constructor 
**
******************************************************/
ContextMenuInfo::ContextMenuInfo( MView *view )
{
	this->view = view;
	preferVedic = true;
	supportsEWToggle = true;
	isDoc = false;
	animate = false;
	isSbc = false;
	partnerStyle = -1;
	masterdoc = graphic = midpoint = textstyle = -1;
}

/**************************************************************
***
**
***
***************************************************************/
wxMenu *ContextMenuProvider::getContextMenu( const ContextMenuInfo &info )
{
  wxMenu *menu = new wxMenu( info.view->getTitle() );
	appendMenuItem( menu, _( "Close" ), CHILD_CLOSE, BITMAP_CLOSE );
  if ( info.isDoc )
  {
		appendMenuItem( menu, _( "Save" ), CHILD_SAVE, BITMAP_SAVE );
		appendMenuItem( menu, _( "Save as" ), CHILD_SAVEAS, BITMAP_SAVEAS );
		appendMenuItem( menu, _( "Print" ), CHILD_PRINT, BITMAP_PRINT );
		appendMenuItem( menu, _( "Quick Print" ), CHILD_QUICKPRINT, BITMAP_QUICKPRINT );
  }

	// Style menu
	if ( info.masterdoc != -1 )
	{
		menu->Append( CHILD_DUMMY, _( "Style"), ( info.preferVedic ? getIMainStyleMenu( info.masterdoc )
			: getWMainStyleMenu( info.masterdoc )));
	}
	else if ( info.graphic != -1 )
	{
		menu->Append( CHILD_DUMMY, _( "Style"), ( info.preferVedic ? getIGraphicStyleMenu( info.graphic )
			: getWGraphicStyleMenu( info.graphic )));
	}
  if ( info.supportsEWToggle )
  {
    menu->AppendSeparator();
    menu->Append( VIEW_PREFERINDIAN, _("Vedic Style"), wxT( "" ), true );
    menu->Check( VIEW_PREFERINDIAN, info.preferVedic );
    menu->Append( VIEW_PREFERWESTERN, _("Western Style"), wxT( "" ), true );
    menu->Check( VIEW_PREFERWESTERN, ! info.preferVedic );
  }
	if ( info.midpoint != -1 && ! info.preferVedic && info.partnerStyle != 1 )
	{
    menu->AppendSeparator();
    menu->Append( CHILD_HSEBERTIN, _( "Ebertin"), wxT( "" ), true );
    menu->Check( CHILD_HSEBERTIN, info.midpoint == 0 );
    menu->Append( CHILD_HSWITTE, _( "Witte"), wxT( "" ), true );
    menu->Check( CHILD_HSWITTE, info.midpoint == 1 );
	}
	if ( info.partnerStyle != -1 )
	{
    menu->AppendSeparator();
    menu->Append( CHILD_PARTNER_TEXT, _( "Text/Midpoint"), wxT( "" ), true );
    menu->Check( CHILD_PARTNER_TEXT, info.partnerStyle == 0 );
    menu->Append( CHILD_PARTNER_COMPOSIT, _( "Composit"), wxT( "" ), true );
    menu->Check( CHILD_PARTNER_COMPOSIT, info.partnerStyle == 1 );
	}
	if ( info.textstyle != -1 )
	{
		menu->AppendSeparator();
		appendMenuItem( menu, _( "Copy" ), CHILD_COPY, BITMAP_COPY );
		menu->Enable( CHILD_COPY, info.textstyle == 1 );
		appendMenuItem( menu, _( "Select all" ), CHILD_SELECT_ALL );
	}
  if ( info.isDoc )
  {
		menu->AppendSeparator();
		appendMenuItem( menu, _( "Birth data" ), CHILD_EDITDATA, BITMAP_EDIT );
   
    // Chart Graphic
    if ( info.preferVedic ) menu->Append( CHILD_DUMMY, _( "Varga"), getVargaMenu() );
    else appendMenuItem( menu, _( "Chart Graphic" ), CHILD_NEW_WCHART, BITMAP_WCHART );

		appendMenuItem( menu, _( "Text Window" ), CHILD_NEW_TEXT, BITMAP_TEXT );
    if ( info.preferVedic )
    {
			appendMenuItem( menu, _( "Dasa Tree" ), CHILD_NEW_DASA, BITMAP_DASA );
			appendMenuItem( menu, _( "Dasa Graphical" ), CHILD_NEW_GRAPHICALDASA, BITMAP_GRAPHICALDASA );
			appendMenuItem( menu, _( "Sarvatobhadra" ), CHILD_NEW_SBC, BITMAP_SBC );
			appendMenuItem( menu, _( "Tajaka (Annual Chart)" ), CHILD_NEW_SOLAR, BITMAP_SOLAR );
    }
    else
    {
			appendMenuItem( menu, _( "Midpoint" ), CHILD_NEW_MIDPOINT, BITMAP_MIDPOINT );
			appendMenuItem( menu, _( "Transit" ), CHILD_NEW_TRANSIT, BITMAP_TRANSIT );
			appendMenuItem( menu, _( "Solar (Annual Chart)" ), CHILD_NEW_SOLAR, BITMAP_SOLAR );
    }
    menu->AppendSeparator();
    menu->Append( CHILD_ANIMATE, _( "Animate"), wxT( "" ), true );
    menu->Check( CHILD_ANIMATE, info.animate );
  }
  if ( info.graphic != -1 || info.isSbc )
  {
    menu->AppendSeparator();
    menu->Append( CHILD_EXPORT, _( "Export Graphics ..."));
  }
  if ( info.isSbc )
  {
		appendMenuItem( menu, _( "Save Text As ..." ), CHILD_SAVETEXT, BITMAP_SAVEAS );
	}
	if ( info.textstyle != -1 )
	{
		menu->AppendSeparator();
		appendMenuItem( menu, _( "Save Text As ..." ), CHILD_SAVETEXT, BITMAP_SAVEAS );
	}

	return menu;
}

/**************************************************************
***
**
***
***************************************************************/
wxMenu *ContextMenuProvider::getIMainStyleMenu( const int &style )
{
  wxMenu *menu = new wxMenu();
	menu->Append( CHILD_MAIN_SHOW_NAVAMSA, _( "Navamsa" ), wxT( "" ), true );
	menu->Check( CHILD_MAIN_SHOW_NAVAMSA, style & IMAIN_CHILD_SHOW_NAVAMSA );
	menu->Append( CHILD_MAIN_SHOW_NAKSHATRA, _( "Nakshatras" ), wxT( "" ), true );
	menu->Check( CHILD_MAIN_SHOW_NAKSHATRA, style & IMAIN_CHILD_SHOW_NAKSHATRA );
	menu->Append( CHILD_MAIN_SHOW_PADA, _( "Padas" ), wxT( "" ), true );
	menu->Check( CHILD_MAIN_SHOW_PADA, style & IMAIN_CHILD_SHOW_PADA );

	menu->Append( CHILD_MAIN_SHOW_KARAKA, _( "Jaimini Karakas" ), wxT( "" ), true );
	menu->Check( CHILD_MAIN_SHOW_KARAKA, style & IMAIN_CHILD_SHOW_KARAKA );
	menu->Append( CHILD_MAIN_SHOW_KP, _( "Krishnamurti" ), wxT( "" ), true );
	menu->Check( CHILD_MAIN_SHOW_KP, style & IMAIN_CHILD_SHOW_KP );

	menu->Append( CHILD_MAIN_SHOW_SHASTIAMSA, _( "Shastiamsa" ), wxT( "" ), true );
	menu->Check( CHILD_MAIN_SHOW_SHASTIAMSA, style & IMAIN_CHILD_SHOW_SHASTIAMSA );
	menu->Append( CHILD_MAIN_SHOW_DASAVARGA, _( "DasaVarga Dignities" ), wxT( "" ), true );
	menu->Check( CHILD_MAIN_SHOW_DASAVARGA, style & IMAIN_CHILD_SHOW_DASAVARGA );
	menu->Append( CHILD_MAIN_SHOW_BHAVA, _( "Bhavas" ), wxT( "" ), true );
	menu->Check( CHILD_MAIN_SHOW_BHAVA, style & IMAIN_CHILD_SHOW_BHAVA );
	menu->Append( CHILD_MAIN_SHOW_ASHTAKA, _( "Ashtakavarga" ), wxT( "" ), true );
	menu->Check( CHILD_MAIN_SHOW_ASHTAKA, style & IMAIN_CHILD_SHOW_ASHTAKA );
	menu->AppendSeparator();

	menu->Append( CHILD_MAIN_SHOW_IHOUSES, _( "Houses" ), wxT( "" ), true );
	menu->Check( CHILD_MAIN_SHOW_IHOUSES, style & IMAIN_CHILD_SHOW_HOUSES );
	menu->Append( CHILD_MAIN_SHOW_LAGNAS, _( "Special Lagnas" ), wxT( "" ), true );
	menu->Check( CHILD_MAIN_SHOW_LAGNAS, style & IMAIN_CHILD_SHOW_LAGNAS );
	menu->Append( CHILD_MAIN_SHOW_UPA, _( "Upagrahas" ), wxT( "" ), true );
	menu->Check( CHILD_MAIN_SHOW_UPA, style & IMAIN_CHILD_SHOW_UPA );
	return menu;
}

/**************************************************************
***
**
***
***************************************************************/
wxMenu *ContextMenuProvider::getWMainStyleMenu( const int &style )
{
  wxMenu *menu = new wxMenu();
	menu->Append( CHILD_MAIN_SHOW_WHOUSES, _( "Houses" ), wxT( "" ), true );
	menu->Check( CHILD_MAIN_SHOW_WHOUSES, style & WMAIN_CHILD_SHOW_HOUSES );
	menu->Append( CHILD_MAIN_SHOW_HOUSEPOS, _( "House Positions" ), wxT( "" ), true );
	menu->Check( CHILD_MAIN_SHOW_HOUSEPOS, style & WMAIN_CHILD_SHOW_HOUSEPOS );
	menu->Append( CHILD_MAIN_SHOW_URANIAN, _( "Uranian Planets" ), wxT( "" ), true );
	menu->Check( CHILD_MAIN_SHOW_URANIAN, style & WMAIN_CHILD_SHOW_URANIAN );
	return menu;
}

/**************************************************************
***
**
***
***************************************************************/
wxMenu *ContextMenuProvider::getWGraphicStyleMenu( const int &style )
{
  wxMenu *menu = new wxMenu();
	menu->Append( CHILD_WSHOWRETRO, _( "Show Retrograde Planets"), wxT( "" ), true );
	menu->Check( CHILD_WSHOWRETRO, style & WGRAPHIC_STYLE_SHOW_RETRO );
	menu->Append( CHILD_WSHOWASPECTS, _( "Show Aspects"), wxT( "" ), true );
	menu->Check( CHILD_WSHOWASPECTS, style & WGRAPHIC_STYLE_SHOW_ASPECTS );
	menu->Append( CHILD_WSHOWHOUSES, _( "Show Houses"), wxT( "" ), true );
	menu->Check( CHILD_WSHOWHOUSES, style & WGRAPHIC_STYLE_SHOW_HOUSES );
	menu->Append( CHILD_WSHOWURANIAN, _( "Show Uranian"), wxT( "" ), true );
	menu->Check( CHILD_WSHOWURANIAN, style & WGRAPHIC_STYLE_SHOW_URANIAN );
	return menu;
}

/**************************************************************
***
**
***
***************************************************************/
wxMenu *ContextMenuProvider::getIGraphicStyleMenu( const int &style )
{
  wxMenu *menu = new wxMenu();
	menu->Append( CHILD_ISHOWEAST, _("East Indian Style"), wxT( "" ), true );
	menu->Check( CHILD_ISHOWEAST, style & IGRAPHIC_STYLE_EAST_INDIAN );
	menu->Append( CHILD_ISHOWSOUTH, _("South Indian Style"), wxT( "" ), true );
	menu->Check( CHILD_ISHOWSOUTH, style & IGRAPHIC_STYLE_SOUTH_INDIAN );
	menu->Append( CHILD_ISHOWNORTH, _("North Indian Style"), wxT( "" ), true );
	menu->Check( CHILD_ISHOWNORTH, style & IGRAPHIC_STYLE_NORTH_INDIAN );
	menu->AppendSeparator();
	menu->Append( CHILD_ISHOWARUDHA, _( "Show Arudhas"), wxT( "" ), true );
	menu->Check( CHILD_ISHOWARUDHA, style & IGRAPHIC_STYLE_SHOW_ARUDHAS );
	menu->Append( CHILD_ISHOWLAGNAS, _( "Show Special Lagnas"), wxT( "" ), true );
	menu->Check( CHILD_ISHOWLAGNAS, style & IGRAPHIC_STYLE_SHOW_SPECIAL_LAGNAS );
	menu->Append( CHILD_ISHOWRETRO, _( "Show Retrograde Planets"), wxT( "" ), true );
	menu->Check( CHILD_ISHOWRETRO, style & IGRAPHIC_STYLE_SHOW_RETRO );
	return menu;
}

/**************************************************************
***
**
***
***************************************************************/
wxMenu *getVargaMenu()
{
	int i;
	VargaExpert expert; 
  wxString s, d;

  wxMenu *menu = new wxMenu();
	for( i = 0; i < expert.getNbVargas(); i++ )
	{
		if ( expert.getVargaDivision( i ))
		{
			//s.sprintf( wxT( "%s (D %d)" ), expert.getVargaName( i ), expert.getVargaDivision( i ) );
			s = expert.getVargaName( i );
			d.sprintf( _( "D-%d" ), expert.getVargaDivision( i ) );
			s += wxT( " " );
			s += d;
		}
		else
			s = expert.getVargaName( i );
		appendMenuItem( menu, (const wxChar*)s, CHILD_NEW_RASI+i, BITMAP_CHART );
	}
	return menu;
}

/**************************************************************
***
**
***
***************************************************************/
wxMenu *ContextMenuProvider::getAppWindowContextMenu()
{
  wxMenu *menu = new wxMenu( _( "Main Window Menu" ));

	appendMenuItem( menu, _( "New" ), APP_FILENEW, BITMAP_NEW );
	appendMenuItem( menu, _("Open" ), APP_FILEOPEN, BITMAP_OPEN );
  menu->AppendSeparator();
	appendMenuItem( menu, _("Ephemeris" ), APP_SHOWEPHEM, BITMAP_EPHEM );
	appendMenuItem( menu, _("Eclipses" ),APP_SHOWECLIPSE, BITMAP_ECLIPSE );
	appendMenuItem( menu, _("Hora" ), APP_SHOWHORA, BITMAP_HORA );
	appendMenuItem( menu, _("Partner" ), APP_NEW_PARTNER, BITMAP_PARTNER );
  menu->AppendSeparator();
  wxMenu *iconmenu = new wxMenu();
	iconmenu->AppendRadioItem( APP_LIST_BIGICONS, _( "Big Icons" ) );
	iconmenu->AppendRadioItem( APP_LIST_SMALLICONS, _( "Small Icons" ) );
	iconmenu->AppendRadioItem( APP_LIST_TABLE, _( "Table" ) );
	switch( config->listStyle )
	{
		case 1: iconmenu->Check( APP_LIST_SMALLICONS, true ); break;
		case 2: iconmenu->Check( APP_LIST_TABLE, true ); break;
		default: iconmenu->Check( APP_LIST_BIGICONS, true ); break;
	}
  menu->Append( CHILD_DUMMY, _("Window List"), iconmenu );
	appendMenuItem( menu, _( "Configuration" ), APP_CONFIGURE, BITMAP_CONFIG );
	appendMenuItem( menu, _( "Location Database" ), APP_LOCATION, BITMAP_WORLD );
  menu->AppendSeparator();
	appendMenuItem( menu, _("Quit" ), APP_FILEQUIT, BITMAP_QUIT );
	return menu;
}




