/*

	This is the source code of

   	M A I T R E Y A
    ===============

	Open source platform for Vedic and western astrology

  File           MenuProvider.h
  Release        4.1
  Author         Martin Pettau
  Copyright (C)  2003-2006 by the author

  Released under the Artistic License as published by the
  Free Software Foundation, read the file 'COPYING' for more information.

*/

#ifndef _MENUPROVIDER_H_
#define _MENUPROVIDER_H_

#ifdef __GNUG__
	#pragma interface "MenuProvider.h"
#endif

#include <wx/object.h>
#include <wx/menu.h>
#include <wx/string.h>

class wxFont;
class ChildWindow;
class MView;

void appendMenuItem( wxMenu *menu, const wxChar *title, const int &id, const int bitmap = -1,
	const bool checkable = false );

wxMenu *getVargaMenu();

/*****************************************************
**
**   CLASS AppMenuBar  
**
******************************************************/
class AppMenuBar : public wxMenuBar
{
public:
	AppMenuBar( int style );
	void updateMenus( const bool &isWin, const bool &isDoc, const bool &animated, const int &checkEW );
	void addToRecentFiles( const wxString& );
	wxString getRecentFilesEntry( const int& );
	void saveRecentFiles();

private:
	wxMenu *filemenu, *horoscopemenu, *wmenu, *imenu, *extramenu, *helpmenu, *recentmenu;
	wxArrayString recentfiles;
};

/*****************************************************
**
**   CLASS ContextMenuInfo  
**
******************************************************/
class ContextMenuInfo
{
public:
	ContextMenuInfo( MView* );
	MView *view;
	bool preferVedic;
	bool supportsEWToggle;
	bool isDoc;
	bool animate;
	bool isSbc;
	int masterdoc;
	int graphic;
	int midpoint;
	int textstyle;
	int partnerStyle;
};

/*****************************************************
**
**   CLASS ContextMenuProvider  
**
******************************************************/
class ContextMenuProvider : public wxObject
{
public:
	wxMenu *getContextMenu( const ContextMenuInfo& );
	wxMenu *getAppWindowContextMenu();

private:
	wxMenu *getIMainStyleMenu( const int &style );
	wxMenu *getWMainStyleMenu( const int &style );
	wxMenu *getIGraphicStyleMenu( const int &style );
	wxMenu *getWGraphicStyleMenu( const int &style );
};


#endif


