/*

	This is the source code of

   	M A I T R E Y A
    ===============

	Open source platform for Vedic and western astrology

  File           MidpointView.h
  Release        4.1
  Author         Martin Pettau
  Copyright (C)  2003-2006 by the author

  Released under the Artistic License as published by the
  Free Software Foundation, read the file 'COPYING' for more information.

*/

#ifndef _MIDPOINTVIEW_H_
#define _MIDPOINTVIEW_H_

#ifdef __GNUG__
	#pragma interface "MidpointView.h"
#endif

#include "TextView.h"
#include "Base.h"

#include "DataSet.h"


class ChildWindow;
class Document;
class wxChoice;
class wxSpinEvent;
class wxSpinCtrl;

/*****************************************************
**
**   CLASS MidpointBaseView  
**
******************************************************/
class MidpointBaseView : public TextViewBase
{
public:
	MidpointBaseView( MViewInfo );
	virtual bool dispatchCommand( const int &command );
	int getHsSystem() { return hsSystem; }

protected:
	virtual void onChangeHsSystem( const int &hsSystem );
	virtual void SetContextMenuInfo( ContextMenuInfo& );
	int hsSystem;

private:
	DECLARE_CLASS( MidpointBaseView )
};

/*****************************************************
**
**   CLASS MidpointView  
**
******************************************************/
class MidpointView : public MidpointBaseView
{
public:
	MidpointView( MViewInfo );
	~MidpointView();

	virtual const wxChar *getWindowLabel( const bool shortname = false );

protected:
	virtual void onChangeHsSystem( const int &hsSystem );
	virtual void write( Writer* );
	virtual void OnToolbarCommand();
	virtual void initToolItems();
	int mode;
	int orbis;
	int circle;
	int yl;
	int year;
	double yearlength;
	int sortorder;
	int filter;

private:
	DECLARE_CLASS( MidpointView )
	DECLARE_EVENT_TABLE()
};

/*****************************************************
**
**   CLASS TransitView  
**
******************************************************/
class TransitView : public MidpointBaseView
{
public:
	TransitView( MViewInfo );
	~TransitView();
	virtual const wxChar *getWindowLabel( const bool shortname = false );
protected:

	virtual void OnToolbarCommand();
	void OnActual( wxCommandEvent& );
	virtual void write( Writer* );
	int yl;
	double yearlength;
	int mode, orbis, circle, sortorder, filter;
	virtual void initToolItems();

	DataSet dataset;

private:
	DECLARE_CLASS( TransitView )
	DECLARE_EVENT_TABLE()
};


#endif

